/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.crawl.SignatureFactory;
import org.apache.nutch.indexer.IndexWriters;
import org.apache.nutch.indexer.IndexingException;
import org.apache.nutch.indexer.IndexingFilters;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.net.URLNormalizers;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseResult;
import org.apache.nutch.parse.ParseSegment;
import org.apache.nutch.parse.ParseUtil;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.protocol.ProtocolOutput;
import org.apache.nutch.scoring.ScoringFilters;
import org.apache.nutch.util.AbstractChecker;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingFiltersChecker
extends AbstractChecker {
    protected URLNormalizers normalizers = null;
    protected boolean dumpText = false;
    protected boolean followRedirects = false;
    protected boolean checkRobotsTxt = false;
    protected boolean doIndex = false;
    protected HashMap<String, String> metadata = new HashMap();
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public int run(String[] args) throws Exception {
        String url = null;
        String usage = "Usage:\n  IndexingFiltersChecker [OPTIONS] <url>\n    Fetch single URL and index it\n  IndexingFiltersChecker [OPTIONS] -stdin\n    Read URLs to be indexed from stdin\n  IndexingFiltersChecker [OPTIONS] -listen <port> [-keepClientCnxOpen]\n    Listen on <port> for URLs to be indexed\nOptions:\n  -D<property>=<value>\tset/overwrite Nutch/Hadoop properties\n                  \t(a generic Hadoop option to be passed\n                  \t before other command-specific options)\n  -normalize      \tnormalize URLs\n  -followRedirects\tfollow redirects when fetching URL\n  -checkRobotsTxt\tfail if the robots.txt disallows fetching\n  -dumpText       \tshow the entire plain-text content,\n                  \tnot only the first 100 characters\n  -doIndex        \tpass document to configured index writers\n                  \tand let them index it\n  -md <key>=<value>\tmetadata added to CrawlDatum before parsing\n";
        if (args.length < 1) {
            System.err.println(usage);
            return -1;
        }
        this.doIndex = this.getConf().getBoolean("doIndex", false);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-normalize")) {
                this.normalizers = new URLNormalizers(this.getConf(), "default");
                continue;
            }
            if (args[i].equals("-followRedirects")) {
                this.followRedirects = true;
                continue;
            }
            if (args[i].equals("-checkRobotsTxt")) {
                this.checkRobotsTxt = true;
                continue;
            }
            if (args[i].equals("-dumpText")) {
                this.dumpText = true;
                continue;
            }
            if (args[i].equals("-doIndex")) {
                this.doIndex = true;
                continue;
            }
            if (args[i].equals("-md")) {
                String nextOne;
                int firstEquals;
                String k = null;
                String v = null;
                if ((firstEquals = (nextOne = args[++i]).indexOf("=")) != -1) {
                    k = nextOne.substring(0, firstEquals);
                    v = nextOne.substring(firstEquals + 1);
                } else {
                    k = nextOne;
                }
                this.metadata.put(k, v);
                continue;
            }
            int numConsumed = super.parseArgs(args, i);
            if (numConsumed > 0) {
                i += numConsumed - 1;
                continue;
            }
            if (i != args.length - 1) {
                System.err.println("ERR: Not a recognized argument: " + args[i]);
                System.err.println(usage);
                return -1;
            }
            url = args[i];
        }
        if (url != null) {
            return super.processSingle(url);
        }
        return super.run();
    }

    @Override
    protected int process(String url, StringBuilder output) throws Exception {
        int numRedirects;
        if (this.normalizers != null) {
            url = this.normalizers.normalize(url, "default");
        }
        LOG.info("fetching: " + url);
        CrawlDatum datum = new CrawlDatum();
        for (String key : this.metadata.keySet()) {
            String value = this.metadata.get(key);
            if (value == null) {
                value = "";
            }
            datum.getMetaData().put((Writable)new Text(key), (Writable)new Text(value));
        }
        int maxRedirects = this.getConf().getInt("http.redirect.max", 3);
        if (this.followRedirects) {
            if (maxRedirects == 0) {
                LOG.info("Following max. 3 redirects (ignored http.redirect.max == 0)");
                maxRedirects = 3;
            } else {
                LOG.info("Following max. {} redirects", (Object)maxRedirects);
            }
        }
        ProtocolOutput protocolOutput = this.getProtocolOutput(url, datum, this.checkRobotsTxt);
        Text turl = new Text(url);
        for (numRedirects = 0; protocolOutput != null && !protocolOutput.getStatus().isSuccess() && this.followRedirects && protocolOutput.getStatus().isRedirect() && maxRedirects >= numRedirects; ++numRedirects) {
            String[] stuff = protocolOutput.getStatus().getArgs();
            url = stuff[0];
            LOG.info("Follow redirect to {}", (Object)url);
            if (this.normalizers != null) {
                url = this.normalizers.normalize(url, "default");
            }
            turl.set(url);
            protocolOutput = this.getProtocolOutput(url, datum, this.checkRobotsTxt);
        }
        if (this.checkRobotsTxt && protocolOutput == null) {
            System.err.println("Fetch disallowed by robots.txt");
            return -1;
        }
        if (!protocolOutput.getStatus().isSuccess()) {
            System.err.println("Fetch failed with protocol status: " + protocolOutput.getStatus());
            if (protocolOutput.getStatus().isRedirect()) {
                System.err.println("Redirect(s) not handled due to configuration.");
                System.err.println("Max Redirects to handle per config: " + maxRedirects);
                System.err.println("Number of Redirects handled: " + numRedirects);
            }
            return -1;
        }
        Content content = protocolOutput.getContent();
        if (content == null) {
            output.append("No content for " + url + "\n");
            return 0;
        }
        String contentType = content.getContentType();
        if (contentType == null) {
            LOG.error("Failed to determine content type!");
            return -1;
        }
        datum.getMetaData().put((Writable)new Text("Content-Type"), (Writable)new Text(contentType));
        if (ParseSegment.isTruncated(content)) {
            LOG.warn("Content is truncated, parse may fail!");
        }
        ScoringFilters scfilters = new ScoringFilters(this.getConf());
        try {
            scfilters.passScoreBeforeParsing(turl, datum, content);
        }
        catch (Exception e) {
            LOG.warn("Couldn't pass score, url {} ({})", (Object)url, (Object)e);
        }
        LOG.info("parsing: {}", (Object)url);
        LOG.info("contentType: {}", (Object)contentType);
        ParseResult parseResult = new ParseUtil(this.getConf()).parse(content);
        NutchDocument doc = new NutchDocument();
        doc.add("id", url);
        Text urlText = new Text(url);
        Inlinks inlinks = null;
        Parse parse = parseResult.get(urlText);
        if (parse == null) {
            LOG.error("Failed to get parse from parse result");
            LOG.error("Available parses in parse result (by URL key):");
            for (Map.Entry<Text, Parse> entry : parseResult) {
                LOG.error("  " + entry.getKey());
            }
            LOG.error("Parse result does not contain a parse for URL to be checked:");
            LOG.error("  " + urlText);
            return -1;
        }
        byte[] signature = SignatureFactory.getSignature(this.getConf()).calculate(content, parse);
        parse.getData().getContentMeta().set("nutch.content.digest", StringUtil.toHexString(signature));
        String digest = parse.getData().getContentMeta().get("nutch.content.digest");
        doc.add("digest", digest);
        datum.setSignature(signature);
        try {
            scfilters.passScoreAfterParsing(turl, content, parseResult.get(turl));
        }
        catch (Exception e) {
            LOG.warn("Couldn't pass score, url {} ({})", (Object)turl, (Object)e);
        }
        IndexingFilters indexers = new IndexingFilters(this.getConf());
        try {
            doc = indexers.filter(doc, parse, urlText, datum, inlinks);
        }
        catch (IndexingException e) {
            e.printStackTrace();
        }
        if (doc == null) {
            output.append("Document discarded by indexing filter\n");
            return 0;
        }
        for (String fname : doc.getFieldNames()) {
            List<Object> values = doc.getField(fname).getValues();
            if (values == null) continue;
            for (Object value : values) {
                String str = value.toString();
                int minText = this.dumpText ? str.length() : Math.min(100, str.length());
                output.append(fname + " :\t" + str.substring(0, minText) + "\n");
            }
        }
        output.append("\n");
        if (this.doIndex) {
            IndexWriters writers = IndexWriters.get(this.getConf());
            writers.open(this.getConf(), "IndexingFilterChecker");
            writers.write(doc);
            writers.close();
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new IndexingFiltersChecker(), (String[])args);
        System.exit(res);
    }
}

