/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.hostdb;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.hostdb.HostDatum;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.apache.nutch.util.SegmentReaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadHostDb
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String HOSTDB_DUMP_HEADER = "hostdb.dump.field.header";
    public static final String HOSTDB_DUMP_HOSTNAMES = "hostdb.dump.hostnames";
    public static final String HOSTDB_DUMP_HOMEPAGES = "hostdb.dump.homepages";
    public static final String HOSTDB_FILTER_EXPRESSION = "hostdb.filter.expression";

    private void readHostDb(Path hostDb, Path output, boolean dumpHomepages, boolean dumpHostnames, String expr) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LOG.info("ReadHostDb: starting");
        Configuration conf = this.getConf();
        conf.setBoolean(HOSTDB_DUMP_HOMEPAGES, dumpHomepages);
        conf.setBoolean(HOSTDB_DUMP_HOSTNAMES, dumpHostnames);
        if (expr != null) {
            conf.set(HOSTDB_FILTER_EXPRESSION, expr);
        }
        conf.setBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", false);
        conf.set("mapreduce.output.textoutputformat.separator", "\t");
        Job job = Job.getInstance((Configuration)conf, (String)"Nutch ReadHostDb");
        job.setJarByClass(ReadHostDb.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(hostDb, "current"));
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.setMapperClass(ReadHostDbMapper.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(0);
        try {
            boolean success = job.waitForCompletion(true);
            if (!success) {
                String message = NutchJob.getJobFailureLogMessage("ReadHostDb", job);
                LOG.error(message);
                throw new RuntimeException(message);
            }
        }
        catch (IOException | ClassNotFoundException | InterruptedException e) {
            LOG.error("ReadHostDb job failed: {}", (Object)e.getMessage());
            throw e;
        }
        stopWatch.stop();
        LOG.info("ReadHostDb: finished, elapsed: {} ms", (Object)stopWatch.getTime(TimeUnit.MILLISECONDS));
    }

    private void getHostDbRecord(Path hostDb, String host) throws Exception {
        Configuration conf = this.getConf();
        SequenceFile.Reader[] readers = SegmentReaderUtil.getReaders(hostDb, conf);
        Class keyClass = readers[0].getKeyClass();
        Class valueClass = readers[0].getValueClass();
        if (!keyClass.getName().equals("org.apache.hadoop.io.Text")) {
            throw new IOException("Incompatible key (" + keyClass.getName() + ")");
        }
        Text key = (Text)keyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        HostDatum value = (HostDatum)valueClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        for (int i = 0; i < readers.length; ++i) {
            while (readers[i].next((Writable)key, (Writable)value)) {
                if (!host.equals(key.toString())) continue;
                System.out.println(value.toString());
            }
            readers[i].close();
        }
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new ReadHostDb(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: ReadHostDb <hostdb> [-get <url>] [<output> [-dumpHomepages | -dumpHostnames | -expr <expr.>]]");
            return -1;
        }
        boolean dumpHomepages = false;
        boolean dumpHostnames = false;
        String expr = null;
        String get = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-dumpHomepages")) {
                LOG.info("ReadHostDb: dumping homepage URL's");
                dumpHomepages = true;
            }
            if (args[i].equals("-dumpHostnames")) {
                LOG.info("ReadHostDb: dumping hostnames");
                dumpHostnames = true;
            }
            if (args[i].equals("-get")) {
                get = args[i + 1];
                LOG.info("ReadHostDb: get: " + get);
                ++i;
            }
            if (!args[i].equals("-expr")) continue;
            expr = args[i + 1];
            LOG.info("ReadHostDb: evaluating expression: " + expr);
            ++i;
        }
        try {
            if (get != null) {
                this.getHostDbRecord(new Path(args[0], "current"), get);
            } else {
                this.readHostDb(new Path(args[0]), new Path(args[1]), dumpHomepages, dumpHostnames, expr);
            }
            return 0;
        }
        catch (Exception e) {
            LOG.error("ReadHostDb: " + StringUtils.stringifyException((Throwable)e));
            return -1;
        }
    }

    static class ReadHostDbMapper
    extends Mapper<Text, HostDatum, Text, Text> {
        protected boolean dumpHostnames = false;
        protected boolean dumpHomepages = false;
        protected boolean fieldHeader = true;
        protected Text emptyText = new Text();
        protected JexlScript expr = null;

        ReadHostDbMapper() {
        }

        public void setup(Mapper.Context context) {
            this.dumpHomepages = context.getConfiguration().getBoolean(ReadHostDb.HOSTDB_DUMP_HOMEPAGES, false);
            this.dumpHostnames = context.getConfiguration().getBoolean(ReadHostDb.HOSTDB_DUMP_HOSTNAMES, false);
            this.fieldHeader = context.getConfiguration().getBoolean(ReadHostDb.HOSTDB_DUMP_HEADER, true);
            String expr = context.getConfiguration().get(ReadHostDb.HOSTDB_FILTER_EXPRESSION);
            if (expr != null) {
                JexlEngine jexl = new JexlBuilder().silent(true).strict(true).create();
                this.expr = jexl.createScript(expr);
            }
        }

        public void map(Text key, HostDatum datum, Mapper.Context context) throws IOException, InterruptedException {
            if (this.fieldHeader && !this.dumpHomepages && !this.dumpHostnames) {
                context.write((Object)new Text("hostname"), (Object)new Text("unfetched\tfetched\tgone\tredirTemp\tredirPerm\tnotModified\tnumRecords\tdnsFail\tcnxFail\tsumFail\tscore\tlastCheck\thomepage\tmetadata"));
                this.fieldHeader = false;
            }
            if (this.expr != null) {
                MapContext jcontext = new MapContext();
                jcontext.set("unfetched", (Object)datum.getUnfetched());
                jcontext.set("fetched", (Object)datum.getFetched());
                jcontext.set("gone", (Object)datum.getGone());
                jcontext.set("redirTemp", (Object)datum.getRedirTemp());
                jcontext.set("redirPerm", (Object)datum.getRedirPerm());
                jcontext.set("redirs", (Object)(datum.getRedirPerm() + datum.getRedirTemp()));
                jcontext.set("notModified", (Object)datum.getNotModified());
                jcontext.set("ok", (Object)(datum.getFetched() + datum.getNotModified()));
                jcontext.set("numRecords", (Object)datum.numRecords());
                jcontext.set("dnsFailures", (Object)datum.getDnsFailures());
                jcontext.set("connectionFailures", (Object)datum.getConnectionFailures());
                if (datum.hasMetaData()) {
                    for (Map.Entry entry : datum.getMetaData().entrySet()) {
                        Text tkey;
                        Object value = entry.getValue();
                        if (value instanceof FloatWritable) {
                            FloatWritable fvalue = (FloatWritable)value;
                            tkey = (Text)entry.getKey();
                            jcontext.set(tkey.toString(), (Object)Float.valueOf(fvalue.get()));
                        }
                        if (!(value instanceof IntWritable)) continue;
                        IntWritable ivalue = (IntWritable)value;
                        tkey = (Text)entry.getKey();
                        jcontext.set(tkey.toString(), (Object)ivalue.get());
                    }
                }
                try {
                    if (!Boolean.TRUE.equals(this.expr.execute((JexlContext)jcontext))) {
                        return;
                    }
                }
                catch (Exception e) {
                    LOG.info(e.toString() + " for " + key.toString());
                }
            }
            if (this.dumpHomepages) {
                if (datum.hasHomepageUrl()) {
                    context.write((Object)new Text(datum.getHomepageUrl()), (Object)this.emptyText);
                }
                return;
            }
            if (this.dumpHostnames) {
                context.write((Object)key, (Object)this.emptyText);
                return;
            }
            context.write((Object)key, (Object)new Text(datum.toString()));
        }
    }
}

