/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.fetcher;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.fetcher.FetchItemQueues;
import org.apache.nutch.net.URLFilterException;
import org.apache.nutch.net.URLFilters;
import org.apache.nutch.net.URLNormalizers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueFeeder
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Mapper.Context context;
    private FetchItemQueues queues;
    private int size;
    private long timelimit = -1L;
    private URLFilters urlFilters = null;
    private URLNormalizers urlNormalizers = null;
    private String urlNormalizerScope = "default";

    public QueueFeeder(Mapper.Context context, FetchItemQueues queues, int size) {
        this.context = context;
        this.queues = queues;
        this.size = size;
        this.setDaemon(true);
        this.setName("QueueFeeder");
        Configuration conf = context.getConfiguration();
        if (conf.getBoolean("fetcher.filter.urls", false)) {
            this.urlFilters = new URLFilters(conf);
        }
        if (conf.getBoolean("fetcher.normalize.urls", false)) {
            this.urlNormalizers = new URLNormalizers(conf, this.urlNormalizerScope);
        }
    }

    public void setTimeLimit(long tl) {
        this.timelimit = tl;
    }

    private String filterNormalize(String url) {
        if (url != null) {
            try {
                if (this.urlNormalizers != null) {
                    url = this.urlNormalizers.normalize(url, this.urlNormalizerScope);
                }
                if (this.urlFilters != null) {
                    url = this.urlFilters.filter(url);
                }
            }
            catch (MalformedURLException | URLFilterException e) {
                LOG.warn("Skipping {}: {}", (Object)url, (Object)e);
                url = null;
            }
        }
        return url;
    }

    @Override
    public void run() {
        boolean hasMore = true;
        int cnt = 0;
        int[] queuingStatus = new int[FetchItemQueues.QueuingStatus.values().length];
        while (hasMore) {
            if (this.timelimit != -1L && System.currentTimeMillis() >= this.timelimit) {
                try {
                    hasMore = this.context.nextKeyValue();
                    int n = FetchItemQueues.QueuingStatus.HIT_BY_TIMELIMIT.ordinal();
                    queuingStatus[n] = queuingStatus[n] + 1;
                    continue;
                }
                catch (IOException e) {
                    LOG.error("QueueFeeder error reading input, record " + cnt, (Throwable)e);
                    return;
                }
                catch (InterruptedException e) {
                    LOG.info("QueueFeeder interrupted, exception:", (Throwable)e);
                    return;
                }
            }
            int feed = this.size - this.queues.getTotalSize();
            if (feed <= 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            LOG.debug("-feeding {} input urls ...", (Object)feed);
            while (feed > 0 && hasMore) {
                try {
                    hasMore = this.context.nextKeyValue();
                    if (!hasMore) continue;
                    Text url = (Text)this.context.getCurrentKey();
                    if (this.urlFilters != null || this.urlNormalizers != null) {
                        String u = this.filterNormalize(url.toString());
                        if (u == null) {
                            this.context.getCounter("FetcherStatus", "filtered").increment(1L);
                            continue;
                        }
                        url = new Text(u);
                    } else {
                        url = new Text(url);
                    }
                    CrawlDatum datum = new CrawlDatum();
                    datum.set((CrawlDatum)this.context.getCurrentValue());
                    FetchItemQueues.QueuingStatus status = this.queues.addFetchItem(url, datum);
                    int n = status.ordinal();
                    queuingStatus[n] = queuingStatus[n] + 1;
                    if (status == FetchItemQueues.QueuingStatus.ABOVE_EXCEPTION_THRESHOLD) {
                        this.context.getCounter("FetcherStatus", "AboveExceptionThresholdInQueue").increment(1L);
                    }
                    ++cnt;
                    --feed;
                }
                catch (IOException e) {
                    LOG.error("QueueFeeder error reading input, record " + cnt, (Throwable)e);
                    return;
                }
                catch (InterruptedException e) {
                    LOG.info("QueueFeeder interrupted, exception:", (Throwable)e);
                }
            }
        }
        this.queues.feederAlive = false;
        LOG.info("QueueFeeder finished: total {} records", (Object)cnt);
        LOG.info("QueueFeeder queuing status:");
        for (FetchItemQueues.QueuingStatus status : FetchItemQueues.QueuingStatus.values()) {
            LOG.info("\t{}\t{}", (Object)queuingStatus[status.ordinal()], (Object)status);
        }
    }
}

