/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.fetcher;

import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Locale;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchItem {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    int outlinkDepth = 0;
    String queueID;
    Text url;
    URL u;
    CrawlDatum datum;

    public FetchItem(Text url, URL u, CrawlDatum datum, String queueID) {
        this(url, u, datum, queueID, 0);
    }

    public FetchItem(Text url, URL u, CrawlDatum datum, String queueID, int outlinkDepth) {
        this.url = url;
        this.u = u;
        this.datum = datum;
        this.queueID = queueID;
        this.outlinkDepth = outlinkDepth;
    }

    public static FetchItem create(Text url, CrawlDatum datum, String queueMode) {
        return FetchItem.create(url, datum, queueMode, 0);
    }

    public static FetchItem create(Text url, CrawlDatum datum, String queueMode, int outlinkDepth) {
        String key;
        URL u = null;
        try {
            u = new URL(url.toString());
        }
        catch (Exception e) {
            LOG.warn("Cannot parse url: " + url, (Throwable)e);
            return null;
        }
        if ("byIP".equalsIgnoreCase(queueMode)) {
            try {
                InetAddress addr = InetAddress.getByName(u.getHost());
                key = addr.getHostAddress();
            }
            catch (UnknownHostException e) {
                LOG.warn("Unable to resolve: " + u.getHost() + ", skipping.");
                return null;
            }
        } else if ("byDomain".equalsIgnoreCase(queueMode)) {
            key = URLUtil.getDomainName(u).toLowerCase(Locale.ROOT);
            if (key == null) {
                LOG.warn("Unknown domain for url: " + url + ", using URL string as key");
                key = u.toExternalForm();
            }
        } else {
            key = u.getHost().toLowerCase(Locale.ROOT);
            if (key == null) {
                LOG.warn("Unknown host for url: " + url + ", using URL string as key");
                key = u.toExternalForm();
            }
        }
        return new FetchItem(url, u, datum, key, outlinkDepth);
    }

    public CrawlDatum getDatum() {
        return this.datum;
    }

    public String getQueueID() {
        return this.queueID;
    }

    public Text getUrl() {
        return this.url;
    }

    public URL getURL2() {
        return this.u;
    }
}

