/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MapFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.HashPartitioner;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.crawl.Inlink;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.util.AbstractChecker;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkDbReader
extends AbstractChecker
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Partitioner<Text, Inlinks> PARTITIONER = new HashPartitioner();
    private Path directory;
    private MapFile.Reader[] readers;
    private long lastModified = 0L;

    public LinkDbReader() {
    }

    public LinkDbReader(Configuration conf, Path directory) throws Exception {
        this.setConf(conf);
        this.init(directory);
    }

    public void init(Path directory) throws Exception {
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openReaders() throws IOException {
        Path linkDbPath = new Path(this.directory, "current");
        FileStatus stat = linkDbPath.getFileSystem(this.getConf()).getFileStatus(this.directory);
        long lastModified = stat.getModificationTime();
        LinkDbReader linkDbReader = this;
        synchronized (linkDbReader) {
            if (this.readers != null) {
                if (this.lastModified == lastModified) {
                    return;
                }
                this.close();
            }
            this.lastModified = lastModified;
            this.readers = MapFileOutputFormat.getReaders((Path)linkDbPath, (Configuration)this.getConf());
        }
    }

    public String[] getAnchors(Text url) throws IOException {
        Inlinks inlinks = this.getInlinks(url);
        if (inlinks == null) {
            return null;
        }
        return inlinks.getAnchors();
    }

    public Inlinks getInlinks(Text url) throws IOException {
        this.openReaders();
        return (Inlinks)MapFileOutputFormat.getEntry((MapFile.Reader[])this.readers, PARTITIONER, (WritableComparable)url, (Writable)new Inlinks());
    }

    @Override
    public void close() throws IOException {
        if (this.readers != null) {
            for (int i = 0; i < this.readers.length; ++i) {
                this.readers[i].close();
            }
        }
    }

    public void processDumpJob(String linkdb, String output, String regex) throws IOException, InterruptedException, ClassNotFoundException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LOG.info("LinkDb dump: starting");
        LOG.info("LinkDb dump: db: {}", (Object)linkdb);
        Path outFolder = new Path(output);
        Job job = Job.getInstance((Configuration)this.getConf(), (String)("Nutch LinkDbReader: " + linkdb));
        job.setJarByClass(LinkDbReader.class);
        Configuration conf = job.getConfiguration();
        if (regex != null) {
            conf.set("linkdb.regex", regex);
            job.setMapperClass(LinkDBDumpMapper.class);
        }
        FileInputFormat.addInputPath((Job)job, (Path)new Path(linkdb, "current"));
        job.setInputFormatClass(SequenceFileInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)outFolder);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Inlinks.class);
        try {
            boolean success = job.waitForCompletion(true);
            if (!success) {
                String message = NutchJob.getJobFailureLogMessage("LinkDbRead", job);
                LOG.error(message);
                throw new RuntimeException(message);
            }
        }
        catch (IOException | ClassNotFoundException | InterruptedException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw e;
        }
        stopWatch.stop();
        LOG.info("LinkDb dump: finished, elapsed: {} ms", (Object)stopWatch.getTime(TimeUnit.MILLISECONDS));
    }

    @Override
    protected int process(String line, StringBuilder output) throws Exception {
        Inlinks links = this.getInlinks(new Text(line));
        if (links == null) {
            output.append(" - no link information.");
        } else {
            Iterator<Inlink> it = links.iterator();
            while (it.hasNext()) {
                output.append(it.next().toString());
                output.append("\n");
            }
        }
        output.append("\n");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new LinkDbReader(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: LinkDbReader <linkdb> (-dump <out_dir> [-regex <regex>] | -url <url> | -listen <port>)");
            System.err.println("\t-dump <out_dir>\tdump whole link db to a text file in <out_dir>");
            System.err.println("\t\t-regex <regex>\trestrict to url's matching expression");
            System.err.println("\t-url <url>\tprint information about <url> to System.out");
            System.err.println("\t-listen <port> [-keepClientCnxOpen]\tlisten on <port> for URLs and");
            System.err.println("\t\t\tsend information about <url> back");
            return -1;
        }
        int numConsumed = 0;
        try {
            for (int i = 1; i < args.length; ++i) {
                if (args[i].equals("-dump")) {
                    String regex = null;
                    for (int j = i + 1; j < args.length; ++j) {
                        if (!args[i].equals("-regex")) continue;
                        regex = args[++j];
                    }
                    this.processDumpJob(args[0], args[i + 1], regex);
                    return 0;
                }
                if (args[i].equals("-url")) {
                    this.init(new Path(args[0]));
                    return this.processSingle(args[++i]);
                }
                numConsumed = super.parseArgs(args, i);
                if (numConsumed > 0) {
                    this.init(new Path(args[0]));
                    i += numConsumed - 1;
                    continue;
                }
                System.err.println("Error: wrong argument " + args[1]);
                return -1;
            }
        }
        catch (Exception e) {
            LOG.error("LinkDbReader: " + StringUtils.stringifyException((Throwable)e));
            return -1;
        }
        if (numConsumed > 0) {
            return super.run();
        }
        return 0;
    }

    public static class LinkDBDumpMapper
    extends Mapper<Text, Inlinks, Text, Inlinks> {
        Pattern pattern = null;
        Matcher matcher = null;

        public void setup(Mapper.Context context) {
            Configuration conf = context.getConfiguration();
            if (conf.get("linkdb.regex", null) != null) {
                this.pattern = Pattern.compile(conf.get("linkdb.regex"));
            }
        }

        public void map(Text key, Inlinks value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.pattern != null) {
                this.matcher = this.pattern.matcher(key.toString());
                if (!this.matcher.matches()) {
                    return;
                }
            }
            context.write((Object)key, (Object)value);
        }
    }
}

