/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MapFileOutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.CrawlDb;
import org.apache.nutch.crawl.CrawlDbFilter;
import org.apache.nutch.crawl.FetchSchedule;
import org.apache.nutch.crawl.FetchScheduleFactory;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlDbMerger
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public CrawlDbMerger() {
    }

    public CrawlDbMerger(Configuration conf) {
        this.setConf(conf);
    }

    public void merge(Path output, Path[] dbs, boolean normalize, boolean filter) throws Exception {
        Path lock = CrawlDb.lock(this.getConf(), output, false);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LOG.info("CrawlDb merge: starting");
        Job job = CrawlDbMerger.createMergeJob(this.getConf(), output, normalize, filter);
        for (int i = 0; i < dbs.length; ++i) {
            LOG.info("Adding {}", (Object)dbs[i]);
            FileInputFormat.addInputPath((Job)job, (Path)new Path(dbs[i], "current"));
        }
        Path outPath = FileOutputFormat.getOutputPath((JobContext)job);
        FileSystem fs = outPath.getFileSystem(this.getConf());
        try {
            boolean success = job.waitForCompletion(true);
            if (!success) {
                String message = NutchJob.getJobFailureLogMessage("CrawlDbMerger", job);
                LOG.error(message);
                NutchJob.cleanupAfterFailure(outPath, lock, fs);
                throw new RuntimeException(message);
            }
            CrawlDb.install(job, output);
        }
        catch (IOException | ClassNotFoundException | InterruptedException e) {
            LOG.error("CrawlDbMerge job failed: {}", (Object)e.getMessage());
            NutchJob.cleanupAfterFailure(outPath, lock, fs);
            throw e;
        }
        stopWatch.stop();
        LOG.info("CrawlDb merge: finished, elapsed: {}", (Object)stopWatch.getTime(TimeUnit.MILLISECONDS));
    }

    public static Job createMergeJob(Configuration conf, Path output, boolean normalize, boolean filter) throws IOException {
        Path newCrawlDb = new Path(output, "merge-" + Integer.toString(new Random().nextInt(Integer.MAX_VALUE)));
        Job job = Job.getInstance((Configuration)conf, (String)("Nutch CrawlDbMerger: " + output));
        conf = job.getConfiguration();
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setJarByClass(CrawlDbMerger.class);
        job.setMapperClass(CrawlDbFilter.class);
        conf.setBoolean("crawldb.url.filters", filter);
        conf.setBoolean("crawldb.url.normalizers", normalize);
        job.setReducerClass(Merger.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)newCrawlDb);
        job.setOutputFormatClass(MapFileOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(CrawlDatum.class);
        return job;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new CrawlDbMerger(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: CrawlDbMerger <output_crawldb> <crawldb1> [<crawldb2> <crawldb3> ...] [-normalize] [-filter]");
            System.err.println("\toutput_crawldb\toutput CrawlDb");
            System.err.println("\tcrawldb1 ...\tinput CrawlDb-s (single input CrawlDb is ok)");
            System.err.println("\t-normalize\tuse URLNormalizer on urls in the crawldb(s) (usually not needed)");
            System.err.println("\t-filter\tuse URLFilters on urls in the crawldb(s)");
            return -1;
        }
        Path output = new Path(args[0]);
        ArrayList<Path> dbs = new ArrayList<Path>();
        boolean filter = false;
        boolean normalize = false;
        for (int i = 1; i < args.length; ++i) {
            if ("-filter".equals(args[i])) {
                filter = true;
                continue;
            }
            if ("-normalize".equals(args[i])) {
                normalize = true;
                continue;
            }
            Path dbPath = new Path(args[i]);
            FileSystem fs = dbPath.getFileSystem(this.getConf());
            if (!fs.exists(dbPath)) continue;
            dbs.add(dbPath);
        }
        try {
            this.merge(output, dbs.toArray(new Path[dbs.size()]), normalize, filter);
            return 0;
        }
        catch (Exception e) {
            LOG.error("CrawlDb merge: " + StringUtils.stringifyException((Throwable)e));
            return -1;
        }
    }

    public static class Merger
    extends Reducer<Text, CrawlDatum, Text, CrawlDatum> {
        private FetchSchedule schedule;

        public void setup(Reducer.Context context) {
            Configuration conf = context.getConfiguration();
            this.schedule = FetchScheduleFactory.getFetchSchedule(conf);
        }

        public void reduce(Text key, Iterable<CrawlDatum> values, Reducer.Context context) throws IOException, InterruptedException {
            CrawlDatum res = new CrawlDatum();
            res.setFetchTime(-1L);
            MapWritable meta = new MapWritable();
            for (CrawlDatum val : values) {
                if (this.isNewer(res, val)) {
                    meta = this.mergeMeta(val.getMetaData(), meta);
                    res.set(val);
                    continue;
                }
                meta = this.mergeMeta(meta, val.getMetaData());
            }
            res.setMetaData(meta);
            context.write((Object)key, (Object)res);
        }

        private boolean isNewer(CrawlDatum cd1, CrawlDatum cd2) {
            return this.schedule.calculateLastFetchTime(cd2) > this.schedule.calculateLastFetchTime(cd1) || this.schedule.calculateLastFetchTime(cd2) == this.schedule.calculateLastFetchTime(cd1) && cd2.getFetchTime() > cd1.getFetchTime();
        }

        private MapWritable mergeMeta(MapWritable from, MapWritable to) {
            for (Map.Entry e : from.entrySet()) {
                to.put((Writable)e.getKey(), (Writable)e.getValue());
            }
            return to;
        }
    }
}

