/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.interactiveselenium;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.metadata.SpellCheckedMetadata;
import org.apache.nutch.net.protocols.HttpDateFormat;
import org.apache.nutch.net.protocols.Response;
import org.apache.nutch.protocol.ProtocolException;
import org.apache.nutch.protocol.http.api.HttpBase;
import org.apache.nutch.protocol.http.api.HttpException;
import org.apache.nutch.protocol.interactiveselenium.DummyX509TrustManager;
import org.apache.nutch.protocol.interactiveselenium.Http;
import org.apache.nutch.protocol.interactiveselenium.handlers.InteractiveSeleniumHandler;
import org.apache.nutch.protocol.selenium.HttpWebClient;
import org.openqa.selenium.WebDriver;

public class HttpResponse
implements Response {
    private Http http;
    private URL url;
    private String orig;
    private String base;
    private byte[] content;
    private int code;
    private Metadata headers;
    private InteractiveSeleniumHandler[] handlers;
    private StringBuffer httpHeaders;
    private Configuration conf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse(Http http, URL url, CrawlDatum datum) throws ProtocolException, IOException {
        block44: {
            Object portString;
            int port;
            this.headers = new SpellCheckedMetadata();
            this.conf = null;
            this.conf = http.getConf();
            this.http = http;
            this.url = url;
            this.orig = url.toString();
            this.base = url.toString();
            Scheme scheme = null;
            if ("http".equals(url.getProtocol())) {
                scheme = Scheme.HTTP;
            } else if ("https".equals(url.getProtocol())) {
                scheme = Scheme.HTTPS;
            } else {
                throw new HttpException("Unknown scheme (not http/https) for url:" + url);
            }
            if (Http.LOG.isTraceEnabled()) {
                Http.LOG.trace("fetching " + url);
            }
            String path = "".equals(url.getFile()) ? "/" : url.getFile();
            String host = url.getHost();
            if (url.getPort() == -1) {
                port = scheme == Scheme.HTTP ? 80 : 443;
                portString = "";
            } else {
                port = url.getPort();
                portString = ":" + port;
            }
            try (Socket socket = null;){
                String accept;
                String acceptCharset;
                String acceptLanguage;
                socket = new Socket();
                socket.setSoTimeout(http.getTimeout());
                String sockHost = http.useProxy(url) ? http.getProxyHost() : host;
                int sockPort = http.useProxy(url) ? http.getProxyPort() : port;
                InetSocketAddress sockAddr = new InetSocketAddress(sockHost, sockPort);
                socket.connect(sockAddr, http.getTimeout());
                if (scheme == Scheme.HTTPS) {
                    SSLSocketFactory factory;
                    if (http.isTlsCheckCertificates()) {
                        factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    } else {
                        SSLContext sslContext = SSLContext.getInstance("TLS");
                        sslContext.init(null, new TrustManager[]{new DummyX509TrustManager(null)}, null);
                        factory = sslContext.getSocketFactory();
                    }
                    SSLSocket sslsocket = (SSLSocket)factory.createSocket(socket, sockHost, sockPort, true);
                    sslsocket.setUseClientMode(true);
                    HashSet<String> protocols = new HashSet<String>(Arrays.asList(sslsocket.getSupportedProtocols()));
                    HashSet<String> ciphers = new HashSet<String>(Arrays.asList(sslsocket.getSupportedCipherSuites()));
                    protocols.retainAll(http.getTlsPreferredProtocols());
                    ciphers.retainAll(http.getTlsPreferredCipherSuites());
                    sslsocket.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
                    sslsocket.setEnabledCipherSuites(ciphers.toArray(new String[ciphers.size()]));
                    sslsocket.startHandshake();
                    socket = sslsocket;
                }
                if (sockAddr != null && this.conf.getBoolean("store.ip.address", false)) {
                    this.headers.add("_ip_", sockAddr.getAddress().getHostAddress());
                }
                OutputStream req = socket.getOutputStream();
                StringBuffer reqStr = new StringBuffer("GET ");
                if (http.useProxy(url)) {
                    reqStr.append(url.getProtocol() + "://" + host + (String)portString + path);
                } else {
                    reqStr.append(path);
                }
                reqStr.append(" HTTP/1.0\r\n");
                reqStr.append("Host: ");
                reqStr.append(host);
                reqStr.append((String)portString);
                reqStr.append("\r\n");
                reqStr.append("Accept-Encoding: x-gzip, gzip, deflate\r\n");
                String userAgent = http.getUserAgent();
                if (userAgent == null || userAgent.length() == 0) {
                    if (Http.LOG.isErrorEnabled()) {
                        Http.LOG.error("User-agent is not set!");
                    }
                } else {
                    reqStr.append("User-Agent: ");
                    reqStr.append(userAgent);
                    reqStr.append("\r\n");
                }
                if (!(acceptLanguage = http.getAcceptLanguage()).isEmpty()) {
                    reqStr.append("Accept-Language: ");
                    reqStr.append(acceptLanguage);
                    reqStr.append("\r\n");
                }
                if (!(acceptCharset = http.getAcceptCharset()).isEmpty()) {
                    reqStr.append("Accept-Charset: ");
                    reqStr.append(acceptCharset);
                    reqStr.append("\r\n");
                }
                if (!(accept = http.getAccept()).isEmpty()) {
                    reqStr.append("Accept: ");
                    reqStr.append(accept);
                    reqStr.append("\r\n");
                }
                if (http.isCookieEnabled() && datum.getMetaData().containsKey((Object)HttpBase.COOKIE)) {
                    String cookie = ((Text)datum.getMetaData().get((Object)HttpBase.COOKIE)).toString();
                    reqStr.append("Cookie: ");
                    reqStr.append(cookie);
                    reqStr.append("\r\n");
                }
                if (http.isIfModifiedSinceEnabled() && datum.getModifiedTime() > 0L) {
                    reqStr.append("If-Modified-Since: " + HttpDateFormat.toString((long)datum.getModifiedTime()));
                    reqStr.append("\r\n");
                }
                reqStr.append("\r\n");
                if (this.conf.getBoolean("store.http.request", false)) {
                    this.headers.add("_request_", reqStr.toString());
                }
                byte[] reqBytes = reqStr.toString().getBytes();
                req.write(reqBytes);
                req.flush();
                PushbackInputStream in = new PushbackInputStream(new BufferedInputStream(socket.getInputStream(), 8192), 8192);
                StringBuffer line = new StringBuffer();
                if (this.conf.getBoolean("store.http.headers", false)) {
                    this.httpHeaders = new StringBuffer();
                }
                this.headers.add("nutch.fetch.time", Long.toString(System.currentTimeMillis()));
                boolean haveSeenNonContinueStatus = false;
                while (!haveSeenNonContinueStatus) {
                    this.code = this.parseStatusLine(in, line);
                    if (this.httpHeaders != null) {
                        this.httpHeaders.append(line).append("\n");
                    }
                    this.parseHeaders(in, line);
                    haveSeenNonContinueStatus = this.code != 100;
                }
                String contentType = this.getHeader("Content-Type");
                if (contentType == null) break block44;
                if (contentType.contains("text/html") || contentType.contains("application/xhtml")) {
                    this.readPlainContent(url);
                    break block44;
                }
                try {
                    int contentLength = Integer.MAX_VALUE;
                    String contentLengthString = this.headers.get("Content-Length");
                    if (contentLengthString != null) {
                        try {
                            contentLength = Integer.parseInt(contentLengthString.trim());
                        }
                        catch (NumberFormatException ex) {
                            throw new HttpException("bad content length: " + contentLengthString);
                        }
                    }
                    if (http.getMaxContent() >= 0 && contentLength > http.getMaxContent()) {
                        contentLength = http.getMaxContent();
                    }
                    byte[] buffer = new byte[8192];
                    int bufferFilled = 0;
                    int totalRead = 0;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while ((bufferFilled = in.read(buffer, 0, buffer.length)) != -1 && totalRead + bufferFilled <= contentLength) {
                        totalRead += bufferFilled;
                        out.write(buffer, 0, bufferFilled);
                    }
                    this.content = out.toByteArray();
                }
                catch (Exception e) {
                    if (this.code == 200) {
                        throw new IOException(e.toString());
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public int getCode() {
        return this.code;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Metadata getHeaders() {
        return this.headers;
    }

    public byte[] getContent() {
        return this.content;
    }

    private void loadSeleniumHandlers() {
        if (this.handlers != null) {
            return;
        }
        String handlerConfig = this.conf.get("interactiveselenium.handlers", "DefaultHandler");
        String[] handlerNames = handlerConfig.split(",");
        this.handlers = new InteractiveSeleniumHandler[handlerNames.length];
        for (int i = 0; i < handlerNames.length; ++i) {
            try {
                String classToLoad = this.getClass().getPackage().getName() + ".handlers." + handlerNames[i];
                try {
                    this.handlers[i] = (InteractiveSeleniumHandler)InteractiveSeleniumHandler.class.cast(Class.forName(classToLoad).getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                Http.LOG.info("Successfully loaded " + classToLoad);
                continue;
            }
            catch (ClassNotFoundException e) {
                Http.LOG.info("Unable to load Handler class for: " + handlerNames[i]);
                continue;
            }
            catch (InstantiationException e) {
                Http.LOG.info("Unable to instantiate Handler: " + handlerNames[i]);
                continue;
            }
            catch (IllegalAccessException e) {
                Http.LOG.info("Illegal access with Handler: " + handlerNames[i]);
            }
        }
    }

    private void readPlainContent(URL url) throws IOException {
        if (this.handlers == null) {
            this.loadSeleniumHandlers();
        }
        Object processedPage = "";
        for (InteractiveSeleniumHandler handler : this.handlers) {
            if (!handler.shouldProcessURL(url.toString())) continue;
            WebDriver driver = HttpWebClient.getDriverForPage((String)url.toString(), (Configuration)this.conf);
            processedPage = (String)processedPage + handler.processDriver(driver);
            HttpWebClient.cleanUpDriver((WebDriver)driver);
        }
        this.content = ((String)processedPage).getBytes("UTF-8");
    }

    private int parseStatusLine(PushbackInputStream in, StringBuffer line) throws IOException, HttpException {
        int code;
        HttpResponse.readLine(in, line, false);
        int codeStart = line.indexOf(" ");
        int codeEnd = line.indexOf(" ", codeStart + 1);
        if (codeEnd == -1) {
            codeEnd = line.length();
        }
        try {
            code = Integer.parseInt(line.substring(codeStart + 1, codeEnd));
        }
        catch (NumberFormatException e) {
            throw new HttpException("bad status line '" + line + "': " + e.getMessage(), (Throwable)e);
        }
        return code;
    }

    private void processHeaderLine(StringBuffer line) throws IOException, HttpException {
        char c;
        int valueStart;
        int colonIndex = line.indexOf(":");
        if (colonIndex == -1) {
            int i;
            for (i = 0; i < line.length() && Character.isWhitespace(line.charAt(i)); ++i) {
            }
            if (i == line.length()) {
                return;
            }
            throw new HttpException("No colon in header:" + line);
        }
        String key = line.substring(0, colonIndex);
        for (valueStart = colonIndex + 1; valueStart < line.length() && ((c = line.charAt(valueStart)) == ' ' || c == '\t'); ++valueStart) {
        }
        String value = line.substring(valueStart);
        this.headers.set(key, value);
    }

    private void parseHeaders(PushbackInputStream in, StringBuffer line) throws IOException, HttpException {
        while (HttpResponse.readLine(in, line, true) != 0) {
            int pos = line.indexOf("<!DOCTYPE");
            if (pos != -1 || (pos = line.indexOf("<HTML")) != -1 || (pos = line.indexOf("<html")) != -1) {
                in.unread(line.substring(pos).getBytes("UTF-8"));
                line.setLength(pos);
                try {
                    this.processHeaderLine(line);
                }
                catch (Exception e) {
                    Http.LOG.warn("Error: ", (Throwable)e);
                }
                return;
            }
            this.processHeaderLine(line);
        }
    }

    private static int readLine(PushbackInputStream in, StringBuffer line, boolean allowContinuedLine) throws IOException {
        line.setLength(0);
        int c = in.read();
        while (c != -1) {
            block0 : switch (c) {
                case 13: {
                    if (HttpResponse.peek(in) == 10) {
                        in.read();
                    }
                }
                case 10: {
                    if (line.length() > 0 && allowContinuedLine) {
                        switch (HttpResponse.peek(in)) {
                            case 9: 
                            case 32: {
                                in.read();
                                break block0;
                            }
                        }
                    }
                    return line.length();
                }
                default: {
                    line.append((char)c);
                }
            }
            c = in.read();
        }
        throw new EOFException();
    }

    private static int peek(PushbackInputStream in) throws IOException {
        int value = in.read();
        in.unread(value);
        return value;
    }

    protected static enum Scheme {
        HTTP,
        HTTPS;

    }
}

