/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexwriter.dummy;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.nutch.indexer.IndexWriter;
import org.apache.nutch.indexer.IndexWriterParams;
import org.apache.nutch.indexer.NutchDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyIndexWriter
implements IndexWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Configuration config;
    private Writer writer;
    private boolean delete = false;
    private String path;

    public void open(Configuration conf, String name) throws IOException {
    }

    public void open(IndexWriterParams parameters) throws IOException {
        this.delete = parameters.getBoolean("delete", false);
        this.path = parameters.get("path", "/");
        if (this.path == null) {
            Object message = "Missing path.";
            message = (String)message + "\n" + this.describe();
            LOG.error((String)message);
            throw new RuntimeException((String)message);
        }
        if (this.writer != null) {
            LOG.warn("Dummy index file already open for writing");
            return;
        }
        try {
            LOG.debug("Opening dummy index file {}", (Object)this.path);
            this.writer = new BufferedWriter(new FileWriter(this.path));
        }
        catch (IOException ex) {
            LOG.error("Failed to open index file {}: {}", (Object)this.path, (Object)StringUtils.stringifyException((Throwable)ex));
        }
    }

    public void delete(String key) throws IOException {
        if (this.delete) {
            this.writer.write("delete\t" + key + "\n");
        }
    }

    public void update(NutchDocument doc) throws IOException {
        this.writer.write("update\t" + doc.getFieldValue("id") + "\n");
    }

    public void write(NutchDocument doc) throws IOException {
        this.writer.write("add\t" + doc.getFieldValue("id") + "\n");
    }

    public void close() throws IOException {
        LOG.debug("Closing dummy index file");
        this.writer.flush();
        this.writer.close();
    }

    public void commit() throws IOException {
        this.writer.write("commit\n");
    }

    public Configuration getConf() {
        return this.config;
    }

    public void setConf(Configuration conf) {
        this.config = conf;
    }

    public Map<String, Map.Entry<String, Object>> describe() {
        LinkedHashMap<String, Map.Entry<String, Object>> properties = new LinkedHashMap<String, Map.Entry<String, Object>>();
        properties.put("delete", new AbstractMap.SimpleEntry<String, Boolean>("If delete operations should be written to the file.", this.delete));
        properties.put("path", new AbstractMap.SimpleEntry<String, String>("Path where the file will be created.", this.path));
        return properties;
    }
}

