/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.json.JsonTypeCoercer;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeToken;

public class Json {
    public static final String JSON_UTF_8 = "application/json; charset=utf-8";
    public static final Type LIST_OF_MAPS_TYPE = new TypeToken<List<Map<String, Object>>>(){}.getType();
    public static final Type MAP_TYPE = new TypeToken<Map<String, Object>>(){}.getType();
    public static final Type OBJECT_TYPE = new TypeToken<Object>(){}.getType();
    private final JsonTypeCoercer fromJson = new JsonTypeCoercer();

    /*
     * Enabled aggressive exception aggregation
     */
    public String toJson(Object toConvert) {
        try (StringWriter writer = new StringWriter();){
            JsonOutput jsonOutput = this.newOutput(writer);
            try {
                jsonOutput.write(toConvert);
                String string = ((Object)writer).toString();
                if (jsonOutput != null) {
                    jsonOutput.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (jsonOutput != null) {
                    try {
                        jsonOutput.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public <T> T toType(String source, Type typeOfT) {
        return this.toType(source, typeOfT, PropertySetting.BY_NAME);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T toType(String source, Type typeOfT, PropertySetting setter) {
        try (StringReader reader = new StringReader(source);){
            T t = this.toType(reader, typeOfT, setter);
            return t;
        }
        catch (JsonException e) {
            throw new JsonException("Unable to parse: " + source, (Throwable)((Object)e));
        }
    }

    public <T> T toType(Reader source, Type typeOfT) {
        return this.toType(source, typeOfT, PropertySetting.BY_NAME);
    }

    public <T> T toType(Reader source, Type typeOfT, PropertySetting setter) {
        if (setter == null) {
            throw new JsonException("Mechanism for setting properties must be set");
        }
        try (JsonInput json = this.newInput(source);){
            Object t = this.fromJson.coerce(json, typeOfT, setter);
            return t;
        }
    }

    public JsonInput newInput(Reader from) throws UncheckedIOException {
        return new JsonInput(from, this.fromJson, PropertySetting.BY_NAME);
    }

    public JsonOutput newOutput(Appendable to) throws UncheckedIOException {
        return new JsonOutput(to);
    }
}

