/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util.concurrent;

import org.opensearch.ExceptionsHelper;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.util.concurrent.WrappedRunnable;

class TimedRunnable
extends AbstractRunnable
implements WrappedRunnable {
    private final Runnable original;
    private final long creationTimeNanos;
    private long startTimeNanos;
    private long finishTimeNanos = -1L;
    private boolean failedOrRejected = false;

    TimedRunnable(Runnable original) {
        this.original = original;
        this.creationTimeNanos = System.nanoTime();
    }

    @Override
    public void doRun() {
        try {
            this.startTimeNanos = System.nanoTime();
            this.original.run();
        }
        finally {
            this.finishTimeNanos = System.nanoTime();
        }
    }

    @Override
    public void onRejection(Exception e) {
        this.failedOrRejected = true;
        if (this.original instanceof AbstractRunnable) {
            ((AbstractRunnable)this.original).onRejection(e);
        } else {
            ExceptionsHelper.reThrowIfNotNull(e);
        }
    }

    @Override
    public void onFailure(Exception e) {
        this.failedOrRejected = true;
        ExceptionsHelper.reThrowIfNotNull(e);
    }

    @Override
    public boolean isForceExecution() {
        return this.original instanceof AbstractRunnable && ((AbstractRunnable)this.original).isForceExecution();
    }

    long getTotalNanos() {
        if (this.finishTimeNanos == -1L) {
            return -1L;
        }
        return Math.max(this.finishTimeNanos - this.creationTimeNanos, 1L);
    }

    long getTotalExecutionNanos() {
        if (this.startTimeNanos == -1L || this.finishTimeNanos == -1L) {
            return -1L;
        }
        return Math.max(this.finishTimeNanos - this.startTimeNanos, 1L);
    }

    boolean getFailedOrRejected() {
        return this.failedOrRejected;
    }

    @Override
    public Runnable unwrap() {
        return this.original;
    }
}

