/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.net.urlnormalizer.slash;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.net.URLNormalizer;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.PluginRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlashURLNormalizer
implements URLNormalizer {
    private Configuration conf;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final char QUESTION_MARK = '?';
    private static final char SLASH = '/';
    private static final char DOT = '.';
    private static final String PROTOCOL_DELIMITER = "://";
    private static String attributeFile = null;
    private static final Map<String, Boolean> slashesMap = new HashMap<String, Boolean>();

    private synchronized void readConfiguration(Reader configReader) throws IOException {
        String line;
        if (slashesMap.size() > 0) {
            return;
        }
        BufferedReader reader = new BufferedReader(configReader);
        while ((line = reader.readLine()) != null) {
            if (!StringUtils.isNotBlank((String)line) || line.startsWith("#")) continue;
            int delimiterIndex = (line = line.trim()).indexOf(" ");
            if (delimiterIndex == -1) {
                delimiterIndex = line.indexOf("\t");
            }
            String host = line.substring(0, delimiterIndex);
            String rule = line.substring(delimiterIndex + 1).trim();
            if (rule.equals("+")) {
                slashesMap.put(host, true);
                continue;
            }
            slashesMap.put(host, false);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        String pluginName = "urlnormalizer-slash";
        Extension[] extensions = PluginRepository.get((Configuration)conf).getExtensionPoint(URLNormalizer.class.getName()).getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            Extension extension = extensions[i];
            if (!extension.getDescriptor().getPluginId().equals(pluginName)) continue;
            attributeFile = extension.getAttribute("file");
            break;
        }
        if (attributeFile != null && attributeFile.trim().equals("")) {
            attributeFile = null;
        }
        if (attributeFile != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Attribute \"file\" is defined for plugin " + pluginName + " as " + attributeFile);
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("Attribute \"file\" is not defined in plugin.xml for plugin " + pluginName);
        }
        String file = conf.get("urlnormalizer.slashes.file", attributeFile);
        String stringRules = conf.get("urlnormalizer.slashes.rules");
        Reader reader = null;
        if (stringRules != null) {
            reader = new StringReader(stringRules);
        } else {
            LOG.info("Reading {} rules file {}", (Object)pluginName, (Object)file);
            reader = conf.getConfResourceAsReader(file);
        }
        try {
            if (reader == null) {
                reader = new FileReader(file);
            }
            this.readConfiguration(reader);
        }
        catch (IOException e) {
            LOG.error("Error reading " + pluginName + " rule file " + file, (Throwable)e);
        }
    }

    public String normalize(String url, String scope) throws MalformedURLException {
        URL u = new URL(url);
        String host = u.getHost();
        if (slashesMap.containsKey(host)) {
            String protocol = u.getProtocol();
            String path = u.getPath();
            if (path.length() > 1) {
                boolean trailingSlash;
                String queryString = u.getQuery();
                boolean rule = slashesMap.get(host);
                int lastIndexOfSlash = path.lastIndexOf(47);
                boolean bl = trailingSlash = lastIndexOfSlash == path.length() - 1;
                if (!trailingSlash && rule) {
                    int lastIndexOfDot = path.lastIndexOf(46);
                    if (path.length() < 6 || lastIndexOfDot == -1 || lastIndexOfDot < path.length() - 6) {
                        StringBuilder buffer = new StringBuilder(protocol);
                        buffer.append(PROTOCOL_DELIMITER);
                        buffer.append(host);
                        buffer.append(path);
                        buffer.append('/');
                        if (queryString != null) {
                            buffer.append('?');
                            buffer.append(queryString);
                        }
                        url = buffer.toString();
                    }
                } else if (trailingSlash && !rule) {
                    StringBuilder buffer = new StringBuilder(protocol);
                    buffer.append(PROTOCOL_DELIMITER);
                    buffer.append(host);
                    buffer.append(path.substring(0, lastIndexOfSlash));
                    if (queryString != null) {
                        buffer.append('?');
                        buffer.append(queryString);
                    }
                    url = buffer.toString();
                }
            }
        }
        return url;
    }
}

