/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer.replace;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldReplacer {
    private static final Logger LOG = LoggerFactory.getLogger((String)FieldReplacer.class.getName());
    private final String fieldName;
    private final String toFieldName;
    private final Pattern pattern;
    private final String replacement;
    private boolean isValid = true;

    public FieldReplacer(String fieldName, String toFieldName, String pattern, String replacement, Integer flags) {
        if (fieldName == null || fieldName.trim().length() == 0) {
            LOG.error("Empty fieldName provided, FieldReplacer marked invalid.");
            this.isValid = false;
        }
        if (pattern == null || pattern.trim().length() == 0) {
            LOG.error("Empty pattern for field " + fieldName + "provided, FieldReplacer marked invalid.");
            this.isValid = false;
        }
        this.replacement = replacement == null ? "" : replacement;
        this.fieldName = fieldName.trim();
        this.toFieldName = toFieldName.trim();
        if (this.isValid) {
            LOG.info("Compiling pattern " + pattern + " for field " + fieldName);
            Pattern myPattern = null;
            try {
                myPattern = flags != null ? Pattern.compile(pattern, flags) : Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                LOG.error("Pattern " + pattern + " for field " + fieldName + " failed to compile: " + e.toString());
                this.isValid = false;
            }
            this.pattern = myPattern;
        } else {
            this.pattern = null;
        }
    }

    public FieldReplacer(String fieldName, String pattern, String replacement, Integer flags) {
        this(fieldName, fieldName, pattern, replacement, flags);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getToFieldName() {
        return this.toFieldName;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String replace(String value) {
        if (this.isValid) {
            return this.pattern.matcher(value).replaceAll(this.replacement);
        }
        return value;
    }

    public String checkAndReplace(String fieldName, String value) {
        Matcher m;
        if (this.fieldName.equals(fieldName) && value != null && value.length() > 0 && this.isValid && (m = this.pattern.matcher(value)).find()) {
            return m.replaceAll(this.replacement);
        }
        return null;
    }
}

