/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable;

import de.vandermeer.asciitable.AT_ColumnWidthCalculator;
import de.vandermeer.asciitable.AT_Row;
import de.vandermeer.asciitable.CWC_LongestWord;
import java.util.LinkedList;
import org.apache.commons.lang3.Validate;

public class CWC_LongestWordMin
implements AT_ColumnWidthCalculator {
    protected int min;
    protected int[] minAr;

    public CWC_LongestWordMin(int min) {
        Validate.validState((min >= 3 ? 1 : 0) != 0, (String)"minimum column width cannot be smaller than 3", (Object[])new Object[0]);
        this.min = min;
    }

    public CWC_LongestWordMin(int[] minAr) {
        Validate.notNull((Object)minAr);
        for (int m : minAr) {
            if (m == -1 || m >= 3) continue;
            throw new IllegalArgumentException("array contains minimum column width smaller than 3");
        }
        this.minAr = minAr;
    }

    @Override
    public int[] calculateColumnWidths(LinkedList<AT_Row> rows, int colNumbers, int tableWidth) {
        Validate.notNull(rows);
        if (this.minAr != null && this.minAr.length != colNumbers) {
            throw new IllegalArgumentException("minAr length is not the same as rows in the table");
        }
        int[] ret = CWC_LongestWord.longestWord(rows, colNumbers);
        for (int i = 0; i < ret.length; ++i) {
            if (this.min != 0) {
                if (ret[i] >= this.min) continue;
                ret[i] = this.min;
                continue;
            }
            if (this.minAr == null || this.minAr[i] == -1 || ret[i] >= this.minAr[i]) continue;
            ret[i] = this.minAr[i];
        }
        return ret;
    }
}

