/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer.arbitrary;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.IndexingException;
import org.apache.nutch.indexer.IndexingFilter;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.parse.Parse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbitraryIndexingFilter
implements IndexingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private int arbitraryAddsCount = 0;
    private String fieldName;
    private String className;
    private String[] userConstrArgs;
    private String[] constrArgs;
    private String methodName;
    private String[] methodArgs;
    private Object result;
    private boolean overwrite = false;
    private Configuration conf;

    public NutchDocument filter(NutchDocument doc, Parse parse, Text url, CrawlDatum datum, Inlinks inlinks) throws IndexingException {
        Class<?> theClass = null;
        Method theMethod = null;
        Constructor<?> theConstructor = null;
        Object instance = null;
        if (doc == null) {
            LOG.debug("In filter() where doc is null for url == {}", (Object)String.valueOf(url));
            return doc;
        }
        if (url == null) {
            LOG.debug("In filter() where url is null. Nothing to do.");
            return doc;
        }
        int cfgCounter = 0;
        while (cfgCounter < this.arbitraryAddsCount) {
            this.setIndexedConf(this.conf, cfgCounter);
            ++cfgCounter;
            try {
                theClass = Class.forName(this.className);
                theMethod = this.methodArgs.length > 0 ? theClass.getDeclaredMethod(this.methodName, String[].class) : theClass.getMethod(this.methodName, new Class[0]);
                theConstructor = theClass.getDeclaredConstructor(String[].class);
            }
            catch (Exception e) {
                LOG.error("Exception preparing reflection tasks. className was {}", (Object)String.valueOf(this.className));
                e.printStackTrace();
            }
            try {
                this.constrArgs = new String[this.userConstrArgs.length + 1];
                this.constrArgs[0] = url.toString();
                System.arraycopy(this.userConstrArgs, 0, this.constrArgs, 1, this.userConstrArgs.length);
                instance = theConstructor.newInstance(new Object[]{this.constrArgs});
                this.result = this.methodArgs.length > 0 ? theMethod.invoke(instance, new Object[]{this.methodArgs}) : theMethod.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                LOG.error("Exception in reflection trying to instantiate/invoke. url was {} & className was {}", (Object)String.valueOf(url), (Object)String.valueOf(this.className));
                if (this.constrArgs.length > 0) {
                    LOG.error("constrArgs[1] was {}", (Object)String.valueOf(this.constrArgs[1]));
                }
                LOG.error("methodName was {}", (Object)String.valueOf(this.className));
                if (this.methodArgs.length > 0) {
                    LOG.error("methodArgs[0] was {}", (Object)String.valueOf(this.methodArgs[0]));
                }
                e.printStackTrace();
            }
            LOG.debug("{}.{}() returned {} for field {}.", new Object[]{this.className, this.methodName, String.valueOf(this.result), String.valueOf(this.fieldName)});
            if (this.overwrite) {
                LOG.debug("overwrite == true for fieldName == {} ", (Object)this.fieldName);
                if (doc.getFieldNames().contains(this.fieldName)) {
                    LOG.debug("Removing field '{}' from doc for overwrite", (Object)this.fieldName);
                    doc.removeField(this.fieldName);
                }
            }
            if (this.result == null) {
                LOG.debug("Call to {}.{} returned null", (Object)this.className, (Object)this.methodName);
                if (this.overwrite) {
                    LOG.debug("{} has been cleared.", (Object)this.fieldName);
                }
            }
            LOG.debug("Adding value '{}' for field '{}' to doc", this.result, (Object)this.fieldName);
            doc.add(this.fieldName, this.result);
        }
        return doc;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.arbitraryAddsCount = conf.getInt("index.arbitrary.function.count", 1);
        LOG.info("Will process the first {} fieldName defs in config.", (Object)String.valueOf(this.arbitraryAddsCount));
    }

    public void setIndexedConf(Configuration conf, int ndx) {
        LOG.debug("In setIndexedConf() where ndx was passed in as {}", (Object)String.valueOf(ndx));
        this.fieldName = conf.get("index.arbitrary.fieldName.".concat(String.valueOf(ndx)));
        LOG.debug("Looking now for index.arbitrary.fieldname.{} which was: {}", (Object)String.valueOf(ndx), (Object)String.valueOf(this.fieldName));
        if (this.fieldName == null || this.fieldName == "") {
            throw new RuntimeException("Problem in configuration where the index.arbitrary.fieldName." + String.valueOf(ndx) + " is missing.");
        }
        this.className = conf.get("index.arbitrary.className.".concat(String.valueOf(ndx)));
        if (this.className == null || this.className == "") {
            throw new RuntimeException("Problem in configuration where the index.arbitrary.className." + String.valueOf(ndx) + " is missing.");
        }
        this.userConstrArgs = conf.getTrimmedStrings("index.arbitrary.constructorArgs.".concat(String.valueOf(ndx)));
        this.methodName = conf.get("index.arbitrary.methodName.".concat(String.valueOf(ndx)), "");
        this.methodArgs = conf.getTrimmedStrings("index.arbitrary.methodArgs.".concat(String.valueOf(ndx)));
        this.overwrite = conf.getBoolean("index.arbitrary.overwrite.".concat(String.valueOf(ndx)), false);
        if (this.overwrite) {
            LOG.info("overwrite set == true for processing {}.", (Object)this.fieldName);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }
}

