/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.net.urlnormalizer.querystring;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.net.URLNormalizer;

public class QuerystringURLNormalizer
implements URLNormalizer {
    private Configuration conf;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public String normalize(String urlString, String scope) throws MalformedURLException {
        URL url = new URL(urlString);
        String queryString = url.getQuery();
        if (queryString == null) {
            return urlString;
        }
        List<String> queryStringParts = Arrays.asList(queryString.split("&"));
        Collections.sort(queryStringParts);
        StringBuilder sb = new StringBuilder();
        sb.append(url.getProtocol());
        sb.append("://");
        sb.append(url.getHost());
        if (url.getPort() > -1) {
            sb.append(":");
            sb.append(url.getPort());
        }
        sb.append(url.getPath());
        sb.append("?");
        sb.append(StringUtils.join(queryStringParts, (String)"&"));
        if (url.getRef() != null) {
            sb.append("#");
            sb.append(url.getRef());
        }
        return sb.toString();
    }
}

