/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.file;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.net.protocols.HttpDateFormat;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.protocol.file.File;
import org.apache.nutch.protocol.file.FileException;
import org.apache.tika.Tika;

public class FileResponse {
    private String orig;
    private String base;
    private byte[] content;
    private static final byte[] EMPTY_CONTENT = new byte[0];
    private int code;
    private Metadata headers;
    private final File file;
    private Configuration conf;
    private Tika tika;

    public int getCode() {
        return this.code;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public byte[] getContent() {
        return this.content;
    }

    public Content toContent() {
        return new Content(this.orig, this.base, this.content != null ? this.content : EMPTY_CONTENT, this.getHeader("Content-Type"), this.headers, this.conf);
    }

    public FileResponse(URL url, CrawlDatum datum, File file, Configuration conf) throws FileException, IOException {
        block13: {
            this.headers = new Metadata();
            this.orig = url.toString();
            this.base = url.toString();
            this.file = file;
            this.conf = conf;
            this.tika = new Tika();
            if (!"file".equals(url.getProtocol())) {
                throw new FileException("Not a file url:" + url);
            }
            if (File.LOG.isTraceEnabled()) {
                File.LOG.trace("fetching {}", (Object)url);
            }
            if (url.getQuery() != null) {
                File.LOG.warn("file:// URL may not include a query (query part ignored): {}", (Object)url);
            }
            String path = url.getPath().isEmpty() ? "/" : url.getPath();
            try {
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.content = null;
            java.io.File f = new java.io.File(path);
            if (!f.exists()) {
                this.code = 404;
                return;
            }
            if (!f.canRead()) {
                this.code = 401;
                return;
            }
            if (!f.equals(f.getCanonicalFile())) {
                this.headers.set("Location", f.getCanonicalFile().toURI().toURL().toString());
                this.code = 300;
                return;
            }
            if (f.lastModified() <= datum.getModifiedTime()) {
                this.code = 304;
                this.headers.set("Last-Modified", HttpDateFormat.toString((long)f.lastModified()));
                return;
            }
            if (f.isDirectory()) {
                this.getDirAsHttpResponse(f);
                break block13;
            }
            if (f.isFile()) {
                this.getFileAsHttpResponse(f);
                break block13;
            }
            this.code = 500;
            return;
        }
    }

    private void getFileAsHttpResponse(java.io.File f) throws FileException, IOException {
        int offset;
        long size = f.length();
        if (size > Integer.MAX_VALUE) {
            throw new FileException("file is too large, size: " + size);
        }
        int len = (int)size;
        if (this.file.maxContentLength >= 0 && len > this.file.maxContentLength) {
            len = this.file.maxContentLength;
        }
        this.content = new byte[len];
        FileInputStream is = new FileInputStream(f);
        int n = 0;
        for (offset = 0; offset < len && (n = ((InputStream)is).read(this.content, offset, len - offset)) >= 0; offset += n) {
        }
        if (offset < len && File.LOG.isWarnEnabled()) {
            File.LOG.warn("not enough bytes read from file: " + f.getPath());
        }
        ((InputStream)is).close();
        this.headers.set("Content-Length", Long.valueOf(size).toString());
        this.headers.set("Last-Modified", HttpDateFormat.toString((long)f.lastModified()));
        String mimeType = this.tika.detect(f);
        this.headers.set("Content-Type", mimeType != null ? mimeType : "");
        this.code = 200;
    }

    private void getDirAsHttpResponse(java.io.File f) throws IOException {
        String path = f.toString();
        this.content = this.file.crawlParents ? this.list2html(f.listFiles(), path, !"/".equals(path)) : this.list2html(f.listFiles(), path, false);
        this.headers.set("Content-Length", Integer.valueOf(this.content.length).toString());
        this.headers.set("Content-Type", "text/html");
        this.headers.set("Last-Modified", HttpDateFormat.toString((long)f.lastModified()));
        this.code = 200;
    }

    private byte[] list2html(java.io.File[] list, String path, boolean includeDotDot) {
        StringBuffer x = new StringBuffer("<html><head>");
        x.append("<title>Index of " + path + "</title></head>\n");
        x.append("<body><h1>Index of " + path + "</h1><pre>\n");
        if (includeDotDot) {
            x.append("<a href='../'>../</a>\t-\t-\t-\n");
        }
        for (int i = 0; i < list.length; ++i) {
            java.io.File f = list[i];
            String name = f.getName();
            String time = HttpDateFormat.toString((long)f.lastModified());
            if (f.isDirectory()) {
                x.append("<a href='" + name + "/'>" + name + "/</a>\t");
                x.append(time + "\t-\n");
                continue;
            }
            if (!f.isFile()) continue;
            x.append("<a href='" + name + "'>" + name + "</a>\t");
            x.append(time + "\t" + f.length() + "\n");
        }
        x.append("</pre></body></html>\n");
        return new String(x).getBytes();
    }
}

