/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.file;

import crawlercommons.robots.BaseRobotRules;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.protocol.Protocol;
import org.apache.nutch.protocol.ProtocolOutput;
import org.apache.nutch.protocol.ProtocolStatus;
import org.apache.nutch.protocol.RobotRulesParser;
import org.apache.nutch.protocol.file.FileError;
import org.apache.nutch.protocol.file.FileResponse;
import org.apache.nutch.util.NutchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class File
implements Protocol {
    protected static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final int MAX_REDIRECTS = 5;
    int maxContentLength;
    boolean crawlParents;
    boolean symlinksAsRedirects = true;
    private Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.maxContentLength = conf.getInt("file.content.limit", 0x100000);
        this.crawlParents = conf.getBoolean("file.crawl.parent", true);
        this.symlinksAsRedirects = conf.getBoolean("file.crawl.redirect_noncanonical", true);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public ProtocolOutput getProtocolOutput(Text url, CrawlDatum datum) {
        String urlString = url.toString();
        try {
            int code;
            URL u = new URL(urlString);
            int redirects = 0;
            while (true) {
                FileResponse response;
                if ((code = (response = new FileResponse(u, datum, this, this.getConf())).getCode()) == 200) {
                    return new ProtocolOutput(response.toContent());
                }
                if (code == 304) {
                    return new ProtocolOutput(response.toContent(), ProtocolStatus.STATUS_NOTMODIFIED);
                }
                if (code == 401) {
                    return new ProtocolOutput(response.toContent(), new ProtocolStatus(17));
                }
                if (code == 404) {
                    return new ProtocolOutput(response.toContent(), ProtocolStatus.STATUS_NOTFOUND);
                }
                if (code < 300 || code >= 400) break;
                u = new URL(response.getHeader("Location"));
                if (LOG.isTraceEnabled()) {
                    LOG.trace("redirect to " + u);
                }
                if (this.symlinksAsRedirects) {
                    return new ProtocolOutput(response.toContent(), new ProtocolStatus(12, (Object)u));
                }
                if (redirects == 5) {
                    LOG.trace("Too many redirects: {}", (Object)url);
                    return new ProtocolOutput(response.toContent(), new ProtocolStatus(19, (Object)u));
                }
                ++redirects;
            }
            throw new FileError(code);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ProtocolOutput(null, new ProtocolStatus((Throwable)e));
        }
    }

    public static void main(String[] args) throws Exception {
        int maxContentLength = Integer.MIN_VALUE;
        boolean dumpContent = false;
        String urlString = null;
        String usage = "Usage: File [-maxContentLength L] [-dumpContent] url";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-maxContentLength")) {
                maxContentLength = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-dumpContent")) {
                dumpContent = true;
                continue;
            }
            if (i != args.length - 1) {
                System.err.println(usage);
                System.exit(-1);
                continue;
            }
            urlString = args[i];
        }
        File file = new File();
        file.setConf(NutchConfiguration.create());
        if (maxContentLength != Integer.MIN_VALUE) {
            file.setMaxContentLength(maxContentLength);
        }
        ProtocolOutput output = file.getProtocolOutput(new Text(urlString), new CrawlDatum());
        Content content = output.getContent();
        System.err.println("URL: " + content.getUrl());
        System.err.println("Status: " + output.getStatus());
        System.err.println("Content-Type: " + content.getContentType());
        System.err.println("Content-Length: " + content.getMetadata().get("Content-Length"));
        System.err.println("Last-Modified: " + content.getMetadata().get("Last-Modified"));
        String redirectLocation = content.getMetadata().get("Location");
        if (redirectLocation != null) {
            System.err.println("Location: " + redirectLocation);
        }
        if (dumpContent) {
            System.out.print(new String(content.getContent()));
        }
        file = null;
    }

    public BaseRobotRules getRobotRules(Text url, CrawlDatum datum, List<Content> robotsTxtContent) {
        return RobotRulesParser.EMPTY_RULES;
    }
}

