/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tools.TerseFailure;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.TreeSet;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class StorageTool$
implements Logging {
    public static StorageTool$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new StorageTool$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        try {
            Namespace namespace = this.parseArguments(args);
            String command = namespace.getString("command");
            Option config = Option$.MODULE$.apply((Object)namespace.getString("config")).flatMap((Function1 & Serializable & scala.Serializable)p -> new Some((Object)new KafkaConfig(Utils.loadProps((String)p))));
            if ("info".equals(command)) {
                Seq<String> directories = this.configToLogDirectories((KafkaConfig)config.get());
                boolean selfManagedMode = this.configToSelfManagedMode((KafkaConfig)config.get());
                throw Exit$.MODULE$.exit(this.infoCommand(System.out, selfManagedMode, directories), Exit$.MODULE$.exit$default$2());
            }
            if ("format".equals(command)) {
                Seq<String> directories = this.configToLogDirectories((KafkaConfig)config.get());
                String clusterId = namespace.getString("cluster_id");
                MetadataVersion metadataVersion = this.getMetadataVersion(namespace, (Option<String>)Option$.MODULE$.apply(((KafkaConfig)config.get()).originals().get(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()));
                if (!metadataVersion.isKRaftSupported()) {
                    throw new TerseFailure("Must specify a valid KRaft metadata version of at least 3.0.");
                }
                if (!metadataVersion.isProduction()) {
                    if (Predef$.MODULE$.Boolean2boolean(((KafkaConfig)config.get()).unstableMetadataVersionsEnabled())) {
                        System.out.println(new StringBuilder(48).append("WARNING: using pre-production metadata version ").append(metadataVersion).append(".").toString());
                    } else {
                        throw new TerseFailure(new StringBuilder(54).append("Metadata version ").append(metadataVersion).append(" is not ready for production use yet.").toString());
                    }
                }
                MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(clusterId).setNodeId(((KafkaConfig)config.get()).nodeId()).build();
                ArrayBuffer metadataRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.getUserScramCredentialRecords(namespace).foreach((Function1 & Serializable & scala.Serializable)userScramCredentialRecords -> {
                    StorageTool$.$anonfun$main$3(metadataVersion, metadataRecords, userScramCredentialRecords);
                    return BoxedUnit.UNIT;
                });
                BootstrapMetadata bootstrapMetadata = this.buildBootstrapMetadata(metadataVersion, (Option<ArrayBuffer<ApiMessageAndVersion>>)new Some((Object)metadataRecords), "format command");
                Boolean ignoreFormatted = namespace.getBoolean("ignore_formatted");
                if (!this.configToSelfManagedMode((KafkaConfig)config.get())) {
                    throw new TerseFailure("The kafka configuration file appears to be for a legacy cluster. Formatting is only supported for clusters in KRaft mode.");
                }
                throw Exit$.MODULE$.exit(this.formatCommand(System.out, directories, metaProperties, bootstrapMetadata, metadataVersion, Predef$.MODULE$.Boolean2boolean(ignoreFormatted)), Exit$.MODULE$.exit$default$2());
            }
            if ("random-uuid".equals(command)) {
                System.out.println(Uuid.randomUuid());
                throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
            }
            throw new RuntimeException(new StringBuilder(16).append("Unknown command ").append(command).toString());
        }
        catch (TerseFailure e) {
            System.err.println(e.getMessage());
            throw Exit$.MODULE$.exit(1, (Option<String>)new Some((Object)e.getMessage()));
        }
    }

    public Namespace parseArguments(String[] args) {
        ArgumentParser parser2 = ArgumentParsers.newArgumentParser((String)"kafka-storage", (boolean)true, (String)"-", (String)"@").description("The Kafka storage tool.");
        Subparsers subparsers = parser2.addSubparsers().dest("command");
        Subparser infoParser = subparsers.addParser("info").help("Get information about the Kafka log directories on this node.");
        Subparser formatParser = subparsers.addParser("format").help("Format the Kafka log directories on this node.");
        subparsers.addParser("random-uuid").help("Print a random UUID.");
        new .colon.colon((Object)infoParser, (List)new .colon.colon((Object)formatParser, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)parser -> parser.addArgument(new String[]{"--config", "-c"}).action((ArgumentAction)Arguments.store()).required(true).help("The Kafka configuration file to use."));
        formatParser.addArgument(new String[]{"--cluster-id", "-t"}).action((ArgumentAction)Arguments.store()).required(true).help("The cluster ID to use.");
        formatParser.addArgument(new String[]{"--add-scram", "-S"}).action((ArgumentAction)Arguments.append()).help(new StringOps(Predef$.MODULE$.augmentString("A SCRAM_CREDENTIAL to add to the __cluster_metadata log e.g.\n              |'SCRAM-SHA-256=[name=alice,password=alice-secret]'\n              |'SCRAM-SHA-512=[name=alice,iterations=8192,salt=\"N3E=\",saltedpassword=\"YCE=\"]'")).stripMargin());
        formatParser.addArgument(new String[]{"--ignore-formatted", "-g"}).action((ArgumentAction)Arguments.storeTrue());
        formatParser.addArgument(new String[]{"--release-version", "-r"}).action((ArgumentAction)Arguments.store()).help(new StringBuilder(100).append("A KRaft release version to use for the initial metadata version. The minimum is 3.0, the default is ").append(MetadataVersion.LATEST_PRODUCTION.version()).toString());
        return parser2.parseArgsOrFail(args);
    }

    public Seq<String> configToLogDirectories(KafkaConfig config) {
        TreeSet directories = new TreeSet((Ordering)Ordering.String$.MODULE$);
        directories.$plus$plus$eq(config.logDirs());
        Option$.MODULE$.apply((Object)config.metadataLogDir()).foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)directories.add((Object)elem)));
        return directories.toSeq();
    }

    public boolean configToSelfManagedMode(KafkaConfig config) {
        return config.processRoles().nonEmpty();
    }

    public MetadataVersion getMetadataVersion(Namespace namespace, Option<String> defaultVersionString) {
        MetadataVersion metadataVersion;
        if (defaultVersionString instanceof Some) {
            metadataVersion = MetadataVersion.fromVersionString((String)((String)((Some)defaultVersionString).value()));
        } else if (None$.MODULE$.equals(defaultVersionString)) {
            metadataVersion = MetadataVersion.LATEST_PRODUCTION;
        } else {
            throw new MatchError(defaultVersionString);
        }
        MetadataVersion defaultValue = metadataVersion;
        return (MetadataVersion)Option$.MODULE$.apply((Object)namespace.getString("release_version")).map((Function1 & Serializable & scala.Serializable)ver -> MetadataVersion.fromVersionString((String)ver)).getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultValue);
    }

    public UserScramCredentialRecord getUserScramCredentialRecord(String mechanism, String config) {
        Map argMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.substring(1, config.length() - 1).split(","))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.split("=(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).map((Function1 & Serializable & scala.Serializable)args -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)args[0]), (Object)args[1].replaceAll("\"", "")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        ScramMechanism scramMechanism = ScramMechanism.forMechanismName((String)mechanism);
        String name = StorageTool$.getName$1(argMap);
        byte[] salt = StorageTool$.getSalt$1(argMap, scramMechanism);
        int iterations = StorageTool$.getIterations$1(argMap, scramMechanism);
        byte[] saltedPassword = StorageTool$.getSaltedPassword$1(argMap, scramMechanism, salt, iterations);
        try {
            ScramFormatter formatter = new ScramFormatter(scramMechanism);
            return new UserScramCredentialRecord().setName(name).setMechanism(scramMechanism.type()).setSalt(salt).setStoredKey(formatter.storedKey(formatter.clientKey(saltedPassword))).setServerKey(formatter.serverKey(saltedPassword)).setIterations(iterations);
        }
        catch (Throwable e) {
            throw new TerseFailure(new StringBuilder(54).append("Error attempting to create UserScramCredentialRecord: ").append(e.getMessage()).toString());
        }
    }

    public Option<ArrayBuffer<UserScramCredentialRecord>> getUserScramCredentialRecords(Namespace namespace) {
        if (namespace.getList("add_scram") != null) {
            List listofAddConfig = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(namespace.getList("add_scram")).asScala()).toList();
            ArrayBuffer userScramCredentialRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            listofAddConfig.foreach((Function1 & Serializable & scala.Serializable)singleAddConfig -> {
                StorageTool$.$anonfun$getUserScramCredentialRecords$1(userScramCredentialRecords, singleAddConfig);
                return BoxedUnit.UNIT;
            });
            return new Some((Object)userScramCredentialRecords);
        }
        return None$.MODULE$;
    }

    public int infoCommand(PrintStream stream, boolean selfManagedMode, Seq<String> directories) {
        ArrayBuffer problems = new ArrayBuffer();
        ArrayBuffer foundDirectories = new ArrayBuffer();
        ObjectRef prevMetadata = ObjectRef.create((Object)None$.MODULE$);
        ((IterableLike)directories.sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)directory -> {
            BoxedUnit boxedUnit;
            block8: {
                Path directoryPath = Paths.get(directory, new String[0]);
                if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
                    if (!Files.exists(directoryPath, new LinkOption[0])) {
                        return problems.$plus$eq((Object)new StringBuilder(15).append(directoryPath).append(" does not exist").toString());
                    }
                    return problems.$plus$eq((Object)new StringBuilder(19).append(directoryPath).append(" is not a directory").toString());
                }
                foundDirectories.$plus$eq((Object)((Object)directoryPath).toString());
                Path metaPath = directoryPath.resolve("meta.properties");
                if (!Files.exists(metaPath, new LinkOption[0])) {
                    return problems.$plus$eq((Object)new StringBuilder(18).append(directoryPath).append(" is not formatted.").toString());
                }
                Properties properties = PropertiesUtils.readPropertiesFile((String)((Object)metaPath).toString());
                try {
                    MetaProperties curMetadata = new MetaProperties.Builder(properties).build();
                    if (((Option)prevMetadata$1.elem).isEmpty()) {
                        prevMetadata$1.elem = new Some((Object)curMetadata);
                        boxedUnit = BoxedUnit.UNIT;
                        break block8;
                    }
                    if (!((MetaProperties)((Option)prevMetadata$1.elem).get()).clusterId().equals(curMetadata.clusterId())) {
                        boxedUnit = problems.$plus$eq((Object)"Mismatched cluster IDs between storage directories.");
                        break block8;
                    }
                    if (!((MetaProperties)((Option)prevMetadata$1.elem).get()).nodeId().equals(curMetadata.nodeId())) {
                        boxedUnit = problems.$plus$eq((Object)"Mismatched node IDs between storage directories.");
                        break block8;
                    }
                    return BoxedUnit.UNIT;
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    boxedUnit = problems.$plus$eq((Object)new StringBuilder(16).append("Error loading ").append(metaPath).append(": ").append(e.getMessage()).toString());
                }
            }
            return boxedUnit;
        });
        ((Option)prevMetadata.elem).foreach((Function1 & Serializable & scala.Serializable)prev -> {
            if (selfManagedMode) {
                if (prev.version().equals((Object)MetaPropertiesVersion.V0)) {
                    return problems.$plus$eq((Object)"The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.");
                }
                return BoxedUnit.UNIT;
            }
            if (prev.version().equals((Object)MetaPropertiesVersion.V1)) {
                return problems.$plus$eq((Object)"The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.");
            }
            return BoxedUnit.UNIT;
        });
        if (directories.isEmpty()) {
            stream.println("No directories specified.");
            return 0;
        }
        if (foundDirectories.nonEmpty()) {
            if (foundDirectories.size() == 1) {
                stream.println("Found log directory:");
            } else {
                stream.println("Found log directories:");
            }
            foundDirectories.foreach((Function1 & Serializable & scala.Serializable)d -> {
                stream.println(new StringOps(Predef$.MODULE$.augmentString("  %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d})));
                return BoxedUnit.UNIT;
            });
            stream.println("");
        }
        ((Option)prevMetadata.elem).foreach((Function1 & Serializable & scala.Serializable)prev -> {
            StorageTool$.$anonfun$infoCommand$4(stream, prev);
            return BoxedUnit.UNIT;
        });
        if (problems.nonEmpty()) {
            if (problems.size() == 1) {
                stream.println("Found problem:");
            } else {
                stream.println("Found problems:");
            }
            problems.foreach((Function1 & Serializable & scala.Serializable)d -> {
                stream.println(new StringOps(Predef$.MODULE$.augmentString("  %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d})));
                return BoxedUnit.UNIT;
            });
            stream.println("");
            return 1;
        }
        return 0;
    }

    public BootstrapMetadata buildBootstrapMetadata(MetadataVersion metadataVersion, Option<ArrayBuffer<ApiMessageAndVersion>> metadataOptionalArguments, String source) {
        ArrayList<ApiMessageAndVersion> metadataRecords = new ArrayList<ApiMessageAndVersion>();
        metadataRecords.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(metadataVersion.featureLevel()), (short)0));
        metadataOptionalArguments.foreach((Function1 & Serializable & scala.Serializable)metadataArguments -> {
            metadataArguments.foreach((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToBoolean((boolean)metadataRecords$2.add(record)));
            return BoxedUnit.UNIT;
        });
        return BootstrapMetadata.fromRecords(metadataRecords, (String)source);
    }

    public MetaProperties buildMetadataProperties(String clusterIdStr, KafkaConfig config) {
        Uuid uuid;
        try {
            uuid = Uuid.fromString((String)clusterIdStr);
        }
        catch (Throwable e) {
            throw new TerseFailure(new StringBuilder(55).append("Cluster ID string ").append(clusterIdStr).append(" ").append("does not appear to be a valid UUID: ").append(e.getMessage()).toString());
        }
        Uuid effectiveClusterId = uuid;
        if (config.nodeId() < 0) {
            throw new TerseFailure(new StringBuilder(58).append("The node.id must be set to a non-negative integer. We saw ").append(config.nodeId()).toString());
        }
        return new MetaProperties.Builder().setClusterId(effectiveClusterId.toString()).setNodeId(config.nodeId()).build();
    }

    public int formatCommand(PrintStream stream, Seq<String> directories, MetaProperties metaProperties, MetadataVersion metadataVersion, boolean ignoreFormatted) {
        BootstrapMetadata bootstrapMetadata = this.buildBootstrapMetadata(metadataVersion, (Option<ArrayBuffer<ApiMessageAndVersion>>)None$.MODULE$, "format command");
        return this.formatCommand(stream, directories, metaProperties, bootstrapMetadata, metadataVersion, ignoreFormatted);
    }

    public int formatCommand(PrintStream stream, Seq<String> directories, MetaProperties metaProperties, BootstrapMetadata bootstrapMetadata, MetadataVersion metadataVersion, boolean ignoreFormatted) {
        if (directories.isEmpty()) {
            throw new TerseFailure("No log directories found in the configuration.");
        }
        MetaPropertiesEnsemble.Loader loader = new MetaPropertiesEnsemble.Loader();
        directories.foreach((Function1 & Serializable & scala.Serializable)x$3 -> loader.addLogDir(x$3));
        MetaPropertiesEnsemble metaPropertiesEnsemble = loader.load();
        metaPropertiesEnsemble.verify(metaProperties.clusterId(), metaProperties.nodeId(), EnumSet.noneOf(MetaPropertiesEnsemble.VerificationFlag.class));
        System.out.println(new StringBuilder(23).append("metaPropertiesEnsemble=").append(metaPropertiesEnsemble).toString());
        MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(metaPropertiesEnsemble);
        if (!ignoreFormatted && !copier.logDirProps().isEmpty()) {
            String firstLogDir = (String)copier.logDirProps().keySet().iterator().next();
            throw new TerseFailure(new StringBuilder(107).append("Log directory ").append(firstLogDir).append(" is already formatted. ").append("Use --ignore-formatted to ignore this directory and format the others.").toString());
        }
        if (!copier.errorLogDirs().isEmpty()) {
            String firstLogDir = (String)copier.errorLogDirs().iterator().next();
            throw new TerseFailure(new StringBuilder(40).append("I/O error trying to read log directory ").append(firstLogDir).append(".").toString());
        }
        if (metaPropertiesEnsemble.emptyLogDirs().isEmpty()) {
            stream.println("All of the log directories are already formatted.");
        } else {
            metaPropertiesEnsemble.emptyLogDirs().forEach(logDir2 -> {
                copier.setLogDirProps(logDir2, new MetaProperties.Builder(metaProperties).setDirectoryId(copier.generateValidDirectoryId()).build());
                copier.setPreWriteHandler((logDir, isNew, metaProperties) -> {
                    stream.println(new StringBuilder(35).append("Formatting ").append(logDir).append(" with metadata.version ").append(metadataVersion).append(".").toString());
                    Files.createDirectories(Paths.get(logDir, new String[0]), new FileAttribute[0]);
                    new BootstrapDirectory(logDir, Optional.empty()).writeBinaryFile(bootstrapMetadata);
                });
                copier.setWriteErrorHandler((logDir, e) -> {
                    throw new TerseFailure(new StringBuilder(43).append("Error while writing meta.properties file ").append(logDir).append(": ").append(e.getMessage()).toString());
                });
                copier.writeLogDirChanges();
            });
        }
        return 0;
    }

    public static final /* synthetic */ void $anonfun$main$3(MetadataVersion metadataVersion$1, ArrayBuffer metadataRecords$1, ArrayBuffer userScramCredentialRecords) {
        if (!metadataVersion$1.isScramSupported()) {
            throw new TerseFailure("SCRAM is only supported in metadataVersion IBP_3_5_IV2 or later.");
        }
        userScramCredentialRecords.foreach((Function1 & Serializable & scala.Serializable)record -> {
            metadataRecords$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ApiMessageAndVersion[]{new ApiMessageAndVersion((ApiMessage)record, (short)0)}));
            return BoxedUnit.UNIT;
        });
    }

    private static final String getName$1(Map argMap) {
        if (!argMap.contains((Object)"name")) {
            throw new TerseFailure("You must supply 'name' to add-scram");
        }
        return (String)argMap.apply((Object)"name");
    }

    private static final byte[] getSalt$1(Map argMap, ScramMechanism scramMechanism) {
        if (argMap.contains((Object)"salt")) {
            return Base64.getDecoder().decode((String)argMap.apply((Object)"salt"));
        }
        return new ScramFormatter(scramMechanism).secureRandomBytes();
    }

    private static final int getIterations$1(Map argMap, ScramMechanism scramMechanism) {
        if (argMap.contains((Object)"salt")) {
            int iterations = new StringOps(Predef$.MODULE$.augmentString((String)argMap.apply((Object)"iterations"))).toInt();
            if (iterations < scramMechanism.minIterations()) {
                throw new TerseFailure(new StringBuilder(48).append("The 'iterations' value must be >= ").append(scramMechanism.minIterations()).append(" for add-scram").toString());
            }
            if (iterations > scramMechanism.maxIterations()) {
                throw new TerseFailure(new StringBuilder(48).append("The 'iterations' value must be <= ").append(scramMechanism.maxIterations()).append(" for add-scram").toString());
            }
            return iterations;
        }
        return 4096;
    }

    private static final byte[] getSaltedPassword$1(Map argMap, ScramMechanism scramMechanism, byte[] salt, int iterations) {
        if (argMap.contains((Object)"password")) {
            if (argMap.contains((Object)"saltedpassword")) {
                throw new TerseFailure("You must only supply one of 'password' or 'saltedpassword' to add-scram");
            }
            return new ScramFormatter(scramMechanism).saltedPassword((String)argMap.apply((Object)"password"), salt, iterations);
        }
        if (!argMap.contains((Object)"saltedpassword")) {
            throw new TerseFailure("You must supply one of 'password' or 'saltedpassword' to add-scram");
        }
        if (!argMap.contains((Object)"salt")) {
            throw new TerseFailure("You must supply 'salt' with 'saltedpassword' to add-scram");
        }
        return Base64.getDecoder().decode((String)argMap.apply((Object)"saltedpassword"));
    }

    public static final /* synthetic */ void $anonfun$getUserScramCredentialRecords$1(ArrayBuffer userScramCredentialRecords$1, String singleAddConfig) {
        String[] nameValueRecord = singleAddConfig.split("\\s+")[0].split("=", 2);
        String string = nameValueRecord[0];
        if ("SCRAM-SHA-256".equals(string)) {
            userScramCredentialRecords$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UserScramCredentialRecord[]{MODULE$.getUserScramCredentialRecord(nameValueRecord[0], nameValueRecord[1])}));
            return;
        }
        if ("SCRAM-SHA-512".equals(string)) {
            userScramCredentialRecords$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UserScramCredentialRecord[]{MODULE$.getUserScramCredentialRecord(nameValueRecord[0], nameValueRecord[1])}));
            return;
        }
        throw new TerseFailure(new StringBuilder(42).append("The add-scram mechanism ").append(nameValueRecord[0]).append(" is not supported.").toString());
    }

    public static final /* synthetic */ void $anonfun$infoCommand$4(PrintStream stream$1, MetaProperties prev) {
        TreeMap sortedOutput = new TreeMap();
        prev.toProperties().entrySet().forEach(e -> sortedOutput.put(e.getKey().toString(), e.getValue().toString()));
        stream$1.println(new StringBuilder(16).append("Found metadata: ").append(sortedOutput).toString());
        stream$1.println("");
    }

    private StorageTool$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

