/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.urlfilter.suffix;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.net.URLFilter;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.SuffixStringMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuffixURLFilter
implements URLFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String attributeFile = null;
    private SuffixStringMatcher suffixes;
    private boolean modeAccept = false;
    private boolean filterFromPath = false;
    private boolean ignoreCase = false;
    private Configuration conf;

    public SuffixURLFilter() throws IOException {
    }

    public SuffixURLFilter(Reader reader) throws IOException {
        this.readConfiguration(reader);
    }

    public String filter(String url) {
        String a;
        if (url == null) {
            return null;
        }
        String _url = this.ignoreCase ? url.toLowerCase() : url;
        if (this.filterFromPath) {
            try {
                URL pUrl = new URL(_url);
                _url = pUrl.getPath();
            }
            catch (MalformedURLException pUrl) {
                // empty catch block
            }
        }
        if ((a = this.suffixes.shortestMatch(_url)) == null) {
            if (this.modeAccept) {
                return url;
            }
            return null;
        }
        if (this.modeAccept) {
            return null;
        }
        return url;
    }

    public void readConfiguration(Reader reader) throws IOException {
        String line;
        if (reader == null) {
            LOG.warn("Missing urlfilter.suffix.file, all URLs will be rejected!");
            this.suffixes = new SuffixStringMatcher(new String[0]);
            this.modeAccept = false;
            this.ignoreCase = false;
            return;
        }
        BufferedReader in = new BufferedReader(reader);
        ArrayList<String> aSuffixes = new ArrayList<String>();
        boolean allow = false;
        boolean ignore = false;
        block5: while ((line = in.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            char first = line.charAt(0);
            switch (first) {
                case '\n': 
                case ' ': 
                case '#': {
                    continue block5;
                }
                case '-': {
                    allow = false;
                    if (line.contains("P")) {
                        this.filterFromPath = true;
                    }
                    if (!line.contains("I")) continue block5;
                    ignore = true;
                    continue block5;
                }
                case '+': {
                    allow = true;
                    if (line.contains("P")) {
                        this.filterFromPath = true;
                    }
                    if (!line.contains("I")) continue block5;
                    ignore = true;
                    continue block5;
                }
            }
            aSuffixes.add(line);
        }
        if (ignore) {
            for (int i = 0; i < aSuffixes.size(); ++i) {
                aSuffixes.set(i, ((String)aSuffixes.get(i)).toLowerCase());
            }
        }
        this.suffixes = new SuffixStringMatcher(aSuffixes);
        this.modeAccept = allow;
        this.ignoreCase = ignore;
    }

    public static void main(String[] args) throws IOException {
        String line;
        SuffixURLFilter filter;
        if (args.length >= 1) {
            filter = new SuffixURLFilter(new FileReader(args[0]));
        } else {
            filter = new SuffixURLFilter();
            filter.setConf(NutchConfiguration.create());
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while ((line = in.readLine()) != null) {
            String out = filter.filter(line);
            if (out != null) {
                System.out.println("ACCEPTED " + out);
                continue;
            }
            System.out.println("REJECTED " + out);
        }
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        String pluginName = "urlfilter-suffix";
        Extension[] extensions = PluginRepository.get((Configuration)conf).getExtensionPoint(URLFilter.class.getName()).getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            Extension extension = extensions[i];
            if (!extension.getDescriptor().getPluginId().equals(pluginName)) continue;
            this.attributeFile = extension.getAttribute("file");
            break;
        }
        if (this.attributeFile != null && this.attributeFile.trim().isEmpty()) {
            this.attributeFile = null;
        }
        if (this.attributeFile != null) {
            LOG.info("Attribute \"file\" is defined for plugin {} as {}", (Object)pluginName, (Object)this.attributeFile);
        }
        String file = conf.get("urlfilter.suffix.file", this.attributeFile);
        String stringRules = conf.get("urlfilter.suffix.rules");
        Reader reader = null;
        if (stringRules != null) {
            reader = new StringReader(stringRules);
        } else {
            LOG.info("Reading {} rules file {}", (Object)pluginName, (Object)file);
            reader = conf.getConfResourceAsReader(file);
        }
        try {
            this.readConfiguration(reader);
        }
        catch (IOException e) {
            LOG.error("Error reading " + pluginName + " rule file " + file, (Throwable)e);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public boolean isModeAccept() {
        return this.modeAccept;
    }

    public void setModeAccept(boolean modeAccept) {
        this.modeAccept = modeAccept;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setFilterFromPath(boolean filterFromPath) {
        this.filterFromPath = filterFromPath;
    }
}

