/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexwriter.elastic;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.nutch.indexer.IndexWriter;
import org.apache.nutch.indexer.IndexWriterParams;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.indexer.NutchField;
import org.apache.nutch.util.StringUtil;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticIndexWriter
implements IndexWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int DEFAULT_PORT = 9300;
    private static final int DEFAULT_MAX_BULK_DOCS = 250;
    private static final int DEFAULT_MAX_BULK_LENGTH = 2500500;
    private static final int DEFAULT_EXP_BACKOFF_MILLIS = 100;
    private static final int DEFAULT_EXP_BACKOFF_RETRIES = 10;
    private static final int DEFAULT_BULK_CLOSE_TIMEOUT = 600;
    private static final String DEFAULT_INDEX = "nutch";
    private static final String DEFAULT_USER = "elastic";
    private String[] hosts;
    private int port;
    private String scheme = "http";
    private String user = null;
    private String password = null;
    private boolean auth;
    private int maxBulkDocs;
    private int maxBulkLength;
    private int expBackoffMillis;
    private int expBackoffRetries;
    private String defaultIndex;
    private RestHighLevelClient client;
    private BulkProcessor bulkProcessor;
    private long bulkCloseTimeout;
    private Configuration config;

    public void open(Configuration conf, String name) throws IOException {
    }

    public void open(IndexWriterParams parameters) throws IOException {
        String hosts = (String)parameters.get((Object)"host");
        if (StringUtils.isBlank((String)hosts)) {
            Object message = "Missing elastic.host this should be set in index-writers.xml ";
            message = (String)message + "\n" + this.describe();
            LOG.error((String)message);
            throw new RuntimeException((String)message);
        }
        this.bulkCloseTimeout = parameters.getLong("bulk.close.timeout", 600L);
        this.defaultIndex = parameters.get("index", DEFAULT_INDEX);
        this.maxBulkDocs = parameters.getInt("max.bulk.docs", 250);
        this.maxBulkLength = parameters.getInt("max.bulk.size", 2500500);
        this.expBackoffMillis = parameters.getInt("exponential.backoff.millis", 100);
        this.expBackoffRetries = parameters.getInt("exponential.backoff.retries", 10);
        this.client = this.makeClient(parameters);
        LOG.debug("Creating BulkProcessor with maxBulkDocs={}, maxBulkLength={}", (Object)this.maxBulkDocs, (Object)this.maxBulkLength);
        this.bulkProcessor = BulkProcessor.builder((request, bulkListener) -> this.client.bulkAsync(request, RequestOptions.DEFAULT, bulkListener), (BulkProcessor.Listener)this.bulkProcessorListener()).setBulkActions(this.maxBulkDocs).setBulkSize(new ByteSizeValue((long)this.maxBulkLength, ByteSizeUnit.BYTES)).setConcurrentRequests(1).setBackoffPolicy(BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)this.expBackoffMillis), (int)this.expBackoffRetries)).build();
    }

    protected RestHighLevelClient makeClient(IndexWriterParams parameters) throws IOException {
        RestClientBuilder restClientBuilder;
        this.hosts = parameters.getStrings("host");
        this.port = parameters.getInt("port", 9300);
        this.scheme = parameters.get("scheme", "http");
        this.auth = parameters.getBoolean("auth", false);
        this.user = parameters.get("username", DEFAULT_USER);
        this.password = parameters.get("password", "");
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.user, this.password));
        RestHighLevelClient client = null;
        if (this.hosts != null && this.port > 1) {
            HttpHost[] hostsList = new HttpHost[this.hosts.length];
            int i = 0;
            for (String host : this.hosts) {
                hostsList[i++] = new HttpHost(host, this.port, this.scheme);
            }
            restClientBuilder = RestClient.builder((HttpHost[])hostsList);
            if (this.auth) {
                restClientBuilder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                    final /* synthetic */ CredentialsProvider val$credentialsProvider;
                    {
                        this.val$credentialsProvider = credentialsProvider;
                    }

                    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder arg0) {
                        return arg0.setDefaultCredentialsProvider(this.val$credentialsProvider);
                    }
                });
            }
            if ("https".equals(this.scheme)) {
                try {
                    SSLContextBuilder sslBuilder = SSLContexts.custom();
                    sslBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                    SSLContext sslContext = sslBuilder.build();
                    restClientBuilder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider, sslContext){
                        final /* synthetic */ CredentialsProvider val$credentialsProvider;
                        final /* synthetic */ SSLContext val$sslContext;
                        {
                            this.val$credentialsProvider = credentialsProvider;
                            this.val$sslContext = sSLContext;
                        }

                        public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                            if (ElasticIndexWriter.this.auth) {
                                httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                            }
                            httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                            return httpClientBuilder.setSSLContext(this.val$sslContext);
                        }
                    });
                }
                catch (Exception e) {
                    LOG.error("Error setting up SSLContext because: " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            throw new IOException("ElasticRestClient initialization Failed!!!\\n\\nPlease Provide the hosts");
        }
        client = new RestHighLevelClient(restClientBuilder);
        return client;
    }

    protected BulkProcessor.Listener bulkProcessorListener() {
        return new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                LOG.error("Elasticsearch indexing failed:", failure);
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                if (response.hasFailures()) {
                    LOG.warn("Failures occurred during bulk request: {}", (Object)response.buildFailureMessage());
                }
            }
        };
    }

    public void write(NutchDocument doc) throws IOException {
        String id = (String)doc.getFieldValue("id");
        String type = doc.getDocumentMeta().get("type");
        if (type == null) {
            type = "doc";
        }
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        for (Map.Entry e : doc) {
            List values = ((NutchField)e.getValue()).getValues();
            if (values.size() > 1) {
                builder.array((String)e.getKey(), new Object[]{values});
                continue;
            }
            Object value = values.get(0);
            if (value instanceof Date) {
                value = DateTimeFormatter.ISO_INSTANT.format(((Date)value).toInstant());
            }
            builder.field((String)e.getKey(), value);
        }
        builder.endObject();
        IndexRequest request = new IndexRequest(this.defaultIndex).id(id).source(builder);
        request.opType(DocWriteRequest.OpType.INDEX);
        this.bulkProcessor.add(request);
    }

    public void delete(String key) throws IOException {
        DeleteRequest request = new DeleteRequest(this.defaultIndex, key);
        this.bulkProcessor.add(request);
    }

    public void update(NutchDocument doc) throws IOException {
        this.write(doc);
    }

    public void commit() throws IOException {
        this.bulkProcessor.flush();
    }

    public void close() throws IOException {
        try {
            this.bulkProcessor.awaitClose(this.bulkCloseTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("interrupted while waiting for BulkProcessor to complete ({})", (Object)e.getMessage());
        }
        this.client.close();
    }

    public Map<String, Map.Entry<String, Object>> describe() {
        LinkedHashMap<String, Map.Entry<String, Object>> properties = new LinkedHashMap<String, Map.Entry<String, Object>>();
        properties.put("host", new AbstractMap.SimpleEntry<String, String>("Comma-separated list of hostnames", this.hosts == null ? "" : String.join((CharSequence)",", this.hosts)));
        properties.put("port", new AbstractMap.SimpleEntry<String, Integer>("The port to connect to elastic server.", this.port));
        properties.put("scheme", new AbstractMap.SimpleEntry<String, String>("The scheme (http or https) to connect to elastic server.", this.scheme));
        properties.put("index", new AbstractMap.SimpleEntry<String, String>("Default index to send documents to.", this.defaultIndex));
        properties.put("username", new AbstractMap.SimpleEntry<String, String>("Username for auth credentials", this.user));
        properties.put("password", new AbstractMap.SimpleEntry<String, String>("Password for auth credentials", StringUtil.mask((String)this.password)));
        properties.put("max.bulk.docs", new AbstractMap.SimpleEntry<String, Integer>("Maximum size of the bulk in number of documents.", this.maxBulkDocs));
        properties.put("max.bulk.size", new AbstractMap.SimpleEntry<String, Integer>("Maximum size of the bulk in bytes.", this.maxBulkLength));
        properties.put("exponential.backoff.millis", new AbstractMap.SimpleEntry<String, Integer>("Initial delay for the BulkProcessor exponential backoff policy.", this.expBackoffMillis));
        properties.put("exponential.backoff.retries", new AbstractMap.SimpleEntry<String, Integer>("Number of times the BulkProcessor exponential backoff policy should retry bulk operations.", this.expBackoffRetries));
        properties.put("bulk.close.timeout", new AbstractMap.SimpleEntry<String, Long>("Number of seconds allowed for the BulkProcessor to complete its last operation.", this.bulkCloseTimeout));
        return properties;
    }

    public void setConf(Configuration conf) {
        this.config = conf;
    }

    public Configuration getConf() {
        return this.config;
    }
}

