#define LOG_MODULE PacketLogModuleSSLLayer

#if defined(WIN32) || defined(WINx64) //for using ntohl, ntohs, etc.
#include <winsock2.h>
#elif LINUX
#include <in.h> //for using ntohl, ntohs, etc.
#elif MAC_OS_X
#include <arpa/inet.h> //for using ntohl, ntohs, etc.
#endif
#include <string.h>
#include <sstream>
#include <map>
#include <Logger.h>
#include <SSLHandshake.h>


namespace pcpp
{

// --------------
// SSLCipherSuite
// --------------

static const SSLCipherSuite Cipher1 = SSLCipherSuite(0x0000, SSL_KEYX_NULL, SSL_AUTH_NULL, SSL_SYM_NULL, SSL_HASH_NULL, "TLS_NULL_WITH_NULL_NULL");
static const SSLCipherSuite Cipher2 = SSLCipherSuite(0x0001, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_NULL, SSL_HASH_MD5, "TLS_RSA_WITH_NULL_MD5");
static const SSLCipherSuite Cipher3 = SSLCipherSuite(0x0002, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_NULL, SSL_HASH_SHA, "TLS_RSA_WITH_NULL_SHA");
static const SSLCipherSuite Cipher4 = SSLCipherSuite(0x0003, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_RC4_40, SSL_HASH_MD5, "TLS_RSA_EXPORT_WITH_RC4_40_MD5");
static const SSLCipherSuite Cipher5 = SSLCipherSuite(0x0004, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_RC4_128, SSL_HASH_MD5, "TLS_RSA_WITH_RC4_128_MD5");
static const SSLCipherSuite Cipher6 = SSLCipherSuite(0x0005, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_RC4_128, SSL_HASH_SHA, "TLS_RSA_WITH_RC4_128_SHA");
static const SSLCipherSuite Cipher7 = SSLCipherSuite(0x0006, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_RC2_CBC_40, SSL_HASH_MD5, "TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5");
static const SSLCipherSuite Cipher8 = SSLCipherSuite(0x0007, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_IDEA_CBC, SSL_HASH_SHA, "TLS_RSA_WITH_IDEA_CBC_SHA");
static const SSLCipherSuite Cipher9 = SSLCipherSuite(0x0008, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_DES40_CBC, SSL_HASH_SHA, "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA");
static const SSLCipherSuite Cipher10 = SSLCipherSuite(0x0009, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_DES_CBC, SSL_HASH_SHA, "TLS_RSA_WITH_DES_CBC_SHA");
static const SSLCipherSuite Cipher11 = SSLCipherSuite(0x000A, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_RSA_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher12 = SSLCipherSuite(0x000B, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_DES40_CBC, SSL_HASH_SHA, "TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA");
static const SSLCipherSuite Cipher13 = SSLCipherSuite(0x000C, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_DES_CBC, SSL_HASH_SHA, "TLS_DH_DSS_WITH_DES_CBC_SHA");
static const SSLCipherSuite Cipher14 = SSLCipherSuite(0x000D, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher15 = SSLCipherSuite(0x000E, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_DES40_CBC, SSL_HASH_SHA, "TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA");
static const SSLCipherSuite Cipher16 = SSLCipherSuite(0x000F, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_DES_CBC, SSL_HASH_SHA, "TLS_DH_RSA_WITH_DES_CBC_SHA");
static const SSLCipherSuite Cipher17 = SSLCipherSuite(0x0010, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher18 = SSLCipherSuite(0x0011, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_DES40_CBC, SSL_HASH_SHA, "TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA");
static const SSLCipherSuite Cipher19 = SSLCipherSuite(0x0012, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_DES_CBC, SSL_HASH_SHA, "TLS_DHE_DSS_WITH_DES_CBC_SHA");
static const SSLCipherSuite Cipher20 = SSLCipherSuite(0x0013, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher21 = SSLCipherSuite(0x0014, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_DES40_CBC, SSL_HASH_SHA, "TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA");
static const SSLCipherSuite Cipher22 = SSLCipherSuite(0x0015, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_DES_CBC, SSL_HASH_SHA, "TLS_DHE_RSA_WITH_DES_CBC_SHA");
static const SSLCipherSuite Cipher23 = SSLCipherSuite(0x0016, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher24 = SSLCipherSuite(0x0017, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_RC4_40, SSL_HASH_MD5, "TLS_DH_anon_EXPORT_WITH_RC4_40_MD5");
static const SSLCipherSuite Cipher25 = SSLCipherSuite(0x0018, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_RC4_128, SSL_HASH_MD5, "TLS_DH_anon_WITH_RC4_128_MD5");
static const SSLCipherSuite Cipher26 = SSLCipherSuite(0x0019, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_DES40_CBC, SSL_HASH_SHA, "TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA");
static const SSLCipherSuite Cipher27 = SSLCipherSuite(0x001A, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_DES_CBC, SSL_HASH_SHA, "TLS_DH_anon_WITH_DES_CBC_SHA");
static const SSLCipherSuite Cipher28 = SSLCipherSuite(0x001B, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_DH_anon_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher29 = SSLCipherSuite(0x001E, SSL_KEYX_KRB5, SSL_AUTH_KRB5, SSL_SYM_DES_CBC, SSL_HASH_SHA, "TLS_KRB5_WITH_DES_CBC_SHA");
static const SSLCipherSuite Cipher30 = SSLCipherSuite(0x001F, SSL_KEYX_KRB5, SSL_AUTH_KRB5, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_KRB5_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher31 = SSLCipherSuite(0x0020, SSL_KEYX_KRB5, SSL_AUTH_KRB5, SSL_SYM_RC4_128, SSL_HASH_SHA, "TLS_KRB5_WITH_RC4_128_SHA");
static const SSLCipherSuite Cipher32 = SSLCipherSuite(0x0021, SSL_KEYX_KRB5, SSL_AUTH_KRB5, SSL_SYM_IDEA_CBC, SSL_HASH_SHA, "TLS_KRB5_WITH_IDEA_CBC_SHA");
static const SSLCipherSuite Cipher33 = SSLCipherSuite(0x0022, SSL_KEYX_KRB5, SSL_AUTH_KRB5, SSL_SYM_DES_CBC, SSL_HASH_MD5, "TLS_KRB5_WITH_DES_CBC_MD5");
static const SSLCipherSuite Cipher34 = SSLCipherSuite(0x0023, SSL_KEYX_KRB5, SSL_AUTH_KRB5, SSL_SYM_3DES_EDE_CBC, SSL_HASH_MD5, "TLS_KRB5_WITH_3DES_EDE_CBC_MD5");
static const SSLCipherSuite Cipher35 = SSLCipherSuite(0x0024, SSL_KEYX_KRB5, SSL_AUTH_KRB5, SSL_SYM_RC4_128, SSL_HASH_MD5, "TLS_KRB5_WITH_RC4_128_MD5");
static const SSLCipherSuite Cipher36 = SSLCipherSuite(0x0025, SSL_KEYX_KRB5, SSL_AUTH_KRB5, SSL_SYM_IDEA_CBC, SSL_HASH_MD5, "TLS_KRB5_WITH_IDEA_CBC_MD5");
static const SSLCipherSuite Cipher37 = SSLCipherSuite(0x0026, SSL_KEYX_KRB5, SSL_AUTH_KRB5, SSL_SYM_DES_CBC_40, SSL_HASH_SHA, "TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA");
static const SSLCipherSuite Cipher38 = SSLCipherSuite(0x0027, SSL_KEYX_KRB5, SSL_AUTH_KRB5, SSL_SYM_RC2_CBC_40, SSL_HASH_SHA, "TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA");
static const SSLCipherSuite Cipher39 = SSLCipherSuite(0x0028, SSL_KEYX_KRB5, SSL_AUTH_KRB5, SSL_SYM_RC4_40, SSL_HASH_SHA, "TLS_KRB5_EXPORT_WITH_RC4_40_SHA");
static const SSLCipherSuite Cipher40 = SSLCipherSuite(0x0029, SSL_KEYX_KRB5, SSL_AUTH_KRB5, SSL_SYM_DES_CBC_40, SSL_HASH_MD5, "TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5");
static const SSLCipherSuite Cipher41 = SSLCipherSuite(0x002A, SSL_KEYX_KRB5, SSL_AUTH_KRB5, SSL_SYM_RC2_CBC_40, SSL_HASH_MD5, "TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5");
static const SSLCipherSuite Cipher42 = SSLCipherSuite(0x002B, SSL_KEYX_KRB5, SSL_AUTH_KRB5, SSL_SYM_RC4_40, SSL_HASH_MD5, "TLS_KRB5_EXPORT_WITH_RC4_40_MD5");
static const SSLCipherSuite Cipher43 = SSLCipherSuite(0x002C, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_NULL, SSL_HASH_SHA, "TLS_PSK_WITH_NULL_SHA");
static const SSLCipherSuite Cipher44 = SSLCipherSuite(0x002D, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_NULL, SSL_HASH_SHA, "TLS_DHE_PSK_WITH_NULL_SHA");
static const SSLCipherSuite Cipher45 = SSLCipherSuite(0x002E, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_NULL, SSL_HASH_SHA, "TLS_RSA_PSK_WITH_NULL_SHA");
static const SSLCipherSuite Cipher46 = SSLCipherSuite(0x002F, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_RSA_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher47 = SSLCipherSuite(0x0030, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_DH_DSS_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher48 = SSLCipherSuite(0x0031, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_DH_RSA_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher49 = SSLCipherSuite(0x0032, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_DHE_DSS_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher50 = SSLCipherSuite(0x0033, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_DHE_RSA_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher51 = SSLCipherSuite(0x0034, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_DH_anon_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher52 = SSLCipherSuite(0x0035, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_RSA_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher53 = SSLCipherSuite(0x0036, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_DH_DSS_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher54 = SSLCipherSuite(0x0037, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_DH_RSA_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher55 = SSLCipherSuite(0x0038, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_DHE_DSS_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher56 = SSLCipherSuite(0x0039, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_DHE_RSA_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher57 = SSLCipherSuite(0x003A, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_DH_anon_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher58 = SSLCipherSuite(0x003B, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_NULL, SSL_HASH_SHA256, "TLS_RSA_WITH_NULL_SHA256");
static const SSLCipherSuite Cipher59 = SSLCipherSuite(0x003C, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_AES_128_CBC, SSL_HASH_SHA256, "TLS_RSA_WITH_AES_128_CBC_SHA256");
static const SSLCipherSuite Cipher60 = SSLCipherSuite(0x003D, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_AES_256_CBC, SSL_HASH_SHA256, "TLS_RSA_WITH_AES_256_CBC_SHA256");
static const SSLCipherSuite Cipher61 = SSLCipherSuite(0x003E, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_AES_128_CBC, SSL_HASH_SHA256, "TLS_DH_DSS_WITH_AES_128_CBC_SHA256");
static const SSLCipherSuite Cipher62 = SSLCipherSuite(0x003F, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_AES_128_CBC, SSL_HASH_SHA256, "TLS_DH_RSA_WITH_AES_128_CBC_SHA256");
static const SSLCipherSuite Cipher63 = SSLCipherSuite(0x0040, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_AES_128_CBC, SSL_HASH_SHA256, "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256");
static const SSLCipherSuite Cipher64 = SSLCipherSuite(0x0041, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA, "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA");
static const SSLCipherSuite Cipher65 = SSLCipherSuite(0x0042, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA, "TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA");
static const SSLCipherSuite Cipher66 = SSLCipherSuite(0x0043, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA, "TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA");
static const SSLCipherSuite Cipher67 = SSLCipherSuite(0x0044, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA, "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA");
static const SSLCipherSuite Cipher68 = SSLCipherSuite(0x0045, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA, "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA");
static const SSLCipherSuite Cipher69 = SSLCipherSuite(0x0046, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA, "TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA");
static const SSLCipherSuite Cipher70 = SSLCipherSuite(0x0067, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_AES_128_CBC, SSL_HASH_SHA256, "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256");
static const SSLCipherSuite Cipher71 = SSLCipherSuite(0x0068, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_AES_256_CBC, SSL_HASH_SHA256, "TLS_DH_DSS_WITH_AES_256_CBC_SHA256");
static const SSLCipherSuite Cipher72 = SSLCipherSuite(0x0069, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_AES_256_CBC, SSL_HASH_SHA256, "TLS_DH_RSA_WITH_AES_256_CBC_SHA256");
static const SSLCipherSuite Cipher73 = SSLCipherSuite(0x006A, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_AES_256_CBC, SSL_HASH_SHA256, "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256");
static const SSLCipherSuite Cipher74 = SSLCipherSuite(0x006B, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_AES_256_CBC, SSL_HASH_SHA256, "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256");
static const SSLCipherSuite Cipher75 = SSLCipherSuite(0x006C, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_AES_128_CBC, SSL_HASH_SHA256, "TLS_DH_anon_WITH_AES_128_CBC_SHA256");
static const SSLCipherSuite Cipher76 = SSLCipherSuite(0x006D, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_AES_256_CBC, SSL_HASH_SHA256, "TLS_DH_anon_WITH_AES_256_CBC_SHA256");
static const SSLCipherSuite Cipher77 = SSLCipherSuite(0x0084, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA, "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA");
static const SSLCipherSuite Cipher78 = SSLCipherSuite(0x0085, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA, "TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA");
static const SSLCipherSuite Cipher79 = SSLCipherSuite(0x0086, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA, "TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA");
static const SSLCipherSuite Cipher80 = SSLCipherSuite(0x0087, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA, "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA");
static const SSLCipherSuite Cipher81 = SSLCipherSuite(0x0088, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA, "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA");
static const SSLCipherSuite Cipher82 = SSLCipherSuite(0x0089, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA, "TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA");
static const SSLCipherSuite Cipher83 = SSLCipherSuite(0x008A, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_RC4_128, SSL_HASH_SHA, "TLS_PSK_WITH_RC4_128_SHA");
static const SSLCipherSuite Cipher84 = SSLCipherSuite(0x008B, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_PSK_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher85 = SSLCipherSuite(0x008C, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_PSK_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher86 = SSLCipherSuite(0x008D, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_PSK_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher87 = SSLCipherSuite(0x008E, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_RC4_128, SSL_HASH_SHA, "TLS_DHE_PSK_WITH_RC4_128_SHA");
static const SSLCipherSuite Cipher88 = SSLCipherSuite(0x008F, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher89 = SSLCipherSuite(0x0090, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_DHE_PSK_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher90 = SSLCipherSuite(0x0091, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_DHE_PSK_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher91 = SSLCipherSuite(0x0092, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_RC4_128, SSL_HASH_SHA, "TLS_RSA_PSK_WITH_RC4_128_SHA");
static const SSLCipherSuite Cipher92 = SSLCipherSuite(0x0093, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher93 = SSLCipherSuite(0x0094, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_RSA_PSK_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher94 = SSLCipherSuite(0x0095, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_RSA_PSK_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher95 = SSLCipherSuite(0x0096, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_SEED_CBC, SSL_HASH_SHA, "TLS_RSA_WITH_SEED_CBC_SHA");
static const SSLCipherSuite Cipher96 = SSLCipherSuite(0x0097, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_SEED_CBC, SSL_HASH_SHA, "TLS_DH_DSS_WITH_SEED_CBC_SHA");
static const SSLCipherSuite Cipher97 = SSLCipherSuite(0x0098, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_SEED_CBC, SSL_HASH_SHA, "TLS_DH_RSA_WITH_SEED_CBC_SHA");
static const SSLCipherSuite Cipher98 = SSLCipherSuite(0x0099, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_SEED_CBC, SSL_HASH_SHA, "TLS_DHE_DSS_WITH_SEED_CBC_SHA");
static const SSLCipherSuite Cipher99 = SSLCipherSuite(0x009A, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_SEED_CBC, SSL_HASH_SHA, "TLS_DHE_RSA_WITH_SEED_CBC_SHA");
static const SSLCipherSuite Cipher100 = SSLCipherSuite(0x009B, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_SEED_CBC, SSL_HASH_SHA, "TLS_DH_anon_WITH_SEED_CBC_SHA");
static const SSLCipherSuite Cipher101 = SSLCipherSuite(0x009C, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_AES_128_GCM, SSL_HASH_SHA256, "TLS_RSA_WITH_AES_128_GCM_SHA256");
static const SSLCipherSuite Cipher102 = SSLCipherSuite(0x009D, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_AES_256_GCM, SSL_HASH_SHA384, "TLS_RSA_WITH_AES_256_GCM_SHA384");
static const SSLCipherSuite Cipher103 = SSLCipherSuite(0x009E, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_AES_128_GCM, SSL_HASH_SHA256, "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256");
static const SSLCipherSuite Cipher104 = SSLCipherSuite(0x009F, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_AES_256_GCM, SSL_HASH_SHA384, "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384");
static const SSLCipherSuite Cipher105 = SSLCipherSuite(0x00A0, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_AES_128_GCM, SSL_HASH_SHA256, "TLS_DH_RSA_WITH_AES_128_GCM_SHA256");
static const SSLCipherSuite Cipher106 = SSLCipherSuite(0x00A1, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_AES_256_GCM, SSL_HASH_SHA384, "TLS_DH_RSA_WITH_AES_256_GCM_SHA384");
static const SSLCipherSuite Cipher107 = SSLCipherSuite(0x00A2, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_AES_128_GCM, SSL_HASH_SHA256, "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256");
static const SSLCipherSuite Cipher108 = SSLCipherSuite(0x00A3, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_AES_256_GCM, SSL_HASH_SHA384, "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384");
static const SSLCipherSuite Cipher109 = SSLCipherSuite(0x00A4, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_AES_128_GCM, SSL_HASH_SHA256, "TLS_DH_DSS_WITH_AES_128_GCM_SHA256");
static const SSLCipherSuite Cipher110 = SSLCipherSuite(0x00A5, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_AES_256_GCM, SSL_HASH_SHA384, "TLS_DH_DSS_WITH_AES_256_GCM_SHA384");
static const SSLCipherSuite Cipher111 = SSLCipherSuite(0x00A6, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_AES_128_GCM, SSL_HASH_SHA256, "TLS_DH_anon_WITH_AES_128_GCM_SHA256");
static const SSLCipherSuite Cipher112 = SSLCipherSuite(0x00A7, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_AES_256_GCM, SSL_HASH_SHA384, "TLS_DH_anon_WITH_AES_256_GCM_SHA384");
static const SSLCipherSuite Cipher113 = SSLCipherSuite(0x00A8, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_AES_128_GCM, SSL_HASH_SHA256, "TLS_PSK_WITH_AES_128_GCM_SHA256");
static const SSLCipherSuite Cipher114 = SSLCipherSuite(0x00A9, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_AES_256_GCM, SSL_HASH_SHA384, "TLS_PSK_WITH_AES_256_GCM_SHA384");
static const SSLCipherSuite Cipher115 = SSLCipherSuite(0x00AA, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_AES_128_GCM, SSL_HASH_SHA256, "TLS_DHE_PSK_WITH_AES_128_GCM_SHA256");
static const SSLCipherSuite Cipher116 = SSLCipherSuite(0x00AB, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_AES_256_GCM, SSL_HASH_SHA384, "TLS_DHE_PSK_WITH_AES_256_GCM_SHA384");
static const SSLCipherSuite Cipher117 = SSLCipherSuite(0x00AC, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_AES_128_GCM, SSL_HASH_SHA256, "TLS_RSA_PSK_WITH_AES_128_GCM_SHA256");
static const SSLCipherSuite Cipher118 = SSLCipherSuite(0x00AD, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_AES_256_GCM, SSL_HASH_SHA384, "TLS_RSA_PSK_WITH_AES_256_GCM_SHA384");
static const SSLCipherSuite Cipher119 = SSLCipherSuite(0x00AE, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_AES_128_CBC, SSL_HASH_SHA256, "TLS_PSK_WITH_AES_128_CBC_SHA256");
static const SSLCipherSuite Cipher120 = SSLCipherSuite(0x00AF, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_AES_256_CBC, SSL_HASH_SHA384, "TLS_PSK_WITH_AES_256_CBC_SHA384");
static const SSLCipherSuite Cipher121 = SSLCipherSuite(0x00B0, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_NULL, SSL_HASH_SHA256, "TLS_PSK_WITH_NULL_SHA256");
static const SSLCipherSuite Cipher122 = SSLCipherSuite(0x00B1, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_NULL, SSL_HASH_SHA384, "TLS_PSK_WITH_NULL_SHA384");
static const SSLCipherSuite Cipher123 = SSLCipherSuite(0x00B2, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_AES_128_CBC, SSL_HASH_SHA256, "TLS_DHE_PSK_WITH_AES_128_CBC_SHA256");
static const SSLCipherSuite Cipher124 = SSLCipherSuite(0x00B3, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_AES_256_CBC, SSL_HASH_SHA384, "TLS_DHE_PSK_WITH_AES_256_CBC_SHA384");
static const SSLCipherSuite Cipher125 = SSLCipherSuite(0x00B4, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_NULL, SSL_HASH_SHA256, "TLS_DHE_PSK_WITH_NULL_SHA256");
static const SSLCipherSuite Cipher126 = SSLCipherSuite(0x00B5, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_NULL, SSL_HASH_SHA384, "TLS_DHE_PSK_WITH_NULL_SHA384");
static const SSLCipherSuite Cipher127 = SSLCipherSuite(0x00B6, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_AES_128_CBC, SSL_HASH_SHA256, "TLS_RSA_PSK_WITH_AES_128_CBC_SHA256");
static const SSLCipherSuite Cipher128 = SSLCipherSuite(0x00B7, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_AES_256_CBC, SSL_HASH_SHA384, "TLS_RSA_PSK_WITH_AES_256_CBC_SHA384");
static const SSLCipherSuite Cipher129 = SSLCipherSuite(0x00B8, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_NULL, SSL_HASH_SHA256, "TLS_RSA_PSK_WITH_NULL_SHA256");
static const SSLCipherSuite Cipher130 = SSLCipherSuite(0x00B9, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_NULL, SSL_HASH_SHA384, "TLS_RSA_PSK_WITH_NULL_SHA384");
static const SSLCipherSuite Cipher131 = SSLCipherSuite(0x00BA, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA256, "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher132 = SSLCipherSuite(0x00BB, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA256, "TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher133 = SSLCipherSuite(0x00BC, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA256, "TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher134 = SSLCipherSuite(0x00BD, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA256, "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher135 = SSLCipherSuite(0x00BE, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA256, "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher136 = SSLCipherSuite(0x00BF, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA256, "TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher137 = SSLCipherSuite(0x00C0, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA256, "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256");
static const SSLCipherSuite Cipher138 = SSLCipherSuite(0x00C1, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA256, "TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256");
static const SSLCipherSuite Cipher139 = SSLCipherSuite(0x00C2, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA256, "TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256");
static const SSLCipherSuite Cipher140 = SSLCipherSuite(0x00C3, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA256, "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256");
static const SSLCipherSuite Cipher141 = SSLCipherSuite(0x00C4, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA256, "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256");
static const SSLCipherSuite Cipher142 = SSLCipherSuite(0x00C5, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA256, "TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256");
static const SSLCipherSuite Cipher143 = SSLCipherSuite(0xC001, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_NULL, SSL_HASH_SHA, "TLS_ECDH_ECDSA_WITH_NULL_SHA");
static const SSLCipherSuite Cipher144 = SSLCipherSuite(0xC002, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_RC4_128, SSL_HASH_SHA, "TLS_ECDH_ECDSA_WITH_RC4_128_SHA");
static const SSLCipherSuite Cipher145 = SSLCipherSuite(0xC003, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher146 = SSLCipherSuite(0xC004, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher147 = SSLCipherSuite(0xC005, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher148 = SSLCipherSuite(0xC006, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_NULL, SSL_HASH_SHA, "TLS_ECDHE_ECDSA_WITH_NULL_SHA");
static const SSLCipherSuite Cipher149 = SSLCipherSuite(0xC007, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_RC4_128, SSL_HASH_SHA, "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA");
static const SSLCipherSuite Cipher150 = SSLCipherSuite(0xC008, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher151 = SSLCipherSuite(0xC009, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher152 = SSLCipherSuite(0xC00A, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher153 = SSLCipherSuite(0xC00B, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_NULL, SSL_HASH_SHA, "TLS_ECDH_RSA_WITH_NULL_SHA");
static const SSLCipherSuite Cipher154 = SSLCipherSuite(0xC00C, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_RC4_128, SSL_HASH_SHA, "TLS_ECDH_RSA_WITH_RC4_128_SHA");
static const SSLCipherSuite Cipher155 = SSLCipherSuite(0xC00D, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher156 = SSLCipherSuite(0xC00E, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher157 = SSLCipherSuite(0xC00F, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher158 = SSLCipherSuite(0xC010, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_NULL, SSL_HASH_SHA, "TLS_ECDHE_RSA_WITH_NULL_SHA");
static const SSLCipherSuite Cipher159 = SSLCipherSuite(0xC011, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_RC4_128, SSL_HASH_SHA, "TLS_ECDHE_RSA_WITH_RC4_128_SHA");
static const SSLCipherSuite Cipher160 = SSLCipherSuite(0xC012, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher161 = SSLCipherSuite(0xC013, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher162 = SSLCipherSuite(0xC014, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher163 = SSLCipherSuite(0xC015, SSL_KEYX_ECDH, SSL_AUTH_anon, SSL_SYM_NULL, SSL_HASH_SHA, "TLS_ECDH_anon_WITH_NULL_SHA");
static const SSLCipherSuite Cipher164 = SSLCipherSuite(0xC016, SSL_KEYX_ECDH, SSL_AUTH_anon, SSL_SYM_RC4_128, SSL_HASH_SHA, "TLS_ECDH_anon_WITH_RC4_128_SHA");
static const SSLCipherSuite Cipher165 = SSLCipherSuite(0xC017, SSL_KEYX_ECDH, SSL_AUTH_anon, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher166 = SSLCipherSuite(0xC018, SSL_KEYX_ECDH, SSL_AUTH_anon, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_ECDH_anon_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher167 = SSLCipherSuite(0xC019, SSL_KEYX_ECDH, SSL_AUTH_anon, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_ECDH_anon_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher168 = SSLCipherSuite(0xC01A, SSL_KEYX_SRP, SSL_AUTH_SHA, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher169 = SSLCipherSuite(0xC01B, SSL_KEYX_SRP, SSL_AUTH_RSA, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher170 = SSLCipherSuite(0xC01C, SSL_KEYX_SRP, SSL_AUTH_DSS, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher171 = SSLCipherSuite(0xC01D, SSL_KEYX_SRP, SSL_AUTH_SHA, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_SRP_SHA_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher172 = SSLCipherSuite(0xC01E, SSL_KEYX_SRP, SSL_AUTH_RSA, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher173 = SSLCipherSuite(0xC01F, SSL_KEYX_SRP, SSL_AUTH_DSS, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher174 = SSLCipherSuite(0xC020, SSL_KEYX_SRP, SSL_AUTH_SHA, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_SRP_SHA_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher175 = SSLCipherSuite(0xC021, SSL_KEYX_SRP, SSL_AUTH_RSA, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher176 = SSLCipherSuite(0xC022, SSL_KEYX_SRP, SSL_AUTH_DSS, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher177 = SSLCipherSuite(0xC023, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_AES_128_CBC, SSL_HASH_SHA256, "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256");
static const SSLCipherSuite Cipher178 = SSLCipherSuite(0xC024, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_AES_256_CBC, SSL_HASH_SHA384, "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384");
static const SSLCipherSuite Cipher179 = SSLCipherSuite(0xC025, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_AES_128_CBC, SSL_HASH_SHA256, "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256");
static const SSLCipherSuite Cipher180 = SSLCipherSuite(0xC026, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_AES_256_CBC, SSL_HASH_SHA384, "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384");
static const SSLCipherSuite Cipher181 = SSLCipherSuite(0xC027, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_AES_128_CBC, SSL_HASH_SHA256, "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256");
static const SSLCipherSuite Cipher182 = SSLCipherSuite(0xC028, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_AES_256_CBC, SSL_HASH_SHA384, "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384");
static const SSLCipherSuite Cipher183 = SSLCipherSuite(0xC029, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_AES_128_CBC, SSL_HASH_SHA256, "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256");
static const SSLCipherSuite Cipher184 = SSLCipherSuite(0xC02A, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_AES_256_CBC, SSL_HASH_SHA384, "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384");
static const SSLCipherSuite Cipher185 = SSLCipherSuite(0xC02B, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_AES_128_GCM, SSL_HASH_SHA256, "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
static const SSLCipherSuite Cipher186 = SSLCipherSuite(0xC02C, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_AES_256_GCM, SSL_HASH_SHA384, "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
static const SSLCipherSuite Cipher187 = SSLCipherSuite(0xC02D, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_AES_128_GCM, SSL_HASH_SHA256, "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256");
static const SSLCipherSuite Cipher188 = SSLCipherSuite(0xC02E, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_AES_256_GCM, SSL_HASH_SHA384, "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384");
static const SSLCipherSuite Cipher189 = SSLCipherSuite(0xC02F, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_AES_128_GCM, SSL_HASH_SHA256, "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
static const SSLCipherSuite Cipher190 = SSLCipherSuite(0xC030, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_AES_256_GCM, SSL_HASH_SHA384, "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
static const SSLCipherSuite Cipher191 = SSLCipherSuite(0xC031, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_AES_128_GCM, SSL_HASH_SHA256, "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256");
static const SSLCipherSuite Cipher192 = SSLCipherSuite(0xC032, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_AES_256_GCM, SSL_HASH_SHA384, "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384");
static const SSLCipherSuite Cipher193 = SSLCipherSuite(0xC033, SSL_KEYX_ECDHE, SSL_AUTH_PSK, SSL_SYM_RC4_128, SSL_HASH_SHA, "TLS_ECDHE_PSK_WITH_RC4_128_SHA");
static const SSLCipherSuite Cipher194 = SSLCipherSuite(0xC034, SSL_KEYX_ECDHE, SSL_AUTH_PSK, SSL_SYM_3DES_EDE_CBC, SSL_HASH_SHA, "TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA");
static const SSLCipherSuite Cipher195 = SSLCipherSuite(0xC035, SSL_KEYX_ECDHE, SSL_AUTH_PSK, SSL_SYM_AES_128_CBC, SSL_HASH_SHA, "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA");
static const SSLCipherSuite Cipher196 = SSLCipherSuite(0xC036, SSL_KEYX_ECDHE, SSL_AUTH_PSK, SSL_SYM_AES_256_CBC, SSL_HASH_SHA, "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA");
static const SSLCipherSuite Cipher197 = SSLCipherSuite(0xC037, SSL_KEYX_ECDHE, SSL_AUTH_PSK, SSL_SYM_AES_128_CBC, SSL_HASH_SHA256, "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256");
static const SSLCipherSuite Cipher198 = SSLCipherSuite(0xC038, SSL_KEYX_ECDHE, SSL_AUTH_PSK, SSL_SYM_AES_256_CBC, SSL_HASH_SHA384, "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384");
static const SSLCipherSuite Cipher199 = SSLCipherSuite(0xC039, SSL_KEYX_ECDHE, SSL_AUTH_PSK, SSL_SYM_NULL, SSL_HASH_SHA, "TLS_ECDHE_PSK_WITH_NULL_SHA");
static const SSLCipherSuite Cipher200 = SSLCipherSuite(0xC03A, SSL_KEYX_ECDHE, SSL_AUTH_PSK, SSL_SYM_NULL, SSL_HASH_SHA256, "TLS_ECDHE_PSK_WITH_NULL_SHA256");
static const SSLCipherSuite Cipher201 = SSLCipherSuite(0xC03B, SSL_KEYX_ECDHE, SSL_AUTH_PSK, SSL_SYM_NULL, SSL_HASH_SHA384, "TLS_ECDHE_PSK_WITH_NULL_SHA384");
static const SSLCipherSuite Cipher202 = SSLCipherSuite(0xC03C, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_ARIA_128_CBC, SSL_HASH_SHA256, "TLS_RSA_WITH_ARIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher203 = SSLCipherSuite(0xC03D, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_ARIA_256_CBC, SSL_HASH_SHA384, "TLS_RSA_WITH_ARIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher204 = SSLCipherSuite(0xC03E, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_ARIA_128_CBC, SSL_HASH_SHA256, "TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher205 = SSLCipherSuite(0xC03F, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_ARIA_256_CBC, SSL_HASH_SHA384, "TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher206 = SSLCipherSuite(0xC040, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_ARIA_128_CBC, SSL_HASH_SHA256, "TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher207 = SSLCipherSuite(0xC041, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_ARIA_256_CBC, SSL_HASH_SHA384, "TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher208 = SSLCipherSuite(0xC042, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_ARIA_128_CBC, SSL_HASH_SHA256, "TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher209 = SSLCipherSuite(0xC043, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_ARIA_256_CBC, SSL_HASH_SHA384, "TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher210 = SSLCipherSuite(0xC044, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_ARIA_128_CBC, SSL_HASH_SHA256, "TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher211 = SSLCipherSuite(0xC045, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_ARIA_256_CBC, SSL_HASH_SHA384, "TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher212 = SSLCipherSuite(0xC046, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_ARIA_128_CBC, SSL_HASH_SHA256, "TLS_DH_anon_WITH_ARIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher213 = SSLCipherSuite(0xC047, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_ARIA_256_CBC, SSL_HASH_SHA384, "TLS_DH_anon_WITH_ARIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher214 = SSLCipherSuite(0xC048, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_ARIA_128_CBC, SSL_HASH_SHA256, "TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher215 = SSLCipherSuite(0xC049, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_ARIA_256_CBC, SSL_HASH_SHA384, "TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher216 = SSLCipherSuite(0xC04A, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_ARIA_128_CBC, SSL_HASH_SHA256, "TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher217 = SSLCipherSuite(0xC04B, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_ARIA_256_CBC, SSL_HASH_SHA384, "TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher218 = SSLCipherSuite(0xC04C, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_ARIA_128_CBC, SSL_HASH_SHA256, "TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher219 = SSLCipherSuite(0xC04D, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_ARIA_256_CBC, SSL_HASH_SHA384, "TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher220 = SSLCipherSuite(0xC04E, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_ARIA_128_CBC, SSL_HASH_SHA256, "TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher221 = SSLCipherSuite(0xC04F, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_ARIA_256_CBC, SSL_HASH_SHA384, "TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher222 = SSLCipherSuite(0xC050, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_ARIA_128_GCM, SSL_HASH_SHA256, "TLS_RSA_WITH_ARIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher223 = SSLCipherSuite(0xC051, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_ARIA_256_GCM, SSL_HASH_SHA384, "TLS_RSA_WITH_ARIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher224 = SSLCipherSuite(0xC052, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_ARIA_128_GCM, SSL_HASH_SHA256, "TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher225 = SSLCipherSuite(0xC053, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_ARIA_256_GCM, SSL_HASH_SHA384, "TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher226 = SSLCipherSuite(0xC054, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_ARIA_128_GCM, SSL_HASH_SHA256, "TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher227 = SSLCipherSuite(0xC055, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_ARIA_256_GCM, SSL_HASH_SHA384, "TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher228 = SSLCipherSuite(0xC056, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_ARIA_128_GCM, SSL_HASH_SHA256, "TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher229 = SSLCipherSuite(0xC057, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_ARIA_256_GCM, SSL_HASH_SHA384, "TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher230 = SSLCipherSuite(0xC058, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_ARIA_128_GCM, SSL_HASH_SHA256, "TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher231 = SSLCipherSuite(0xC059, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_ARIA_256_GCM, SSL_HASH_SHA384, "TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher232 = SSLCipherSuite(0xC05A, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_ARIA_128_GCM, SSL_HASH_SHA256, "TLS_DH_anon_WITH_ARIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher233 = SSLCipherSuite(0xC05B, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_ARIA_256_GCM, SSL_HASH_SHA384, "TLS_DH_anon_WITH_ARIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher234 = SSLCipherSuite(0xC05C, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_ARIA_128_GCM, SSL_HASH_SHA256, "TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher235 = SSLCipherSuite(0xC05D, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_ARIA_256_GCM, SSL_HASH_SHA384, "TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher236 = SSLCipherSuite(0xC05E, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_ARIA_128_GCM, SSL_HASH_SHA256, "TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher237 = SSLCipherSuite(0xC05F, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_ARIA_256_GCM, SSL_HASH_SHA384, "TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher238 = SSLCipherSuite(0xC060, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_ARIA_128_GCM, SSL_HASH_SHA256, "TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher239 = SSLCipherSuite(0xC061, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_ARIA_256_GCM, SSL_HASH_SHA384, "TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher240 = SSLCipherSuite(0xC062, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_ARIA_128_GCM, SSL_HASH_SHA256, "TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher241 = SSLCipherSuite(0xC063, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_ARIA_256_GCM, SSL_HASH_SHA384, "TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher242 = SSLCipherSuite(0xC064, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_ARIA_128_CBC, SSL_HASH_SHA256, "TLS_PSK_WITH_ARIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher243 = SSLCipherSuite(0xC065, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_ARIA_256_CBC, SSL_HASH_SHA384, "TLS_PSK_WITH_ARIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher244 = SSLCipherSuite(0xC066, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_ARIA_128_CBC, SSL_HASH_SHA256, "TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher245 = SSLCipherSuite(0xC067, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_ARIA_256_CBC, SSL_HASH_SHA384, "TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher246 = SSLCipherSuite(0xC068, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_ARIA_128_CBC, SSL_HASH_SHA256, "TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher247 = SSLCipherSuite(0xC069, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_ARIA_256_CBC, SSL_HASH_SHA384, "TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher248 = SSLCipherSuite(0xC06A, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_ARIA_128_GCM, SSL_HASH_SHA256, "TLS_PSK_WITH_ARIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher249 = SSLCipherSuite(0xC06B, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_ARIA_256_GCM, SSL_HASH_SHA384, "TLS_PSK_WITH_ARIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher250 = SSLCipherSuite(0xC06C, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_ARIA_128_GCM, SSL_HASH_SHA256, "TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher251 = SSLCipherSuite(0xC06D, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_ARIA_256_GCM, SSL_HASH_SHA384, "TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher252 = SSLCipherSuite(0xC06E, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_ARIA_128_GCM, SSL_HASH_SHA256, "TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher253 = SSLCipherSuite(0xC06F, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_ARIA_256_GCM, SSL_HASH_SHA384, "TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher254 = SSLCipherSuite(0xC070, SSL_KEYX_ECDHE, SSL_AUTH_PSK, SSL_SYM_ARIA_128_CBC, SSL_HASH_SHA256, "TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher255 = SSLCipherSuite(0xC071, SSL_KEYX_ECDHE, SSL_AUTH_PSK, SSL_SYM_ARIA_256_CBC, SSL_HASH_SHA384, "TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher256 = SSLCipherSuite(0xC072, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA256, "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher257 = SSLCipherSuite(0xC073, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA384, "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher258 = SSLCipherSuite(0xC074, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA256, "TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher259 = SSLCipherSuite(0xC075, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA384, "TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher260 = SSLCipherSuite(0xC076, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA256, "TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher261 = SSLCipherSuite(0xC077, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA384, "TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher262 = SSLCipherSuite(0xC078, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA256, "TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher263 = SSLCipherSuite(0xC079, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA384, "TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher264 = SSLCipherSuite(0xC07A, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_128_GCM, SSL_HASH_SHA256, "TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher265 = SSLCipherSuite(0xC07B, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_256_GCM, SSL_HASH_SHA384, "TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher266 = SSLCipherSuite(0xC07C, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_128_GCM, SSL_HASH_SHA256, "TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher267 = SSLCipherSuite(0xC07D, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_256_GCM, SSL_HASH_SHA384, "TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher268 = SSLCipherSuite(0xC07E, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_128_GCM, SSL_HASH_SHA256, "TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher269 = SSLCipherSuite(0xC07F, SSL_KEYX_DH, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_256_GCM, SSL_HASH_SHA384, "TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher270 = SSLCipherSuite(0xC080, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_CAMELLIA_128_GCM, SSL_HASH_SHA256, "TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher271 = SSLCipherSuite(0xC081, SSL_KEYX_DHE, SSL_AUTH_DSS, SSL_SYM_CAMELLIA_256_GCM, SSL_HASH_SHA384, "TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher272 = SSLCipherSuite(0xC082, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_CAMELLIA_128_GCM, SSL_HASH_SHA256, "TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher273 = SSLCipherSuite(0xC083, SSL_KEYX_DH, SSL_AUTH_DSS, SSL_SYM_CAMELLIA_256_GCM, SSL_HASH_SHA384, "TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher274 = SSLCipherSuite(0xC084, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_CAMELLIA_128_GCM, SSL_HASH_SHA256, "TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher275 = SSLCipherSuite(0xC085, SSL_KEYX_DH, SSL_AUTH_anon, SSL_SYM_CAMELLIA_256_GCM, SSL_HASH_SHA384, "TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher276 = SSLCipherSuite(0xC086, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_CAMELLIA_128_GCM, SSL_HASH_SHA256, "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher277 = SSLCipherSuite(0xC087, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_CAMELLIA_256_GCM, SSL_HASH_SHA384, "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher278 = SSLCipherSuite(0xC088, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_CAMELLIA_128_GCM, SSL_HASH_SHA256, "TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher279 = SSLCipherSuite(0xC089, SSL_KEYX_ECDH, SSL_AUTH_ECDSA, SSL_SYM_CAMELLIA_256_GCM, SSL_HASH_SHA384, "TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher280 = SSLCipherSuite(0xC08A, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_128_GCM, SSL_HASH_SHA256, "TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher281 = SSLCipherSuite(0xC08B, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_256_GCM, SSL_HASH_SHA384, "TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher282 = SSLCipherSuite(0xC08C, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_128_GCM, SSL_HASH_SHA256, "TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher283 = SSLCipherSuite(0xC08D, SSL_KEYX_ECDH, SSL_AUTH_RSA, SSL_SYM_CAMELLIA_256_GCM, SSL_HASH_SHA384, "TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher284 = SSLCipherSuite(0xC08E, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_CAMELLIA_128_GCM, SSL_HASH_SHA256, "TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher285 = SSLCipherSuite(0xC08F, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_CAMELLIA_256_GCM, SSL_HASH_SHA384, "TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher286 = SSLCipherSuite(0xC090, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_CAMELLIA_128_GCM, SSL_HASH_SHA256, "TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher287 = SSLCipherSuite(0xC091, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_CAMELLIA_256_GCM, SSL_HASH_SHA384, "TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher288 = SSLCipherSuite(0xC092, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_CAMELLIA_128_GCM, SSL_HASH_SHA256, "TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256");
static const SSLCipherSuite Cipher289 = SSLCipherSuite(0xC093, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_CAMELLIA_256_GCM, SSL_HASH_SHA384, "TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384");
static const SSLCipherSuite Cipher290 = SSLCipherSuite(0xC094, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA256, "TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher291 = SSLCipherSuite(0xC095, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA384, "TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher292 = SSLCipherSuite(0xC096, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA256, "TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher293 = SSLCipherSuite(0xC097, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA384, "TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher294 = SSLCipherSuite(0xC098, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA256, "TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher295 = SSLCipherSuite(0xC099, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA384, "TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher296 = SSLCipherSuite(0xC09A, SSL_KEYX_ECDHE, SSL_AUTH_PSK, SSL_SYM_CAMELLIA_128_CBC, SSL_HASH_SHA256, "TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256");
static const SSLCipherSuite Cipher297 = SSLCipherSuite(0xC09B, SSL_KEYX_ECDHE, SSL_AUTH_PSK, SSL_SYM_CAMELLIA_256_CBC, SSL_HASH_SHA384, "TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384");
static const SSLCipherSuite Cipher298 = SSLCipherSuite(0xC09C, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_AES_128, SSL_HASH_CCM, "TLS_RSA_WITH_AES_128_CCM");
static const SSLCipherSuite Cipher299 = SSLCipherSuite(0xC09D, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_AES_256, SSL_HASH_CCM, "TLS_RSA_WITH_AES_256_CCM");
static const SSLCipherSuite Cipher300 = SSLCipherSuite(0xC09E, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_AES_128, SSL_HASH_CCM, "TLS_DHE_RSA_WITH_AES_128_CCM");
static const SSLCipherSuite Cipher301 = SSLCipherSuite(0xC09F, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_AES_256, SSL_HASH_CCM, "TLS_DHE_RSA_WITH_AES_256_CCM");
static const SSLCipherSuite Cipher302 = SSLCipherSuite(0xC0A0, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_AES_128, SSL_HASH_CCM_8, "TLS_RSA_WITH_AES_128_CCM_8");
static const SSLCipherSuite Cipher303 = SSLCipherSuite(0xC0A1, SSL_KEYX_RSA, SSL_AUTH_RSA, SSL_SYM_AES_256, SSL_HASH_CCM_8, "TLS_RSA_WITH_AES_256_CCM_8");
static const SSLCipherSuite Cipher304 = SSLCipherSuite(0xC0A2, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_AES_128, SSL_HASH_CCM_8, "TLS_DHE_RSA_WITH_AES_128_CCM_8");
static const SSLCipherSuite Cipher305 = SSLCipherSuite(0xC0A3, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_AES_256, SSL_HASH_CCM_8, "TLS_DHE_RSA_WITH_AES_256_CCM_8");
static const SSLCipherSuite Cipher306 = SSLCipherSuite(0xC0A4, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_AES_128, SSL_HASH_CCM, "TLS_PSK_WITH_AES_128_CCM");
static const SSLCipherSuite Cipher307 = SSLCipherSuite(0xC0A5, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_AES_256, SSL_HASH_CCM, "TLS_PSK_WITH_AES_256_CCM");
static const SSLCipherSuite Cipher308 = SSLCipherSuite(0xC0A6, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_AES_128, SSL_HASH_CCM, "TLS_DHE_PSK_WITH_AES_128_CCM");
static const SSLCipherSuite Cipher309 = SSLCipherSuite(0xC0A7, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_AES_256, SSL_HASH_CCM, "TLS_DHE_PSK_WITH_AES_256_CCM");
static const SSLCipherSuite Cipher310 = SSLCipherSuite(0xC0A8, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_AES_128, SSL_HASH_CCM_8, "TLS_PSK_WITH_AES_128_CCM_8");
static const SSLCipherSuite Cipher311 = SSLCipherSuite(0xC0A9, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_AES_256, SSL_HASH_CCM_8, "TLS_PSK_WITH_AES_256_CCM_8");
static const SSLCipherSuite Cipher312 = SSLCipherSuite(0xC0AA, SSL_KEYX_PSK, SSL_AUTH_DHE, SSL_SYM_AES_128, SSL_HASH_CCM_8, "TLS_PSK_DHE_WITH_AES_128_CCM_8");
static const SSLCipherSuite Cipher313 = SSLCipherSuite(0xC0AB, SSL_KEYX_PSK, SSL_AUTH_DHE, SSL_SYM_AES_256, SSL_HASH_CCM_8, "TLS_PSK_DHE_WITH_AES_256_CCM_8");
static const SSLCipherSuite Cipher314 = SSLCipherSuite(0xC0AC, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_AES_128, SSL_HASH_CCM, "TLS_ECDHE_ECDSA_WITH_AES_128_CCM");
static const SSLCipherSuite Cipher315 = SSLCipherSuite(0xC0AD, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_AES_256, SSL_HASH_CCM, "TLS_ECDHE_ECDSA_WITH_AES_256_CCM");
static const SSLCipherSuite Cipher316 = SSLCipherSuite(0xC0AE, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_AES_128, SSL_HASH_CCM_8, "TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8");
static const SSLCipherSuite Cipher317 = SSLCipherSuite(0xC0AF, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_AES_256, SSL_HASH_CCM_8, "TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8");
static const SSLCipherSuite Cipher318 = SSLCipherSuite(0xCCA8, SSL_KEYX_ECDHE, SSL_AUTH_RSA, SSL_SYM_CHACHA20_POLY1305, SSL_HASH_SHA256, "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256");
static const SSLCipherSuite Cipher319 = SSLCipherSuite(0xCCA9, SSL_KEYX_ECDHE, SSL_AUTH_ECDSA, SSL_SYM_CHACHA20_POLY1305, SSL_HASH_SHA256, "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256");
static const SSLCipherSuite Cipher320 = SSLCipherSuite(0xCCAA, SSL_KEYX_DHE, SSL_AUTH_RSA, SSL_SYM_CHACHA20_POLY1305, SSL_HASH_SHA256, "TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256");
static const SSLCipherSuite Cipher321 = SSLCipherSuite(0xCCAB, SSL_KEYX_PSK, SSL_AUTH_PSK, SSL_SYM_CHACHA20_POLY1305, SSL_HASH_SHA256, "TLS_PSK_WITH_CHACHA20_POLY1305_SHA256");
static const SSLCipherSuite Cipher322 = SSLCipherSuite(0xCCAC, SSL_KEYX_ECDHE, SSL_AUTH_PSK, SSL_SYM_CHACHA20_POLY1305, SSL_HASH_SHA256, "TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256");
static const SSLCipherSuite Cipher323 = SSLCipherSuite(0xCCAD, SSL_KEYX_DHE, SSL_AUTH_PSK, SSL_SYM_CHACHA20_POLY1305, SSL_HASH_SHA256, "TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256");
static const SSLCipherSuite Cipher324 = SSLCipherSuite(0xCCAE, SSL_KEYX_RSA, SSL_AUTH_PSK, SSL_SYM_CHACHA20_POLY1305, SSL_HASH_SHA256, "TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256");


static std::map<uint16_t, SSLCipherSuite*> createCipherSuiteIdToObjectMap()
{
	std::map<uint16_t, SSLCipherSuite*> result;

	result[0x0000] = (SSLCipherSuite*)&Cipher1;
	result[0x0001] = (SSLCipherSuite*)&Cipher2;
	result[0x0002] = (SSLCipherSuite*)&Cipher3;
	result[0x0003] = (SSLCipherSuite*)&Cipher4;
	result[0x0004] = (SSLCipherSuite*)&Cipher5;
	result[0x0005] = (SSLCipherSuite*)&Cipher6;
	result[0x0006] = (SSLCipherSuite*)&Cipher7;
	result[0x0007] = (SSLCipherSuite*)&Cipher8;
	result[0x0008] = (SSLCipherSuite*)&Cipher9;
	result[0x0009] = (SSLCipherSuite*)&Cipher10;
	result[0x000A] = (SSLCipherSuite*)&Cipher11;
	result[0x000B] = (SSLCipherSuite*)&Cipher12;
	result[0x000C] = (SSLCipherSuite*)&Cipher13;
	result[0x000D] = (SSLCipherSuite*)&Cipher14;
	result[0x000E] = (SSLCipherSuite*)&Cipher15;
	result[0x000F] = (SSLCipherSuite*)&Cipher16;
	result[0x0010] = (SSLCipherSuite*)&Cipher17;
	result[0x0011] = (SSLCipherSuite*)&Cipher18;
	result[0x0012] = (SSLCipherSuite*)&Cipher19;
	result[0x0013] = (SSLCipherSuite*)&Cipher20;
	result[0x0014] = (SSLCipherSuite*)&Cipher21;
	result[0x0015] = (SSLCipherSuite*)&Cipher22;
	result[0x0016] = (SSLCipherSuite*)&Cipher23;
	result[0x0017] = (SSLCipherSuite*)&Cipher24;
	result[0x0018] = (SSLCipherSuite*)&Cipher25;
	result[0x0019] = (SSLCipherSuite*)&Cipher26;
	result[0x001A] = (SSLCipherSuite*)&Cipher27;
	result[0x001B] = (SSLCipherSuite*)&Cipher28;
	result[0x001E] = (SSLCipherSuite*)&Cipher29;
	result[0x001F] = (SSLCipherSuite*)&Cipher30;
	result[0x0020] = (SSLCipherSuite*)&Cipher31;
	result[0x0021] = (SSLCipherSuite*)&Cipher32;
	result[0x0022] = (SSLCipherSuite*)&Cipher33;
	result[0x0023] = (SSLCipherSuite*)&Cipher34;
	result[0x0024] = (SSLCipherSuite*)&Cipher35;
	result[0x0025] = (SSLCipherSuite*)&Cipher36;
	result[0x0026] = (SSLCipherSuite*)&Cipher37;
	result[0x0027] = (SSLCipherSuite*)&Cipher38;
	result[0x0028] = (SSLCipherSuite*)&Cipher39;
	result[0x0029] = (SSLCipherSuite*)&Cipher40;
	result[0x002A] = (SSLCipherSuite*)&Cipher41;
	result[0x002B] = (SSLCipherSuite*)&Cipher42;
	result[0x002C] = (SSLCipherSuite*)&Cipher43;
	result[0x002D] = (SSLCipherSuite*)&Cipher44;
	result[0x002E] = (SSLCipherSuite*)&Cipher45;
	result[0x002F] = (SSLCipherSuite*)&Cipher46;
	result[0x0030] = (SSLCipherSuite*)&Cipher47;
	result[0x0031] = (SSLCipherSuite*)&Cipher48;
	result[0x0032] = (SSLCipherSuite*)&Cipher49;
	result[0x0033] = (SSLCipherSuite*)&Cipher50;
	result[0x0034] = (SSLCipherSuite*)&Cipher51;
	result[0x0035] = (SSLCipherSuite*)&Cipher52;
	result[0x0036] = (SSLCipherSuite*)&Cipher53;
	result[0x0037] = (SSLCipherSuite*)&Cipher54;
	result[0x0038] = (SSLCipherSuite*)&Cipher55;
	result[0x0039] = (SSLCipherSuite*)&Cipher56;
	result[0x003A] = (SSLCipherSuite*)&Cipher57;
	result[0x003B] = (SSLCipherSuite*)&Cipher58;
	result[0x003C] = (SSLCipherSuite*)&Cipher59;
	result[0x003D] = (SSLCipherSuite*)&Cipher60;
	result[0x003E] = (SSLCipherSuite*)&Cipher61;
	result[0x003F] = (SSLCipherSuite*)&Cipher62;
	result[0x0040] = (SSLCipherSuite*)&Cipher63;
	result[0x0041] = (SSLCipherSuite*)&Cipher64;
	result[0x0042] = (SSLCipherSuite*)&Cipher65;
	result[0x0043] = (SSLCipherSuite*)&Cipher66;
	result[0x0044] = (SSLCipherSuite*)&Cipher67;
	result[0x0045] = (SSLCipherSuite*)&Cipher68;
	result[0x0046] = (SSLCipherSuite*)&Cipher69;
	result[0x0067] = (SSLCipherSuite*)&Cipher70;
	result[0x0068] = (SSLCipherSuite*)&Cipher71;
	result[0x0069] = (SSLCipherSuite*)&Cipher72;
	result[0x006A] = (SSLCipherSuite*)&Cipher73;
	result[0x006B] = (SSLCipherSuite*)&Cipher74;
	result[0x006C] = (SSLCipherSuite*)&Cipher75;
	result[0x006D] = (SSLCipherSuite*)&Cipher76;
	result[0x0084] = (SSLCipherSuite*)&Cipher77;
	result[0x0085] = (SSLCipherSuite*)&Cipher78;
	result[0x0086] = (SSLCipherSuite*)&Cipher79;
	result[0x0087] = (SSLCipherSuite*)&Cipher80;
	result[0x0088] = (SSLCipherSuite*)&Cipher81;
	result[0x0089] = (SSLCipherSuite*)&Cipher82;
	result[0x008A] = (SSLCipherSuite*)&Cipher83;
	result[0x008B] = (SSLCipherSuite*)&Cipher84;
	result[0x008C] = (SSLCipherSuite*)&Cipher85;
	result[0x008D] = (SSLCipherSuite*)&Cipher86;
	result[0x008E] = (SSLCipherSuite*)&Cipher87;
	result[0x008F] = (SSLCipherSuite*)&Cipher88;
	result[0x0090] = (SSLCipherSuite*)&Cipher89;
	result[0x0091] = (SSLCipherSuite*)&Cipher90;
	result[0x0092] = (SSLCipherSuite*)&Cipher91;
	result[0x0093] = (SSLCipherSuite*)&Cipher92;
	result[0x0094] = (SSLCipherSuite*)&Cipher93;
	result[0x0095] = (SSLCipherSuite*)&Cipher94;
	result[0x0096] = (SSLCipherSuite*)&Cipher95;
	result[0x0097] = (SSLCipherSuite*)&Cipher96;
	result[0x0098] = (SSLCipherSuite*)&Cipher97;
	result[0x0099] = (SSLCipherSuite*)&Cipher98;
	result[0x009A] = (SSLCipherSuite*)&Cipher99;
	result[0x009B] = (SSLCipherSuite*)&Cipher100;
	result[0x009C] = (SSLCipherSuite*)&Cipher101;
	result[0x009D] = (SSLCipherSuite*)&Cipher102;
	result[0x009E] = (SSLCipherSuite*)&Cipher103;
	result[0x009F] = (SSLCipherSuite*)&Cipher104;
	result[0x00A0] = (SSLCipherSuite*)&Cipher105;
	result[0x00A1] = (SSLCipherSuite*)&Cipher106;
	result[0x00A2] = (SSLCipherSuite*)&Cipher107;
	result[0x00A3] = (SSLCipherSuite*)&Cipher108;
	result[0x00A4] = (SSLCipherSuite*)&Cipher109;
	result[0x00A5] = (SSLCipherSuite*)&Cipher110;
	result[0x00A6] = (SSLCipherSuite*)&Cipher111;
	result[0x00A7] = (SSLCipherSuite*)&Cipher112;
	result[0x00A8] = (SSLCipherSuite*)&Cipher113;
	result[0x00A9] = (SSLCipherSuite*)&Cipher114;
	result[0x00AA] = (SSLCipherSuite*)&Cipher115;
	result[0x00AB] = (SSLCipherSuite*)&Cipher116;
	result[0x00AC] = (SSLCipherSuite*)&Cipher117;
	result[0x00AD] = (SSLCipherSuite*)&Cipher118;
	result[0x00AE] = (SSLCipherSuite*)&Cipher119;
	result[0x00AF] = (SSLCipherSuite*)&Cipher120;
	result[0x00B0] = (SSLCipherSuite*)&Cipher121;
	result[0x00B1] = (SSLCipherSuite*)&Cipher122;
	result[0x00B2] = (SSLCipherSuite*)&Cipher123;
	result[0x00B3] = (SSLCipherSuite*)&Cipher124;
	result[0x00B4] = (SSLCipherSuite*)&Cipher125;
	result[0x00B5] = (SSLCipherSuite*)&Cipher126;
	result[0x00B6] = (SSLCipherSuite*)&Cipher127;
	result[0x00B7] = (SSLCipherSuite*)&Cipher128;
	result[0x00B8] = (SSLCipherSuite*)&Cipher129;
	result[0x00B9] = (SSLCipherSuite*)&Cipher130;
	result[0x00BA] = (SSLCipherSuite*)&Cipher131;
	result[0x00BB] = (SSLCipherSuite*)&Cipher132;
	result[0x00BC] = (SSLCipherSuite*)&Cipher133;
	result[0x00BD] = (SSLCipherSuite*)&Cipher134;
	result[0x00BE] = (SSLCipherSuite*)&Cipher135;
	result[0x00BF] = (SSLCipherSuite*)&Cipher136;
	result[0x00C0] = (SSLCipherSuite*)&Cipher137;
	result[0x00C1] = (SSLCipherSuite*)&Cipher138;
	result[0x00C2] = (SSLCipherSuite*)&Cipher139;
	result[0x00C3] = (SSLCipherSuite*)&Cipher140;
	result[0x00C4] = (SSLCipherSuite*)&Cipher141;
	result[0x00C5] = (SSLCipherSuite*)&Cipher142;
	result[0xC001] = (SSLCipherSuite*)&Cipher143;
	result[0xC002] = (SSLCipherSuite*)&Cipher144;
	result[0xC003] = (SSLCipherSuite*)&Cipher145;
	result[0xC004] = (SSLCipherSuite*)&Cipher146;
	result[0xC005] = (SSLCipherSuite*)&Cipher147;
	result[0xC006] = (SSLCipherSuite*)&Cipher148;
	result[0xC007] = (SSLCipherSuite*)&Cipher149;
	result[0xC008] = (SSLCipherSuite*)&Cipher150;
	result[0xC009] = (SSLCipherSuite*)&Cipher151;
	result[0xC00A] = (SSLCipherSuite*)&Cipher152;
	result[0xC00B] = (SSLCipherSuite*)&Cipher153;
	result[0xC00C] = (SSLCipherSuite*)&Cipher154;
	result[0xC00D] = (SSLCipherSuite*)&Cipher155;
	result[0xC00E] = (SSLCipherSuite*)&Cipher156;
	result[0xC00F] = (SSLCipherSuite*)&Cipher157;
	result[0xC010] = (SSLCipherSuite*)&Cipher158;
	result[0xC011] = (SSLCipherSuite*)&Cipher159;
	result[0xC012] = (SSLCipherSuite*)&Cipher160;
	result[0xC013] = (SSLCipherSuite*)&Cipher161;
	result[0xC014] = (SSLCipherSuite*)&Cipher162;
	result[0xC015] = (SSLCipherSuite*)&Cipher163;
	result[0xC016] = (SSLCipherSuite*)&Cipher164;
	result[0xC017] = (SSLCipherSuite*)&Cipher165;
	result[0xC018] = (SSLCipherSuite*)&Cipher166;
	result[0xC019] = (SSLCipherSuite*)&Cipher167;
	result[0xC01A] = (SSLCipherSuite*)&Cipher168;
	result[0xC01B] = (SSLCipherSuite*)&Cipher169;
	result[0xC01C] = (SSLCipherSuite*)&Cipher170;
	result[0xC01D] = (SSLCipherSuite*)&Cipher171;
	result[0xC01E] = (SSLCipherSuite*)&Cipher172;
	result[0xC01F] = (SSLCipherSuite*)&Cipher173;
	result[0xC020] = (SSLCipherSuite*)&Cipher174;
	result[0xC021] = (SSLCipherSuite*)&Cipher175;
	result[0xC022] = (SSLCipherSuite*)&Cipher176;
	result[0xC023] = (SSLCipherSuite*)&Cipher177;
	result[0xC024] = (SSLCipherSuite*)&Cipher178;
	result[0xC025] = (SSLCipherSuite*)&Cipher179;
	result[0xC026] = (SSLCipherSuite*)&Cipher180;
	result[0xC027] = (SSLCipherSuite*)&Cipher181;
	result[0xC028] = (SSLCipherSuite*)&Cipher182;
	result[0xC029] = (SSLCipherSuite*)&Cipher183;
	result[0xC02A] = (SSLCipherSuite*)&Cipher184;
	result[0xC02B] = (SSLCipherSuite*)&Cipher185;
	result[0xC02C] = (SSLCipherSuite*)&Cipher186;
	result[0xC02D] = (SSLCipherSuite*)&Cipher187;
	result[0xC02E] = (SSLCipherSuite*)&Cipher188;
	result[0xC02F] = (SSLCipherSuite*)&Cipher189;
	result[0xC030] = (SSLCipherSuite*)&Cipher190;
	result[0xC031] = (SSLCipherSuite*)&Cipher191;
	result[0xC032] = (SSLCipherSuite*)&Cipher192;
	result[0xC033] = (SSLCipherSuite*)&Cipher193;
	result[0xC034] = (SSLCipherSuite*)&Cipher194;
	result[0xC035] = (SSLCipherSuite*)&Cipher195;
	result[0xC036] = (SSLCipherSuite*)&Cipher196;
	result[0xC037] = (SSLCipherSuite*)&Cipher197;
	result[0xC038] = (SSLCipherSuite*)&Cipher198;
	result[0xC039] = (SSLCipherSuite*)&Cipher199;
	result[0xC03A] = (SSLCipherSuite*)&Cipher200;
	result[0xC03B] = (SSLCipherSuite*)&Cipher201;
	result[0xC03C] = (SSLCipherSuite*)&Cipher202;
	result[0xC03D] = (SSLCipherSuite*)&Cipher203;
	result[0xC03E] = (SSLCipherSuite*)&Cipher204;
	result[0xC03F] = (SSLCipherSuite*)&Cipher205;
	result[0xC040] = (SSLCipherSuite*)&Cipher206;
	result[0xC041] = (SSLCipherSuite*)&Cipher207;
	result[0xC042] = (SSLCipherSuite*)&Cipher208;
	result[0xC043] = (SSLCipherSuite*)&Cipher209;
	result[0xC044] = (SSLCipherSuite*)&Cipher210;
	result[0xC045] = (SSLCipherSuite*)&Cipher211;
	result[0xC046] = (SSLCipherSuite*)&Cipher212;
	result[0xC047] = (SSLCipherSuite*)&Cipher213;
	result[0xC048] = (SSLCipherSuite*)&Cipher214;
	result[0xC049] = (SSLCipherSuite*)&Cipher215;
	result[0xC04A] = (SSLCipherSuite*)&Cipher216;
	result[0xC04B] = (SSLCipherSuite*)&Cipher217;
	result[0xC04C] = (SSLCipherSuite*)&Cipher218;
	result[0xC04D] = (SSLCipherSuite*)&Cipher219;
	result[0xC04E] = (SSLCipherSuite*)&Cipher220;
	result[0xC04F] = (SSLCipherSuite*)&Cipher221;
	result[0xC050] = (SSLCipherSuite*)&Cipher222;
	result[0xC051] = (SSLCipherSuite*)&Cipher223;
	result[0xC052] = (SSLCipherSuite*)&Cipher224;
	result[0xC053] = (SSLCipherSuite*)&Cipher225;
	result[0xC054] = (SSLCipherSuite*)&Cipher226;
	result[0xC055] = (SSLCipherSuite*)&Cipher227;
	result[0xC056] = (SSLCipherSuite*)&Cipher228;
	result[0xC057] = (SSLCipherSuite*)&Cipher229;
	result[0xC058] = (SSLCipherSuite*)&Cipher230;
	result[0xC059] = (SSLCipherSuite*)&Cipher231;
	result[0xC05A] = (SSLCipherSuite*)&Cipher232;
	result[0xC05B] = (SSLCipherSuite*)&Cipher233;
	result[0xC05C] = (SSLCipherSuite*)&Cipher234;
	result[0xC05D] = (SSLCipherSuite*)&Cipher235;
	result[0xC05E] = (SSLCipherSuite*)&Cipher236;
	result[0xC05F] = (SSLCipherSuite*)&Cipher237;
	result[0xC060] = (SSLCipherSuite*)&Cipher238;
	result[0xC061] = (SSLCipherSuite*)&Cipher239;
	result[0xC062] = (SSLCipherSuite*)&Cipher240;
	result[0xC063] = (SSLCipherSuite*)&Cipher241;
	result[0xC064] = (SSLCipherSuite*)&Cipher242;
	result[0xC065] = (SSLCipherSuite*)&Cipher243;
	result[0xC066] = (SSLCipherSuite*)&Cipher244;
	result[0xC067] = (SSLCipherSuite*)&Cipher245;
	result[0xC068] = (SSLCipherSuite*)&Cipher246;
	result[0xC069] = (SSLCipherSuite*)&Cipher247;
	result[0xC06A] = (SSLCipherSuite*)&Cipher248;
	result[0xC06B] = (SSLCipherSuite*)&Cipher249;
	result[0xC06C] = (SSLCipherSuite*)&Cipher250;
	result[0xC06D] = (SSLCipherSuite*)&Cipher251;
	result[0xC06E] = (SSLCipherSuite*)&Cipher252;
	result[0xC06F] = (SSLCipherSuite*)&Cipher253;
	result[0xC070] = (SSLCipherSuite*)&Cipher254;
	result[0xC071] = (SSLCipherSuite*)&Cipher255;
	result[0xC072] = (SSLCipherSuite*)&Cipher256;
	result[0xC073] = (SSLCipherSuite*)&Cipher257;
	result[0xC074] = (SSLCipherSuite*)&Cipher258;
	result[0xC075] = (SSLCipherSuite*)&Cipher259;
	result[0xC076] = (SSLCipherSuite*)&Cipher260;
	result[0xC077] = (SSLCipherSuite*)&Cipher261;
	result[0xC078] = (SSLCipherSuite*)&Cipher262;
	result[0xC079] = (SSLCipherSuite*)&Cipher263;
	result[0xC07A] = (SSLCipherSuite*)&Cipher264;
	result[0xC07B] = (SSLCipherSuite*)&Cipher265;
	result[0xC07C] = (SSLCipherSuite*)&Cipher266;
	result[0xC07D] = (SSLCipherSuite*)&Cipher267;
	result[0xC07E] = (SSLCipherSuite*)&Cipher268;
	result[0xC07F] = (SSLCipherSuite*)&Cipher269;
	result[0xC080] = (SSLCipherSuite*)&Cipher270;
	result[0xC081] = (SSLCipherSuite*)&Cipher271;
	result[0xC082] = (SSLCipherSuite*)&Cipher272;
	result[0xC083] = (SSLCipherSuite*)&Cipher273;
	result[0xC084] = (SSLCipherSuite*)&Cipher274;
	result[0xC085] = (SSLCipherSuite*)&Cipher275;
	result[0xC086] = (SSLCipherSuite*)&Cipher276;
	result[0xC087] = (SSLCipherSuite*)&Cipher277;
	result[0xC088] = (SSLCipherSuite*)&Cipher278;
	result[0xC089] = (SSLCipherSuite*)&Cipher279;
	result[0xC08A] = (SSLCipherSuite*)&Cipher280;
	result[0xC08B] = (SSLCipherSuite*)&Cipher281;
	result[0xC08C] = (SSLCipherSuite*)&Cipher282;
	result[0xC08D] = (SSLCipherSuite*)&Cipher283;
	result[0xC08E] = (SSLCipherSuite*)&Cipher284;
	result[0xC08F] = (SSLCipherSuite*)&Cipher285;
	result[0xC090] = (SSLCipherSuite*)&Cipher286;
	result[0xC091] = (SSLCipherSuite*)&Cipher287;
	result[0xC092] = (SSLCipherSuite*)&Cipher288;
	result[0xC093] = (SSLCipherSuite*)&Cipher289;
	result[0xC094] = (SSLCipherSuite*)&Cipher290;
	result[0xC095] = (SSLCipherSuite*)&Cipher291;
	result[0xC096] = (SSLCipherSuite*)&Cipher292;
	result[0xC097] = (SSLCipherSuite*)&Cipher293;
	result[0xC098] = (SSLCipherSuite*)&Cipher294;
	result[0xC099] = (SSLCipherSuite*)&Cipher295;
	result[0xC09A] = (SSLCipherSuite*)&Cipher296;
	result[0xC09B] = (SSLCipherSuite*)&Cipher297;
	result[0xC09C] = (SSLCipherSuite*)&Cipher298;
	result[0xC09D] = (SSLCipherSuite*)&Cipher299;
	result[0xC09E] = (SSLCipherSuite*)&Cipher300;
	result[0xC09F] = (SSLCipherSuite*)&Cipher301;
	result[0xC0A0] = (SSLCipherSuite*)&Cipher302;
	result[0xC0A1] = (SSLCipherSuite*)&Cipher303;
	result[0xC0A2] = (SSLCipherSuite*)&Cipher304;
	result[0xC0A3] = (SSLCipherSuite*)&Cipher305;
	result[0xC0A4] = (SSLCipherSuite*)&Cipher306;
	result[0xC0A5] = (SSLCipherSuite*)&Cipher307;
	result[0xC0A6] = (SSLCipherSuite*)&Cipher308;
	result[0xC0A7] = (SSLCipherSuite*)&Cipher309;
	result[0xC0A8] = (SSLCipherSuite*)&Cipher310;
	result[0xC0A9] = (SSLCipherSuite*)&Cipher311;
	result[0xC0AA] = (SSLCipherSuite*)&Cipher312;
	result[0xC0AB] = (SSLCipherSuite*)&Cipher313;
	result[0xC0AC] = (SSLCipherSuite*)&Cipher314;
	result[0xC0AD] = (SSLCipherSuite*)&Cipher315;
	result[0xC0AE] = (SSLCipherSuite*)&Cipher316;
	result[0xC0AF] = (SSLCipherSuite*)&Cipher317;
	result[0xCCA8] = (SSLCipherSuite*)&Cipher318;
	result[0xCCA9] = (SSLCipherSuite*)&Cipher319;
	result[0xCCAA] = (SSLCipherSuite*)&Cipher320;
	result[0xCCAB] = (SSLCipherSuite*)&Cipher321;
	result[0xCCAC] = (SSLCipherSuite*)&Cipher322;
	result[0xCCAD] = (SSLCipherSuite*)&Cipher323;
	result[0xCCAE] = (SSLCipherSuite*)&Cipher324;

	return result;
}

static std::map<std::string, SSLCipherSuite*> createCipherSuiteStringToObjectMap()
{
	std::map<std::string, SSLCipherSuite*> result;

	result["TLS_NULL_WITH_NULL_NULL"] = (SSLCipherSuite*)&Cipher1;
	result["TLS_RSA_WITH_NULL_MD5"] = (SSLCipherSuite*)&Cipher2;
	result["TLS_RSA_WITH_NULL_SHA"] = (SSLCipherSuite*)&Cipher3;
	result["TLS_RSA_EXPORT_WITH_RC4_40_MD5"] = (SSLCipherSuite*)&Cipher4;
	result["TLS_RSA_WITH_RC4_128_MD5"] = (SSLCipherSuite*)&Cipher5;
	result["TLS_RSA_WITH_RC4_128_SHA"] = (SSLCipherSuite*)&Cipher6;
	result["TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5"] = (SSLCipherSuite*)&Cipher7;
	result["TLS_RSA_WITH_IDEA_CBC_SHA"] = (SSLCipherSuite*)&Cipher8;
	result["TLS_RSA_EXPORT_WITH_DES40_CBC_SHA"] = (SSLCipherSuite*)&Cipher9;
	result["TLS_RSA_WITH_DES_CBC_SHA"] = (SSLCipherSuite*)&Cipher10;
	result["TLS_RSA_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher11;
	result["TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA"] = (SSLCipherSuite*)&Cipher12;
	result["TLS_DH_DSS_WITH_DES_CBC_SHA"] = (SSLCipherSuite*)&Cipher13;
	result["TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher14;
	result["TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA"] = (SSLCipherSuite*)&Cipher15;
	result["TLS_DH_RSA_WITH_DES_CBC_SHA"] = (SSLCipherSuite*)&Cipher16;
	result["TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher17;
	result["TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"] = (SSLCipherSuite*)&Cipher18;
	result["TLS_DHE_DSS_WITH_DES_CBC_SHA"] = (SSLCipherSuite*)&Cipher19;
	result["TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher20;
	result["TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA"] = (SSLCipherSuite*)&Cipher21;
	result["TLS_DHE_RSA_WITH_DES_CBC_SHA"] = (SSLCipherSuite*)&Cipher22;
	result["TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher23;
	result["TLS_DH_anon_EXPORT_WITH_RC4_40_MD5"] = (SSLCipherSuite*)&Cipher24;
	result["TLS_DH_anon_WITH_RC4_128_MD5"] = (SSLCipherSuite*)&Cipher25;
	result["TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA"] = (SSLCipherSuite*)&Cipher26;
	result["TLS_DH_anon_WITH_DES_CBC_SHA"] = (SSLCipherSuite*)&Cipher27;
	result["TLS_DH_anon_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher28;
	result["TLS_KRB5_WITH_DES_CBC_SHA"] = (SSLCipherSuite*)&Cipher29;
	result["TLS_KRB5_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher30;
	result["TLS_KRB5_WITH_RC4_128_SHA"] = (SSLCipherSuite*)&Cipher31;
	result["TLS_KRB5_WITH_IDEA_CBC_SHA"] = (SSLCipherSuite*)&Cipher32;
	result["TLS_KRB5_WITH_DES_CBC_MD5"] = (SSLCipherSuite*)&Cipher33;
	result["TLS_KRB5_WITH_3DES_EDE_CBC_MD5"] = (SSLCipherSuite*)&Cipher34;
	result["TLS_KRB5_WITH_RC4_128_MD5"] = (SSLCipherSuite*)&Cipher35;
	result["TLS_KRB5_WITH_IDEA_CBC_MD5"] = (SSLCipherSuite*)&Cipher36;
	result["TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA"] = (SSLCipherSuite*)&Cipher37;
	result["TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA"] = (SSLCipherSuite*)&Cipher38;
	result["TLS_KRB5_EXPORT_WITH_RC4_40_SHA"] = (SSLCipherSuite*)&Cipher39;
	result["TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5"] = (SSLCipherSuite*)&Cipher40;
	result["TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5"] = (SSLCipherSuite*)&Cipher41;
	result["TLS_KRB5_EXPORT_WITH_RC4_40_MD5"] = (SSLCipherSuite*)&Cipher42;
	result["TLS_PSK_WITH_NULL_SHA"] = (SSLCipherSuite*)&Cipher43;
	result["TLS_DHE_PSK_WITH_NULL_SHA"] = (SSLCipherSuite*)&Cipher44;
	result["TLS_RSA_PSK_WITH_NULL_SHA"] = (SSLCipherSuite*)&Cipher45;
	result["TLS_RSA_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher46;
	result["TLS_DH_DSS_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher47;
	result["TLS_DH_RSA_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher48;
	result["TLS_DHE_DSS_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher49;
	result["TLS_DHE_RSA_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher50;
	result["TLS_DH_anon_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher51;
	result["TLS_RSA_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher52;
	result["TLS_DH_DSS_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher53;
	result["TLS_DH_RSA_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher54;
	result["TLS_DHE_DSS_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher55;
	result["TLS_DHE_RSA_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher56;
	result["TLS_DH_anon_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher57;
	result["TLS_RSA_WITH_NULL_SHA256"] = (SSLCipherSuite*)&Cipher58;
	result["TLS_RSA_WITH_AES_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher59;
	result["TLS_RSA_WITH_AES_256_CBC_SHA256"] = (SSLCipherSuite*)&Cipher60;
	result["TLS_DH_DSS_WITH_AES_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher61;
	result["TLS_DH_RSA_WITH_AES_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher62;
	result["TLS_DHE_DSS_WITH_AES_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher63;
	result["TLS_RSA_WITH_CAMELLIA_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher64;
	result["TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher65;
	result["TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher66;
	result["TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher67;
	result["TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher68;
	result["TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher69;
	result["TLS_DHE_RSA_WITH_AES_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher70;
	result["TLS_DH_DSS_WITH_AES_256_CBC_SHA256"] = (SSLCipherSuite*)&Cipher71;
	result["TLS_DH_RSA_WITH_AES_256_CBC_SHA256"] = (SSLCipherSuite*)&Cipher72;
	result["TLS_DHE_DSS_WITH_AES_256_CBC_SHA256"] = (SSLCipherSuite*)&Cipher73;
	result["TLS_DHE_RSA_WITH_AES_256_CBC_SHA256"] = (SSLCipherSuite*)&Cipher74;
	result["TLS_DH_anon_WITH_AES_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher75;
	result["TLS_DH_anon_WITH_AES_256_CBC_SHA256"] = (SSLCipherSuite*)&Cipher76;
	result["TLS_RSA_WITH_CAMELLIA_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher77;
	result["TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher78;
	result["TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher79;
	result["TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher80;
	result["TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher81;
	result["TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher82;
	result["TLS_PSK_WITH_RC4_128_SHA"] = (SSLCipherSuite*)&Cipher83;
	result["TLS_PSK_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher84;
	result["TLS_PSK_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher85;
	result["TLS_PSK_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher86;
	result["TLS_DHE_PSK_WITH_RC4_128_SHA"] = (SSLCipherSuite*)&Cipher87;
	result["TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher88;
	result["TLS_DHE_PSK_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher89;
	result["TLS_DHE_PSK_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher90;
	result["TLS_RSA_PSK_WITH_RC4_128_SHA"] = (SSLCipherSuite*)&Cipher91;
	result["TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher92;
	result["TLS_RSA_PSK_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher93;
	result["TLS_RSA_PSK_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher94;
	result["TLS_RSA_WITH_SEED_CBC_SHA"] = (SSLCipherSuite*)&Cipher95;
	result["TLS_DH_DSS_WITH_SEED_CBC_SHA"] = (SSLCipherSuite*)&Cipher96;
	result["TLS_DH_RSA_WITH_SEED_CBC_SHA"] = (SSLCipherSuite*)&Cipher97;
	result["TLS_DHE_DSS_WITH_SEED_CBC_SHA"] = (SSLCipherSuite*)&Cipher98;
	result["TLS_DHE_RSA_WITH_SEED_CBC_SHA"] = (SSLCipherSuite*)&Cipher99;
	result["TLS_DH_anon_WITH_SEED_CBC_SHA"] = (SSLCipherSuite*)&Cipher100;
	result["TLS_RSA_WITH_AES_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher101;
	result["TLS_RSA_WITH_AES_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher102;
	result["TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher103;
	result["TLS_DHE_RSA_WITH_AES_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher104;
	result["TLS_DH_RSA_WITH_AES_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher105;
	result["TLS_DH_RSA_WITH_AES_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher106;
	result["TLS_DHE_DSS_WITH_AES_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher107;
	result["TLS_DHE_DSS_WITH_AES_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher108;
	result["TLS_DH_DSS_WITH_AES_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher109;
	result["TLS_DH_DSS_WITH_AES_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher110;
	result["TLS_DH_anon_WITH_AES_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher111;
	result["TLS_DH_anon_WITH_AES_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher112;
	result["TLS_PSK_WITH_AES_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher113;
	result["TLS_PSK_WITH_AES_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher114;
	result["TLS_DHE_PSK_WITH_AES_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher115;
	result["TLS_DHE_PSK_WITH_AES_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher116;
	result["TLS_RSA_PSK_WITH_AES_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher117;
	result["TLS_RSA_PSK_WITH_AES_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher118;
	result["TLS_PSK_WITH_AES_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher119;
	result["TLS_PSK_WITH_AES_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher120;
	result["TLS_PSK_WITH_NULL_SHA256"] = (SSLCipherSuite*)&Cipher121;
	result["TLS_PSK_WITH_NULL_SHA384"] = (SSLCipherSuite*)&Cipher122;
	result["TLS_DHE_PSK_WITH_AES_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher123;
	result["TLS_DHE_PSK_WITH_AES_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher124;
	result["TLS_DHE_PSK_WITH_NULL_SHA256"] = (SSLCipherSuite*)&Cipher125;
	result["TLS_DHE_PSK_WITH_NULL_SHA384"] = (SSLCipherSuite*)&Cipher126;
	result["TLS_RSA_PSK_WITH_AES_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher127;
	result["TLS_RSA_PSK_WITH_AES_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher128;
	result["TLS_RSA_PSK_WITH_NULL_SHA256"] = (SSLCipherSuite*)&Cipher129;
	result["TLS_RSA_PSK_WITH_NULL_SHA384"] = (SSLCipherSuite*)&Cipher130;
	result["TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher131;
	result["TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher132;
	result["TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher133;
	result["TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher134;
	result["TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher135;
	result["TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher136;
	result["TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256"] = (SSLCipherSuite*)&Cipher137;
	result["TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256"] = (SSLCipherSuite*)&Cipher138;
	result["TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256"] = (SSLCipherSuite*)&Cipher139;
	result["TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256"] = (SSLCipherSuite*)&Cipher140;
	result["TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256"] = (SSLCipherSuite*)&Cipher141;
	result["TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256"] = (SSLCipherSuite*)&Cipher142;
	result["TLS_ECDH_ECDSA_WITH_NULL_SHA"] = (SSLCipherSuite*)&Cipher143;
	result["TLS_ECDH_ECDSA_WITH_RC4_128_SHA"] = (SSLCipherSuite*)&Cipher144;
	result["TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher145;
	result["TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher146;
	result["TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher147;
	result["TLS_ECDHE_ECDSA_WITH_NULL_SHA"] = (SSLCipherSuite*)&Cipher148;
	result["TLS_ECDHE_ECDSA_WITH_RC4_128_SHA"] = (SSLCipherSuite*)&Cipher149;
	result["TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher150;
	result["TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher151;
	result["TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher152;
	result["TLS_ECDH_RSA_WITH_NULL_SHA"] = (SSLCipherSuite*)&Cipher153;
	result["TLS_ECDH_RSA_WITH_RC4_128_SHA"] = (SSLCipherSuite*)&Cipher154;
	result["TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher155;
	result["TLS_ECDH_RSA_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher156;
	result["TLS_ECDH_RSA_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher157;
	result["TLS_ECDHE_RSA_WITH_NULL_SHA"] = (SSLCipherSuite*)&Cipher158;
	result["TLS_ECDHE_RSA_WITH_RC4_128_SHA"] = (SSLCipherSuite*)&Cipher159;
	result["TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher160;
	result["TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher161;
	result["TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher162;
	result["TLS_ECDH_anon_WITH_NULL_SHA"] = (SSLCipherSuite*)&Cipher163;
	result["TLS_ECDH_anon_WITH_RC4_128_SHA"] = (SSLCipherSuite*)&Cipher164;
	result["TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher165;
	result["TLS_ECDH_anon_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher166;
	result["TLS_ECDH_anon_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher167;
	result["TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher168;
	result["TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher169;
	result["TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher170;
	result["TLS_SRP_SHA_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher171;
	result["TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher172;
	result["TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher173;
	result["TLS_SRP_SHA_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher174;
	result["TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher175;
	result["TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher176;
	result["TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher177;
	result["TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher178;
	result["TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher179;
	result["TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher180;
	result["TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher181;
	result["TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher182;
	result["TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher183;
	result["TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher184;
	result["TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher185;
	result["TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher186;
	result["TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher187;
	result["TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher188;
	result["TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher189;
	result["TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher190;
	result["TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher191;
	result["TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher192;
	result["TLS_ECDHE_PSK_WITH_RC4_128_SHA"] = (SSLCipherSuite*)&Cipher193;
	result["TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA"] = (SSLCipherSuite*)&Cipher194;
	result["TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA"] = (SSLCipherSuite*)&Cipher195;
	result["TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA"] = (SSLCipherSuite*)&Cipher196;
	result["TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher197;
	result["TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher198;
	result["TLS_ECDHE_PSK_WITH_NULL_SHA"] = (SSLCipherSuite*)&Cipher199;
	result["TLS_ECDHE_PSK_WITH_NULL_SHA256"] = (SSLCipherSuite*)&Cipher200;
	result["TLS_ECDHE_PSK_WITH_NULL_SHA384"] = (SSLCipherSuite*)&Cipher201;
	result["TLS_RSA_WITH_ARIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher202;
	result["TLS_RSA_WITH_ARIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher203;
	result["TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher204;
	result["TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher205;
	result["TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher206;
	result["TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher207;
	result["TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher208;
	result["TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher209;
	result["TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher210;
	result["TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher211;
	result["TLS_DH_anon_WITH_ARIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher212;
	result["TLS_DH_anon_WITH_ARIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher213;
	result["TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher214;
	result["TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher215;
	result["TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher216;
	result["TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher217;
	result["TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher218;
	result["TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher219;
	result["TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher220;
	result["TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher221;
	result["TLS_RSA_WITH_ARIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher222;
	result["TLS_RSA_WITH_ARIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher223;
	result["TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher224;
	result["TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher225;
	result["TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher226;
	result["TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher227;
	result["TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher228;
	result["TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher229;
	result["TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher230;
	result["TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher231;
	result["TLS_DH_anon_WITH_ARIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher232;
	result["TLS_DH_anon_WITH_ARIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher233;
	result["TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher234;
	result["TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher235;
	result["TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher236;
	result["TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher237;
	result["TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher238;
	result["TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher239;
	result["TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher240;
	result["TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher241;
	result["TLS_PSK_WITH_ARIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher242;
	result["TLS_PSK_WITH_ARIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher243;
	result["TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher244;
	result["TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher245;
	result["TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher246;
	result["TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher247;
	result["TLS_PSK_WITH_ARIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher248;
	result["TLS_PSK_WITH_ARIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher249;
	result["TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher250;
	result["TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher251;
	result["TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher252;
	result["TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher253;
	result["TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher254;
	result["TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher255;
	result["TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher256;
	result["TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher257;
	result["TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher258;
	result["TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher259;
	result["TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher260;
	result["TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher261;
	result["TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher262;
	result["TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher263;
	result["TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher264;
	result["TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher265;
	result["TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher266;
	result["TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher267;
	result["TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher268;
	result["TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher269;
	result["TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher270;
	result["TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher271;
	result["TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher272;
	result["TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher273;
	result["TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher274;
	result["TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher275;
	result["TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher276;
	result["TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher277;
	result["TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher278;
	result["TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher279;
	result["TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher280;
	result["TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher281;
	result["TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher282;
	result["TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher283;
	result["TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher284;
	result["TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher285;
	result["TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher286;
	result["TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher287;
	result["TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256"] = (SSLCipherSuite*)&Cipher288;
	result["TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384"] = (SSLCipherSuite*)&Cipher289;
	result["TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher290;
	result["TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher291;
	result["TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher292;
	result["TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher293;
	result["TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher294;
	result["TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher295;
	result["TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256"] = (SSLCipherSuite*)&Cipher296;
	result["TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384"] = (SSLCipherSuite*)&Cipher297;
	result["TLS_RSA_WITH_AES_128_CCM"] = (SSLCipherSuite*)&Cipher298;
	result["TLS_RSA_WITH_AES_256_CCM"] = (SSLCipherSuite*)&Cipher299;
	result["TLS_DHE_RSA_WITH_AES_128_CCM"] = (SSLCipherSuite*)&Cipher300;
	result["TLS_DHE_RSA_WITH_AES_256_CCM"] = (SSLCipherSuite*)&Cipher301;
	result["TLS_RSA_WITH_AES_128_CCM_8"] = (SSLCipherSuite*)&Cipher302;
	result["TLS_RSA_WITH_AES_256_CCM_8"] = (SSLCipherSuite*)&Cipher303;
	result["TLS_DHE_RSA_WITH_AES_128_CCM_8"] = (SSLCipherSuite*)&Cipher304;
	result["TLS_DHE_RSA_WITH_AES_256_CCM_8"] = (SSLCipherSuite*)&Cipher305;
	result["TLS_PSK_WITH_AES_128_CCM"] = (SSLCipherSuite*)&Cipher306;
	result["TLS_PSK_WITH_AES_256_CCM"] = (SSLCipherSuite*)&Cipher307;
	result["TLS_DHE_PSK_WITH_AES_128_CCM"] = (SSLCipherSuite*)&Cipher308;
	result["TLS_DHE_PSK_WITH_AES_256_CCM"] = (SSLCipherSuite*)&Cipher309;
	result["TLS_PSK_WITH_AES_128_CCM_8"] = (SSLCipherSuite*)&Cipher310;
	result["TLS_PSK_WITH_AES_256_CCM_8"] = (SSLCipherSuite*)&Cipher311;
	result["TLS_PSK_DHE_WITH_AES_128_CCM_8"] = (SSLCipherSuite*)&Cipher312;
	result["TLS_PSK_DHE_WITH_AES_256_CCM_8"] = (SSLCipherSuite*)&Cipher313;
	result["TLS_ECDHE_ECDSA_WITH_AES_128_CCM"] = (SSLCipherSuite*)&Cipher314;
	result["TLS_ECDHE_ECDSA_WITH_AES_256_CCM"] = (SSLCipherSuite*)&Cipher315;
	result["TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8"] = (SSLCipherSuite*)&Cipher316;
	result["TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8"] = (SSLCipherSuite*)&Cipher317;
	result["TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256"] = (SSLCipherSuite*)&Cipher318;
	result["TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256"] = (SSLCipherSuite*)&Cipher319;
	result["TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256"] = (SSLCipherSuite*)&Cipher320;
	result["TLS_PSK_WITH_CHACHA20_POLY1305_SHA256"] = (SSLCipherSuite*)&Cipher321;
	result["TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256"] = (SSLCipherSuite*)&Cipher322;
	result["TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256"] = (SSLCipherSuite*)&Cipher323;
	result["TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256"] = (SSLCipherSuite*)&Cipher324;

	return result;
}

static const std::map<uint16_t, SSLCipherSuite*> CipherSuiteIdToObjectMap = createCipherSuiteIdToObjectMap();

static const std::map<std::string, SSLCipherSuite*> CipherSuiteStringToObjectMap = createCipherSuiteStringToObjectMap();

SSLCipherSuite* SSLCipherSuite::getCipherSuiteByID(uint16_t id)
{
	std::map<uint16_t, SSLCipherSuite*>::const_iterator pos = CipherSuiteIdToObjectMap.find(id);
	if (pos == CipherSuiteIdToObjectMap.end())
	    return NULL;
	else
	    return pos->second;
}

SSLCipherSuite* SSLCipherSuite::getCipherSuiteByName(std::string name)
{
	std::map<std::string, SSLCipherSuite*>::const_iterator pos = CipherSuiteStringToObjectMap.find(name);
	if (pos == CipherSuiteStringToObjectMap.end())
	    return NULL;
	else
	    return pos->second;
}

// --------------------
// SSLExtension methods
// --------------------

SSLExtension::SSLExtension(uint8_t* data)
{
	m_RawData = data;
}

SSLExtensionType SSLExtension::getType()
{
	uint16_t typeAsInt = getTypeAsInt();
	if (typeAsInt <= 24 || typeAsInt == 35 || typeAsInt == 65281)
		return (SSLExtensionType)typeAsInt;

	return SSL_EXT_Unknown;
}

uint16_t SSLExtension::getTypeAsInt()
{
	return ntohs(getExtensionStruct()->extensionType);
}

uint16_t SSLExtension::getLength()
{
	return ntohs(getExtensionStruct()->extensionDataLength);
}

uint16_t SSLExtension::getTotalLength()
{
	return getLength() + 2*sizeof(uint16_t);
}

uint8_t* SSLExtension::getData()
{
	return getExtensionStruct()->extensionData;
}


// ----------------------------------------
// SSLServerNameIndicationExtension methods
// ----------------------------------------

std::string SSLServerNameIndicationExtension::getHostName()
{
	uint8_t* hostNameLengthPos = getData() + sizeof(uint16_t) + sizeof(uint8_t);
	uint16_t hostNameLength = ntohs(*(uint16_t*)hostNameLengthPos);

	char* hostNameAsCharArr = new char[hostNameLength+1];
	memset(hostNameAsCharArr, 0, hostNameLength+1);
	memcpy(hostNameAsCharArr, hostNameLengthPos + sizeof(uint16_t), hostNameLength);

	std::string res = std::string(hostNameAsCharArr);
	delete[] hostNameAsCharArr;
	return res;
}


// ---------------------------
// SSLHandshakeMessage methods
// ---------------------------

SSLHandshakeMessage::SSLHandshakeMessage(uint8_t* data, size_t dataLen, SSLHandshakeLayer* container)
{
	m_Data = data;
	m_DataLen = dataLen;
	m_Container = container;
}

SSLHandshakeMessage* SSLHandshakeMessage::createHandhakeMessage(uint8_t* data, size_t dataLen, SSLHandshakeLayer* container)
{
	if (dataLen < sizeof(ssl_tls_handshake_layer))
		return NULL;

	ssl_tls_handshake_layer* hsMsgHeader = (ssl_tls_handshake_layer*)data;
	switch (hsMsgHeader->handshakeType)
	{
	case SSL_CLIENT_HELLO:
		return new SSLClientHelloMessage(data, dataLen, container);
	case SSL_SERVER_HELLO:
		return new SSLServerHelloMessage(data, dataLen, container);
	case SSL_HELLO_REQUEST:
		return new SSLHelloRequestMessage(data, dataLen, container);
	case SSL_CERTIFICATE:
		return new SSLCertificateMessage(data, dataLen, container);
	case SSL_SERVER_KEY_EXCHANGE:
		return new SSLServerKeyExchangeMessage(data, dataLen, container);
	case SSL_CERTIFICATE_REQUEST:
		return new SSLCertificateRequestMessage(data, dataLen, container);
	case SSL_CERTIFICATE_VERIFY:
		return new SSLCertificateVerifyMessage(data, dataLen, container);
	case SSL_CLIENT_KEY_EXCHANGE:
		return new SSLClientKeyExchangeMessage(data, dataLen, container);
	case SSL_FINISHED:
		return new SSLFinishedMessage(data, dataLen, container);
	case SSL_SERVER_DONE:
		return new SSLServerHelloDoneMessage(data, dataLen, container);
	case SSL_NEW_SESSION_TICKET:
		return new SSLNewSessionTicketMessage(data, dataLen, container);
	default:
		return new SSLUnknownMessage(data, dataLen, container);
	}
}

SSLHandshakeType SSLHandshakeMessage::getHandshakeType()
{
	ssl_tls_handshake_layer* handshakeLayer = (ssl_tls_handshake_layer*)m_Data;
	return (SSLHandshakeType)handshakeLayer->handshakeType;
}

size_t SSLHandshakeMessage::getMessageLength()
{
	ssl_tls_handshake_layer* handshakeLayer = (ssl_tls_handshake_layer*)m_Data;
	//TODO: add handshakeLayer->length1 to the calculation
	size_t len = sizeof(ssl_tls_handshake_layer) + ntohs(handshakeLayer->length2);
	if (len > m_DataLen)
		return m_DataLen;

	return len;
}

bool SSLHandshakeMessage::isMessageComplete()
{
	if (m_DataLen < sizeof(ssl_tls_handshake_layer))
		return false;

	ssl_tls_handshake_layer* handshakeLayer = (ssl_tls_handshake_layer*)m_Data;
	size_t len = sizeof(ssl_tls_handshake_layer) + ntohs(handshakeLayer->length2);
	return len <= m_DataLen;
}


// -----------------------------
// SSLClientHelloMessage methods
// -----------------------------

SSLClientHelloMessage::SSLClientHelloMessage(uint8_t* data, size_t dataLen, SSLHandshakeLayer* container)
	: SSLHandshakeMessage(data, dataLen, container)
{
	size_t extensionLengthOffset = sizeof(ssl_tls_client_server_hello) + sizeof(uint8_t) + getSessionIDLength() + sizeof(uint16_t) + sizeof(uint16_t)*getCipherSuiteCount() + 2*sizeof(uint8_t);
	if (extensionLengthOffset + sizeof(uint16_t) > m_DataLen)
		return;

	uint8_t* extensionLengthPos = m_Data + extensionLengthOffset;
	uint16_t extensionLength = getExtensionsLenth();
	uint8_t* extensionPos = extensionLengthPos + sizeof(uint16_t);
	uint8_t* curPos = extensionPos;
	size_t messageLen = getMessageLength();
	while ((curPos - extensionPos) < (int)extensionLength && (curPos - m_Data) < (int)messageLen)
	{
		SSLExtension* newExt = NULL;
		uint16_t sslExtType = ntohs(*(uint16_t*)curPos);
		if (sslExtType == SSL_EXT_SERVER_NAME)
		{
			newExt = new SSLServerNameIndicationExtension(curPos);
		}
		else
		{
			newExt = new SSLExtension(curPos);
		}

		m_ExtensionList.pushBack(newExt);
		curPos += newExt->getTotalLength();
	}
}

SSLVersion SSLClientHelloMessage::getHandshakeVersion()
{
	uint16_t handshakeVersion = ntohs(getClientHelloHeader()->handshakeVersion);
	return (SSLVersion)handshakeVersion;
}

uint8_t SSLClientHelloMessage::getSessionIDLength()
{
	uint8_t val = *(m_Data + sizeof(ssl_tls_client_server_hello));
	if ((size_t)val > m_DataLen - sizeof(ssl_tls_client_server_hello) - 1)
		return (uint8_t)(m_DataLen - sizeof(ssl_tls_client_server_hello) - 1);

	return val;
}

uint8_t* SSLClientHelloMessage::getSessionID()
{
	if (getSessionIDLength() > 0)
		return (m_Data + sizeof(ssl_tls_client_server_hello) + 1);
	else
		return NULL;
}

int SSLClientHelloMessage::getCipherSuiteCount()
{
	size_t cipherSuiteOffset = sizeof(ssl_tls_client_server_hello) + sizeof(uint8_t) + getSessionIDLength();
	if (cipherSuiteOffset + sizeof(uint16_t) > m_DataLen)
		return 0;

	uint16_t cipherSuiteLen = *(uint16_t*)(m_Data + cipherSuiteOffset);
	return ntohs(cipherSuiteLen) / 2;
}

SSLCipherSuite* SSLClientHelloMessage::getCipherSuite(int index)
{
	if (index < 0 || index >= getCipherSuiteCount())
		return NULL;

	size_t cipherSuiteStartOffset = sizeof(ssl_tls_client_server_hello) + sizeof(uint8_t) + getSessionIDLength() + sizeof(uint16_t);
	if (cipherSuiteStartOffset + sizeof(uint16_t) > m_DataLen)
		return NULL;

	uint16_t* cipherSuiteStartPos = (uint16_t*)(m_Data + cipherSuiteStartOffset);
	return SSLCipherSuite::getCipherSuiteByID(ntohs(*(cipherSuiteStartPos+index)));
}

uint8_t SSLClientHelloMessage::getCompressionMethodsValue()
{
	size_t offset = sizeof(ssl_tls_client_server_hello) + sizeof(uint8_t) + getSessionIDLength() + sizeof(uint16_t) + sizeof(uint16_t)*getCipherSuiteCount() + sizeof(uint8_t);
	if (offset + sizeof(uint8_t) > m_DataLen)
		return 0xff;

	uint8_t* pos = m_Data + offset;
	return *pos;
}

int SSLClientHelloMessage::getExtensionCount()
{
	return m_ExtensionList.size();
}

uint16_t SSLClientHelloMessage::getExtensionsLenth()
{
	size_t extensionLengthOffset = sizeof(ssl_tls_client_server_hello) + sizeof(uint8_t) + getSessionIDLength() + sizeof(uint16_t) + sizeof(uint16_t)*getCipherSuiteCount() + 2*sizeof(uint8_t);
	if (extensionLengthOffset + sizeof(uint16_t) > m_DataLen)
		return 0;

	uint8_t* extensionLengthPos = m_Data + extensionLengthOffset;
	return ntohs(*(uint16_t*)extensionLengthPos);
}

SSLExtension* SSLClientHelloMessage::getExtension(int index)
{
	return m_ExtensionList.at(index);
}

SSLExtension* SSLClientHelloMessage::getExtensionOfType(uint16_t type)
{
	size_t vecSize = m_ExtensionList.size();
	for (size_t i = 0; i < vecSize; i++)
	{
		SSLExtension* curElem = m_ExtensionList.at(i);
		if (curElem->getTypeAsInt() == type)
			return curElem;
	}

	return NULL;
}

SSLExtension* SSLClientHelloMessage::getExtensionOfType(SSLExtensionType type)
{
	size_t vecSize = m_ExtensionList.size();
	for (size_t i = 0; i < vecSize; i++)
	{
		SSLExtension* curElem = m_ExtensionList.at(i);
		if (curElem->getType() == type)
			return curElem;
	}

	return NULL;
}

std::string SSLClientHelloMessage::toString()
{
	return "Client Hello message";
}


// -----------------------------
// SSLServerHelloMessage methods
// -----------------------------

SSLServerHelloMessage::SSLServerHelloMessage(uint8_t* data, size_t dataLen, SSLHandshakeLayer* container)
	: SSLHandshakeMessage(data, dataLen, container)
{
	size_t extensionLengthOffset = sizeof(ssl_tls_client_server_hello) + sizeof(uint8_t) + getSessionIDLength() + sizeof(uint16_t) + sizeof(uint8_t);
	if (extensionLengthOffset + sizeof(uint16_t) > m_DataLen)
		return;

	uint8_t* extensionLengthPos = m_Data + extensionLengthOffset;
	uint16_t extensionLength = getExtensionsLenth();
	uint8_t* extensionPos = extensionLengthPos + sizeof(uint16_t);
	uint8_t* curPos = extensionPos;
	size_t messageLen = getMessageLength();
	while ((curPos - extensionPos) < (int)extensionLength && (curPos - m_Data) < (int)messageLen)
	{
		SSLExtension* newExt = NULL;
		uint16_t sslExtType = ntohs(*(uint16_t*)curPos);
		if (sslExtType == SSL_EXT_SERVER_NAME)
		{
			newExt = new SSLServerNameIndicationExtension(curPos);
		}
		else
		{
			newExt = new SSLExtension(curPos);
		}

		m_ExtensionList.pushBack(newExt);
		curPos += newExt->getTotalLength();
	}
}

SSLVersion SSLServerHelloMessage::getHandshakeVersion()
{
	uint16_t handshakeVersion = ntohs(getServerHelloHeader()->handshakeVersion);
	return (SSLVersion)handshakeVersion;

}
uint8_t SSLServerHelloMessage::getSessionIDLength()
{
	uint8_t val = *(m_Data + sizeof(ssl_tls_client_server_hello));
	if ((size_t)val > m_DataLen - sizeof(ssl_tls_client_server_hello) - 1)
		return (uint8_t)(m_DataLen - sizeof(ssl_tls_client_server_hello) - 1);

	return val;
}

uint8_t* SSLServerHelloMessage::getSessionID()
{
	if (getSessionIDLength() > 0)
		return (m_Data + sizeof(ssl_tls_client_server_hello) + 1);
	else
		return NULL;
}

SSLCipherSuite* SSLServerHelloMessage::getCipherSuite()
{
	size_t cipherSuiteStartOffset = sizeof(ssl_tls_client_server_hello) + sizeof(uint8_t) + getSessionIDLength();
	if (cipherSuiteStartOffset + sizeof(uint16_t) > m_DataLen)
		return NULL;

	uint16_t* cipherSuiteStartPos = (uint16_t*)(m_Data + cipherSuiteStartOffset);
	return SSLCipherSuite::getCipherSuiteByID(ntohs(*(cipherSuiteStartPos)));
}

uint8_t SSLServerHelloMessage::getCompressionMethodsValue()
{
	size_t offset = sizeof(ssl_tls_client_server_hello) + sizeof(uint8_t) + getSessionIDLength() + sizeof(uint16_t);
	if (offset + sizeof(uint8_t) > m_DataLen)
		return 0xff;

	uint8_t* pos = m_Data + offset;
	return *pos;
}

int SSLServerHelloMessage::getExtensionCount()
{
	return m_ExtensionList.size();
}

uint16_t SSLServerHelloMessage::getExtensionsLenth()
{
	size_t extensionLengthOffset  = sizeof(ssl_tls_client_server_hello) + sizeof(uint8_t) + getSessionIDLength() + sizeof(uint16_t) + sizeof(uint8_t);
	if (extensionLengthOffset + sizeof(uint16_t) > m_DataLen)
		return 0;

	uint16_t* extensionLengthPos = (uint16_t*)(m_Data + extensionLengthOffset);
	return ntohs(*extensionLengthPos);
}

SSLExtension* SSLServerHelloMessage::getExtension(int index)
{
	if (index < 0 || index >= (int)m_ExtensionList.size())
		return NULL;

	return m_ExtensionList.at(index);
}

SSLExtension* SSLServerHelloMessage::getExtensionOfType(uint16_t type)
{
	size_t vecSize = m_ExtensionList.size();
	for (size_t i = 0; i < vecSize; i++)
	{
		SSLExtension* curElem = m_ExtensionList.at(i);
		if (curElem->getType() == type)
			return curElem;
	}

	return NULL;
}

SSLExtension* SSLServerHelloMessage::getExtensionOfType(SSLExtensionType type)
{
	size_t vecSize = m_ExtensionList.size();
	for (size_t i = 0; i < vecSize; i++)
	{
		SSLExtension* curElem = m_ExtensionList.at(i);
		if (curElem->getType() == type)
			return curElem;
	}

	return NULL;
}

std::string SSLServerHelloMessage::toString()
{
	return "Server Hello message";
}


// -----------------------------
// SSLCertificateMessage methods
// -----------------------------

SSLCertificateMessage::SSLCertificateMessage(uint8_t* data, size_t dataLen, SSLHandshakeLayer* container)
	: SSLHandshakeMessage(data, dataLen, container)
{
	if (dataLen < sizeof(ssl_tls_handshake_layer) +
			sizeof(uint8_t)*3) // certificates length (3B)
		return;

	size_t messageLen = getMessageLength();
	// read certificates length
	// TODO: certificates length is 3B. Currently assuming the MSB is 0 and reading only 2 LSBs
	uint8_t* curPos = data + sizeof(ssl_tls_handshake_layer) + sizeof(uint8_t);
	uint16_t certificatesLength = ntohs(*(uint16_t*)(curPos));
	if (certificatesLength == 0)
		return;

	// advance to position of first certificate
	curPos += sizeof(uint16_t);

	while (true)
	{
		// try to read certificate length (3B)
		// TODO: certificate length is 3B. Currently assuming the MSB is 0 and reading only 2 LSBs
		if (curPos + 3*sizeof(uint8_t) - data > (int)messageLen)
			break;

		// read certificate length
		curPos += sizeof(uint8_t);
		uint16_t certificateLength = ntohs(*(uint16_t*)(curPos));

		// advance to start position of certificate
		curPos += sizeof(uint16_t);

		// if packet doesn't contain the full certificate, read only what you got from current position till the
		// end of the packet
		bool certificateFull = true;
		if (curPos - data + certificateLength > (int)messageLen)
		{
			certificateLength = messageLen - (curPos - data);
			certificateFull = false;
		}

		LOG_DEBUG("Parsing certificate: pos=%d; len=%d\n", (int)(curPos-data), (int)certificateLength);
		SSLx509Certificate* newCert = new SSLx509Certificate(curPos, certificateLength, certificateFull);
		m_CertificateList.pushBack(newCert);

		curPos += certificateLength;
	}
}

std::string SSLCertificateMessage::toString()
{
	return "Certificate message";
}

int SSLCertificateMessage::getNumOfCertificates()
{
	return m_CertificateList.size();
}

SSLx509Certificate* SSLCertificateMessage::getCertificate(int index)
{
	if (index < 0 || index > (int)m_CertificateList.size())
	{
		LOG_DEBUG("certificate index out of range: asked for index %d, total size is %d", index, (int)m_CertificateList.size());
		return NULL;
	}

	return m_CertificateList.at(index);
}



// ------------------------------
// SSLHelloRequestMessage methods
// ------------------------------

std::string SSLHelloRequestMessage::toString()
{
	return "Hello Request message";
}


// ---------------------------------
// SSLServerHelloDoneMessage methods
// ---------------------------------

std::string SSLServerHelloDoneMessage::toString()
{
	return "Server Hello Done message";
}

// -----------------------------------
// SSLServerKeyExchangeMessage methods
// -----------------------------------

uint8_t* SSLServerKeyExchangeMessage::getServerKeyExchangeParams()
{
	if (getMessageLength() > sizeof(ssl_tls_handshake_layer))
		return (m_Data + sizeof(ssl_tls_handshake_layer));

	return NULL;
}

size_t SSLServerKeyExchangeMessage::getServerKeyExchangeParamsLength()
{
	size_t msgLength = getMessageLength();
	if (msgLength <= sizeof(ssl_tls_handshake_layer))
		return 0;

	return msgLength - sizeof(ssl_tls_handshake_layer);
}

std::string SSLServerKeyExchangeMessage::toString()
{
	return "Server Key Exchange message";
}

// -----------------------------------
// SSLClientKeyExchangeMessage methods
// -----------------------------------

uint8_t* SSLClientKeyExchangeMessage::getClientKeyExchangeParams()
{
	if (getMessageLength() > sizeof(ssl_tls_handshake_layer))
		return (m_Data + sizeof(ssl_tls_handshake_layer));

	return NULL;
}

size_t SSLClientKeyExchangeMessage::getClientKeyExchangeParamsLength()
{
	size_t msgLength = getMessageLength();
	if (msgLength <= sizeof(ssl_tls_handshake_layer))
		return 0;

	return msgLength - sizeof(ssl_tls_handshake_layer);
}

std::string SSLClientKeyExchangeMessage::toString()
{
	return "Client Key Exchange message";
}


// ------------------------------------
// SSLCertificateRequestMessage methods
// ------------------------------------

SSLCertificateRequestMessage::SSLCertificateRequestMessage(uint8_t* data, size_t dataLen, SSLHandshakeLayer* container)
		: SSLHandshakeMessage(data, dataLen, container)
{
	if (dataLen < sizeof(ssl_tls_handshake_layer) +
			sizeof(uint8_t)) // certificate types count (1B)
		return;

	size_t messageLen = getMessageLength();

	uint8_t certificateTypesCount = *(uint8_t*)(data + sizeof(ssl_tls_handshake_layer));

	if (certificateTypesCount > messageLen)
		certificateTypesCount = messageLen;

	uint8_t* pos = data + sizeof(ssl_tls_handshake_layer) + sizeof(uint8_t);
	for (uint8_t i = 0; i < certificateTypesCount; i++)
	{
		uint8_t certType = *(uint8_t*)(pos + i);
		if (certType == 0 ||
				(certType > 6 && certType < 20) ||
				(certType > 20 && certType < 64) ||
				certType > 64)
			m_ClientCertificateTypes.push_back(SSL_CCT_UNKNOWN);
		else
			m_ClientCertificateTypes.push_back((SSLClientCertificateType)certType);
	}

}

std::vector<SSLClientCertificateType>& SSLCertificateRequestMessage::getCertificateTypes()
{
	return m_ClientCertificateTypes;
}

uint8_t* SSLCertificateRequestMessage::getCertificateAuthorityData()
{
	size_t messageLen = getMessageLength();
	size_t offset = sizeof(ssl_tls_handshake_layer) + sizeof(uint8_t) + m_ClientCertificateTypes.size() + sizeof(uint16_t);
	if (offset >= messageLen)
		return NULL;

	return m_Data + offset;
}

size_t SSLCertificateRequestMessage::getCertificateAuthorityLength()
{
	size_t messageLen = getMessageLength();
	size_t offset = sizeof(ssl_tls_handshake_layer) + sizeof(uint8_t) + m_ClientCertificateTypes.size();
	if (offset + sizeof(uint16_t) >= messageLen)
		return 0;

	uint16_t certAuthLen = ntohs(*(uint16_t*)(m_Data + offset));

	offset += sizeof(uint16_t);

	if (messageLen - offset < certAuthLen)
		return messageLen - offset;

	return certAuthLen;
}

std::string SSLCertificateRequestMessage::toString()
{
	return "Certificate Request message";
}


// -----------------------------------
// SSLCertificateVerifyMessage methods
// -----------------------------------

uint8_t* SSLCertificateVerifyMessage::getSignedHash()
{
	if (getMessageLength() > sizeof(ssl_tls_handshake_layer))
		return (m_Data + sizeof(ssl_tls_handshake_layer));

	return NULL;
}

size_t SSLCertificateVerifyMessage::getSignedHashLength()
{
	size_t msgLength = getMessageLength();
	if (msgLength <= sizeof(ssl_tls_handshake_layer))
		return 0;

	return msgLength - sizeof(ssl_tls_handshake_layer);
}

std::string SSLCertificateVerifyMessage::toString()
{
	return "Certificate Verify message";
}

// --------------------------
// SSLFinishedMessage methods
// --------------------------

uint8_t* SSLFinishedMessage::getSignedHash()
{
	if (getMessageLength() > sizeof(ssl_tls_handshake_layer))
		return (m_Data + sizeof(ssl_tls_handshake_layer));

	return NULL;
}

size_t SSLFinishedMessage::getSignedHashLength()
{
	size_t msgLength = getMessageLength();
	if (msgLength <= sizeof(ssl_tls_handshake_layer))
		return 0;

	return msgLength - sizeof(ssl_tls_handshake_layer);
}

std::string SSLFinishedMessage::toString()
{
	return "Finished message";
}


// ----------------------------------
// SSLNewSessionTicketMessage methods
// ----------------------------------

uint8_t* SSLNewSessionTicketMessage::getSessionTicketData()
{
	if (getMessageLength() > sizeof(ssl_tls_handshake_layer))
		return (m_Data + sizeof(ssl_tls_handshake_layer));

	return NULL;
}

size_t SSLNewSessionTicketMessage::getSessionTicketDataLength()
{
	size_t msgLength = getMessageLength();
	if (msgLength <= sizeof(ssl_tls_handshake_layer))
		return 0;

	return msgLength - sizeof(ssl_tls_handshake_layer);
}

std::string SSLNewSessionTicketMessage::toString()
{
	return "New Session Ticket message";
}


// -------------------------
// SSLUnknownMessage methods
// -------------------------

SSLHandshakeType SSLUnknownMessage::getHandshakeType()
{
	// if message type is unknown, it may be some encrypted message so message type isn't necessarily written
	// in clear in the first byte. So always return SSL_HANDSHAKE_UNKNOWN
	return SSL_HANDSHAKE_UNKNOWN;
}

size_t SSLUnknownMessage::getMessageLength()
{
	// if message type is unknown, it may be some encrypted message so message length isn't necessarily written
	// in clear. So in this case assume message is in length of all remaining data
	return m_DataLen;
}


std::string SSLUnknownMessage::toString()
{
	return "Unknown message";
}

} // namespace pcpp
