/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <string>
#include <vector>
#include "agent/agent_version.h"

namespace org {
namespace apache {
namespace nifi {
namespace minifi {

const char* const AgentBuild::VERSION = "0.10.0";
const char* const AgentBuild::BUILD_IDENTIFIER = "GRJHQRcRYsBO4Tqnc9M4js7z";
const char* const AgentBuild::BUILD_REV = "d1b78dc018bb59292b59d1e0b6f3fef382120bd2";
const char* const AgentBuild::BUILD_DATE = "1623080865";
const char* const AgentBuild::COMPILER = "/usr/bin/c++";
const char* const AgentBuild::COMPILER_VERSION = "8.4.0";
const char* const AgentBuild::COMPILER_FLAGS = " -DOPENSSL_SUPPORT -DSODIUM_STATIC=1 -Wall -Wextra";

std::vector<std::string> AgentBuild::getExtensions() {
  static std::vector<std::string> extensions;
  if (extensions.empty()) {
    extensions.push_back("minifi-standard-processors");
    extensions.push_back("minifi-http-curl");
    extensions.push_back("minifi-expression-language-extensions");
    extensions.push_back("minifi-civet-extensions");
    extensions.push_back("minifi-rocksdb-repos");
    extensions.push_back("minifi-archive-extensions");
    extensions.push_back("minifi-coap");
    extensions.push_back("minifi-script-extensions");
    extensions.push_back("minifi-systemd");
    extensions.push_back("minifi-system");
  }
  return extensions;
}

}  // namespace minifi
}  // namespace nifi
}  // namespace apache
}  // namespace org

