/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.internal;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;

public class ByteChannelContentSource
implements Content.Source {
    private final AutoLock lock = new AutoLock();
    private final SerializedInvoker _invoker = new SerializedInvoker(ByteChannelContentSource.class);
    private final ByteBufferPool.Sized _byteBufferPool;
    private ByteChannel _byteChannel;
    private final long _offset;
    private final long _length;
    private RetainableByteBuffer _buffer;
    private long _offsetRemaining;
    private long _totalRead;
    private Runnable demandCallback;
    private Content.Chunk _terminal;

    public ByteChannelContentSource(ByteBufferPool.Sized byteBufferPool, ByteChannel byteChannel) {
        this(byteBufferPool, byteChannel, 0L, -1L);
    }

    public ByteChannelContentSource(ByteBufferPool.Sized byteBufferPool, ByteChannel byteChannel, long offset, long length) {
        this._byteBufferPool = Objects.requireNonNullElse(byteBufferPool, ByteBufferPool.SIZED_NON_POOLING);
        this._byteChannel = byteChannel;
        this._offset = offset;
        this._length = TypeUtil.checkOffsetLengthSize((long)offset, (long)length, (long)-1L);
        this._offsetRemaining = offset;
    }

    protected ByteChannel open() throws IOException {
        return this._byteChannel;
    }

    @Override
    public void demand(Runnable demandCallback) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.demandCallback != null) {
                throw new IllegalStateException("demand pending");
            }
            this.demandCallback = demandCallback;
        }
        this._invoker.run(this::invokeDemandCallback);
    }

    private void invokeDemandCallback() {
        Runnable demandCallback;
        try (AutoLock ignored = this.lock.lock();){
            demandCallback = this.demandCallback;
            this.demandCallback = null;
        }
        if (demandCallback != null) {
            ExceptionUtil.run((Runnable)demandCallback, this::fail);
        }
    }

    protected void lockedSetTerminal(Content.Chunk terminal) {
        assert (this.lock.isHeldByCurrentThread());
        if (this._terminal == null) {
            this._terminal = Objects.requireNonNull(terminal);
        } else {
            ExceptionUtil.addSuppressedIfNotAssociated((Throwable)this._terminal.getFailure(), (Throwable)terminal.getFailure());
        }
        IO.close((Closeable)this._byteChannel);
        if (this._buffer != null) {
            this._buffer.release();
        }
        this._buffer = null;
    }

    private void lockedEnsureOpenOrTerminal() {
        assert (this.lock.isHeldByCurrentThread());
        if (!(this._terminal != null || this._byteChannel != null && this._byteChannel.isOpen())) {
            try {
                this._byteChannel = this.open();
                if (this._byteChannel == null || !this._byteChannel.isOpen()) {
                    this.lockedSetTerminal(Content.Chunk.from(new ClosedChannelException(), true));
                } else {
                    ByteChannel byteChannel = this._byteChannel;
                    if (byteChannel instanceof SeekableByteChannel) {
                        SeekableByteChannel seekableByteChannel = (SeekableByteChannel)byteChannel;
                        seekableByteChannel.position(this._offset);
                        this._offsetRemaining = 0L;
                    }
                }
            }
            catch (IOException e) {
                this.lockedSetTerminal(Content.Chunk.from(e, true));
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Content.Chunk read() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 3[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void fail(Throwable failure) {
        try (AutoLock ignored = this.lock.lock();){
            this.lockedSetTerminal(Content.Chunk.from(failure, true));
        }
    }

    @Override
    public long getLength() {
        return this._length;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean rewind() {
        boolean bl;
        block15: {
            AutoLock ignored;
            block13: {
                boolean bl2;
                block14: {
                    block11: {
                        boolean bl3;
                        block12: {
                            ignored = this.lock.lock();
                            if (this._byteChannel instanceof SeekableByteChannel) break block11;
                            bl3 = false;
                            if (ignored == null) break block12;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            ignored.close();
                        }
                        return bl3;
                    }
                    if (this._terminal != null && !Content.Chunk.isFailure(this._terminal) && (this._byteChannel == null || this._byteChannel instanceof SeekableByteChannel)) {
                        this._terminal = null;
                    }
                    this.lockedEnsureOpenOrTerminal();
                    if (this._terminal == null && this._byteChannel != null && this._byteChannel.isOpen()) break block13;
                    bl2 = false;
                    if (ignored == null) break block14;
                    ignored.close();
                }
                return bl2;
            }
            try {
                ((SeekableByteChannel)this._byteChannel).position(this._offset);
                this._offsetRemaining = 0L;
                this._totalRead = 0L;
                bl = true;
                if (ignored == null) break block15;
            }
            catch (Throwable t) {
                try {
                    this.lockedSetTerminal(Content.Chunk.from(t, true));
                    boolean bl4 = true;
                    return bl4;
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            ignored.close();
        }
        return bl;
    }

    public static class PathContentSource
    extends ByteChannelContentSource {
        private final Path _path;

        public PathContentSource(Path path) {
            this(null, path, 0L, -1L);
        }

        public PathContentSource(ByteBufferPool.Sized byteBufferPool, Path path) {
            this(byteBufferPool, path, 0L, -1L);
        }

        public PathContentSource(ByteBufferPool.Sized byteBufferPool, Path path, long offset, long length) {
            super(byteBufferPool, null, offset, TypeUtil.checkOffsetLengthSize((long)offset, (long)length, (long)PathContentSource.size(path)));
            this._path = path;
        }

        public Path getPath() {
            return this._path;
        }

        @Override
        protected ByteChannel open() throws IOException {
            return Files.newByteChannel(this._path, StandardOpenOption.READ);
        }

        private static long size(Path path) {
            try {
                return Files.size(path);
            }
            catch (IOException e) {
                return -1L;
            }
        }
    }
}

