/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.policies;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.AccessPolicyAction;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.PoliciesClient;
import org.apache.nifi.toolkit.client.TenantsClient;
import org.apache.nifi.web.api.dto.AccessPolicyDTO;
import org.apache.nifi.web.api.entity.AccessPolicyEntity;
import org.apache.nifi.web.api.entity.TenantEntity;

public class UpdateAccessPolicy
extends AbstractNiFiCommand<VoidResult> {
    public UpdateAccessPolicy() {
        super("update-policy", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Updates the access policy for the given resource and action, or creates the policy if it doesn't not exist. In stand-alone mode this command will not produce all of the output seen in interactive mode unless the --verbose argument is specified.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.POLICY_RESOURCE.createOption());
        this.addOption(CommandOption.POLICY_ACTION.createOption());
        this.addOption(CommandOption.USER_NAME_LIST.createOption());
        this.addOption(CommandOption.USER_ID_LIST.createOption());
        this.addOption(CommandOption.GROUP_NAME_LIST.createOption());
        this.addOption(CommandOption.GROUP_ID_LIST.createOption());
        this.addOption(CommandOption.OVERWRITE_POLICY.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        AccessPolicyEntity policyEntity;
        PoliciesClient policiesClient = client.getPoliciesClient();
        TenantsClient tenantsClient = client.getTenantsClient();
        String resource = "/" + StringUtils.removeStart((String)this.getRequiredArg(properties, CommandOption.POLICY_RESOURCE), (String)"/");
        AccessPolicyAction actionType = AccessPolicyAction.valueOf(this.getRequiredArg(properties, CommandOption.POLICY_ACTION).toUpperCase().trim());
        String users = this.getArg(properties, CommandOption.USER_NAME_LIST);
        String userIds = this.getArg(properties, CommandOption.USER_ID_LIST);
        String groups = this.getArg(properties, CommandOption.GROUP_NAME_LIST);
        String groupIds = this.getArg(properties, CommandOption.GROUP_ID_LIST);
        LinkedHashSet<TenantEntity> userEntities = new LinkedHashSet<TenantEntity>();
        if (StringUtils.isNotBlank((CharSequence)users)) {
            userEntities.addAll(UpdateAccessPolicy.generateTenantEntities(users, tenantsClient.getUsers()));
        }
        if (StringUtils.isNotBlank((CharSequence)userIds)) {
            userEntities.addAll(UpdateAccessPolicy.generateTenantEntities(userIds));
        }
        LinkedHashSet<TenantEntity> groupEntites = new LinkedHashSet<TenantEntity>();
        if (StringUtils.isNotBlank((CharSequence)groups)) {
            groupEntites.addAll(UpdateAccessPolicy.generateTenantEntities(groups, tenantsClient.getUserGroups()));
        }
        if (StringUtils.isNotBlank((CharSequence)groupIds)) {
            groupEntites.addAll(UpdateAccessPolicy.generateTenantEntities(groupIds));
        }
        if (userEntities.isEmpty() && groupEntites.isEmpty()) {
            throw new CommandException("Users and groups were blank, nothing to update");
        }
        boolean overwrite = properties.containsKey(CommandOption.OVERWRITE_POLICY.getLongName());
        try {
            policyEntity = policiesClient.getAccessPolicy(resource, actionType.toString().toLowerCase());
        }
        catch (NiFiClientException e) {
            policyEntity = null;
        }
        if (policyEntity == null) {
            if (this.shouldPrint(properties)) {
                this.println("Access policy not found for action " + actionType.toString().toLowerCase() + " on resource /" + StringUtils.removeStart((String)resource, (String)"/"));
            }
            AccessPolicyDTO policyDTO = new AccessPolicyDTO();
            policyDTO.setResource(resource);
            policyDTO.setAction(actionType.toString().toLowerCase());
            policyDTO.setUsers(new LinkedHashSet());
            policyDTO.setUserGroups(new LinkedHashSet());
            policyEntity = new AccessPolicyEntity();
            policyEntity.setComponent(policyDTO);
            policyEntity.setRevision(this.getInitialRevisionDTO());
            this.setTenant(policyEntity, userEntities, groupEntites, overwrite, properties);
            AccessPolicyEntity createdEntity = policiesClient.createAccessPolicy(policyEntity);
            if (this.shouldPrint(properties)) {
                this.println("New access policy was created");
                this.println("id: " + createdEntity.getId());
            }
        } else if (!resource.equals(policyEntity.getComponent().getResource())) {
            if (this.shouldPrint(properties)) {
                this.println("Override the policy inherited from " + policyEntity.getComponent().getResource());
            }
            AccessPolicyDTO policyDTO = new AccessPolicyDTO();
            policyDTO.setResource(resource);
            policyDTO.setAction(actionType.toString().toLowerCase());
            policyDTO.setUsers(policyEntity.getComponent().getUsers());
            policyDTO.setUserGroups(policyEntity.getComponent().getUserGroups());
            policyEntity = new AccessPolicyEntity();
            policyEntity.setComponent(policyDTO);
            policyEntity.setRevision(this.getInitialRevisionDTO());
            this.setTenant(policyEntity, userEntities, groupEntites, overwrite, properties);
            AccessPolicyEntity createdEntity = policiesClient.createAccessPolicy(policyEntity);
            if (this.shouldPrint(properties)) {
                this.println("Override access policy was created");
                this.println("id: " + createdEntity.getId());
            }
        } else {
            String clientId = this.getContext().getSession().getNiFiClientID();
            policyEntity.getRevision().setClientId(clientId);
            this.setTenant(policyEntity, userEntities, groupEntites, overwrite, properties);
            policiesClient.updateAccessPolicy(policyEntity);
            if (this.shouldPrint(properties)) {
                this.println("Access policy was updated");
                this.println("id: " + policyEntity.getId());
            }
        }
        return VoidResult.getInstance();
    }

    private void setTenant(AccessPolicyEntity policyEntity, Set<TenantEntity> userEntities, Set<TenantEntity> groupEntities, boolean overwrite, Properties properties) {
        if (overwrite) {
            policyEntity.getComponent().setUsers(new LinkedHashSet());
            policyEntity.getComponent().setUserGroups(new LinkedHashSet());
        }
        Set userSet = policyEntity.getComponent().getUsers();
        userEntities.forEach(entity -> this.addTenant(userSet, (TenantEntity)entity, "User", properties));
        Set groupSet = policyEntity.getComponent().getUserGroups();
        groupEntities.forEach(entity -> this.addTenant(groupSet, (TenantEntity)entity, "User group", properties));
    }

    private void addTenant(Set<TenantEntity> tenantSet, TenantEntity additionalTenant, String tenantType, Properties properties) {
        String dispTenantName;
        String string = dispTenantName = additionalTenant.getComponent() != null && StringUtils.isNotBlank((CharSequence)additionalTenant.getComponent().getIdentity()) ? tenantType + " \"" + additionalTenant.getComponent().getIdentity() + "\"" : tenantType + " (id: " + additionalTenant.getId() + ")";
        if (tenantSet.contains(additionalTenant)) {
            if (this.shouldPrint(properties)) {
                this.println(dispTenantName + " already included");
            }
        } else {
            if (this.shouldPrint(properties)) {
                this.println(dispTenantName + " added");
            }
            tenantSet.add(additionalTenant);
        }
    }

    private boolean shouldPrint(Properties properties) {
        return this.isInteractive() || this.isVerbose(properties);
    }
}

