/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.api.ReferenceResolver;
import org.apache.nifi.toolkit.cli.api.Referenceable;
import org.apache.nifi.toolkit.cli.api.ResolvedReference;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;

public class ProcessGroupsResult
extends AbstractWritableResult<List<ProcessGroupDTO>>
implements Referenceable {
    private final List<ProcessGroupDTO> processGroups;

    public ProcessGroupsResult(ResultType resultType, List<ProcessGroupDTO> processGroups) {
        super(resultType);
        this.processGroups = Objects.requireNonNull(processGroups);
        this.processGroups.sort(Comparator.comparing(ProcessGroupDTO::getName));
    }

    @Override
    public List<ProcessGroupDTO> getResult() {
        return this.processGroups;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 20, 36, true).column("Id", 36, 36, false).column("Running", 7, 7, false).column("Stopped", 7, 7, false).column("Disabled", 8, 8, false).column("Invalid", 7, 7, false).build();
        for (int i = 0; i < this.processGroups.size(); ++i) {
            ProcessGroupDTO dto = this.processGroups.get(i);
            table.addRow(String.valueOf(i + 1), dto.getName(), dto.getId(), String.valueOf(dto.getRunningCount()), String.valueOf(dto.getStoppedCount()), String.valueOf(dto.getDisabledCount()), String.valueOf(dto.getInvalidCount()));
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public ReferenceResolver createReferenceResolver(Context context) {
        final HashMap backRefs = new HashMap();
        AtomicInteger position = new AtomicInteger(0);
        this.processGroups.forEach(p -> backRefs.put(position.incrementAndGet(), p));
        return new ReferenceResolver(){

            @Override
            public ResolvedReference resolve(CommandOption option, Integer position) {
                ProcessGroupDTO pg = (ProcessGroupDTO)backRefs.get(position);
                if (pg != null) {
                    return new ResolvedReference(option, position, pg.getName(), pg.getId());
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return backRefs.isEmpty();
            }
        };
    }
}

