/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ComponentRunStatusEntity;

public abstract class AbstractNiFiActivateCommand<C extends ComponentEntity, S extends ComponentRunStatusEntity>
extends AbstractNiFiCommand<VoidResult> {
    public AbstractNiFiActivateCommand(String name) {
        super(name, VoidResult.class);
    }

    protected void activate(NiFiClient client, Properties properties, Set<C> componentEntities, String state) throws IOException, CommandException {
        if (this.shouldPrint(properties)) {
            this.println();
        }
        ArrayList<NiFiClientException> exceptions = new ArrayList<NiFiClientException>();
        for (ComponentEntity componentEntity : componentEntities) {
            RevisionDTO revisionDTO = new RevisionDTO();
            revisionDTO.setVersion(componentEntity.getRevision().getVersion());
            revisionDTO.setClientId(this.getContext().getSession().getNiFiClientID());
            S runStatusEntity = this.getRunStatusEntity();
            runStatusEntity.setRevision(revisionDTO);
            runStatusEntity.setState(state);
            runStatusEntity.validateState();
            try {
                ComponentEntity activated = this.activateComponent(client, componentEntity, runStatusEntity);
                if (!this.shouldPrint(properties)) continue;
                this.println(this.getDispName(activated) + " has been " + state.toLowerCase());
                this.println();
            }
            catch (NiFiClientException e) {
                exceptions.add(e);
                if (!this.shouldPrint(properties)) continue;
                this.println(this.getDispName(componentEntity) + " could not be " + state.toLowerCase());
                this.println();
                e.printStackTrace();
            }
        }
        if (exceptions.size() > 0) {
            throw new CommandException(exceptions.size() + " components could not be " + state.toLowerCase() + ", run command with -verbose to obtain more details");
        }
    }

    private boolean shouldPrint(Properties properties) {
        return this.isInteractive() || this.isVerbose(properties);
    }

    public abstract S getRunStatusEntity();

    public abstract C activateComponent(NiFiClient var1, C var2, S var3) throws NiFiClientException, IOException;

    public abstract String getDispName(C var1);
}

