/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.postgresql;

import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.authentication.postgres.PgpassFileReader;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.FlywayTeamsUpgradeMessage;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.UrlUtils;
import org.flywaydb.database.postgresql.PostgreSQLDatabase;
import org.flywaydb.database.postgresql.PostgreSQLParser;

public class PostgreSQLDatabaseType
extends BaseDatabaseType {
    private static final Log LOG = LogFactory.getLog(PostgreSQLDatabaseType.class);

    public String getName() {
        return "PostgreSQL";
    }

    public List<String> getSupportedEngines() {
        return List.of(this.getName(), "AuroraPostgreSql", "YugabyteDb", "TimescaleDb");
    }

    public int getNullType() {
        return 0;
    }

    public boolean handlesJDBCUrl(String url) {
        return UrlUtils.isSecretManagerUrl((String)url, (String)"postgresql") || url.startsWith("jdbc:postgresql:") || url.startsWith("jdbc:p6spy:postgresql:") || UrlUtils.isAwsWrapperUrl((String)url, (String)"postgresql");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:postgresql:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        if (UrlUtils.isAwsWrapperUrl((String)url, (String)"postgresql")) {
            return "software.amazon.jdbc.Driver";
        }
        return "org.postgresql.Driver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("PostgreSQL");
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new PostgreSQLDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new PostgreSQLParser(configuration, parsingContext);
    }

    public void setDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
        props.put("applicationName", "Flyway by Redgate");
    }

    public Properties getExternalAuthProperties(String url, String username) {
        PgpassFileReader pgpassFileReader = new PgpassFileReader();
        if (pgpassFileReader.getPgpassFilePath() != null) {
            LOG.info(FlywayTeamsUpgradeMessage.generate((String)("pgpass file '" + pgpassFileReader.getPgpassFilePath() + "'"), (String)"use this for database authentication"));
        }
        return super.getExternalAuthProperties(url, username);
    }
}

