/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.naming.Binding;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.AuthenticatedLdapEntryContextMapper;
import org.springframework.ldap.core.ContextExecutor;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DefaultLdapClientBuilder;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapClient;
import org.springframework.ldap.core.LdapEntryIdentification;
import org.springframework.ldap.core.LdapEntryIdentificationContextMapper;
import org.springframework.ldap.core.NameClassPairMapper;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.query.SearchScope;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.util.Assert;

class DefaultLdapClient
implements LdapClient {
    private final Logger logger = LoggerFactory.getLogger(DefaultLdapClient.class);
    private static final boolean DONT_RETURN_OBJ_FLAG = false;
    private static final boolean RETURN_OBJ_FLAG = true;
    private final ContextSource contextSource;
    private final Supplier<SearchControls> searchControlsSupplier;
    private boolean ignorePartialResultException = false;
    private boolean ignoreNameNotFoundException = false;
    private boolean ignoreSizeLimitExceededException = true;
    private final Consumer<NamingException> namingExceptionHandler = ex -> {
        if (ex instanceof NameNotFoundException) {
            if (!this.ignoreNameNotFoundException) {
                throw LdapUtils.convertLdapException(ex);
            }
            this.logger.warn("Base context not found, ignoring: " + ex.getMessage());
            return;
        }
        if (ex instanceof PartialResultException) {
            if (!this.ignorePartialResultException) {
                throw LdapUtils.convertLdapException(ex);
            }
            this.logger.debug("PartialResultException encountered and ignored", (Throwable)ex);
            return;
        }
        if (ex instanceof SizeLimitExceededException) {
            if (!this.ignoreSizeLimitExceededException) {
                throw LdapUtils.convertLdapException(ex);
            }
            this.logger.debug("SizeLimitExceededException encountered and ignored", (Throwable)ex);
            return;
        }
        throw LdapUtils.convertLdapException(ex);
    };

    DefaultLdapClient(ContextSource contextSource, Supplier<SearchControls> searchControlsSupplier) {
        this.contextSource = contextSource;
        this.searchControlsSupplier = searchControlsSupplier;
    }

    @Override
    public LdapClient.ListSpec list(String name) {
        return new DefaultListSpec(LdapUtils.newLdapName(name));
    }

    @Override
    public LdapClient.ListSpec list(Name name) {
        return new DefaultListSpec(LdapUtils.newLdapName(name));
    }

    @Override
    public LdapClient.ListBindingsSpec listBindings(String name) {
        return new DefaultListBindingsSpec(LdapUtils.newLdapName(name));
    }

    @Override
    public LdapClient.ListBindingsSpec listBindings(Name name) {
        return new DefaultListBindingsSpec(LdapUtils.newLdapName(name));
    }

    @Override
    public LdapClient.SearchSpec search() {
        return new DefaultSearchSpec();
    }

    @Override
    public LdapClient.AuthenticateSpec authenticate() {
        return new DefaultAuthenticateSpec();
    }

    @Override
    public LdapClient.BindSpec bind(String name) {
        return new DefaultBindSpec(LdapUtils.newLdapName(name));
    }

    @Override
    public LdapClient.BindSpec bind(Name name) {
        return new DefaultBindSpec(LdapUtils.newLdapName(name));
    }

    @Override
    public LdapClient.ModifySpec modify(String name) {
        return new DefaultModifySpec(new DirContextAdapter(LdapUtils.newLdapName(name)));
    }

    @Override
    public LdapClient.ModifySpec modify(Name name) {
        return new DefaultModifySpec(new DirContextAdapter(LdapUtils.newLdapName(name)));
    }

    @Override
    public LdapClient.UnbindSpec unbind(String name) {
        return new DefaultUnbindSpec(LdapUtils.newLdapName(name));
    }

    @Override
    public LdapClient.UnbindSpec unbind(Name name) {
        return new DefaultUnbindSpec(LdapUtils.newLdapName(name));
    }

    @Override
    public LdapClient.Builder mutate() {
        return new DefaultLdapClientBuilder(this.contextSource, this.searchControlsSupplier);
    }

    void setIgnorePartialResultException(boolean ignorePartialResultException) {
        this.ignorePartialResultException = ignorePartialResultException;
    }

    void setIgnoreNameNotFoundException(boolean ignoreNameNotFoundException) {
        this.ignoreNameNotFoundException = ignoreNameNotFoundException;
    }

    void setIgnoreSizeLimitExceededException(boolean ignoreSizeLimitExceededException) {
        this.ignoreSizeLimitExceededException = ignoreSizeLimitExceededException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T computeWithReadOnlyContext(ContextExecutor<T> executor) {
        DirContext context = this.contextSource.getReadOnlyContext();
        try {
            T t = executor.executeWithContext(context);
            return t;
        }
        catch (NamingException ex) {
            this.namingExceptionHandler.accept(ex);
            T t = null;
            return t;
        }
        finally {
            this.closeContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runWithReadWriteContext(ContextRunnable runnable) {
        DirContext context = this.contextSource.getReadWriteContext();
        try {
            runnable.run(context);
        }
        catch (NamingException ex) {
            this.namingExceptionHandler.accept(ex);
        }
        finally {
            this.closeContext(context);
        }
    }

    private <T> NamingExceptionFunction<? extends Binding, T> function(ContextMapper<T> mapper) {
        return result -> mapper.mapFromContext(result.getObject());
    }

    private <T> NamingExceptionFunction<? extends SearchResult, T> function(AttributesMapper<T> mapper) {
        return result -> mapper.mapFromAttributes(result.getAttributes());
    }

    private <T> Enumeration<T> enumeration(final NamingEnumeration<T> enumeration) {
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                try {
                    return enumeration.hasMore();
                }
                catch (NamingException ex) {
                    DefaultLdapClient.this.namingExceptionHandler.accept(ex);
                    return false;
                }
            }

            @Override
            public T nextElement() {
                try {
                    return enumeration.next();
                }
                catch (NamingException ex) {
                    DefaultLdapClient.this.namingExceptionHandler.accept(ex);
                    throw new NoSuchElementException("no such element", ex);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S extends NameClassPair, T> T toObject(NamingEnumeration<S> results, NamingExceptionFunction<? super S, T> mapper) {
        try {
            Enumeration<S> enumeration = this.enumeration(results);
            Function<S, S> function = mapper.wrap(this.namingExceptionHandler);
            if (!enumeration.hasMoreElements()) {
                T t = null;
                return t;
            }
            T result = function.apply(enumeration.nextElement());
            if (enumeration.hasMoreElements()) {
                throw new IncorrectResultSizeDataAccessException(1);
            }
            T t = result;
            return t;
        }
        finally {
            this.closeNamingEnumeration(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S extends NameClassPair, T> List<T> toList(NamingEnumeration<S> results, NamingExceptionFunction<? super S, T> mapper) {
        if (results == null) {
            return Collections.emptyList();
        }
        try {
            Enumeration<S> enumeration = this.enumeration(results);
            Function<S, S> function = mapper.wrap(this.namingExceptionHandler);
            ArrayList<T> mapped = new ArrayList<T>();
            while (enumeration.hasMoreElements()) {
                T result = function.apply(enumeration.nextElement());
                if (result == null) continue;
                mapped.add(result);
            }
            ArrayList<T> arrayList = mapped;
            return arrayList;
        }
        finally {
            this.closeNamingEnumeration(results);
        }
    }

    private <S extends NameClassPair, T> Stream<T> toStream(NamingEnumeration<S> results, NamingExceptionFunction<? super S, T> mapper) {
        if (results == null) {
            return Stream.empty();
        }
        Enumeration<S> enumeration = this.enumeration(results);
        Function<? super S, T> function = mapper.wrap(this.namingExceptionHandler);
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(enumeration.asIterator(), 16), false).map(function::apply).filter(Objects::nonNull).onClose(() -> this.closeNamingEnumeration(results));
    }

    private void closeContext(DirContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private <T> void closeNamingEnumeration(NamingEnumeration<T> results) {
        if (results != null) {
            try {
                results.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final class DefaultListSpec
    implements LdapClient.ListSpec {
        private final Name name;

        private DefaultListSpec(Name name) {
            this.name = name;
        }

        @Override
        public <T> List<T> toList(NameClassPairMapper<T> mapper) {
            ContextExecutor<NamingEnumeration> executor = ctx -> ctx.list(this.name);
            NamingEnumeration results = DefaultLdapClient.this.computeWithReadOnlyContext(executor);
            return DefaultLdapClient.this.toList(results, mapper::mapFromNameClassPair);
        }

        @Override
        public <T> Stream<T> toStream(NameClassPairMapper<T> mapper) {
            ContextExecutor<NamingEnumeration> executor = ctx -> ctx.list(this.name);
            NamingEnumeration results = DefaultLdapClient.this.computeWithReadOnlyContext(executor);
            return DefaultLdapClient.this.toStream(results, mapper::mapFromNameClassPair);
        }
    }

    private final class DefaultListBindingsSpec
    implements LdapClient.ListBindingsSpec {
        private final Name name;

        private DefaultListBindingsSpec(Name name) {
            this.name = name;
        }

        @Override
        public <T> List<T> toList(NameClassPairMapper<T> mapper) {
            ContextExecutor<NamingEnumeration> executor = ctx -> ctx.listBindings(this.name);
            NamingEnumeration results = DefaultLdapClient.this.computeWithReadOnlyContext(executor);
            return DefaultLdapClient.this.toList(results, mapper::mapFromNameClassPair);
        }

        @Override
        public <T> List<T> toList(ContextMapper<T> mapper) {
            ContextExecutor<NamingEnumeration> executor = ctx -> ctx.listBindings(this.name);
            NamingEnumeration results = DefaultLdapClient.this.computeWithReadOnlyContext(executor);
            return DefaultLdapClient.this.toList(results, DefaultLdapClient.this.function(mapper));
        }

        @Override
        public <T> Stream<T> toStream(NameClassPairMapper<T> mapper) {
            ContextExecutor<NamingEnumeration> executor = ctx -> ctx.listBindings(this.name);
            NamingEnumeration results = DefaultLdapClient.this.computeWithReadOnlyContext(executor);
            return DefaultLdapClient.this.toStream(results, mapper::mapFromNameClassPair);
        }

        @Override
        public <T> Stream<T> toStream(ContextMapper<T> mapper) {
            ContextExecutor<NamingEnumeration> executor = ctx -> ctx.listBindings(this.name);
            NamingEnumeration results = DefaultLdapClient.this.computeWithReadOnlyContext(executor);
            return DefaultLdapClient.this.toStream(results, DefaultLdapClient.this.function(mapper));
        }
    }

    private final class DefaultSearchSpec
    implements LdapClient.SearchSpec {
        LdapQuery query = LdapQueryBuilder.query().filter("(objectClass=*)");
        SearchControls controls;

        private DefaultSearchSpec() {
        }

        @Override
        public LdapClient.SearchSpec name(String name) {
            return this.query((LdapQueryBuilder builder) -> builder.base(name).searchScope(SearchScope.OBJECT));
        }

        @Override
        public LdapClient.SearchSpec name(Name name) {
            return this.query((LdapQueryBuilder builder) -> builder.base(name).searchScope(SearchScope.OBJECT));
        }

        @Override
        public LdapClient.SearchSpec query(Consumer<LdapQueryBuilder> consumer) {
            LdapQueryBuilder builder = LdapQueryBuilder.fromQuery(this.query);
            consumer.accept(builder);
            this.query = builder;
            return this;
        }

        @Override
        public LdapClient.SearchSpec query(LdapQuery query) {
            this.query = query;
            return this;
        }

        public <T> T toObject(ContextMapper<T> mapper) {
            this.controls = this.searchControlsForQuery(true);
            NamingEnumeration results = DefaultLdapClient.this.computeWithReadOnlyContext(this::search);
            return DefaultLdapClient.this.toObject(results, DefaultLdapClient.this.function(mapper));
        }

        public <T> T toObject(AttributesMapper<T> mapper) {
            this.controls = this.searchControlsForQuery(false);
            NamingEnumeration results = DefaultLdapClient.this.computeWithReadOnlyContext(this::search);
            return DefaultLdapClient.this.toObject(results, DefaultLdapClient.this.function(mapper));
        }

        public <T> List<T> toList(ContextMapper<T> mapper) {
            this.controls = this.searchControlsForQuery(true);
            NamingEnumeration results = DefaultLdapClient.this.computeWithReadOnlyContext(this::search);
            return DefaultLdapClient.this.toList(results, DefaultLdapClient.this.function(mapper));
        }

        public <T> List<T> toList(AttributesMapper<T> mapper) {
            this.controls = this.searchControlsForQuery(false);
            NamingEnumeration results = DefaultLdapClient.this.computeWithReadOnlyContext(this::search);
            return DefaultLdapClient.this.toList(results, DefaultLdapClient.this.function(mapper));
        }

        public <T> Stream<T> toStream(ContextMapper<T> mapper) {
            this.controls = this.searchControlsForQuery(true);
            NamingEnumeration results = DefaultLdapClient.this.computeWithReadOnlyContext(this::search);
            return DefaultLdapClient.this.toStream(results, DefaultLdapClient.this.function(mapper));
        }

        public <T> Stream<T> toStream(AttributesMapper<T> mapper) {
            this.controls = this.searchControlsForQuery(false);
            NamingEnumeration results = DefaultLdapClient.this.computeWithReadOnlyContext(this::search);
            return DefaultLdapClient.this.toStream(results, DefaultLdapClient.this.function(mapper));
        }

        private NamingEnumeration<SearchResult> search(DirContext ctx) throws NamingException {
            return ctx.search(this.query.base(), this.query.filter().encode(), this.controls);
        }

        private SearchControls searchControlsForQuery(boolean returnObjFlag) {
            SearchControls controls = DefaultLdapClient.this.searchControlsSupplier.get();
            controls.setReturningObjFlag(returnObjFlag);
            controls.setReturningAttributes(this.query.attributes());
            if (this.query.searchScope() != null) {
                controls.setSearchScope(this.query.searchScope().getId());
            }
            if (this.query.countLimit() != null) {
                controls.setCountLimit(this.query.countLimit().intValue());
            }
            if (this.query.timeLimit() != null) {
                controls.setTimeLimit(this.query.timeLimit());
            }
            return controls;
        }
    }

    private final class DefaultAuthenticateSpec
    implements LdapClient.AuthenticateSpec {
        LdapClient.SearchSpec search;
        char[] password;

        private DefaultAuthenticateSpec() {
            this.search = new DefaultSearchSpec();
        }

        @Override
        public LdapClient.AuthenticateSpec query(LdapQuery query) {
            this.search.query(query);
            return this;
        }

        @Override
        public LdapClient.AuthenticateSpec password(String password) {
            this.password = password.toCharArray();
            return this;
        }

        @Override
        public void execute() {
            this.execute((ctx, identification) -> ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T execute(AuthenticatedLdapEntryContextMapper<T> mapper) {
            T t;
            LdapEntryIdentificationContextMapper m = new LdapEntryIdentificationContextMapper();
            List<LdapEntryIdentification> identification = this.search.toList(m);
            if (identification.size() == 0) {
                throw new EmptyResultDataAccessException(1);
            }
            if (identification.size() != 1) {
                throw new IncorrectResultSizeDataAccessException(1, identification.size());
            }
            DirContext ctx = null;
            try {
                String password = this.password != null ? new String(this.password) : null;
                ctx = DefaultLdapClient.this.contextSource.getContext(identification.get(0).getAbsoluteName().toString(), password);
                t = mapper.mapWithContext(ctx, identification.get(0));
                this.password = null;
                DefaultLdapClient.this.closeContext(ctx);
            }
            catch (Throwable throwable) {
                this.password = null;
                DefaultLdapClient.this.closeContext(ctx);
                throw throwable;
            }
            return t;
        }
    }

    private final class DefaultBindSpec
    implements LdapClient.BindSpec {
        private final Name name;
        private Object obj;
        private Attributes attributes;
        private boolean rebind = false;

        private DefaultBindSpec(Name name) {
            this.name = name;
        }

        @Override
        public LdapClient.BindSpec object(Object obj) {
            if (obj instanceof DirContextOperations) {
                boolean updateMode = ((DirContextOperations)obj).isUpdateMode();
                Assert.isTrue((!updateMode ? 1 : 0) != 0, (String)"DirContextOperations must not be in update mode");
            }
            this.obj = obj;
            return this;
        }

        @Override
        public LdapClient.BindSpec attributes(Attributes attributes) {
            this.attributes = attributes;
            return this;
        }

        @Override
        public LdapClient.BindSpec replaceExisting(boolean replaceExisting) {
            this.rebind = replaceExisting;
            return this;
        }

        @Override
        public void execute() {
            if (this.rebind) {
                DefaultLdapClient.this.runWithReadWriteContext(ctx -> ctx.rebind(this.name, this.obj, this.attributes));
            } else {
                DefaultLdapClient.this.runWithReadWriteContext(ctx -> ctx.bind(this.name, this.obj, this.attributes));
            }
        }
    }

    private final class DefaultModifySpec
    implements LdapClient.ModifySpec {
        private final DirContextOperations entry;
        private Name name;
        private ModificationItem[] items;

        private DefaultModifySpec(DirContextOperations entry) {
            this.entry = entry;
            this.name = entry.getDn();
            this.items = entry.getModificationItems();
        }

        @Override
        public LdapClient.ModifySpec name(String name) {
            this.name = LdapUtils.newLdapName(name);
            return this;
        }

        @Override
        public LdapClient.ModifySpec name(Name name) {
            this.name = LdapUtils.newLdapName(name);
            return this;
        }

        @Override
        public LdapClient.ModifySpec attributes(ModificationItem ... modifications) {
            this.items = modifications;
            return this;
        }

        @Override
        public void execute() {
            boolean renamed = false;
            if (!this.entry.getDn().equals(this.name)) {
                DefaultLdapClient.this.runWithReadWriteContext(ctx -> ctx.rename(this.entry.getDn(), this.name));
                renamed = true;
            }
            try {
                if (this.items.length > 0) {
                    DefaultLdapClient.this.runWithReadWriteContext(ctx -> ctx.modifyAttributes(this.name, this.items));
                }
            }
            catch (Throwable th) {
                if (renamed) {
                    DefaultLdapClient.this.runWithReadWriteContext(ctx -> ctx.rename(this.name, this.entry.getDn()));
                }
                throw th;
            }
        }
    }

    private final class DefaultUnbindSpec
    implements LdapClient.UnbindSpec {
        private final Name name;
        private boolean recursive = false;

        private DefaultUnbindSpec(Name name) {
            this.name = name;
        }

        @Override
        public LdapClient.UnbindSpec recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        @Override
        public void execute() {
            if (this.recursive) {
                DefaultLdapClient.this.runWithReadWriteContext(ctx -> this.unbindRecursive(ctx, this.name));
                return;
            }
            DefaultLdapClient.this.runWithReadWriteContext(ctx -> ctx.unbind(this.name));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unbindRecursive(DirContext ctx, Name name) throws NamingException {
            NamingEnumeration<Binding> bindings = null;
            try {
                bindings = ctx.listBindings(name);
                while (bindings.hasMore()) {
                    Binding binding = bindings.next();
                    LdapName childName = LdapUtils.newLdapName(binding.getName());
                    childName.addAll(0, name);
                    this.unbindRecursive(ctx, childName);
                }
                ctx.unbind(name);
                if (DefaultLdapClient.this.logger.isDebugEnabled()) {
                    DefaultLdapClient.this.logger.debug("Entry " + String.valueOf(name) + " deleted");
                }
            }
            finally {
                DefaultLdapClient.this.closeNamingEnumeration(bindings);
            }
        }
    }

    static interface ContextRunnable {
        public void run(DirContext var1) throws NamingException;
    }

    static interface NamingExceptionFunction<S, T> {
        public T apply(S var1) throws NamingException;

        default public Function<S, T> wrap(Consumer<NamingException> handler) {
            return s -> {
                try {
                    return this.apply(s);
                }
                catch (NamingException ex) {
                    handler.accept(ex);
                    return null;
                }
            };
        }
    }
}

