/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.PrintStream;
import java.util.Objects;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.web.api.entity.ClusterSummaryEntity;

public class ClusterSummaryEntityResult
extends AbstractWritableResult<ClusterSummaryEntity> {
    private final ClusterSummaryEntity clusteSummaryEntity;

    public ClusterSummaryEntityResult(ResultType resultType, ClusterSummaryEntity clusteSummaryEntity) {
        super(resultType);
        this.clusteSummaryEntity = Objects.requireNonNull(clusteSummaryEntity);
    }

    @Override
    public ClusterSummaryEntity getResult() {
        return this.clusteSummaryEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        output.printf("Total node count: %d\nConnected node count: %d\nClustered: %s\nConnected to cluster: %s\n", this.clusteSummaryEntity.getClusterSummary().getTotalNodeCount(), this.clusteSummaryEntity.getClusterSummary().getConnectedNodeCount(), this.clusteSummaryEntity.getClusterSummary().getClustered(), this.clusteSummaryEntity.getClusterSummary().getConnectedToCluster());
    }
}

