/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.toolkit.client.FlowClient;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.VersionsClient;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.entity.VersionControlInformationEntity;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotMetadataEntity;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotMetadataSetEntity;
import org.apache.nifi.web.api.entity.VersionedFlowUpdateRequestEntity;

public class PGChangeVersion
extends AbstractNiFiCommand<VoidResult> {
    public PGChangeVersion() {
        super("pg-change-version", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Changes the version for a version controlled process group. This can be used to upgrade to a new version, or revert to a previous version. If no version is specified, the latest version will be used.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
        this.addOption(CommandOption.FLOW_VERSION.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        VersionsClient versionsClient = client.getVersionsClient();
        VersionControlInformationEntity existingVersionControlInfo = versionsClient.getVersionControlInfo(pgId);
        VersionControlInformationDTO existingVersionControlDTO = existingVersionControlInfo.getVersionControlInformation();
        if (existingVersionControlDTO == null) {
            throw new NiFiClientException("Process group is not under version control");
        }
        String newVersion = this.getArg(properties, CommandOption.FLOW_VERSION);
        return this.changeVersion(client, existingVersionControlInfo, newVersion, pgId, this.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VoidResult changeVersion(NiFiClient client, VersionControlInformationEntity existingVersionControlInfo, String newVersion, String pgId, Context context) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        VersionsClient versionsClient = client.getVersionsClient();
        VersionControlInformationDTO existingVersionControlDTO = existingVersionControlInfo.getVersionControlInformation();
        if (newVersion == null && Objects.equals(newVersion = this.getLatestVersion(client, existingVersionControlDTO), existingVersionControlDTO.getVersion())) {
            throw new NiFiClientException("Process group already at latest version");
        }
        existingVersionControlDTO.setVersion(newVersion);
        VersionedFlowUpdateRequestEntity initialUpdateRequest = versionsClient.updateVersionControlInfo(pgId, existingVersionControlInfo);
        String updateRequestId = initialUpdateRequest.getRequest().getRequestId();
        try {
            boolean completed = false;
            for (int i = 0; i < 30; ++i) {
                VersionedFlowUpdateRequestEntity updateRequest = versionsClient.getUpdateRequest(updateRequestId);
                if (updateRequest != null && updateRequest.getRequest().isComplete()) {
                    completed = true;
                    if (updateRequest.getRequest().getFailureReason() == null) break;
                    throw new NiFiClientException(updateRequest.getRequest().getFailureReason());
                }
                try {
                    if (context.isInteractive()) {
                        this.println("Waiting for update request to complete...");
                    }
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!completed) {
                throw new NiFiClientException("Unable to change version of process group, cancelling request");
            }
        }
        finally {
            versionsClient.deleteUpdateRequest(updateRequestId);
        }
        return VoidResult.getInstance();
    }

    String getLatestVersion(NiFiClient client, VersionControlInformationDTO existingVersionControlDTO) throws NiFiClientException, IOException {
        String flowId;
        String bucketId;
        String registryId;
        FlowClient flowClient = client.getFlowClient();
        VersionedFlowSnapshotMetadataSetEntity versions = flowClient.getVersions(registryId = existingVersionControlDTO.getRegistryId(), bucketId = existingVersionControlDTO.getBucketId(), flowId = existingVersionControlDTO.getFlowId());
        if (versions.getVersionedFlowSnapshotMetadataSet() == null || versions.getVersionedFlowSnapshotMetadataSet().isEmpty()) {
            throw new NiFiClientException("No versions available");
        }
        return this.getLatestVersion(versions);
    }

    private String getLatestVersion(VersionedFlowSnapshotMetadataSetEntity versions) {
        long latestTimestamp = 0L;
        String latestVersion = null;
        for (VersionedFlowSnapshotMetadataEntity version : versions.getVersionedFlowSnapshotMetadataSet()) {
            RegisteredFlowSnapshotMetadata versionMetadata = version.getVersionedFlowSnapshotMetadata();
            if (versionMetadata.getTimestamp() <= latestTimestamp) continue;
            latestTimestamp = versionMetadata.getTimestamp();
            latestVersion = versionMetadata.getVersion();
        }
        return latestVersion;
    }
}

