/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl.request;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Form;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.nifi.toolkit.client.NiFiClientConfig;
import org.apache.nifi.toolkit.client.RequestConfig;

public class OIDCClientCredentialsRequestConfig
implements RequestConfig {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String BEARER = "Bearer";
    private final String token;

    public OIDCClientCredentialsRequestConfig(NiFiClientConfig niFiClientConfig, String oidcTokenUrl, String oidcClientId, String oidcClientSecret) {
        Objects.requireNonNull(oidcTokenUrl);
        Objects.requireNonNull(oidcClientId);
        Objects.requireNonNull(oidcClientSecret);
        Objects.requireNonNull(niFiClientConfig);
        SSLContext sslContext = niFiClientConfig.getSslContext();
        HostnameVerifier hostnameVerifier = niFiClientConfig.getHostnameVerifier();
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        if (sslContext != null) {
            clientBuilder.sslContext(sslContext);
        }
        if (hostnameVerifier != null) {
            clientBuilder.hostnameVerifier(hostnameVerifier);
        }
        Form form = new Form();
        form.param("grant_type", "client_credentials");
        form.param("client_id", oidcClientId);
        form.param("client_secret", oidcClientSecret);
        WebTarget target = clientBuilder.build().target(oidcTokenUrl);
        String response = (String)target.request().post(Entity.form((Form)form), String.class);
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.token = mapper.readTree(response).get("access_token").textValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(AUTHORIZATION_HEADER, "Bearer " + this.token);
        return headers;
    }
}

