/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Pointcut;
import org.springframework.core.log.LogMessage;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authorization.AuthorizationDeniedException;
import org.springframework.security.authorization.AuthorizationEventPublisher;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.method.AuthorizationAdvisor;
import org.springframework.security.authorization.method.AuthorizationInterceptorsOrder;
import org.springframework.security.authorization.method.AuthorizationMethodPointcuts;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.MethodInvocationResult;
import org.springframework.security.authorization.method.NoOpAuthorizationEventPublisher;
import org.springframework.security.authorization.method.PostAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.ThrowingMethodAuthorizationDeniedHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.util.Assert;

public final class AuthorizationManagerAfterMethodInterceptor
implements AuthorizationAdvisor {
    private Supplier<SecurityContextHolderStrategy> securityContextHolderStrategy = SecurityContextHolder::getContextHolderStrategy;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Pointcut pointcut;
    private final AuthorizationManager<MethodInvocationResult> authorizationManager;
    private final MethodAuthorizationDeniedHandler defaultHandler = new ThrowingMethodAuthorizationDeniedHandler();
    private int order;
    private AuthorizationEventPublisher eventPublisher = new NoOpAuthorizationEventPublisher();

    public AuthorizationManagerAfterMethodInterceptor(Pointcut pointcut, AuthorizationManager<MethodInvocationResult> authorizationManager) {
        Assert.notNull((Object)pointcut, (String)"pointcut cannot be null");
        Assert.notNull(authorizationManager, (String)"authorizationManager cannot be null");
        this.pointcut = pointcut;
        this.authorizationManager = authorizationManager;
    }

    public static AuthorizationManagerAfterMethodInterceptor postAuthorize() {
        return AuthorizationManagerAfterMethodInterceptor.postAuthorize(new PostAuthorizeAuthorizationManager());
    }

    public static AuthorizationManagerAfterMethodInterceptor postAuthorize(PostAuthorizeAuthorizationManager authorizationManager) {
        AuthorizationManagerAfterMethodInterceptor interceptor = new AuthorizationManagerAfterMethodInterceptor(AuthorizationMethodPointcuts.forAnnotations(PostAuthorize.class), authorizationManager);
        interceptor.setOrder(AuthorizationInterceptorsOrder.POST_AUTHORIZE.getOrder());
        return interceptor;
    }

    public static AuthorizationManagerAfterMethodInterceptor postAuthorize(AuthorizationManager<MethodInvocationResult> authorizationManager) {
        AuthorizationManagerAfterMethodInterceptor interceptor = new AuthorizationManagerAfterMethodInterceptor(AuthorizationMethodPointcuts.forAnnotations(PostAuthorize.class), authorizationManager);
        interceptor.setOrder(AuthorizationInterceptorsOrder.POST_AUTHORIZE.getOrder());
        return interceptor;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        Object result;
        try {
            result = mi.proceed();
        }
        catch (AuthorizationDeniedException ex) {
            AuthorizationManager<MethodInvocationResult> authorizationManager = this.authorizationManager;
            if (authorizationManager instanceof MethodAuthorizationDeniedHandler) {
                MethodAuthorizationDeniedHandler handler = (MethodAuthorizationDeniedHandler)((Object)authorizationManager);
                return handler.handleDeniedInvocation(mi, ex);
            }
            return this.defaultHandler.handleDeniedInvocation(mi, ex);
        }
        return this.attemptAuthorization(mi, result);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setAuthorizationEventPublisher(AuthorizationEventPublisher eventPublisher) {
        Assert.notNull((Object)eventPublisher, (String)"eventPublisher cannot be null");
        this.eventPublisher = eventPublisher;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this;
    }

    public boolean isPerInstance() {
        return true;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy strategy) {
        this.securityContextHolderStrategy = () -> strategy;
    }

    private Object attemptAuthorization(MethodInvocation mi, Object result) {
        this.logger.debug((Object)LogMessage.of(() -> "Authorizing method invocation " + mi));
        MethodInvocationResult object = new MethodInvocationResult(mi, result);
        AuthorizationResult authorizationResult = this.authorizationManager.authorize(this::getAuthentication, object);
        this.eventPublisher.publishAuthorizationEvent(this::getAuthentication, object, authorizationResult);
        if (authorizationResult != null && !authorizationResult.isGranted()) {
            this.logger.debug((Object)LogMessage.of(() -> "Failed to authorize " + mi + " with authorization manager " + this.authorizationManager + " and authorizationResult " + authorizationResult));
            return this.handlePostInvocationDenied(object, authorizationResult);
        }
        this.logger.debug((Object)LogMessage.of(() -> "Authorized method invocation " + mi));
        return result;
    }

    private Object handlePostInvocationDenied(MethodInvocationResult mi, AuthorizationResult result) {
        AuthorizationManager<MethodInvocationResult> authorizationManager = this.authorizationManager;
        if (authorizationManager instanceof MethodAuthorizationDeniedHandler) {
            MethodAuthorizationDeniedHandler deniedHandler = (MethodAuthorizationDeniedHandler)((Object)authorizationManager);
            return deniedHandler.handleDeniedInvocationResult(mi, result);
        }
        return this.defaultHandler.handleDeniedInvocationResult(mi, result);
    }

    private Authentication getAuthentication() {
        Authentication authentication = this.securityContextHolderStrategy.get().getContext().getAuthentication();
        if (authentication == null) {
            throw new AuthenticationCredentialsNotFoundException("An Authentication object was not found in the SecurityContext");
        }
        return authentication;
    }
}

