/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.event;

import java.util.function.Supplier;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class AuthorizationEvent
extends ApplicationEvent {
    private final Supplier<Authentication> authentication;
    private final AuthorizationResult result;

    public AuthorizationEvent(Supplier<Authentication> authentication, Object object, AuthorizationDecision result) {
        super(object);
        Assert.notNull(authentication, (String)"authentication supplier cannot be null");
        this.authentication = authentication;
        this.result = result;
    }

    public AuthorizationEvent(Supplier<Authentication> authentication, Object object, AuthorizationResult result) {
        super(object);
        Assert.notNull(authentication, (String)"authentication supplier cannot be null");
        this.authentication = authentication;
        this.result = result;
    }

    public Supplier<Authentication> getAuthentication() {
        return this.authentication;
    }

    public Object getObject() {
        return this.getSource();
    }

    @Deprecated
    public AuthorizationDecision getAuthorizationDecision() {
        if (this.result == null) {
            return null;
        }
        AuthorizationResult authorizationResult = this.result;
        if (authorizationResult instanceof AuthorizationDecision) {
            AuthorizationDecision decision = (AuthorizationDecision)authorizationResult;
            return decision;
        }
        throw new IllegalArgumentException("Please either call getAuthorizationResult or ensure that the result is of type AuthorizationDecision");
    }

    public AuthorizationResult getAuthorizationResult() {
        return this.result;
    }
}

