/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.util;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class TimestampAdapter
extends XmlAdapter<String, Date> {
    private static final String DEFAULT_DATE_TIME_FORMAT = "MM/dd/yyyy HH:mm:ss.SSS z";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss.SSS z").withZone(ZoneId.systemDefault());

    public String marshal(Date date) throws Exception {
        return DATE_TIME_FORMATTER.format(date.toInstant());
    }

    public Date unmarshal(String date) throws Exception {
        ZonedDateTime dateTime = LocalDateTime.parse(date, DATE_TIME_FORMATTER).atZone(ZoneId.systemDefault());
        return Date.from(dateTime.toInstant());
    }
}

