/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.attribute.expression.language.VariableImpact;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.AsyncLoadedProcessor;
import org.apache.nifi.components.ClassloaderIsolationKeyProvider;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceContext;
import org.apache.nifi.components.resource.ResourceReferenceFactory;
import org.apache.nifi.components.resource.ResourceReferences;
import org.apache.nifi.components.resource.StandardResourceContext;
import org.apache.nifi.components.resource.StandardResourceReferenceFactory;
import org.apache.nifi.components.validation.DisabledServiceValidationResult;
import org.apache.nifi.components.validation.EnablingServiceValidationResult;
import org.apache.nifi.components.validation.ValidationState;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceApiMatcher;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.PropertyConfigurationMapper;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.service.ControllerServiceDisabledException;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.flow.ExecutionEngine;
import org.apache.nifi.flowanalysis.EnforcementPolicy;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.ExpressionLanguageAgnosticParameterParser;
import org.apache.nifi.parameter.ExpressionLanguageAwareParameterParser;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.parameter.ParameterUpdate;
import org.apache.nifi.util.CharacterFilterUtils;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;
import org.apache.nifi.validation.RuleViolation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComponentNode
implements ComponentNode {
    private static final String PERFORM_VALIDATION_STEP_NAME = "Perform Validation";
    private static final Logger logger = LoggerFactory.getLogger(AbstractComponentNode.class);
    private final String id;
    private final ValidationContextFactory validationContextFactory;
    private final ControllerServiceProvider serviceProvider;
    private final AtomicReference<String> name;
    private final AtomicReference<String> annotationData = new AtomicReference();
    private final String componentType;
    private final String componentCanonicalClass;
    private final ReloadComponent reloadComponent;
    private final ExtensionManager extensionManager;
    private final AtomicBoolean isExtensionMissing;
    private final Lock lock = new ReentrantLock();
    private final ConcurrentMap<PropertyDescriptor, PropertyConfiguration> properties = new ConcurrentHashMap<PropertyDescriptor, PropertyConfiguration>();
    private final AtomicReference<Set<String>> sensitiveDynamicPropertyNames = new AtomicReference(new HashSet());
    private volatile String additionalResourcesFingerprint;
    private final AtomicReference<ValidationState> validationState = new AtomicReference<ValidationState>(new ValidationState(ValidationStatus.VALIDATING, Collections.emptyList()));
    private final ValidationTrigger validationTrigger;
    private volatile boolean triggerValidation = true;
    private final Map<String, Integer> parameterReferenceCounts = new ConcurrentHashMap<String, Integer>();
    private ValidationContext validationContext = null;

    public AbstractComponentNode(String id, ValidationContextFactory validationContextFactory, ControllerServiceProvider serviceProvider, String componentType, String componentCanonicalClass, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger, boolean isExtensionMissing) {
        this.id = id;
        this.validationContextFactory = validationContextFactory;
        this.serviceProvider = serviceProvider;
        this.name = new AtomicReference<String>(componentType);
        this.componentType = componentType;
        this.componentCanonicalClass = componentCanonicalClass;
        this.reloadComponent = reloadComponent;
        this.validationTrigger = validationTrigger;
        this.extensionManager = extensionManager;
        this.isExtensionMissing = new AtomicBoolean(isExtensionMissing);
    }

    @Override
    public String getIdentifier() {
        return this.id;
    }

    @Override
    public void setExtensionMissing(boolean extensionMissing) {
        this.isExtensionMissing.set(extensionMissing);
    }

    @Override
    public boolean isExtensionMissing() {
        return this.isExtensionMissing.get();
    }

    @Override
    public String getName() {
        return this.name.get();
    }

    @Override
    public void setName(String name) {
        this.name.set(CharacterFilterUtils.filterInvalidXmlCharacters(Objects.requireNonNull(name).intern()));
    }

    @Override
    public String getAnnotationData() {
        return this.annotationData.get();
    }

    @Override
    public void setAnnotationData(String data) {
        this.annotationData.set(CharacterFilterUtils.filterInvalidXmlCharacters(data));
        logger.debug("Resetting Validation State of {} due to setting annotation data", (Object)this);
        this.resetValidationState();
    }

    @Override
    public Set<URL> getAdditionalClasspathResources(List<PropertyDescriptor> propertyDescriptors) {
        return this.getAdditionalClasspathResources((Collection<PropertyDescriptor>)propertyDescriptors);
    }

    protected Set<URL> getAdditionalClasspathResources(Collection<PropertyDescriptor> propertyDescriptors) {
        return this.getAdditionalClasspathResources(propertyDescriptors, this::getEffectivePropertyValue);
    }

    protected Set<URL> getAdditionalClasspathResources(Collection<PropertyDescriptor> propertyDescriptors, Function<PropertyDescriptor, String> effectiveValueLookup) {
        LinkedHashSet<URL> additionalUrls = new LinkedHashSet<URL>();
        StandardResourceReferenceFactory resourceReferenceFactory = new StandardResourceReferenceFactory();
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            String value;
            if (!descriptor.isDynamicClasspathModifier() || StringUtils.isEmpty((CharSequence)(value = effectiveValueLookup.apply(descriptor)))) continue;
            StandardResourceContext resourceContext = new StandardResourceContext((ResourceReferenceFactory)resourceReferenceFactory, descriptor);
            StandardPropertyValue propertyValue = new StandardPropertyValue((ResourceContext)resourceContext, value, null, this.getParameterLookup());
            ResourceReferences references = propertyValue.evaluateAttributeExpressions().asResources().flatten();
            additionalUrls.addAll(references.asURLs());
        }
        return additionalUrls;
    }

    protected boolean isClasspathDifferent(Map<PropertyDescriptor, String> properties) {
        PropertyDescriptor descriptor;
        for (Map.Entry<PropertyDescriptor, String> entry : properties.entrySet()) {
            descriptor = entry.getKey();
            String value = entry.getValue();
            String currentlyConfiguredValue = this.getEffectivePropertyValue(descriptor);
            if (!descriptor.isDynamicClasspathModifier() || Objects.equals(value, currentlyConfiguredValue)) continue;
            return true;
        }
        for (Map.Entry<PropertyDescriptor, Object> entry : this.getProperties().entrySet()) {
            descriptor = entry.getKey();
            if (!descriptor.isDynamicClasspathModifier() || properties.containsKey(descriptor)) continue;
            return true;
        }
        return false;
    }

    protected void overwriteProperties(Map<String, String> properties) {
        HashMap<String, String> updatedProperties = new HashMap<String, String>(properties);
        HashSet<String> sensitiveDynamicPropNames = new HashSet<String>();
        for (String propertyName : updatedProperties.keySet()) {
            PropertyDescriptor descriptor = this.getPropertyDescriptor(propertyName);
            if (descriptor == null || !descriptor.isDynamic() || !descriptor.isSensitive()) continue;
            sensitiveDynamicPropNames.add(propertyName);
        }
        for (PropertyDescriptor descriptor : this.getProperties().keySet()) {
            updatedProperties.putIfAbsent(descriptor.getName(), null);
        }
        this.setProperties(updatedProperties, true, sensitiveDynamicPropNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(Map<String, String> properties, boolean allowRemovalOfRequiredProperties, Set<String> requestedSensitiveDynamicPropertyNames) {
        if (properties == null) {
            return;
        }
        this.lock.lock();
        try {
            Objects.requireNonNull(requestedSensitiveDynamicPropertyNames, "Sensitive Dynamic Property Names required");
            this.verifyCanUpdateProperties(properties);
            String initialIsolationKey = this.determineClasloaderIsolationKey();
            PropertyConfigurationMapper configurationMapper = new PropertyConfigurationMapper();
            Map<String, PropertyConfiguration> configurationMap = configurationMapper.mapRawPropertyValuesToPropertyConfiguration(this, properties);
            LinkedHashSet<String> removedPropertyNames = new LinkedHashSet<String>();
            try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, (Class)this.getComponent().getClass(), (String)this.id);){
                boolean classloaderIsolationKeyChanged;
                boolean classpathChanged = false;
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    PropertyConfiguration currentConfiguration;
                    PropertyDescriptor descriptor;
                    String propertyName = entry.getKey();
                    PropertyDescriptor componentDescriptor = this.getComponent().getPropertyDescriptor(propertyName);
                    PropertyDescriptor propertyDescriptor = descriptor = componentDescriptor.isDynamic() && requestedSensitiveDynamicPropertyNames.contains(propertyName) ? new PropertyDescriptor.Builder().fromPropertyDescriptor(componentDescriptor).sensitive(true).build() : componentDescriptor;
                    if (descriptor.isDynamicClasspathModifier()) {
                        classpathChanged = true;
                    }
                    if ((currentConfiguration = (PropertyConfiguration)this.properties.get(descriptor)) != null) {
                        for (ParameterReference reference : currentConfiguration.getParameterReferences()) {
                            this.parameterReferenceCounts.merge(reference.getParameterName(), -1, (a, b) -> a == 1 ? null : Integer.valueOf(a + b));
                        }
                    }
                    if (propertyName != null && entry.getValue() == null) {
                        boolean removed = this.removeProperty(propertyName, allowRemovalOfRequiredProperties);
                        if (!removed) continue;
                        removedPropertyNames.add(propertyName);
                        continue;
                    }
                    if (propertyName == null) continue;
                    PropertyConfiguration propertyConfiguration = configurationMap.get(propertyName);
                    List<ParameterReference> parameterReferences = propertyConfiguration.getParameterReferences();
                    for (ParameterReference reference : parameterReferences) {
                        this.parameterReferenceCounts.merge(reference.getParameterName(), 1, (a, b) -> a == -1 ? null : Integer.valueOf(a + b));
                    }
                    this.setProperty(descriptor, propertyConfiguration, this.properties::get);
                }
                LinkedHashSet<String> updatedSensitiveDynamicPropertyNames = new LinkedHashSet<String>((Collection)this.sensitiveDynamicPropertyNames.get());
                updatedSensitiveDynamicPropertyNames.addAll(requestedSensitiveDynamicPropertyNames);
                updatedSensitiveDynamicPropertyNames.removeAll(removedPropertyNames);
                this.sensitiveDynamicPropertyNames.getAndSet(updatedSensitiveDynamicPropertyNames);
                String updatedIsolationKey = this.determineClasloaderIsolationKey();
                boolean bl = classloaderIsolationKeyChanged = !Objects.equals(initialIsolationKey, updatedIsolationKey);
                if (classpathChanged || classloaderIsolationKeyChanged) {
                    logger.info("Updating classpath for {} with the ID {}", (Object)this.componentType, (Object)this.getIdentifier());
                    Set<URL> additionalUrls = this.getAdditionalClasspathResources(this.getComponent().getPropertyDescriptors());
                    try {
                        this.reload(additionalUrls);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Error reloading component with id {}", this.id, e);
                    }
                }
            }
            if (this.isTriggerValidation()) {
                logger.debug("Resetting Validation State of {} due to setting properties", (Object)this);
                this.resetValidationState();
            } else {
                logger.debug("Properties set for {} but not resettingn validation state because validation is paused", (Object)this);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected String determineClasloaderIsolationKey() {
        ConfigurableComponent component = this.getComponent();
        if (!(component instanceof ClassloaderIsolationKeyProvider)) {
            return null;
        }
        ValidationContext validationContext = this.getValidationContextFactory().newValidationContext(this.getProperties(), this.getAnnotationData(), this.getProcessGroupIdentifier(), this.getIdentifier(), this.getParameterContext(), true);
        return this.getClassLoaderIsolationKey((PropertyContext)validationContext);
    }

    @Override
    public void verifyCanUpdateProperties(Map<String, String> properties) {
        this.verifyModifiable();
        ExpressionLanguageAgnosticParameterParser parameterParser = new ExpressionLanguageAgnosticParameterParser();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            ParameterReference reference;
            String propertyName = entry.getKey();
            String value = entry.getValue();
            ParameterTokenList tokenList = parameterParser.parseTokens(value);
            List referenceList = tokenList.toReferenceList();
            PropertyDescriptor descriptor = this.getPropertyDescriptor(propertyName);
            if (!descriptor.isSensitive() || this.isExtensionMissing()) continue;
            if (referenceList.size() > 1) {
                throw new IllegalArgumentException("The property '" + descriptor.getDisplayName() + "' cannot reference more than one Parameter because it is a sensitive property.");
            }
            if (referenceList.size() != 1 || (reference = (ParameterReference)referenceList.get(0)).getStartOffset() == 0 && reference.getEndOffset() == value.length() - 1) continue;
            throw new IllegalArgumentException("The property '" + descriptor.getDisplayName() + "' is a sensitive property so it can reference a Parameter only if there is no other context around the value. For instance, the value '#{abc}' is allowed but 'password#{abc}' is not allowed.");
        }
    }

    protected List<ConfigVerificationResult> verifyConfig(Map<PropertyDescriptor, String> propertyValues, String annotationData, ParameterContext parameterContext) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        try {
            long startNanos = System.nanoTime();
            Map<PropertyDescriptor, PropertyConfiguration> descriptorToConfigMap = AbstractComponentNode.createDescriptorToConfigMap(propertyValues);
            ValidationContext validationContext = this.getValidationContextFactory().newValidationContext(descriptorToConfigMap, annotationData, this.getProcessGroupIdentifier(), this.getIdentifier(), parameterContext, false);
            ValidationState validationState = this.performValidation(validationContext);
            ValidationStatus validationStatus = validationState.getStatus();
            if (validationStatus == ValidationStatus.INVALID) {
                for (ValidationResult result : validationState.getValidationErrors()) {
                    if (result.isValid()) continue;
                    results.add(new ConfigVerificationResult.Builder().verificationStepName(PERFORM_VALIDATION_STEP_NAME).outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Component is invalid: " + String.valueOf(result)).build());
                }
                if (results.isEmpty()) {
                    results.add(new ConfigVerificationResult.Builder().verificationStepName(PERFORM_VALIDATION_STEP_NAME).outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Component is invalid but provided no Validation Results to indicate why").build());
                }
                logger.debug("{} is not valid with the given configuration. Will not attempt to perform any additional verification of configuration. Validation took {}. Reason not valid: {}", new Object[]{this, results, FormatUtils.formatNanos((long)(System.nanoTime() - startNanos), (boolean)false)});
                return results;
            }
            results.add(new ConfigVerificationResult.Builder().verificationStepName(PERFORM_VALIDATION_STEP_NAME).outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("Component Validation passed").build());
        }
        catch (Throwable t) {
            logger.error("Failed to perform verification of component's configuration for {}", (Object)this, (Object)t);
            results.add(new ConfigVerificationResult.Builder().verificationStepName(PERFORM_VALIDATION_STEP_NAME).outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Encountered unexpected failure when attempting to perform verification: " + String.valueOf(t)).build());
        }
        return results;
    }

    private static Map<PropertyDescriptor, PropertyConfiguration> createDescriptorToConfigMap(Map<PropertyDescriptor, String> propertyValues) {
        LinkedHashMap<PropertyDescriptor, PropertyConfiguration> descriptorToConfigMap = new LinkedHashMap<PropertyDescriptor, PropertyConfiguration>();
        for (Map.Entry<PropertyDescriptor, String> entry : propertyValues.entrySet()) {
            PropertyDescriptor descriptor = entry.getKey();
            String rawValue = entry.getValue();
            String propertyValue = rawValue == null ? descriptor.getDefaultValue() : rawValue;
            PropertyConfiguration propertyConfiguration = new PropertyConfiguration(propertyValue, null, Collections.emptyList(), VariableImpact.NEVER_IMPACTED);
            descriptorToConfigMap.put(descriptor, propertyConfiguration);
        }
        return descriptorToConfigMap;
    }

    @Override
    public Set<String> getReferencedParameterNames() {
        return Collections.unmodifiableSet(this.parameterReferenceCounts.keySet());
    }

    @Override
    public boolean isReferencingParameter() {
        return !this.parameterReferenceCounts.isEmpty();
    }

    @Override
    public Set<String> getReferencedAttributeNames() {
        HashSet<String> referencedAttributes = new HashSet<String>();
        for (PropertyDescriptor descriptor : this.getPropertyDescriptors()) {
            String effectiveValue = this.getEffectivePropertyValue(descriptor);
            Set attributes = Query.prepareWithParametersPreEvaluated((String)effectiveValue).getExplicitlyReferencedAttributes();
            referencedAttributes.addAll(attributes);
        }
        return referencedAttributes;
    }

    private String resolveAllowableValue(String explicitValue, PropertyDescriptor descriptor) {
        String displayName;
        if (explicitValue == null || descriptor == null) {
            return null;
        }
        List allowableValues = descriptor.getAllowableValues();
        if (allowableValues == null || allowableValues.isEmpty()) {
            return explicitValue;
        }
        for (AllowableValue allowableValue : allowableValues) {
            if (!Objects.equals(allowableValue.getValue(), explicitValue)) continue;
            return explicitValue;
        }
        for (AllowableValue allowableValue : allowableValues) {
            if (!allowableValue.getValue().equalsIgnoreCase(explicitValue)) continue;
            return allowableValue.getValue();
        }
        for (AllowableValue allowableValue : allowableValues) {
            displayName = allowableValue.getDisplayName();
            if (displayName == null || !Objects.equals(displayName, explicitValue)) continue;
            return allowableValue.getValue();
        }
        for (AllowableValue allowableValue : allowableValues) {
            displayName = allowableValue.getDisplayName();
            if (displayName == null || !displayName.equalsIgnoreCase(explicitValue)) continue;
            return allowableValue.getValue();
        }
        return explicitValue;
    }

    private void setProperty(PropertyDescriptor descriptor, PropertyConfiguration propertyConfiguration, Function<PropertyDescriptor, PropertyConfiguration> valueToCompareFunction) {
        PropertyConfiguration propertyModComparisonValue = valueToCompareFunction.apply(descriptor);
        PropertyConfiguration removed = (PropertyConfiguration)this.properties.remove(descriptor);
        this.properties.put(descriptor, propertyConfiguration);
        String effectiveValue = propertyConfiguration.getEffectiveValue(this.getParameterContext());
        String resolvedValue = this.resolveAllowableValue(effectiveValue, descriptor);
        if (descriptor.getControllerServiceDefinition() != null) {
            Optional.ofNullable(removed).map(_oldConfiguration -> _oldConfiguration.getEffectiveValue(this.getParameterContext())).map(oldEffectiveValue -> this.serviceProvider.getControllerServiceNode((String)oldEffectiveValue)).ifPresent(oldNode -> oldNode.removeReference(this, descriptor));
            Optional.ofNullable(resolvedValue).map(this.serviceProvider::getControllerServiceNode).ifPresent(newNode -> newNode.addReference(this, descriptor));
        }
        if (!propertyConfiguration.equals(propertyModComparisonValue)) {
            try {
                String oldValue = propertyModComparisonValue == null ? null : propertyModComparisonValue.getEffectiveValue(this.getParameterContext());
                this.onPropertyModified(descriptor, oldValue, resolvedValue);
            }
            catch (Exception e) {
                logger.error("Failed to notify {} that property {} changed", new Object[]{this, descriptor, e});
            }
        }
    }

    private boolean removeProperty(String name, boolean allowRemovalOfRequiredProperties) {
        ControllerServiceNode oldNode;
        boolean allowRemoval;
        if (null == name) {
            throw new IllegalArgumentException("Name can not be null");
        }
        PropertyDescriptor descriptor = this.getComponent().getPropertyDescriptor(name);
        boolean bl = allowRemoval = allowRemovalOfRequiredProperties || !descriptor.isRequired();
        if (!allowRemoval) {
            return false;
        }
        PropertyConfiguration propertyConfiguration = (PropertyConfiguration)this.properties.remove(descriptor);
        if (propertyConfiguration == null || propertyConfiguration.getRawValue() == null) {
            return false;
        }
        String value = propertyConfiguration.getEffectiveValue(this.getParameterContext());
        if (descriptor.getControllerServiceDefinition() != null && value != null && (oldNode = this.serviceProvider.getControllerServiceNode(value)) != null) {
            oldNode.removeReference(this, descriptor);
        }
        try {
            this.onPropertyModified(descriptor, value, null);
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), e);
        }
        return true;
    }

    @Override
    public Map<PropertyDescriptor, PropertyConfiguration> getProperties() {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, (Class)this.getComponent().getClass(), (String)this.getIdentifier());){
            List supported = this.getComponent().getPropertyDescriptors();
            if (supported == null || supported.isEmpty()) {
                Map<PropertyDescriptor, PropertyConfiguration> map = Collections.unmodifiableMap(this.properties);
                return map;
            }
            LinkedHashMap<PropertyDescriptor, Object> props = new LinkedHashMap<PropertyDescriptor, Object>();
            for (PropertyDescriptor descriptor2 : supported) {
                props.put(this.getPropertyDescriptor(descriptor2.getName()), null);
            }
            this.properties.forEach((descriptor, config) -> props.put(this.getPropertyDescriptor(descriptor.getName()), config));
            LinkedHashMap<PropertyDescriptor, Object> linkedHashMap = props;
            return linkedHashMap;
        }
    }

    @Override
    public Map<PropertyDescriptor, String> getRawPropertyValues() {
        return this.getPropertyValues((descriptor, config) -> config.getRawValue());
    }

    @Override
    public Map<PropertyDescriptor, String> getEffectivePropertyValues() {
        return this.getPropertyValues((descriptor, config) -> this.getConfigValue((PropertyConfiguration)config, this.isResolveParameter((PropertyDescriptor)descriptor, (PropertyConfiguration)config)));
    }

    private Map<PropertyDescriptor, String> getPropertyValues(BiFunction<PropertyDescriptor, PropertyConfiguration, String> valueFunction) {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, (Class)this.getComponent().getClass(), (String)this.getIdentifier());){
            List supported = this.getComponent().getPropertyDescriptors();
            LinkedHashMap<PropertyDescriptor, String> props = new LinkedHashMap<PropertyDescriptor, String>();
            for (PropertyDescriptor descriptor2 : supported) {
                if (descriptor2 == null) continue;
                PropertyDescriptor upToDateDescriptor = this.getPropertyDescriptor(descriptor2.getName());
                props.put(upToDateDescriptor, upToDateDescriptor.getDefaultValue());
            }
            this.properties.forEach((descriptor, config) -> {
                PropertyDescriptor upToDateDescriptor = this.getPropertyDescriptor(descriptor.getName());
                props.put(upToDateDescriptor, (String)valueFunction.apply(upToDateDescriptor, (PropertyConfiguration)config));
            });
            LinkedHashMap<PropertyDescriptor, String> linkedHashMap = props;
            return linkedHashMap;
        }
    }

    @Override
    public PropertyConfiguration getProperty(PropertyDescriptor property) {
        PropertyConfiguration configuration = (PropertyConfiguration)this.properties.get(property);
        return configuration == null ? PropertyConfiguration.EMPTY : configuration;
    }

    @Override
    public String getEffectivePropertyValue(PropertyDescriptor property) {
        return this.getProperty(property).getEffectiveValue(this.getParameterContext());
    }

    private String getEffectivePropertyValueWithDefault(PropertyDescriptor property) {
        String value = this.getProperty(property).getEffectiveValue(this.getParameterContext());
        if (value == null) {
            value = property.getDefaultValue();
        }
        return value;
    }

    protected String mapRawValueToEffectiveValue(String rawValue) {
        if (rawValue == null) {
            return null;
        }
        ParameterLookup parameterLookup = this.getParameterLookup();
        if (parameterLookup == null) {
            return rawValue;
        }
        ParameterTokenList parameterTokenList = new ExpressionLanguageAgnosticParameterParser().parseTokens(rawValue);
        String effectiveValue = parameterTokenList.substitute(parameterLookup);
        return effectiveValue;
    }

    @Override
    public String getRawPropertyValue(PropertyDescriptor property) {
        return this.getProperty(property).getRawValue();
    }

    @Override
    public void refreshProperties() {
        HashMap<PropertyDescriptor, PropertyConfiguration> copyOfPropertiesMap = new HashMap<PropertyDescriptor, PropertyConfiguration>(this.properties);
        for (Map.Entry entry : copyOfPropertiesMap.entrySet()) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getKey();
            PropertyConfiguration configuration = (PropertyConfiguration)entry.getValue();
            if (propertyDescriptor == null || configuration == null || configuration.getRawValue() == null) continue;
            this.setProperty(propertyDescriptor, configuration, descriptor -> this.createPropertyConfiguration(descriptor.getDefaultValue()));
        }
    }

    private PropertyConfiguration createPropertyConfiguration(String value) {
        ExpressionLanguageAwareParameterParser parser = new ExpressionLanguageAwareParameterParser();
        ParameterTokenList references = parser.parseTokens(value);
        VariableImpact variableImpact = Query.prepare((String)value).getVariableImpact();
        return new PropertyConfiguration(value, references, references.toReferenceList(), variableImpact);
    }

    @Override
    public synchronized boolean isReloadAdditionalResourcesNecessary() {
        if (this.additionalResourcesFingerprint == null) {
            return false;
        }
        Set<PropertyDescriptor> descriptors = this.getProperties().keySet();
        Set<URL> additionalUrls = this.getAdditionalClasspathResources(descriptors);
        String newFingerprint = ClassLoaderUtils.generateAdditionalUrlsFingerprint(additionalUrls, (String)this.determineClasloaderIsolationKey());
        return !StringUtils.equals((CharSequence)this.additionalResourcesFingerprint, (CharSequence)newFingerprint);
    }

    @Override
    public synchronized void reloadAdditionalResourcesIfNecessary() {
        Set<URL> additionalUrls;
        String newFingerprint;
        Set<PropertyDescriptor> descriptors = this.getProperties().keySet();
        boolean dynamicallyModifiesClasspath = descriptors.stream().anyMatch(PropertyDescriptor::isDynamicClasspathModifier);
        String isolationKey = this.determineClasloaderIsolationKey();
        if ((dynamicallyModifiesClasspath || isolationKey != null) && !StringUtils.equals((CharSequence)this.additionalResourcesFingerprint, (CharSequence)(newFingerprint = ClassLoaderUtils.generateAdditionalUrlsFingerprint(additionalUrls = this.getAdditionalClasspathResources(descriptors, this::getEffectivePropertyValueWithDefault), (String)isolationKey)))) {
            this.setAdditionalResourcesFingerprint(newFingerprint);
            try {
                logger.info("Updating classpath for [{}] with the ID [{}]", (Object)this.componentType, (Object)this.getIdentifier());
                this.reload(additionalUrls);
            }
            catch (Exception e) {
                logger.error("Error reloading component with id [{}]: {}", new Object[]{this.id, e.getMessage(), e});
            }
        }
    }

    public int hashCode() {
        return 273171 * this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentNode)) {
            return false;
        }
        ComponentNode other = (ComponentNode)obj;
        return this.id.equals(other.getIdentifier());
    }

    public String toString() {
        String string;
        block8: {
            NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, (Class)this.getComponent().getClass(), (String)this.getComponent().getIdentifier());
            try {
                string = this.getComponent().toString();
                if (narCloseable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (narCloseable != null) {
                        try {
                            narCloseable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return this.getClass().getSimpleName() + "[id=" + this.getIdentifier() + "]";
                }
            }
            narCloseable.close();
        }
        return string;
    }

    @Override
    public ValidationState performValidation(Map<PropertyDescriptor, PropertyConfiguration> properties, String annotationData, ParameterContext parameterContext) {
        ValidationContext validationContext = this.validationContextFactory.newValidationContext(properties, annotationData, this.getProcessGroupIdentifier(), this.getIdentifier(), parameterContext, true);
        return this.performValidation(validationContext);
    }

    @Override
    public ValidationState performValidation(ValidationContext validationContext) {
        Collection<ValidationResult> results;
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, (Class)this.getComponent().getClass(), (String)this.getIdentifier());){
            results = this.computeValidationErrors(validationContext);
        }
        ValidationStatus status = results.isEmpty() ? ValidationStatus.VALID : ValidationStatus.INVALID;
        ValidationState validationState = new ValidationState(status, results);
        return validationState;
    }

    @Override
    public final ValidationStatus performValidation() {
        ValidationContext validationContext;
        ValidationState updatedState;
        ValidationState validationState;
        boolean replaced;
        while (!(replaced = this.replaceValidationState(validationState = this.getValidationState(), updatedState = this.performValidation(validationContext = this.getValidationContext())))) {
        }
        return updatedState.getStatus();
    }

    protected Collection<ValidationResult> computeValidationErrors(ValidationContext validationContext) {
        Throwable failureCause = null;
        try {
            AsyncLoadedProcessor asyncLoadedProcessor;
            if (!this.sensitiveDynamicPropertyNames.get().isEmpty() && !this.isSupportsSensitiveDynamicProperties()) {
                return Collections.singletonList(new ValidationResult.Builder().subject("Component").valid(false).explanation(String.format("Sensitive Dynamic Properties %s configured but not supported", this.sensitiveDynamicPropertyNames)).build());
            }
            ConfigurableComponent component = this.getComponent();
            if (component instanceof AsyncLoadedProcessor && !(asyncLoadedProcessor = (AsyncLoadedProcessor)component).isLoaded()) {
                String explanation = switch (asyncLoadedProcessor.getState()) {
                    case AsyncLoadedProcessor.LoadState.INITIALIZING_ENVIRONMENT -> "Initializing runtime environment for the Processor.";
                    case AsyncLoadedProcessor.LoadState.DEPENDENCY_DOWNLOAD_FAILED -> "Failed to download one or more Processor dependencies. See logs for additional details.";
                    case AsyncLoadedProcessor.LoadState.DOWNLOADING_DEPENDENCIES -> "In the process of downloading third-party dependencies required by the Processor.";
                    case AsyncLoadedProcessor.LoadState.LOADING_PROCESSOR_CODE -> "In the process of loading Processor code";
                    case AsyncLoadedProcessor.LoadState.LOADING_PROCESSOR_CODE_FAILED -> "Failed to parse or load Processor code. See logs for additional details.";
                    default -> null;
                };
                return Collections.singletonList(new ValidationResult.Builder().subject("Processor").explanation(explanation).valid(false).build());
            }
            List<ValidationResult> invalidParameterResults = this.validateParameterReferences(validationContext);
            invalidParameterResults.addAll(this.validateConfig());
            if (!invalidParameterResults.isEmpty()) {
                return invalidParameterResults;
            }
            Collection results = this.getComponent().validate(validationContext);
            ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(results);
            Collection<ValidationResult> referencedServiceValidationResults = this.validateReferencedControllerServices(validationContext);
            validationResults.addAll(referencedServiceValidationResults);
            this.performFlowAnalysisOnThis();
            this.getValidationContextFactory().getRuleViolationsManager().ifPresent(ruleViolationsManager -> {
                Collection<RuleViolation> ruleViolations = ruleViolationsManager.getRuleViolationsForSubject(this.getIdentifier());
                for (RuleViolation ruleViolation : ruleViolations) {
                    if (ruleViolation.getEnforcementPolicy() != EnforcementPolicy.ENFORCE) continue;
                    validationResults.add(new ValidationResult.Builder().subject(this.getComponent().getClass().getSimpleName()).valid(false).explanation(ruleViolation.getViolationMessage()).build());
                }
            });
            logger.debug("Computed validation errors with Validation Context {}; results = {}", (Object)validationContext, validationResults);
            return validationResults;
        }
        catch (ControllerServiceDisabledException e) {
            this.getLogger().debug("Failed to perform validation", e);
            return Collections.singleton(new DisabledServiceValidationResult("Component", e.getControllerServiceId(), "performing validation depends on referencing a Controller Service that is currently disabled"));
        }
        catch (Exception e) {
            this.getLogger().debug("Failed to perform validation", e);
            failureCause = e;
        }
        catch (Error e) {
            this.getLogger().error("Failed to perform validation", e);
            failureCause = e;
        }
        return Collections.singleton(new ValidationResult.Builder().subject("Component").valid(false).explanation("Failed to perform validation due to " + String.valueOf(failureCause)).build());
    }

    protected abstract List<ValidationResult> validateConfig();

    private List<ValidationResult> validateParameterReferences(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        ParameterContext parameterContext = this.getParameterContext();
        boolean assignedToProcessGroup = this.getProcessGroupIdentifier() != null;
        ConfigurableComponent component = this.getComponent();
        for (PropertyDescriptor propertyDescriptor : validationContext.getProperties().keySet()) {
            boolean dependencySatisfied = validationContext.isDependencySatisfied(propertyDescriptor, arg_0 -> ((ConfigurableComponent)component).getPropertyDescriptor(arg_0));
            if (!dependencySatisfied) continue;
            Collection referencedParameters = validationContext.getReferencedParameters(propertyDescriptor.getName());
            if (parameterContext == null && !referencedParameters.isEmpty()) {
                results.add(new ValidationResult.Builder().subject(propertyDescriptor.getDisplayName()).valid(false).explanation(assignedToProcessGroup ? "Property references one or more Parameters but no Parameter Context is currently set on the Process Group" : "Property references one or more Parameters, but Parameters may be referenced only by Processors and Controller Services that reside within a Process Group.").build());
                continue;
            }
            for (String paramName : referencedParameters) {
                ParameterDescriptor parameterDescriptor;
                if (!validationContext.isParameterDefined(paramName)) {
                    results.add(new ValidationResult.Builder().subject(propertyDescriptor.getDisplayName()).valid(false).explanation("Property references Parameter '" + paramName + "' but the currently selected Parameter Context does not have a Parameter with that name").build());
                    continue;
                }
                Optional parameterRef = parameterContext.getParameter(paramName);
                if (!parameterRef.isPresent() || (parameterDescriptor = ((Parameter)parameterRef.get()).getDescriptor()).isSensitive() == propertyDescriptor.isSensitive()) continue;
                results.add(new ValidationResult.Builder().subject(propertyDescriptor.getDisplayName()).valid(false).explanation("The property '" + propertyDescriptor.getDisplayName() + "' cannot reference Parameter '" + parameterDescriptor.getName() + "' because the Sensitivity of the parameter does not match the Sensitivity of the property.").build());
            }
        }
        return results;
    }

    protected final Collection<ValidationResult> validateReferencedControllerServices(ValidationContext validationContext) {
        Set propertyDescriptors = validationContext.getProperties().keySet();
        ConfigurableComponent component = this.getComponent();
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            String controllerServiceId;
            boolean dependencySatisfied;
            if (descriptor.getControllerServiceDefinition() == null || !(dependencySatisfied = validationContext.isDependencySatisfied(descriptor, arg_0 -> ((ConfigurableComponent)component).getPropertyDescriptor(arg_0))) || (controllerServiceId = validationContext.getProperty(descriptor).getValue()) == null) continue;
            ControllerServiceNode controllerServiceNode = this.getControllerServiceProvider().getControllerServiceNode(controllerServiceId);
            if (controllerServiceNode == null) {
                ValidationResult result = this.createInvalidResult(controllerServiceId, descriptor.getDisplayName(), "Invalid Controller Service: " + controllerServiceId + " is not a valid Controller Service Identifier");
                validationResults.add(result);
                continue;
            }
            ValidationResult apiResult = this.validateControllerServiceApi(descriptor, controllerServiceNode);
            if (apiResult != null) {
                validationResults.add(apiResult);
                continue;
            }
            if (!controllerServiceNode.isActive()) {
                boolean csGroupStateless;
                ProcessGroup processGroup = this.getParentProcessGroup().orElse(null);
                ProcessGroup csGroup = controllerServiceNode.getProcessGroup();
                boolean bl = csGroupStateless = csGroup != null && csGroup.resolveExecutionEngine() == ExecutionEngine.STATELESS;
                if (processGroup != null && processGroup.resolveExecutionEngine() != ExecutionEngine.STANDARD && csGroupStateless) continue;
                validationResults.add(new DisabledServiceValidationResult(descriptor.getDisplayName(), controllerServiceId));
                continue;
            }
            if (ControllerServiceState.ENABLING != controllerServiceNode.getState()) continue;
            validationResults.add(new EnablingServiceValidationResult(descriptor.getDisplayName(), controllerServiceId));
        }
        return validationResults;
    }

    private ValidationResult validateControllerServiceApi(PropertyDescriptor descriptor, ControllerServiceNode controllerServiceNode) {
        boolean matchesApiByBundleCoordinates;
        Class controllerServiceApiClass = descriptor.getControllerServiceDefinition();
        if (controllerServiceApiClass.equals(ControllerService.class)) {
            return null;
        }
        ClassLoader controllerServiceApiClassLoader = controllerServiceApiClass.getClassLoader();
        ExtensionManager extensionManager = this.serviceProvider.getExtensionManager();
        String serviceId = controllerServiceNode.getIdentifier();
        String propertyName = descriptor.getDisplayName();
        Bundle controllerServiceApiBundle = extensionManager.getBundle(controllerServiceApiClassLoader);
        if (controllerServiceApiBundle == null) {
            return this.createInvalidResult(serviceId, propertyName, "Unable to find bundle for ControllerService API class " + controllerServiceApiClass.getCanonicalName());
        }
        BundleCoordinate controllerServiceApiCoordinate = controllerServiceApiBundle.getBundleDetails().getCoordinate();
        Bundle controllerServiceBundle = extensionManager.getBundle(controllerServiceNode.getBundleCoordinate());
        if (controllerServiceBundle == null) {
            List possibleBundles = extensionManager.getBundles(controllerServiceNode.getControllerServiceImplementation().getClass().getName());
            if (possibleBundles.size() != 1) {
                return this.createInvalidResult(serviceId, propertyName, "Unable to find bundle for coordinate " + String.valueOf(controllerServiceNode.getBundleCoordinate()));
            }
            controllerServiceBundle = (Bundle)possibleBundles.get(0);
            matchesApiByBundleCoordinates = false;
        } else {
            matchesApiByBundleCoordinates = this.matchesApiBundleCoordinates(extensionManager, controllerServiceBundle, controllerServiceApiCoordinate);
        }
        BundleCoordinate controllerServiceCoordinate = controllerServiceBundle.getBundleDetails().getCoordinate();
        if (!matchesApiByBundleCoordinates) {
            Class controllerServiceImplClass = controllerServiceNode.getControllerServiceImplementation().getClass();
            logger.debug("Comparing methods from service api '{}' against service implementation '{}'", new Object[]{controllerServiceApiClass.getCanonicalName(), controllerServiceImplClass.getCanonicalName()});
            ControllerServiceApiMatcher controllerServiceApiMatcher = new ControllerServiceApiMatcher();
            boolean matchesApi = controllerServiceApiMatcher.matches(controllerServiceApiClass, controllerServiceImplClass);
            if (!matchesApi) {
                String controllerServiceType = controllerServiceNode.getComponentType();
                String controllerServiceApiType = controllerServiceApiClass.getSimpleName();
                String explanation = controllerServiceType + " - " + controllerServiceCoordinate.getVersion() + " from " + controllerServiceCoordinate.getGroup() + " - " + controllerServiceCoordinate.getId() + " is not compatible with " + controllerServiceApiType + " - " + controllerServiceApiCoordinate.getVersion() + " from " + controllerServiceApiCoordinate.getGroup() + " - " + controllerServiceApiCoordinate.getId();
                return this.createInvalidResult(serviceId, propertyName, explanation);
            }
        }
        return null;
    }

    protected void performFlowAnalysisOnThis() {
    }

    private ValidationResult createInvalidResult(String serviceId, String propertyName, String explanation) {
        return new ValidationResult.Builder().input(serviceId).subject(propertyName).valid(false).explanation(explanation).build();
    }

    private boolean matchesApiBundleCoordinates(ExtensionManager extensionManager, Bundle controllerServiceImplBundle, BundleCoordinate requiredApiCoordinate) {
        BundleCoordinate controllerServiceDependencyCoordinate = controllerServiceImplBundle.getBundleDetails().getCoordinate();
        boolean foundApiDependency = false;
        while (controllerServiceDependencyCoordinate != null) {
            if (requiredApiCoordinate.equals((Object)controllerServiceDependencyCoordinate)) {
                foundApiDependency = true;
                break;
            }
            Bundle controllerServiceDependencyBundle = extensionManager.getBundle(controllerServiceDependencyCoordinate);
            if (controllerServiceDependencyBundle == null) {
                controllerServiceDependencyCoordinate = null;
                continue;
            }
            controllerServiceDependencyCoordinate = controllerServiceDependencyBundle.getBundleDetails().getDependencyCoordinate();
        }
        return foundApiDependency;
    }

    @Override
    public boolean isSensitiveDynamicProperty(String name) {
        Objects.requireNonNull(name, "Property Name required");
        return this.sensitiveDynamicPropertyNames.get().contains(name);
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String name) {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, (Class)this.getComponent().getClass(), (String)this.getComponent().getIdentifier());){
            PropertyDescriptor propertyDescriptor = this.getComponent().getPropertyDescriptor(name);
            if (propertyDescriptor.isDynamic() && this.isSensitiveDynamicProperty(name)) {
                PropertyDescriptor propertyDescriptor2 = new PropertyDescriptor.Builder().fromPropertyDescriptor(propertyDescriptor).sensitive(true).build();
                return propertyDescriptor2;
            }
            PropertyDescriptor propertyDescriptor3 = propertyDescriptor;
            return propertyDescriptor3;
        }
    }

    @Override
    public List<PropertyDescriptor> getPropertyDescriptors() {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, (Class)this.getComponent().getClass(), (String)this.getComponent().getIdentifier());){
            List list = this.getComponent().getPropertyDescriptors();
            return list;
        }
    }

    protected void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, (Class)this.getComponent().getClass(), (String)this.getComponent().getIdentifier());){
            this.getComponent().onPropertyModified(descriptor, oldValue, newValue);
        }
    }

    @Override
    public void onParametersModified(Map<String, ParameterUpdate> updatedParameters) {
        if (!this.isReferencingParameter()) {
            return;
        }
        ParameterLookup previousParameterLookup = this.createParameterLookupForPreviousValues(updatedParameters);
        boolean componentAffected = false;
        for (String string : updatedParameters.keySet()) {
            if (!this.isReferencingParameter(string)) continue;
            componentAffected = true;
            break;
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            String updatedValue;
            boolean propertyUpdated;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getKey();
            PropertyConfiguration configuration = (PropertyConfiguration)entry.getValue();
            boolean propertyAffected = false;
            List<ParameterReference> parameterReferences = configuration.getParameterReferences();
            for (ParameterReference reference : parameterReferences) {
                String referencedParamName = reference.getParameterName();
                if (!updatedParameters.containsKey(referencedParamName)) continue;
                propertyAffected = true;
                break;
            }
            if (!propertyAffected) continue;
            String previousValue = configuration.getEffectiveValue(previousParameterLookup);
            boolean bl = propertyUpdated = !Objects.equals(previousValue, updatedValue = configuration.getEffectiveValue(this.getParameterContext()));
            if (propertyUpdated) {
                try {
                    logger.debug("Parameter Context updated, resulting in property {} of {} changing. Calling onPropertyModified().", (Object)propertyDescriptor, (Object)this);
                    this.onPropertyModified(propertyDescriptor, previousValue, updatedValue);
                }
                catch (Exception e) {
                    logger.error("Failed to notify {} that property {} changed", new Object[]{this, propertyDescriptor, e});
                }
                continue;
            }
            logger.debug("Parameter Context updated, and property {} of {} does reference the updated Parameters. However, the overall property value remained unchanged so will not call onPropertyModified().", (Object)propertyDescriptor, (Object)this);
        }
        if (componentAffected) {
            logger.debug("Configuration of {} changed due to an update to Parameter Context. Resetting validation state", (Object)this);
            this.resetValidationState();
        }
    }

    protected void incrementReferenceCounts(String parameterName) {
        this.parameterReferenceCounts.merge(parameterName, 1, (a, b) -> a == -1 ? null : Integer.valueOf(a + b));
    }

    protected void decrementReferenceCounts(String parameterName) {
        this.parameterReferenceCounts.merge(parameterName, -1, (a, b) -> a == 1 ? null : Integer.valueOf(a + b));
    }

    private ParameterLookup createParameterLookupForPreviousValues(final Map<String, ParameterUpdate> updatedParameters) {
        final ParameterContext currentContext = this.getParameterContext();
        return new ParameterLookup(){

            public Optional<Parameter> getParameter(String parameterName) {
                boolean isProvided;
                ParameterDescriptor parameterDescriptor;
                Optional optionalParameter = currentContext == null ? Optional.empty() : currentContext.getParameter(parameterName);
                ParameterUpdate parameterUpdate = (ParameterUpdate)updatedParameters.get(parameterName);
                if (parameterUpdate == null) {
                    return optionalParameter;
                }
                if (optionalParameter.isPresent()) {
                    Parameter previousParameter = (Parameter)optionalParameter.get();
                    parameterDescriptor = previousParameter.getDescriptor();
                    isProvided = previousParameter.isProvided();
                } else {
                    parameterDescriptor = new ParameterDescriptor.Builder().name(parameterName).description("").sensitive(true).build();
                    isProvided = false;
                }
                Parameter updatedParameter = new Parameter.Builder().descriptor(parameterDescriptor).value(parameterUpdate.getPreviousValue()).provided(Boolean.valueOf(isProvided)).build();
                return Optional.of(updatedParameter);
            }

            public boolean isEmpty() {
                return (currentContext == null || currentContext.isEmpty()) && updatedParameters.isEmpty();
            }

            public long getVersion() {
                return 0L;
            }
        };
    }

    @Override
    public ValidationStatus getValidationStatus() {
        return this.validationState.get().getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidationStatus getValidationStatus(long timeout, TimeUnit timeUnit) {
        long millis = timeUnit.toMillis(timeout);
        long maxTime = System.currentTimeMillis() + millis;
        AtomicReference<ValidationState> atomicReference = this.validationState;
        synchronized (atomicReference) {
            while (this.getValidationStatus() == ValidationStatus.VALIDATING) {
                try {
                    long waitMillis = Math.max(0L, maxTime - System.currentTimeMillis());
                    if (waitMillis <= 0L) break;
                    this.validationState.wait(waitMillis);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return this.getValidationStatus();
                }
            }
            return this.getValidationStatus();
        }
    }

    protected ValidationState getValidationState() {
        return this.validationState.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replaceValidationState(ValidationState expectedState, ValidationState newState) {
        AtomicReference<ValidationState> atomicReference = this.validationState;
        synchronized (atomicReference) {
            if (this.validationState.compareAndSet(expectedState, newState)) {
                this.validationState.notifyAll();
                return true;
            }
            return false;
        }
    }

    @Override
    public void resetValidationState() {
        this.lock.lock();
        try {
            if (!this.isValidationNecessary()) {
                logger.debug("Triggered to reset validation state of {} but will leave validation state as {} because validation is not necessary in its current state", (Object)this, (Object)this.validationState.get());
                return;
            }
            this.validationContext = null;
            this.validationState.set(new ValidationState(ValidationStatus.VALIDATING, Collections.emptyList()));
            if (this.isTriggerValidation()) {
                this.validationTrigger.triggerAsync(this);
            } else {
                logger.debug("Reset validation state of {} but will not trigger async validation because trigger has been paused", (Object)this);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void pauseValidationTrigger() {
        this.triggerValidation = false;
    }

    @Override
    public void resumeValidationTrigger() {
        this.triggerValidation = true;
        logger.debug("Resuming Triggering of Validation State for {}; Resetting validation state", (Object)this);
        this.resetValidationState();
    }

    private boolean isTriggerValidation() {
        return this.triggerValidation;
    }

    @Override
    public Collection<ValidationResult> getValidationErrors() {
        return this.getValidationErrors(Collections.emptySet());
    }

    protected Collection<ValidationResult> getValidationErrors(Set<ControllerServiceNode> servicesToIgnore) {
        ValidationState validationState = this.validationState.get();
        if (validationState.getStatus() == ValidationStatus.VALIDATING) {
            return null;
        }
        Collection<ValidationResult> validationErrors = validationState.getValidationErrors();
        if (servicesToIgnore == null || servicesToIgnore.isEmpty()) {
            return validationErrors;
        }
        Set ignoredServiceIds = servicesToIgnore.stream().map(ComponentNode::getIdentifier).collect(Collectors.toSet());
        ArrayList<ValidationResult> retainedValidationErrors = new ArrayList<ValidationResult>();
        for (ValidationResult result : validationErrors) {
            if (!(result instanceof DisabledServiceValidationResult)) {
                retainedValidationErrors.add(result);
                continue;
            }
            String serviceId = ((DisabledServiceValidationResult)result).getControllerServiceIdentifier();
            if (ignoredServiceIds.contains(serviceId)) continue;
            retainedValidationErrors.add(result);
        }
        return retainedValidationErrors;
    }

    public abstract void verifyModifiable() throws IllegalStateException;

    ControllerServiceProvider getControllerServiceProvider() {
        return this.serviceProvider;
    }

    @Override
    public String getCanonicalClassName() {
        return this.componentCanonicalClass;
    }

    @Override
    public String getComponentType() {
        return this.componentType;
    }

    protected ValidationContextFactory getValidationContextFactory() {
        return this.validationContextFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValidationContext getValidationContext() {
        this.lock.lock();
        try {
            ValidationContext context = this.validationContext;
            if (context != null) {
                ValidationContext validationContext = context;
                return validationContext;
            }
            boolean cacheValidationContext = true;
            ConfigurableComponent configurableComponent = this.getComponent();
            if (configurableComponent instanceof AsyncLoadedProcessor) {
                AsyncLoadedProcessor asyncLoadedProcessor = (AsyncLoadedProcessor)configurableComponent;
                cacheValidationContext = asyncLoadedProcessor.isLoaded();
            }
            context = this.getValidationContextFactory().newValidationContext(this.getProperties(), this.getAnnotationData(), this.getProcessGroupIdentifier(), this.getIdentifier(), this.getParameterContext(), true);
            if (cacheValidationContext) {
                this.validationContext = context;
                logger.debug("Updating validation context to {}", (Object)context);
            }
            ValidationContext validationContext = context;
            return validationContext;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected ReloadComponent getReloadComponent() {
        return this.reloadComponent;
    }

    protected ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Override
    public void verifyCanUpdateBundle(BundleCoordinate incomingCoordinate) throws IllegalArgumentException {
        BundleCoordinate existingCoordinate = this.getBundleCoordinate();
        if (!(existingCoordinate.equals((Object)incomingCoordinate) || existingCoordinate.getGroup().equals(incomingCoordinate.getGroup()) && existingCoordinate.getId().equals(incomingCoordinate.getId()))) {
            throw new IllegalArgumentException(String.format("Unable to update component %s from %s to %s because bundle group and id must be the same.", this.getIdentifier(), existingCoordinate.getCoordinate(), incomingCoordinate.getCoordinate()));
        }
    }

    protected void setAdditionalResourcesFingerprint(String additionalResourcesFingerprint) {
        this.additionalResourcesFingerprint = additionalResourcesFingerprint;
    }

    private boolean isResolveParameter(PropertyDescriptor descriptor, PropertyConfiguration config) {
        boolean okToResolve = true;
        ParameterContext context = this.getParameterContext();
        if (context == null) {
            return false;
        }
        for (ParameterReference reference : config.getParameterReferences()) {
            boolean paramIsSensitive;
            String parameterName = reference.getParameterName();
            Optional optionalParameter = context.getParameter(parameterName);
            if (!optionalParameter.isPresent() || (paramIsSensitive = ((Parameter)optionalParameter.get()).getDescriptor().isSensitive()) == descriptor.isSensitive()) continue;
            okToResolve = false;
            break;
        }
        return okToResolve;
    }

    private String getConfigValue(PropertyConfiguration config, boolean okToResolve) {
        return okToResolve ? config.getEffectiveValue(this.getParameterContext()) : config.getRawValue();
    }

    protected abstract ParameterContext getParameterContext();

    @Override
    public boolean isReferencingParameter(String parameterName) {
        return this.parameterReferenceCounts.containsKey(parameterName);
    }
}

