/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.tenant;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.authorization.User;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.TenantsClient;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;

public class CreateUser
extends AbstractNiFiRegistryCommand<StringResult> {
    public CreateUser() {
        super("create-user", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates a new user.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.USER_NAME.createOption());
    }

    @Override
    public StringResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        TenantsClient tenantsClient = client.getTenantsClient();
        String userName = this.getRequiredArg(properties, CommandOption.USER_NAME);
        User user = new User(null, userName);
        User createdUser = tenantsClient.createUser(user);
        return new StringResult(createdUser.getIdentifier(), this.getContext().isInteractive());
    }
}

