/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.minifi.commons.service.FlowSerDeService;

public class StandardFlowSerDeService
implements FlowSerDeService {
    private final ObjectMapper objectMapper;

    StandardFlowSerDeService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public static StandardFlowSerDeService defaultInstance() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_NULL));
        objectMapper.setAnnotationIntrospector((AnnotationIntrospector)new JakartaXmlBindAnnotationIntrospector(objectMapper.getTypeFactory()));
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return new StandardFlowSerDeService(objectMapper);
    }

    public byte[] serialize(VersionedDataflow flow) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            JsonFactory factory = new JsonFactory();
            JsonGenerator generator = factory.createGenerator((OutputStream)byteArrayOutputStream);
            generator.setCodec((ObjectCodec)this.objectMapper);
            generator.writeObject((Object)flow);
            generator.flush();
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new FlowSerializationException("Unable to serialize flow", (Throwable)e);
            }
        }
        byteArrayOutputStream.close();
        return byArray;
    }

    public VersionedDataflow deserialize(byte[] flow) {
        try {
            return (VersionedDataflow)this.objectMapper.readValue(flow, VersionedDataflow.class);
        }
        catch (Exception e) {
            throw new FlowSerializationException("Unable to deserialize flow", (Throwable)e);
        }
    }
}

