/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.authorization.AccessPolicySummary;
import org.apache.nifi.registry.authorization.CurrentUser;
import org.apache.nifi.registry.authorization.Permissions;
import org.apache.nifi.registry.authorization.ResourcePermissions;
import org.apache.nifi.registry.authorization.Tenant;
import org.apache.nifi.registry.authorization.UserGroup;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.exception.ResourceNotFoundException;
import org.apache.nifi.registry.security.authorization.AccessPolicy;
import org.apache.nifi.registry.security.authorization.AccessPolicyProvider;
import org.apache.nifi.registry.security.authorization.AccessPolicyProviderInitializationContext;
import org.apache.nifi.registry.security.authorization.AuthorizableLookup;
import org.apache.nifi.registry.security.authorization.Authorizer;
import org.apache.nifi.registry.security.authorization.AuthorizerCapabilityDetection;
import org.apache.nifi.registry.security.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.ConfigurableAccessPolicyProvider;
import org.apache.nifi.registry.security.authorization.ConfigurableUserGroupProvider;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.ManagedAuthorizer;
import org.apache.nifi.registry.security.authorization.RequestAction;
import org.apache.nifi.registry.security.authorization.Resource;
import org.apache.nifi.registry.security.authorization.UntrustedProxyException;
import org.apache.nifi.registry.security.authorization.User;
import org.apache.nifi.registry.security.authorization.UserAndGroups;
import org.apache.nifi.registry.security.authorization.UserGroupProvider;
import org.apache.nifi.registry.security.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.registry.security.authorization.exception.AccessDeniedException;
import org.apache.nifi.registry.security.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.registry.security.authorization.resource.Authorizable;
import org.apache.nifi.registry.security.authorization.resource.ResourceFactory;
import org.apache.nifi.registry.security.authorization.resource.ResourceType;
import org.apache.nifi.registry.security.authorization.user.NiFiUser;
import org.apache.nifi.registry.security.authorization.user.NiFiUserUtils;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.exception.SecurityProviderDestructionException;
import org.apache.nifi.registry.service.RegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthorizationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationService.class);
    public static final String MSG_NON_MANAGED_AUTHORIZER = "This NiFi Registry is not configured to internally manage users, groups, or policies. Please contact your system administrator.";
    public static final String MSG_NON_CONFIGURABLE_POLICIES = "This NiFi Registry is not configured to allow configurable policies. Please contact your system administrator.";
    public static final String MSG_NON_CONFIGURABLE_USERS = "This NiFi Registry is not configured to allow configurable users and groups. Please contact your system administrator.";
    private AuthorizableLookup authorizableLookup;
    private Authorizer authorizer;
    private RegistryService registryService;
    private UserGroupProvider userGroupProvider;
    private AccessPolicyProvider accessPolicyProvider;

    @Autowired
    public AuthorizationService(AuthorizableLookup authorizableLookup, Authorizer authorizer, RegistryService registryService) {
        this.authorizableLookup = authorizableLookup;
        this.authorizer = authorizer;
        this.registryService = registryService;
        this.accessPolicyProvider = AuthorizerCapabilityDetection.isManagedAuthorizer(this.authorizer) ? ((ManagedAuthorizer)authorizer).getAccessPolicyProvider() : AuthorizationService.createExceptionThrowingAccessPolicyProvider();
        this.userGroupProvider = this.accessPolicyProvider.getUserGroupProvider();
    }

    public AuthorizableLookup getAuthorizableLookup() {
        return this.authorizableLookup;
    }

    public void authorize(Authorizable authorizable, RequestAction action) throws AccessDeniedException {
        authorizable.authorize(this.authorizer, action, NiFiUserUtils.getNiFiUser());
    }

    public boolean isManagedAuthorizer() {
        return AuthorizerCapabilityDetection.isManagedAuthorizer(this.authorizer);
    }

    public boolean isConfigurableUserGroupProvider() {
        return AuthorizerCapabilityDetection.isConfigurableUserGroupProvider(this.authorizer);
    }

    public boolean isConfigurableAccessPolicyProvider() {
        return AuthorizerCapabilityDetection.isConfigurableAccessPolicyProvider(this.authorizer);
    }

    public void verifyAuthorizerIsManaged() {
        if (!this.isManagedAuthorizer()) {
            throw new IllegalStateException(MSG_NON_MANAGED_AUTHORIZER);
        }
    }

    public void verifyAuthorizerSupportsConfigurablePolicies() {
        if (!this.isConfigurableAccessPolicyProvider()) {
            this.verifyAuthorizerIsManaged();
            throw new IllegalStateException(MSG_NON_CONFIGURABLE_POLICIES);
        }
    }

    public void verifyAuthorizerSupportsConfigurableUserGroups() {
        if (!this.isConfigurableUserGroupProvider()) {
            throw new IllegalStateException(MSG_NON_CONFIGURABLE_USERS);
        }
    }

    public CurrentUser getCurrentUser() {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        CurrentUser currentUser = new CurrentUser();
        currentUser.setIdentity(user.getIdentity());
        currentUser.setAnonymous(user.isAnonymous());
        currentUser.setResourcePermissions(this.getTopLevelPermissions());
        return currentUser;
    }

    public Permissions getPermissionsForResource(Authorizable authorizableResource) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        Permissions permissions = new Permissions();
        permissions.setCanRead(authorizableResource.isAuthorized(this.authorizer, RequestAction.READ, user));
        permissions.setCanWrite(authorizableResource.isAuthorized(this.authorizer, RequestAction.WRITE, user));
        permissions.setCanDelete(authorizableResource.isAuthorized(this.authorizer, RequestAction.DELETE, user));
        return permissions;
    }

    public Permissions getPermissionsForResource(Authorizable authorizableResource, Permissions knownParentAuthorizablePermissions) {
        if (knownParentAuthorizablePermissions == null) {
            return this.getPermissionsForResource(authorizableResource);
        }
        Permissions permissions = new Permissions(knownParentAuthorizablePermissions);
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (!permissions.getCanRead()) {
            permissions.setCanRead(authorizableResource.isAuthorized(this.authorizer, RequestAction.READ, user));
        }
        if (!permissions.getCanWrite()) {
            permissions.setCanWrite(authorizableResource.isAuthorized(this.authorizer, RequestAction.WRITE, user));
        }
        if (!permissions.getCanDelete()) {
            permissions.setCanDelete(authorizableResource.isAuthorized(this.authorizer, RequestAction.DELETE, user));
        }
        return permissions;
    }

    private ResourcePermissions getTopLevelPermissions() {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        ResourcePermissions resourcePermissions = new ResourcePermissions();
        Permissions bucketsPermissions = this.getPermissionsForResource(this.authorizableLookup.getBucketsAuthorizable());
        resourcePermissions.setBuckets(bucketsPermissions);
        Permissions policiesPermissions = this.getPermissionsForResource(this.authorizableLookup.getPoliciesAuthorizable());
        resourcePermissions.setPolicies(policiesPermissions);
        Permissions tenantsPermissions = this.getPermissionsForResource(this.authorizableLookup.getTenantsAuthorizable());
        resourcePermissions.setTenants(tenantsPermissions);
        Permissions proxyPermissions = this.getPermissionsForResource(this.authorizableLookup.getProxyAuthorizable());
        resourcePermissions.setProxy(proxyPermissions);
        return resourcePermissions;
    }

    public org.apache.nifi.registry.authorization.User createUser(org.apache.nifi.registry.authorization.User user) {
        this.verifyUserGroupProviderIsConfigurable();
        if (StringUtils.isBlank((CharSequence)user.getIdentity())) {
            throw new IllegalArgumentException("User identity must be specified when creating a new user.");
        }
        User createdUser = this.configurableUserGroupProvider().addUser(AuthorizationService.userFromDTO(user));
        return this.userToDTO(createdUser);
    }

    public List<org.apache.nifi.registry.authorization.User> getUsers() {
        return this.userGroupProvider.getUsers().stream().map(this::userToDTO).collect(Collectors.toList());
    }

    public org.apache.nifi.registry.authorization.User getUser(String identifier) {
        User user = this.userGroupProvider.getUser(identifier);
        if (user == null) {
            LOGGER.warn("The specified user id [{}] does not exist.", (Object)identifier);
            throw new ResourceNotFoundException("The specified user ID does not exist in this registry.");
        }
        return this.userToDTO(user);
    }

    public org.apache.nifi.registry.authorization.User getUserByIdentity(String identity) {
        User user = this.userGroupProvider.getUserByIdentity(identity);
        if (user == null) {
            LOGGER.warn("The specified user identity [{}] does not exist.", (Object)identity);
            throw new ResourceNotFoundException("The specified user ID does not exist in this registry.");
        }
        return this.userToDTO(user);
    }

    public void verifyUserExists(String identifier) {
        User user = this.userGroupProvider.getUser(identifier);
        if (user == null) {
            LOGGER.warn("The specified user id [{}] does not exist.", (Object)identifier);
            throw new ResourceNotFoundException("The specified user ID does not exist in this registry.");
        }
    }

    public org.apache.nifi.registry.authorization.User updateUser(org.apache.nifi.registry.authorization.User user) {
        this.verifyUserGroupProviderIsConfigurable();
        User updatedUser = this.configurableUserGroupProvider().updateUser(AuthorizationService.userFromDTO(user));
        if (updatedUser == null) {
            LOGGER.warn("The specified user id [{}] does not exist.", (Object)user.getIdentifier());
            throw new ResourceNotFoundException("The specified user ID does not exist in this registry.");
        }
        return this.userToDTO(updatedUser);
    }

    public org.apache.nifi.registry.authorization.User deleteUser(String identifier) {
        this.verifyUserGroupProviderIsConfigurable();
        User user = this.userGroupProvider.getUser(identifier);
        if (user == null) {
            LOGGER.warn("The specified user id [{}] does not exist.", (Object)identifier);
            throw new ResourceNotFoundException("The specified user ID does not exist in this registry.");
        }
        this.configurableUserGroupProvider().deleteUser(user);
        return this.userToDTO(user);
    }

    public UserGroup createUserGroup(UserGroup userGroup) {
        this.verifyUserGroupProviderIsConfigurable();
        if (StringUtils.isBlank((CharSequence)userGroup.getIdentity())) {
            throw new IllegalArgumentException("User group identity must be specified when creating a new group.");
        }
        Group createdGroup = this.configurableUserGroupProvider().addGroup(AuthorizationService.userGroupFromDTO(userGroup));
        return this.userGroupToDTO(createdGroup);
    }

    public List<UserGroup> getUserGroups() {
        return this.userGroupProvider.getGroups().stream().map(this::userGroupToDTO).collect(Collectors.toList());
    }

    public UserGroup getUserGroup(String identifier) {
        Group group = this.userGroupProvider.getGroup(identifier);
        if (group == null) {
            LOGGER.warn("The specified user group id [{}] does not exist.", (Object)identifier);
            throw new ResourceNotFoundException("The specified user group ID does not exist in this registry.");
        }
        return this.userGroupToDTO(group);
    }

    public void verifyUserGroupExists(String identifier) {
        Group group = this.userGroupProvider.getGroup(identifier);
        if (group == null) {
            LOGGER.warn("The specified user group id [{}] does not exist.", (Object)identifier);
            throw new ResourceNotFoundException("The specified user group ID does not exist in this registry.");
        }
    }

    public UserGroup updateUserGroup(UserGroup userGroup) {
        this.verifyUserGroupProviderIsConfigurable();
        Group updatedGroup = this.configurableUserGroupProvider().updateGroup(AuthorizationService.userGroupFromDTO(userGroup));
        if (updatedGroup == null) {
            LOGGER.warn("The specified user group id [{}] does not exist.", (Object)userGroup.getIdentifier());
            throw new ResourceNotFoundException("The specified user group ID does not exist in this registry.");
        }
        return this.userGroupToDTO(updatedGroup);
    }

    public UserGroup deleteUserGroup(String identifier) {
        this.verifyUserGroupProviderIsConfigurable();
        Group group = this.userGroupProvider.getGroup(identifier);
        if (group == null) {
            LOGGER.warn("The specified user group id [{}] does not exist.", (Object)identifier);
            throw new ResourceNotFoundException("The specified user group ID does not exist in this registry.");
        }
        this.configurableUserGroupProvider().deleteGroup(group);
        return this.userGroupToDTO(group);
    }

    public org.apache.nifi.registry.authorization.AccessPolicy createAccessPolicy(org.apache.nifi.registry.authorization.AccessPolicy accessPolicy) {
        this.verifyAccessPolicyProviderIsConfigurable();
        if (accessPolicy.getResource() == null) {
            throw new IllegalArgumentException("Resource must be specified when creating a new access policy.");
        }
        RequestAction.valueOfValue((String)accessPolicy.getAction());
        AccessPolicy createdAccessPolicy = this.configurableAccessPolicyProvider().addAccessPolicy(AuthorizationService.accessPolicyFromDTO(accessPolicy));
        return this.accessPolicyToDTO(createdAccessPolicy);
    }

    public org.apache.nifi.registry.authorization.AccessPolicy getAccessPolicy(String identifier) {
        AccessPolicy accessPolicy = this.accessPolicyProvider.getAccessPolicy(identifier);
        if (accessPolicy == null) {
            LOGGER.warn("The specified access policy id [{}] does not exist.", (Object)identifier);
            throw new ResourceNotFoundException("The specified policy does not exist in this registry.");
        }
        return this.accessPolicyToDTO(accessPolicy);
    }

    public org.apache.nifi.registry.authorization.AccessPolicy getAccessPolicy(String resource, RequestAction action) {
        AccessPolicy accessPolicy = this.accessPolicyProvider.getAccessPolicy(resource, action);
        if (accessPolicy == null) {
            throw new ResourceNotFoundException("No policy found for action='" + String.valueOf(action) + "', resource='" + resource + "'");
        }
        return this.accessPolicyToDTO(accessPolicy);
    }

    public List<org.apache.nifi.registry.authorization.AccessPolicy> getAccessPolicies() {
        return this.accessPolicyProvider.getAccessPolicies().stream().map(this::accessPolicyToDTO).collect(Collectors.toList());
    }

    public List<AccessPolicySummary> getAccessPolicySummaries() {
        return this.accessPolicyProvider.getAccessPolicies().stream().map(this::accessPolicyToSummaryDTO).collect(Collectors.toList());
    }

    private List<AccessPolicySummary> getAccessPolicySummariesForUser(String userIdentifier) {
        return this.accessPolicyProvider.getAccessPolicies().stream().filter(accessPolicy -> {
            if (accessPolicy.getUsers().contains(userIdentifier)) {
                return true;
            }
            return accessPolicy.getGroups().stream().anyMatch(g -> {
                Group group = this.userGroupProvider.getGroup(g);
                return group != null && group.getUsers().contains(userIdentifier);
            });
        }).map(this::accessPolicyToSummaryDTO).collect(Collectors.toList());
    }

    private List<AccessPolicySummary> getAccessPolicySummariesForUserGroup(String userGroupIdentifier) {
        return this.accessPolicyProvider.getAccessPolicies().stream().filter(accessPolicy -> accessPolicy.getGroups().contains(userGroupIdentifier)).map(this::accessPolicyToSummaryDTO).collect(Collectors.toList());
    }

    public void verifyAccessPolicyExists(String identifier) {
        AccessPolicy accessPolicy = this.accessPolicyProvider.getAccessPolicy(identifier);
        if (accessPolicy == null) {
            LOGGER.warn("The specified access policy id [{}] does not exist.", (Object)identifier);
            throw new ResourceNotFoundException("The specified policy does not exist in this registry.");
        }
    }

    public org.apache.nifi.registry.authorization.AccessPolicy updateAccessPolicy(org.apache.nifi.registry.authorization.AccessPolicy accessPolicy) {
        this.verifyAccessPolicyProviderIsConfigurable();
        AccessPolicy currentAccessPolicy = this.accessPolicyProvider.getAccessPolicy(accessPolicy.getIdentifier());
        if (currentAccessPolicy == null) {
            LOGGER.warn("The specified access policy id [{}] does not exist.", (Object)accessPolicy.getIdentifier());
            throw new ResourceNotFoundException("The specified policy does not exist in this registry.");
        }
        accessPolicy.setResource(currentAccessPolicy.getResource());
        accessPolicy.setAction(currentAccessPolicy.getAction().toString());
        AccessPolicy updatedAccessPolicy = this.configurableAccessPolicyProvider().updateAccessPolicy(AuthorizationService.accessPolicyFromDTO(accessPolicy));
        if (updatedAccessPolicy == null) {
            LOGGER.warn("The specified access policy id [{}] does not exist.", (Object)accessPolicy.getIdentifier());
            throw new ResourceNotFoundException("The specified policy does not exist in this registry.");
        }
        return this.accessPolicyToDTO(updatedAccessPolicy);
    }

    public org.apache.nifi.registry.authorization.AccessPolicy deleteAccessPolicy(String identifier) {
        this.verifyAccessPolicyProviderIsConfigurable();
        AccessPolicy accessPolicy = this.accessPolicyProvider.getAccessPolicy(identifier);
        if (accessPolicy == null) {
            LOGGER.warn("The specified access policy id [{}] does not exist.", (Object)identifier);
            throw new ResourceNotFoundException("The specified policy does not exist in this registry.");
        }
        this.configurableAccessPolicyProvider().deleteAccessPolicy(accessPolicy);
        return this.accessPolicyToDTO(accessPolicy);
    }

    public List<org.apache.nifi.registry.authorization.Resource> getResources() {
        List<org.apache.nifi.registry.authorization.Resource> dtoResources = this.getAuthorizableResources().stream().map(AuthorizationService::resourceToDTO).collect(Collectors.toList());
        return dtoResources;
    }

    public List<org.apache.nifi.registry.authorization.Resource> getAuthorizedResources(RequestAction actionType) {
        return this.getAuthorizedResources(actionType, null);
    }

    public List<org.apache.nifi.registry.authorization.Resource> getAuthorizedResources(RequestAction actionType, ResourceType resourceType) {
        List<org.apache.nifi.registry.authorization.Resource> authorizedResources = this.getAuthorizableResources(resourceType).stream().filter(resource -> {
            String resourceId = resource.getIdentifier();
            try {
                this.authorizableLookup.getAuthorizableByResource(resource.getIdentifier()).authorize(this.authorizer, actionType, NiFiUserUtils.getNiFiUser());
                return true;
            }
            catch (UntrustedProxyException | AccessDeniedException e) {
                return false;
            }
        }).map(AuthorizationService::resourceToDTO).collect(Collectors.toList());
        return authorizedResources;
    }

    private ConfigurableUserGroupProvider configurableUserGroupProvider() {
        return (ConfigurableUserGroupProvider)this.userGroupProvider;
    }

    private ConfigurableAccessPolicyProvider configurableAccessPolicyProvider() {
        return (ConfigurableAccessPolicyProvider)this.accessPolicyProvider;
    }

    private void verifyUserGroupProviderIsConfigurable() {
        if (!(this.userGroupProvider instanceof ConfigurableUserGroupProvider)) {
            throw new IllegalStateException(MSG_NON_CONFIGURABLE_USERS);
        }
    }

    private void verifyAccessPolicyProviderIsConfigurable() {
        if (!(this.accessPolicyProvider instanceof ConfigurableAccessPolicyProvider)) {
            throw new IllegalStateException(MSG_NON_CONFIGURABLE_POLICIES);
        }
    }

    private ResourcePermissions getTopLevelPermissions(String tenantIdentifier) {
        ResourcePermissions resourcePermissions = new ResourcePermissions();
        Permissions bucketsPermissions = this.getPermissionsForResource(tenantIdentifier, ResourceFactory.getBucketsResource());
        resourcePermissions.setBuckets(bucketsPermissions);
        Permissions policiesPermissions = this.getPermissionsForResource(tenantIdentifier, ResourceFactory.getPoliciesResource());
        resourcePermissions.setPolicies(policiesPermissions);
        Permissions tenantsPermissions = this.getPermissionsForResource(tenantIdentifier, ResourceFactory.getTenantsResource());
        resourcePermissions.setTenants(tenantsPermissions);
        Permissions proxyPermissions = this.getPermissionsForResource(tenantIdentifier, ResourceFactory.getProxyResource());
        resourcePermissions.setProxy(proxyPermissions);
        return resourcePermissions;
    }

    private Permissions getPermissionsForResource(String tenantIdentifier, Resource resource) {
        Permissions permissions = new Permissions();
        permissions.setCanRead(this.checkTenantBelongsToPolicy(tenantIdentifier, resource, RequestAction.READ));
        permissions.setCanWrite(this.checkTenantBelongsToPolicy(tenantIdentifier, resource, RequestAction.WRITE));
        permissions.setCanDelete(this.checkTenantBelongsToPolicy(tenantIdentifier, resource, RequestAction.DELETE));
        return permissions;
    }

    private boolean checkTenantBelongsToPolicy(String tenantIdentifier, Resource resource, RequestAction action) {
        AccessPolicy policy = this.accessPolicyProvider.getAccessPolicy(resource.getIdentifier(), action);
        if (policy == null) {
            return false;
        }
        boolean tenantInPolicy = policy.getUsers().contains(tenantIdentifier) || policy.getGroups().contains(tenantIdentifier);
        return tenantInPolicy;
    }

    private List<Resource> getAuthorizableResources() {
        return this.getAuthorizableResources(null);
    }

    private List<Resource> getAuthorizableResources(ResourceType includeFilter) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (includeFilter == null || includeFilter.equals((Object)ResourceType.Policy)) {
            resources.add(ResourceFactory.getPoliciesResource());
        }
        if (includeFilter == null || includeFilter.equals((Object)ResourceType.Tenant)) {
            resources.add(ResourceFactory.getTenantsResource());
        }
        if (includeFilter == null || includeFilter.equals((Object)ResourceType.Proxy)) {
            resources.add(ResourceFactory.getProxyResource());
        }
        if (includeFilter == null || includeFilter.equals((Object)ResourceType.Actuator)) {
            resources.add(ResourceFactory.getActuatorResource());
        }
        if (includeFilter == null || includeFilter.equals((Object)ResourceType.Swagger)) {
            resources.add(ResourceFactory.getSwaggerResource());
        }
        if (includeFilter == null || includeFilter.equals((Object)ResourceType.Bucket)) {
            resources.add(ResourceFactory.getBucketsResource());
            for (Bucket bucket : this.registryService.getBuckets()) {
                resources.add(ResourceFactory.getBucketResource(bucket.getIdentifier(), bucket.getName()));
            }
        }
        return resources;
    }

    private org.apache.nifi.registry.authorization.User userToDTO(User user) {
        if (user == null) {
            return null;
        }
        String userIdentifier = user.getIdentifier();
        Collection groupsContainingUser = this.userGroupProvider.getGroups().stream().filter(group -> group.getUsers().contains(userIdentifier)).map(this::tenantToDTO).collect(Collectors.toList());
        List<AccessPolicySummary> accessPolicySummaries = this.getAccessPolicySummariesForUser(userIdentifier);
        org.apache.nifi.registry.authorization.User userDTO = new org.apache.nifi.registry.authorization.User(user.getIdentifier(), user.getIdentity());
        userDTO.setConfigurable(Boolean.valueOf(AuthorizerCapabilityDetection.isUserConfigurable(this.authorizer, user)));
        userDTO.setResourcePermissions(this.getTopLevelPermissions(userDTO.getIdentifier()));
        userDTO.addUserGroups(groupsContainingUser);
        userDTO.addAccessPolicies(accessPolicySummaries);
        return userDTO;
    }

    private UserGroup userGroupToDTO(Group userGroup) {
        if (userGroup == null) {
            return null;
        }
        Collection userTenants = userGroup.getUsers() != null ? (Collection)userGroup.getUsers().stream().map(this::tenantIdToDTO).filter(Objects::nonNull).collect(Collectors.toSet()) : null;
        List<AccessPolicySummary> accessPolicySummaries = this.getAccessPolicySummariesForUserGroup(userGroup.getIdentifier());
        UserGroup userGroupDTO = new UserGroup(userGroup.getIdentifier(), userGroup.getName());
        userGroupDTO.setConfigurable(Boolean.valueOf(AuthorizerCapabilityDetection.isGroupConfigurable(this.authorizer, userGroup)));
        userGroupDTO.setResourcePermissions(this.getTopLevelPermissions(userGroupDTO.getIdentifier()));
        userGroupDTO.addUsers(userTenants);
        userGroupDTO.addAccessPolicies(accessPolicySummaries);
        return userGroupDTO;
    }

    private org.apache.nifi.registry.authorization.AccessPolicy accessPolicyToDTO(AccessPolicy accessPolicy) {
        if (accessPolicy == null) {
            return null;
        }
        Collection users = accessPolicy.getUsers() != null ? (Collection)accessPolicy.getUsers().stream().map(this::tenantIdToDTO).filter(Objects::nonNull).collect(Collectors.toList()) : null;
        Collection userGroups = accessPolicy.getGroups() != null ? (Collection)accessPolicy.getGroups().stream().map(this::tenantIdToDTO).filter(Objects::nonNull).collect(Collectors.toList()) : null;
        Boolean isConfigurable = AuthorizerCapabilityDetection.isAccessPolicyConfigurable(this.authorizer, accessPolicy);
        return AuthorizationService.accessPolicyToDTO(accessPolicy, userGroups, users, isConfigurable);
    }

    private Tenant tenantIdToDTO(String identifier) {
        User user = this.userGroupProvider.getUser(identifier);
        if (user != null) {
            return this.tenantToDTO(user);
        }
        Group group = this.userGroupProvider.getGroup(identifier);
        return this.tenantToDTO(group);
    }

    private AccessPolicySummary accessPolicyToSummaryDTO(AccessPolicy accessPolicy) {
        if (accessPolicy == null) {
            return null;
        }
        Boolean isConfigurable = AuthorizerCapabilityDetection.isAccessPolicyConfigurable(this.authorizer, accessPolicy);
        AccessPolicySummary accessPolicySummaryDTO = new AccessPolicySummary();
        accessPolicySummaryDTO.setIdentifier(accessPolicy.getIdentifier());
        accessPolicySummaryDTO.setAction(accessPolicy.getAction().toString());
        accessPolicySummaryDTO.setResource(accessPolicy.getResource());
        accessPolicySummaryDTO.setConfigurable(isConfigurable);
        return accessPolicySummaryDTO;
    }

    private Tenant tenantToDTO(User user) {
        if (user == null) {
            return null;
        }
        Tenant tenantDTO = new Tenant(user.getIdentifier(), user.getIdentity());
        tenantDTO.setConfigurable(Boolean.valueOf(AuthorizerCapabilityDetection.isUserConfigurable(this.authorizer, user)));
        return tenantDTO;
    }

    private Tenant tenantToDTO(Group group) {
        if (group == null) {
            return null;
        }
        Tenant tenantDTO = new Tenant(group.getIdentifier(), group.getName());
        tenantDTO.setConfigurable(Boolean.valueOf(AuthorizerCapabilityDetection.isGroupConfigurable(this.authorizer, group)));
        return tenantDTO;
    }

    private static org.apache.nifi.registry.authorization.Resource resourceToDTO(Resource resource) {
        if (resource == null) {
            return null;
        }
        org.apache.nifi.registry.authorization.Resource resourceDto = new org.apache.nifi.registry.authorization.Resource();
        resourceDto.setIdentifier(resource.getIdentifier());
        resourceDto.setName(resource.getName());
        return resourceDto;
    }

    private static User userFromDTO(org.apache.nifi.registry.authorization.User userDTO) {
        if (userDTO == null) {
            return null;
        }
        return new User.Builder().identifier(userDTO.getIdentifier()).identity(userDTO.getIdentity()).build();
    }

    private static Group userGroupFromDTO(UserGroup userGroupDTO) {
        if (userGroupDTO == null) {
            return null;
        }
        Group.Builder groupBuilder = new Group.Builder().identifier(userGroupDTO.getIdentifier()).name(userGroupDTO.getIdentity());
        Set users = userGroupDTO.getUsers();
        if (users != null) {
            groupBuilder.addUsers(users.stream().map(Tenant::getIdentifier).collect(Collectors.toSet()));
        }
        return groupBuilder.build();
    }

    private static AccessPolicy accessPolicyFromDTO(org.apache.nifi.registry.authorization.AccessPolicy accessPolicyDTO) {
        Set dtoUserGroups;
        AccessPolicy.Builder accessPolicyBuilder = new AccessPolicy.Builder().identifier(accessPolicyDTO.getIdentifier()).resource(accessPolicyDTO.getResource()).action(RequestAction.valueOfValue((String)accessPolicyDTO.getAction()));
        Set dtoUsers = accessPolicyDTO.getUsers();
        if (accessPolicyDTO.getUsers() != null) {
            accessPolicyBuilder.addUsers(dtoUsers.stream().map(Tenant::getIdentifier).collect(Collectors.toSet()));
        }
        if ((dtoUserGroups = accessPolicyDTO.getUserGroups()) != null) {
            accessPolicyBuilder.addGroups(dtoUserGroups.stream().map(Tenant::getIdentifier).collect(Collectors.toSet()));
        }
        return accessPolicyBuilder.build();
    }

    private static org.apache.nifi.registry.authorization.AccessPolicy accessPolicyToDTO(AccessPolicy accessPolicy, Collection<? extends Tenant> userGroups, Collection<? extends Tenant> users, Boolean isConfigurable) {
        if (accessPolicy == null) {
            return null;
        }
        org.apache.nifi.registry.authorization.AccessPolicy accessPolicyDTO = new org.apache.nifi.registry.authorization.AccessPolicy();
        accessPolicyDTO.setIdentifier(accessPolicy.getIdentifier());
        accessPolicyDTO.setAction(accessPolicy.getAction().toString());
        accessPolicyDTO.setResource(accessPolicy.getResource());
        accessPolicyDTO.setConfigurable(isConfigurable);
        accessPolicyDTO.addUsers(users);
        accessPolicyDTO.addUserGroups(userGroups);
        return accessPolicyDTO;
    }

    private static AccessPolicyProvider createExceptionThrowingAccessPolicyProvider() {
        return new AccessPolicyProvider(){

            public Set<AccessPolicy> getAccessPolicies() throws AuthorizationAccessException {
                throw new IllegalStateException(AuthorizationService.MSG_NON_MANAGED_AUTHORIZER);
            }

            public AccessPolicy getAccessPolicy(String identifier) throws AuthorizationAccessException {
                throw new IllegalStateException(AuthorizationService.MSG_NON_MANAGED_AUTHORIZER);
            }

            public AccessPolicy getAccessPolicy(String resourceIdentifier, RequestAction action) throws AuthorizationAccessException {
                throw new IllegalStateException(AuthorizationService.MSG_NON_MANAGED_AUTHORIZER);
            }

            public UserGroupProvider getUserGroupProvider() {
                return new UserGroupProvider(this){

                    public Set<User> getUsers() throws AuthorizationAccessException {
                        throw new IllegalStateException(AuthorizationService.MSG_NON_MANAGED_AUTHORIZER);
                    }

                    public User getUser(String identifier) throws AuthorizationAccessException {
                        throw new IllegalStateException(AuthorizationService.MSG_NON_MANAGED_AUTHORIZER);
                    }

                    public User getUserByIdentity(String identity) throws AuthorizationAccessException {
                        throw new IllegalStateException(AuthorizationService.MSG_NON_MANAGED_AUTHORIZER);
                    }

                    public Set<Group> getGroups() throws AuthorizationAccessException {
                        throw new IllegalStateException(AuthorizationService.MSG_NON_MANAGED_AUTHORIZER);
                    }

                    public Group getGroup(String identifier) throws AuthorizationAccessException {
                        throw new IllegalStateException(AuthorizationService.MSG_NON_MANAGED_AUTHORIZER);
                    }

                    public UserAndGroups getUserAndGroups(String identity) throws AuthorizationAccessException {
                        throw new IllegalStateException(AuthorizationService.MSG_NON_MANAGED_AUTHORIZER);
                    }

                    public void initialize(UserGroupProviderInitializationContext initializationContext) throws SecurityProviderCreationException {
                    }

                    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
                    }

                    public void preDestruction() throws SecurityProviderDestructionException {
                    }
                };
            }

            public void initialize(AccessPolicyProviderInitializationContext initializationContext) throws SecurityProviderCreationException {
            }

            public void onConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
            }

            public void preDestruction() throws SecurityProviderDestructionException {
            }
        };
    }
}

