/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.file;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.nifi.registry.security.authorization.AbstractPolicyBasedAuthorizer;
import org.apache.nifi.registry.security.authorization.AccessPolicy;
import org.apache.nifi.registry.security.authorization.AccessPolicyProviderInitializationContext;
import org.apache.nifi.registry.security.authorization.AccessPolicyProviderLookup;
import org.apache.nifi.registry.security.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.AuthorizerInitializationContext;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.RequestAction;
import org.apache.nifi.registry.security.authorization.StandardAuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.User;
import org.apache.nifi.registry.security.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.registry.security.authorization.UserGroupProviderLookup;
import org.apache.nifi.registry.security.authorization.UsersAndAccessPolicies;
import org.apache.nifi.registry.security.authorization.annotation.AuthorizerContext;
import org.apache.nifi.registry.security.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.registry.security.authorization.file.AuthorizationsHolder;
import org.apache.nifi.registry.security.authorization.file.FileAccessPolicyProvider;
import org.apache.nifi.registry.security.authorization.file.FileUserGroupProvider;
import org.apache.nifi.registry.security.authorization.file.UserGroupHolder;
import org.apache.nifi.registry.security.authorization.util.AccessPolicyProviderUtils;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.identity.IdentityMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAuthorizer
extends AbstractPolicyBasedAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(FileAuthorizer.class);
    private static final String FILE_USER_GROUP_PROVIDER_ID = "file-user-group-provider";
    private static final String FILE_ACCESS_POLICY_PROVIDER_ID = "file-access-policy-provider";
    static final String PROP_LEGACY_AUTHORIZED_USERS_FILE = "Legacy Authorized Users File";
    private FileUserGroupProvider userGroupProvider = new FileUserGroupProvider();
    private FileAccessPolicyProvider accessPolicyProvider = new FileAccessPolicyProvider();

    public void initialize(AuthorizerInitializationContext initializationContext) throws SecurityProviderCreationException {
        this.userGroupProvider.initialize(new UserGroupProviderInitializationContext(this){

            public String getIdentifier() {
                return FileAuthorizer.FILE_USER_GROUP_PROVIDER_ID;
            }

            public UserGroupProviderLookup getUserGroupProviderLookup() {
                return identifier -> null;
            }
        });
        this.accessPolicyProvider.initialize(new AccessPolicyProviderInitializationContext(){

            public String getIdentifier() {
                return FileAuthorizer.FILE_ACCESS_POLICY_PROVIDER_ID;
            }

            public UserGroupProviderLookup getUserGroupProviderLookup() {
                return identifier -> {
                    if (FileAuthorizer.FILE_USER_GROUP_PROVIDER_ID.equals(identifier)) {
                        return FileAuthorizer.this.userGroupProvider;
                    }
                    return null;
                };
            }

            public AccessPolicyProviderLookup getAccessPolicyProviderLookup() {
                return identifier -> null;
            }
        });
    }

    @Override
    public void doOnConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
        Map configurationProperties = configurationContext.getProperties();
        HashMap<String, String> userGroupProperties = new HashMap<String, String>();
        if (configurationProperties.containsKey("Users File")) {
            userGroupProperties.put("Users File", (String)configurationProperties.get("Users File"));
        }
        if (configurationProperties.containsKey(PROP_LEGACY_AUTHORIZED_USERS_FILE)) {
            userGroupProperties.put(PROP_LEGACY_AUTHORIZED_USERS_FILE, (String)configurationProperties.get(PROP_LEGACY_AUTHORIZED_USERS_FILE));
        }
        HashMap<String, String> accessPolicyProperties = new HashMap<String, String>();
        accessPolicyProperties.put("User Group Provider", FILE_USER_GROUP_PROVIDER_ID);
        if (configurationProperties.containsKey("Authorizations File")) {
            accessPolicyProperties.put("Authorizations File", (String)configurationProperties.get("Authorizations File"));
        }
        if (configurationProperties.containsKey("Initial Admin Identity")) {
            accessPolicyProperties.put("Initial Admin Identity", (String)configurationProperties.get("Initial Admin Identity"));
        }
        if (configurationProperties.containsKey(PROP_LEGACY_AUTHORIZED_USERS_FILE)) {
            accessPolicyProperties.put(PROP_LEGACY_AUTHORIZED_USERS_FILE, (String)configurationProperties.get(PROP_LEGACY_AUTHORIZED_USERS_FILE));
        }
        configurationProperties.forEach((property, value) -> {
            Matcher matcher = AccessPolicyProviderUtils.NIFI_IDENTITY_PATTERN.matcher((CharSequence)property);
            if (matcher.matches()) {
                accessPolicyProperties.put((String)property, (String)value);
                userGroupProperties.put(property.replace("NiFi Identity ", "Initial User Identity "), (String)value);
            }
        });
        if (configurationProperties.containsKey("Initial Admin Identity")) {
            String key;
            int i = 0;
            while (userGroupProperties.containsKey(key = "Initial User Identity " + i++)) {
            }
            userGroupProperties.put(key, (String)configurationProperties.get("Initial Admin Identity"));
        }
        this.userGroupProvider.onConfigured(new StandardAuthorizerConfigurationContext(FILE_USER_GROUP_PROVIDER_ID, userGroupProperties));
        this.accessPolicyProvider.onConfigured(new StandardAuthorizerConfigurationContext(FILE_USER_GROUP_PROVIDER_ID, accessPolicyProperties));
    }

    public void preDestruction() {
    }

    @Override
    public synchronized Group doAddGroup(Group group) throws AuthorizationAccessException {
        return this.userGroupProvider.addGroup(group);
    }

    @Override
    public Group getGroup(String identifier) throws AuthorizationAccessException {
        return this.userGroupProvider.getGroup(identifier);
    }

    @Override
    public synchronized Group doUpdateGroup(Group group) throws AuthorizationAccessException {
        return this.userGroupProvider.updateGroup(group);
    }

    @Override
    public synchronized Group deleteGroup(Group group) throws AuthorizationAccessException {
        return this.userGroupProvider.deleteGroup(group);
    }

    @Override
    public Set<Group> getGroups() throws AuthorizationAccessException {
        return this.userGroupProvider.getGroups();
    }

    @Override
    public synchronized User doAddUser(User user) throws AuthorizationAccessException {
        return this.userGroupProvider.addUser(user);
    }

    @Override
    public User getUser(String identifier) throws AuthorizationAccessException {
        return this.userGroupProvider.getUser(identifier);
    }

    @Override
    public User getUserByIdentity(String identity) throws AuthorizationAccessException {
        return this.userGroupProvider.getUserByIdentity(identity);
    }

    @Override
    public synchronized User doUpdateUser(User user) throws AuthorizationAccessException {
        return this.userGroupProvider.updateUser(user);
    }

    @Override
    public synchronized User deleteUser(User user) throws AuthorizationAccessException {
        return this.userGroupProvider.deleteUser(user);
    }

    @Override
    public Set<User> getUsers() throws AuthorizationAccessException {
        return this.userGroupProvider.getUsers();
    }

    @Override
    public synchronized AccessPolicy doAddAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        return this.accessPolicyProvider.addAccessPolicy(accessPolicy);
    }

    @Override
    public AccessPolicy getAccessPolicy(String identifier) throws AuthorizationAccessException {
        return this.accessPolicyProvider.getAccessPolicy(identifier);
    }

    @Override
    public synchronized AccessPolicy updateAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        return this.accessPolicyProvider.updateAccessPolicy(accessPolicy);
    }

    @Override
    public synchronized AccessPolicy deleteAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        return this.accessPolicyProvider.deleteAccessPolicy(accessPolicy);
    }

    @Override
    public Set<AccessPolicy> getAccessPolicies() throws AuthorizationAccessException {
        return this.accessPolicyProvider.getAccessPolicies();
    }

    @AuthorizerContext
    public void setIdentityMapper(IdentityMapper identityMapper) {
        this.userGroupProvider.setIdentityMapper(identityMapper);
        this.accessPolicyProvider.setIdentityMapper(identityMapper);
    }

    @Override
    public synchronized UsersAndAccessPolicies getUsersAndAccessPolicies() throws AuthorizationAccessException {
        final AuthorizationsHolder authorizationsHolder = this.accessPolicyProvider.getAuthorizationsHolder();
        final UserGroupHolder userGroupHolder = this.userGroupProvider.getUserGroupHolder();
        return new UsersAndAccessPolicies(){

            @Override
            public AccessPolicy getAccessPolicy(String resourceIdentifier, RequestAction action) {
                return authorizationsHolder.getAccessPolicy(resourceIdentifier, action);
            }

            @Override
            public User getUser(String identity) {
                return userGroupHolder.getUser(identity);
            }

            @Override
            public Set<Group> getGroups(String userIdentity) {
                return userGroupHolder.getGroups(userIdentity);
            }
        };
    }
}

