/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.db.migration;

import java.util.List;
import javax.sql.DataSource;
import org.apache.nifi.registry.db.migration.BucketEntityV1;
import org.apache.nifi.registry.db.migration.FlowEntityV1;
import org.apache.nifi.registry.db.migration.FlowSnapshotEntityV1;
import org.springframework.jdbc.core.JdbcTemplate;

public class LegacyDatabaseService {
    private final JdbcTemplate jdbcTemplate;

    public LegacyDatabaseService(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public List<BucketEntityV1> getAllBuckets() {
        String sql = "SELECT * FROM bucket ORDER BY name ASC";
        return this.jdbcTemplate.query("SELECT * FROM bucket ORDER BY name ASC", (rs, i) -> {
            BucketEntityV1 b = new BucketEntityV1();
            b.setId(rs.getString("ID"));
            b.setName(rs.getString("NAME"));
            b.setDescription(rs.getString("DESCRIPTION"));
            b.setCreated(rs.getTimestamp("CREATED"));
            return b;
        });
    }

    public List<FlowEntityV1> getAllFlows() {
        String sql = "SELECT * FROM flow f, bucket_item item WHERE item.id = f.id";
        return this.jdbcTemplate.query("SELECT * FROM flow f, bucket_item item WHERE item.id = f.id", (rs, i) -> {
            FlowEntityV1 flowEntity = new FlowEntityV1();
            flowEntity.setId(rs.getString("ID"));
            flowEntity.setName(rs.getString("NAME"));
            flowEntity.setDescription(rs.getString("DESCRIPTION"));
            flowEntity.setCreated(rs.getTimestamp("CREATED"));
            flowEntity.setModified(rs.getTimestamp("MODIFIED"));
            flowEntity.setBucketId(rs.getString("BUCKET_ID"));
            return flowEntity;
        });
    }

    public List<FlowSnapshotEntityV1> getAllFlowSnapshots() {
        String sql = "SELECT * FROM flow_snapshot fs";
        return this.jdbcTemplate.query("SELECT * FROM flow_snapshot fs", (rs, i) -> {
            FlowSnapshotEntityV1 fs = new FlowSnapshotEntityV1();
            fs.setFlowId(rs.getString("FLOW_ID"));
            fs.setVersion(rs.getInt("VERSION"));
            fs.setCreated(rs.getTimestamp("CREATED"));
            fs.setCreatedBy(rs.getString("CREATED_BY"));
            fs.setComments(rs.getString("COMMENTS"));
            return fs;
        });
    }
}

