/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.extension.ExtensionFilterParams;
import org.apache.nifi.extension.manifest.ExtensionType;
import org.apache.nifi.extension.manifest.ProvidedServiceAPI;
import org.apache.nifi.registry.db.entity.BucketEntity;
import org.apache.nifi.registry.db.entity.BucketItemEntity;
import org.apache.nifi.registry.db.entity.BucketItemEntityType;
import org.apache.nifi.registry.db.entity.BundleEntity;
import org.apache.nifi.registry.db.entity.BundleVersionDependencyEntity;
import org.apache.nifi.registry.db.entity.BundleVersionEntity;
import org.apache.nifi.registry.db.entity.ExtensionAdditionalDetailsEntity;
import org.apache.nifi.registry.db.entity.ExtensionEntity;
import org.apache.nifi.registry.db.entity.ExtensionProvidedServiceApiEntity;
import org.apache.nifi.registry.db.entity.ExtensionRestrictionEntity;
import org.apache.nifi.registry.db.entity.FlowEntity;
import org.apache.nifi.registry.db.entity.FlowSnapshotEntity;
import org.apache.nifi.registry.db.entity.TagCountEntity;
import org.apache.nifi.registry.db.mapper.BucketEntityRowMapper;
import org.apache.nifi.registry.db.mapper.BucketItemEntityRowMapper;
import org.apache.nifi.registry.db.mapper.BundleEntityRowMapper;
import org.apache.nifi.registry.db.mapper.BundleVersionDependencyEntityRowMapper;
import org.apache.nifi.registry.db.mapper.BundleVersionEntityRowMapper;
import org.apache.nifi.registry.db.mapper.ExtensionEntityRowMapper;
import org.apache.nifi.registry.db.mapper.FlowEntityRowMapper;
import org.apache.nifi.registry.db.mapper.FlowSnapshotEntityRowMapper;
import org.apache.nifi.registry.db.mapper.TagCountEntityMapper;
import org.apache.nifi.registry.extension.bundle.BundleFilterParams;
import org.apache.nifi.registry.extension.bundle.BundleType;
import org.apache.nifi.registry.extension.bundle.BundleVersionFilterParams;
import org.apache.nifi.registry.service.MetadataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class DatabaseMetadataService
implements MetadataService {
    private final JdbcTemplate jdbcTemplate;
    private static final String BASE_BUCKET_ITEMS_SQL = "SELECT item.id as ID, item.name as NAME, item.description as DESCRIPTION, item.created as CREATED, item.modified as MODIFIED, item.item_type as ITEM_TYPE, b.id as BUCKET_ID, b.name as BUCKET_NAME ,eb.bundle_type as BUNDLE_TYPE, eb.group_id as BUNDLE_GROUP_ID, eb.artifact_id as BUNDLE_ARTIFACT_ID FROM BUCKET_ITEM item INNER JOIN BUCKET b ON item.bucket_id = b.id LEFT JOIN BUNDLE eb ON item.id = eb.id ";
    private static final String BASE_BUNDLE_SQL = "SELECT item.id as ID,item.name as NAME, item.description as DESCRIPTION, item.created as CREATED, item.modified as MODIFIED, eb.bundle_type as BUNDLE_TYPE, eb.group_id as GROUP_ID, eb.artifact_id as ARTIFACT_ID, b.id as BUCKET_ID, b.name as BUCKET_NAME FROM BUNDLE eb, BUCKET_ITEM item,BUCKET b WHERE eb.id = item.id AND item.bucket_id = b.id";
    private static final String BASE_EXTENSION_BUNDLE_VERSION_SQL = "SELECT ebv.id AS ID,ebv.bundle_id AS BUNDLE_ID, ebv.version AS VERSION, ebv.created AS CREATED, ebv.created_by AS CREATED_BY, ebv.description AS DESCRIPTION, ebv.sha_256_hex AS SHA_256_HEX, ebv.sha_256_supplied AS SHA_256_SUPPLIED ,ebv.content_size AS CONTENT_SIZE, ebv.system_api_version AS SYSTEM_API_VERSION, ebv.build_tool AS BUILD_TOOL, ebv.build_flags AS BUILD_FLAGS, ebv.build_branch AS BUILD_BRANCH, ebv.build_tag AS BUILD_TAG, ebv.build_revision AS BUILD_REVISION, ebv.built AS BUILT, ebv.built_by AS BUILT_BY, eb.bucket_id AS BUCKET_ID, eb.group_id AS GROUP_ID, eb.artifact_id AS ARTIFACT_ID FROM BUNDLE eb, BUNDLE_VERSION ebv WHERE eb.id = ebv.bundle_id ";
    private static String BASE_EXTENSION_SQL = "SELECT e.id AS ID, e.bundle_version_id AS BUNDLE_VERSION_ID, e.name AS NAME, e.display_name AS DISPLAY_NAME, e.type AS TYPE, e.content AS CONTENT,e.has_additional_details AS HAS_ADDITIONAL_DETAILS, eb.id AS BUNDLE_ID, eb.group_id AS GROUP_ID, eb.artifact_id AS ARTIFACT_ID, eb.bundle_type AS BUNDLE_TYPE, ebv.version AS VERSION, ebv.system_api_version AS SYSTEM_API_VERSION, b.id AS BUCKET_ID, b.name as BUCKET_NAME FROM EXTENSION e, BUNDLE_VERSION ebv, BUNDLE eb,BUCKET b WHERE e.bundle_version_id = ebv.id AND ebv.bundle_id = eb.id AND eb.bucket_id = b.id ";

    @Autowired
    public DatabaseMetadataService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public BucketEntity createBucket(BucketEntity b) {
        String sql = "INSERT INTO BUCKET (ID, NAME, DESCRIPTION, CREATED, ALLOW_EXTENSION_BUNDLE_REDEPLOY, ALLOW_PUBLIC_READ) VALUES (?, ?, ?, ?, ?, ?)";
        this.jdbcTemplate.update("INSERT INTO BUCKET (ID, NAME, DESCRIPTION, CREATED, ALLOW_EXTENSION_BUNDLE_REDEPLOY, ALLOW_PUBLIC_READ) VALUES (?, ?, ?, ?, ?, ?)", new Object[]{b.getId(), b.getName(), b.getDescription(), b.getCreated(), b.isAllowExtensionBundleRedeploy() ? 1 : 0, b.isAllowPublicRead() ? 1 : 0});
        return b;
    }

    @Override
    public BucketEntity getBucketById(String bucketIdentifier) {
        String sql = "SELECT * FROM BUCKET WHERE id = ?";
        try {
            return (BucketEntity)this.jdbcTemplate.queryForObject("SELECT * FROM BUCKET WHERE id = ?", (RowMapper)new BucketEntityRowMapper(), new Object[]{bucketIdentifier});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public List<BucketEntity> getBucketsByName(String name) {
        String sql = "SELECT * FROM BUCKET WHERE name = ? ORDER BY name ASC";
        return this.jdbcTemplate.query("SELECT * FROM BUCKET WHERE name = ? ORDER BY name ASC", (RowMapper)new BucketEntityRowMapper(), new Object[]{name});
    }

    @Override
    public BucketEntity updateBucket(BucketEntity bucket) {
        String sql = "UPDATE BUCKET SET name = ?, description = ?, allow_extension_bundle_redeploy = ?, allow_public_read = ? WHERE id = ?";
        this.jdbcTemplate.update("UPDATE BUCKET SET name = ?, description = ?, allow_extension_bundle_redeploy = ?, allow_public_read = ? WHERE id = ?", new Object[]{bucket.getName(), bucket.getDescription(), bucket.isAllowExtensionBundleRedeploy() ? 1 : 0, bucket.isAllowPublicRead() ? 1 : 0, bucket.getId()});
        return bucket;
    }

    @Override
    public void deleteBucket(BucketEntity bucket) {
        String sql = "DELETE FROM BUCKET WHERE id = ?";
        this.jdbcTemplate.update("DELETE FROM BUCKET WHERE id = ?", new Object[]{bucket.getId()});
    }

    @Override
    public List<BucketEntity> getBuckets(Set<String> bucketIds) {
        if (bucketIds == null || bucketIds.isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder sqlBuilder = new StringBuilder("SELECT * FROM BUCKET WHERE ");
        this.addIdentifiersInClause(sqlBuilder, "id", bucketIds);
        sqlBuilder.append("ORDER BY name ASC");
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)new BucketEntityRowMapper(), bucketIds.toArray());
    }

    @Override
    public List<BucketEntity> getAllBuckets() {
        String sql = "SELECT * FROM BUCKET ORDER BY name ASC";
        return this.jdbcTemplate.query("SELECT * FROM BUCKET ORDER BY name ASC", (RowMapper)new BucketEntityRowMapper());
    }

    @Override
    public List<BucketItemEntity> getBucketItems(String bucketIdentifier) {
        String sql = "SELECT item.id as ID, item.name as NAME, item.description as DESCRIPTION, item.created as CREATED, item.modified as MODIFIED, item.item_type as ITEM_TYPE, b.id as BUCKET_ID, b.name as BUCKET_NAME ,eb.bundle_type as BUNDLE_TYPE, eb.group_id as BUNDLE_GROUP_ID, eb.artifact_id as BUNDLE_ARTIFACT_ID FROM BUCKET_ITEM item INNER JOIN BUCKET b ON item.bucket_id = b.id LEFT JOIN BUNDLE eb ON item.id = eb.id  WHERE item.bucket_id = ?";
        List items = this.jdbcTemplate.query("SELECT item.id as ID, item.name as NAME, item.description as DESCRIPTION, item.created as CREATED, item.modified as MODIFIED, item.item_type as ITEM_TYPE, b.id as BUCKET_ID, b.name as BUCKET_NAME ,eb.bundle_type as BUNDLE_TYPE, eb.group_id as BUNDLE_GROUP_ID, eb.artifact_id as BUNDLE_ARTIFACT_ID FROM BUCKET_ITEM item INNER JOIN BUCKET b ON item.bucket_id = b.id LEFT JOIN BUNDLE eb ON item.id = eb.id  WHERE item.bucket_id = ?", (RowMapper)new BucketItemEntityRowMapper(), new Object[]{bucketIdentifier});
        return this.getItemsWithCounts(items);
    }

    @Override
    public List<BucketItemEntity> getBucketItems(Set<String> bucketIds) {
        if (bucketIds == null || bucketIds.isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder sqlBuilder = new StringBuilder("SELECT item.id as ID, item.name as NAME, item.description as DESCRIPTION, item.created as CREATED, item.modified as MODIFIED, item.item_type as ITEM_TYPE, b.id as BUCKET_ID, b.name as BUCKET_NAME ,eb.bundle_type as BUNDLE_TYPE, eb.group_id as BUNDLE_GROUP_ID, eb.artifact_id as BUNDLE_ARTIFACT_ID FROM BUCKET_ITEM item INNER JOIN BUCKET b ON item.bucket_id = b.id LEFT JOIN BUNDLE eb ON item.id = eb.id  WHERE item.bucket_id IN (");
        for (int i = 0; i < bucketIds.size(); ++i) {
            if (i > 0) {
                sqlBuilder.append(", ");
            }
            sqlBuilder.append("?");
        }
        sqlBuilder.append(")");
        List items = this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)new BucketItemEntityRowMapper(), bucketIds.toArray());
        return this.getItemsWithCounts(items);
    }

    private List<BucketItemEntity> getItemsWithCounts(Iterable<BucketItemEntity> items) {
        Map<String, Long> snapshotCounts = this.getFlowSnapshotCounts();
        Map<String, Long> extensionBundleVersionCounts = this.getExtensionBundleVersionCounts();
        ArrayList<BucketItemEntity> itemWithCounts = new ArrayList<BucketItemEntity>();
        for (BucketItemEntity item : items) {
            Long versionCount;
            if (item.getType() == BucketItemEntityType.FLOW) {
                Long snapshotCount = snapshotCounts.get(item.getId());
                if (snapshotCount != null) {
                    FlowEntity flowEntity = (FlowEntity)item;
                    flowEntity.setSnapshotCount(snapshotCount);
                }
            } else if (item.getType() == BucketItemEntityType.BUNDLE && (versionCount = extensionBundleVersionCounts.get(item.getId())) != null) {
                BundleEntity bundleEntity = (BundleEntity)item;
                bundleEntity.setVersionCount(versionCount);
            }
            itemWithCounts.add(item);
        }
        return itemWithCounts;
    }

    private Map<String, Long> getFlowSnapshotCounts() {
        String sql = "SELECT flow_id, count(*) FROM FLOW_SNAPSHOT GROUP BY flow_id";
        HashMap<String, Long> results = new HashMap<String, Long>();
        this.jdbcTemplate.query("SELECT flow_id, count(*) FROM FLOW_SNAPSHOT GROUP BY flow_id", rs -> results.put(rs.getString(1), rs.getLong(2)));
        return results;
    }

    private Long getFlowSnapshotCount(String flowIdentifier) {
        String sql = "SELECT count(*) FROM FLOW_SNAPSHOT WHERE flow_id = ?";
        return (Long)this.jdbcTemplate.queryForObject("SELECT count(*) FROM FLOW_SNAPSHOT WHERE flow_id = ?", (rs, num) -> rs.getLong(1), new Object[]{flowIdentifier});
    }

    private Map<String, Long> getExtensionBundleVersionCounts() {
        String sql = "SELECT bundle_id, count(*) FROM BUNDLE_VERSION GROUP BY bundle_id";
        HashMap<String, Long> results = new HashMap<String, Long>();
        this.jdbcTemplate.query("SELECT bundle_id, count(*) FROM BUNDLE_VERSION GROUP BY bundle_id", rs -> results.put(rs.getString(1), rs.getLong(2)));
        return results;
    }

    private Long getExtensionBundleVersionCount(String extensionBundleIdentifier) {
        String sql = "SELECT count(*) FROM BUNDLE_VERSION WHERE bundle_id = ?";
        return (Long)this.jdbcTemplate.queryForObject("SELECT count(*) FROM BUNDLE_VERSION WHERE bundle_id = ?", (rs, num) -> rs.getLong(1), new Object[]{extensionBundleIdentifier});
    }

    @Override
    public FlowEntity createFlow(FlowEntity flow) {
        String itemSql = "INSERT INTO BUCKET_ITEM (ID, NAME, DESCRIPTION, CREATED, MODIFIED, ITEM_TYPE, BUCKET_ID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        this.jdbcTemplate.update("INSERT INTO BUCKET_ITEM (ID, NAME, DESCRIPTION, CREATED, MODIFIED, ITEM_TYPE, BUCKET_ID) VALUES (?, ?, ?, ?, ?, ?, ?)", new Object[]{flow.getId(), flow.getName(), flow.getDescription(), flow.getCreated(), flow.getModified(), flow.getType().toString(), flow.getBucketId()});
        String flowSql = "INSERT INTO FLOW (ID) VALUES (?)";
        this.jdbcTemplate.update("INSERT INTO FLOW (ID) VALUES (?)", new Object[]{flow.getId()});
        return flow;
    }

    @Override
    public FlowEntity getFlowById(String flowIdentifier) {
        String sql = "SELECT * FROM FLOW f, BUCKET_ITEM item WHERE f.id = ? AND item.id = f.id";
        try {
            return (FlowEntity)this.jdbcTemplate.queryForObject("SELECT * FROM FLOW f, BUCKET_ITEM item WHERE f.id = ? AND item.id = f.id", (RowMapper)new FlowEntityRowMapper(), new Object[]{flowIdentifier});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public FlowEntity getFlowByIdWithSnapshotCounts(String flowIdentifier) {
        FlowEntity flowEntity = this.getFlowById(flowIdentifier);
        if (flowEntity == null) {
            return flowEntity;
        }
        Long snapshotCount = this.getFlowSnapshotCount(flowIdentifier);
        if (snapshotCount != null) {
            flowEntity.setSnapshotCount(snapshotCount);
        }
        return flowEntity;
    }

    @Override
    public List<FlowEntity> getFlowsByName(String name) {
        String sql = "SELECT * FROM FLOW f, BUCKET_ITEM item WHERE item.name = ? AND item.id = f.id";
        return this.jdbcTemplate.query("SELECT * FROM FLOW f, BUCKET_ITEM item WHERE item.name = ? AND item.id = f.id", (RowMapper)new FlowEntityRowMapper(), new Object[]{name});
    }

    @Override
    public List<FlowEntity> getFlowsByName(String bucketIdentifier, String name) {
        String sql = "SELECT * FROM FLOW f, BUCKET_ITEM item WHERE item.name = ? AND item.id = f.id AND item.bucket_id = ?";
        return this.jdbcTemplate.query("SELECT * FROM FLOW f, BUCKET_ITEM item WHERE item.name = ? AND item.id = f.id AND item.bucket_id = ?", (RowMapper)new FlowEntityRowMapper(), new Object[]{name, bucketIdentifier});
    }

    @Override
    public List<FlowEntity> getFlowsByBucket(String bucketIdentifier) {
        String sql = "SELECT * FROM FLOW f, BUCKET_ITEM item WHERE item.bucket_id = ? AND item.id = f.id";
        List flows = this.jdbcTemplate.query("SELECT * FROM FLOW f, BUCKET_ITEM item WHERE item.bucket_id = ? AND item.id = f.id", (RowMapper)new FlowEntityRowMapper(), new Object[]{bucketIdentifier});
        Map<String, Long> snapshotCounts = this.getFlowSnapshotCounts();
        for (FlowEntity flowEntity : flows) {
            Long snapshotCount = snapshotCounts.get(flowEntity.getId());
            if (snapshotCount == null) continue;
            flowEntity.setSnapshotCount(snapshotCount);
        }
        return flows;
    }

    @Override
    public FlowEntity updateFlow(FlowEntity flow) {
        flow.setModified(new Date());
        String sql = "UPDATE BUCKET_ITEM SET name = ?, description = ?, modified = ? WHERE id = ?";
        this.jdbcTemplate.update("UPDATE BUCKET_ITEM SET name = ?, description = ?, modified = ? WHERE id = ?", new Object[]{flow.getName(), flow.getDescription(), flow.getModified(), flow.getId()});
        return flow;
    }

    @Override
    public void deleteFlow(FlowEntity flow) {
        String itemDeleteSql = "DELETE FROM BUCKET_ITEM WHERE id = ?";
        this.jdbcTemplate.update("DELETE FROM BUCKET_ITEM WHERE id = ?", new Object[]{flow.getId()});
    }

    @Override
    public FlowSnapshotEntity createFlowSnapshot(FlowSnapshotEntity flowSnapshot) {
        String sql = "INSERT INTO FLOW_SNAPSHOT (FLOW_ID, VERSION, CREATED, CREATED_BY, COMMENTS) VALUES (?, ?, ?, ?, ?)";
        this.jdbcTemplate.update("INSERT INTO FLOW_SNAPSHOT (FLOW_ID, VERSION, CREATED, CREATED_BY, COMMENTS) VALUES (?, ?, ?, ?, ?)", new Object[]{flowSnapshot.getFlowId(), flowSnapshot.getVersion(), flowSnapshot.getCreated(), flowSnapshot.getCreatedBy(), flowSnapshot.getComments()});
        return flowSnapshot;
    }

    @Override
    public FlowSnapshotEntity getFlowSnapshot(String flowIdentifier, Integer version) {
        String sql = "SELECT fs.flow_id, fs.version, fs.created, fs.created_by, fs.comments FROM FLOW_SNAPSHOT fs, FLOW f, BUCKET_ITEM item WHERE item.id = f.id AND f.id = ? AND f.id = fs.flow_id AND fs.version = ?";
        try {
            return (FlowSnapshotEntity)this.jdbcTemplate.queryForObject("SELECT fs.flow_id, fs.version, fs.created, fs.created_by, fs.comments FROM FLOW_SNAPSHOT fs, FLOW f, BUCKET_ITEM item WHERE item.id = f.id AND f.id = ? AND f.id = fs.flow_id AND fs.version = ?", (RowMapper)new FlowSnapshotEntityRowMapper(), new Object[]{flowIdentifier, version});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public FlowSnapshotEntity getLatestSnapshot(String flowIdentifier) {
        String sql = "SELECT * FROM FLOW_SNAPSHOT WHERE flow_id = ? ORDER BY version DESC LIMIT 1";
        try {
            return (FlowSnapshotEntity)this.jdbcTemplate.queryForObject("SELECT * FROM FLOW_SNAPSHOT WHERE flow_id = ? ORDER BY version DESC LIMIT 1", (RowMapper)new FlowSnapshotEntityRowMapper(), new Object[]{flowIdentifier});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public List<FlowSnapshotEntity> getSnapshots(String flowIdentifier) {
        String sql = "SELECT fs.flow_id, fs.version, fs.created, fs.created_by, fs.comments FROM FLOW_SNAPSHOT fs, FLOW f, BUCKET_ITEM item WHERE item.id = f.id AND f.id = ? AND f.id = fs.flow_id";
        return this.jdbcTemplate.query("SELECT fs.flow_id, fs.version, fs.created, fs.created_by, fs.comments FROM FLOW_SNAPSHOT fs, FLOW f, BUCKET_ITEM item WHERE item.id = f.id AND f.id = ? AND f.id = fs.flow_id", (RowMapper)new FlowSnapshotEntityRowMapper(), new Object[]{flowIdentifier});
    }

    @Override
    public void deleteFlowSnapshot(FlowSnapshotEntity flowSnapshot) {
        String sql = "DELETE FROM FLOW_SNAPSHOT WHERE flow_id = ? AND version = ?";
        this.jdbcTemplate.update("DELETE FROM FLOW_SNAPSHOT WHERE flow_id = ? AND version = ?", new Object[]{flowSnapshot.getFlowId(), flowSnapshot.getVersion()});
    }

    @Override
    public BundleEntity createBundle(BundleEntity extensionBundle) {
        String itemSql = "INSERT INTO BUCKET_ITEM (ID, NAME, DESCRIPTION, CREATED, MODIFIED, ITEM_TYPE, BUCKET_ID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        this.jdbcTemplate.update("INSERT INTO BUCKET_ITEM (ID, NAME, DESCRIPTION, CREATED, MODIFIED, ITEM_TYPE, BUCKET_ID) VALUES (?, ?, ?, ?, ?, ?, ?)", new Object[]{extensionBundle.getId(), extensionBundle.getName(), extensionBundle.getDescription(), extensionBundle.getCreated(), extensionBundle.getModified(), extensionBundle.getType().name(), extensionBundle.getBucketId()});
        String bundleSql = "INSERT INTO BUNDLE (ID, BUCKET_ID, BUNDLE_TYPE, GROUP_ID, ARTIFACT_ID) VALUES (?, ?, ?, ?, ?)";
        this.jdbcTemplate.update("INSERT INTO BUNDLE (ID, BUCKET_ID, BUNDLE_TYPE, GROUP_ID, ARTIFACT_ID) VALUES (?, ?, ?, ?, ?)", new Object[]{extensionBundle.getId(), extensionBundle.getBucketId(), extensionBundle.getBundleType().name(), extensionBundle.getGroupId(), extensionBundle.getArtifactId()});
        return extensionBundle;
    }

    @Override
    public BundleEntity getBundle(String extensionBundleId) {
        StringBuilder sqlBuilder = new StringBuilder(BASE_BUNDLE_SQL).append(" AND eb.id = ?");
        try {
            BundleEntity entity = (BundleEntity)this.jdbcTemplate.queryForObject(sqlBuilder.toString(), (RowMapper)new BundleEntityRowMapper(), new Object[]{extensionBundleId});
            Long versionCount = this.getExtensionBundleVersionCount(extensionBundleId);
            if (versionCount != null) {
                entity.setVersionCount(versionCount);
            }
            return entity;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public BundleEntity getBundle(String bucketId, String groupId, String artifactId) {
        StringBuilder sqlBuilder = new StringBuilder(BASE_BUNDLE_SQL).append(" AND eb.bucket_id = ? ").append("AND eb.group_id = ? ").append("AND eb.artifact_id = ? ");
        try {
            BundleEntity entity = (BundleEntity)this.jdbcTemplate.queryForObject(sqlBuilder.toString(), (RowMapper)new BundleEntityRowMapper(), new Object[]{bucketId, groupId, artifactId});
            Long versionCount = this.getExtensionBundleVersionCount(entity.getId());
            if (versionCount != null) {
                entity.setVersionCount(versionCount);
            }
            return entity;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public List<BundleEntity> getBundles(Set<String> bucketIds, BundleFilterParams filterParams) {
        if (bucketIds == null || bucketIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sqlBuilder = new StringBuilder("SELECT item.id as ID, item.name as NAME, item.description as DESCRIPTION, item.created as CREATED, item.modified as MODIFIED, item.item_type as ITEM_TYPE, b.id as BUCKET_ID, b.name as BUCKET_NAME ,eb.bundle_type as BUNDLE_TYPE, eb.group_id as GROUP_ID, eb.artifact_id as ARTIFACT_ID FROM BUNDLE eb, BUCKET_ITEM item,BUCKET b WHERE item.id = eb.id AND b.id = item.bucket_id");
        if (filterParams != null) {
            String artifactId;
            String groupId;
            String bucketName = filterParams.getBucketName();
            if (!StringUtils.isBlank((CharSequence)bucketName)) {
                sqlBuilder.append(" AND b.name LIKE ? ");
                args.add(bucketName);
            }
            if (!StringUtils.isBlank((CharSequence)(groupId = filterParams.getGroupId()))) {
                sqlBuilder.append(" AND eb.group_id LIKE ? ");
                args.add(groupId);
            }
            if (!StringUtils.isBlank((CharSequence)(artifactId = filterParams.getArtifactId()))) {
                sqlBuilder.append(" AND eb.artifact_id LIKE ? ");
                args.add(artifactId);
            }
        }
        sqlBuilder.append(" AND ");
        this.addIdentifiersInClause(sqlBuilder, "item.bucket_id", bucketIds);
        sqlBuilder.append("ORDER BY eb.group_id ASC, eb.artifact_id ASC");
        args.addAll(bucketIds);
        List bundleEntities = this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)new BundleEntityRowMapper(), args.toArray());
        return this.populateVersionCounts(bundleEntities);
    }

    @Override
    public List<BundleEntity> getBundlesByBucket(String bucketId) {
        String sqlBuilder = "SELECT item.id as ID,item.name as NAME, item.description as DESCRIPTION, item.created as CREATED, item.modified as MODIFIED, eb.bundle_type as BUNDLE_TYPE, eb.group_id as GROUP_ID, eb.artifact_id as ARTIFACT_ID, b.id as BUCKET_ID, b.name as BUCKET_NAME FROM BUNDLE eb, BUCKET_ITEM item,BUCKET b WHERE eb.id = item.id AND item.bucket_id = b.id AND b.id = ? ORDER BY eb.group_id ASC, eb.artifact_id ASC";
        List bundles = this.jdbcTemplate.query("SELECT item.id as ID,item.name as NAME, item.description as DESCRIPTION, item.created as CREATED, item.modified as MODIFIED, eb.bundle_type as BUNDLE_TYPE, eb.group_id as GROUP_ID, eb.artifact_id as ARTIFACT_ID, b.id as BUCKET_ID, b.name as BUCKET_NAME FROM BUNDLE eb, BUCKET_ITEM item,BUCKET b WHERE eb.id = item.id AND item.bucket_id = b.id AND b.id = ? ORDER BY eb.group_id ASC, eb.artifact_id ASC", (RowMapper)new BundleEntityRowMapper(), new Object[]{bucketId});
        return this.populateVersionCounts(bundles);
    }

    @Override
    public List<BundleEntity> getBundlesByBucketAndGroup(String bucketId, String groupId) {
        StringBuilder sqlBuilder = new StringBuilder(BASE_BUNDLE_SQL).append(" AND b.id = ?").append(" AND eb.group_id = ?").append(" ORDER BY eb.group_id ASC, eb.artifact_id ASC");
        List bundles = this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)new BundleEntityRowMapper(), new Object[]{bucketId, groupId});
        return this.populateVersionCounts(bundles);
    }

    private List<BundleEntity> populateVersionCounts(List<BundleEntity> bundles) {
        if (!bundles.isEmpty()) {
            Map<String, Long> versionCounts = this.getExtensionBundleVersionCounts();
            for (BundleEntity entity : bundles) {
                Long versionCount = versionCounts.get(entity.getId());
                if (versionCount == null) continue;
                entity.setVersionCount(versionCount);
            }
        }
        return bundles;
    }

    @Override
    public void deleteBundle(BundleEntity extensionBundle) {
        this.deleteBundle(extensionBundle.getId());
    }

    @Override
    public void deleteBundle(String extensionBundleId) {
        String itemDeleteSql = "DELETE FROM BUCKET_ITEM WHERE id = ?";
        this.jdbcTemplate.update("DELETE FROM BUCKET_ITEM WHERE id = ?", new Object[]{extensionBundleId});
    }

    @Override
    public BundleVersionEntity createBundleVersion(BundleVersionEntity extensionBundleVersion) {
        String sql = "INSERT INTO BUNDLE_VERSION (ID, BUNDLE_ID, VERSION, CREATED, CREATED_BY, DESCRIPTION, SHA_256_HEX, SHA_256_SUPPLIED,CONTENT_SIZE, SYSTEM_API_VERSION, BUILD_TOOL, BUILD_FLAGS, BUILD_BRANCH, BUILD_TAG, BUILD_REVISION, BUILT, BUILT_BY) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.jdbcTemplate.update("INSERT INTO BUNDLE_VERSION (ID, BUNDLE_ID, VERSION, CREATED, CREATED_BY, DESCRIPTION, SHA_256_HEX, SHA_256_SUPPLIED,CONTENT_SIZE, SYSTEM_API_VERSION, BUILD_TOOL, BUILD_FLAGS, BUILD_BRANCH, BUILD_TAG, BUILD_REVISION, BUILT, BUILT_BY) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{extensionBundleVersion.getId(), extensionBundleVersion.getBundleId(), extensionBundleVersion.getVersion(), extensionBundleVersion.getCreated(), extensionBundleVersion.getCreatedBy(), extensionBundleVersion.getDescription(), extensionBundleVersion.getSha256Hex(), extensionBundleVersion.getSha256Supplied() ? 1 : 0, extensionBundleVersion.getContentSize(), extensionBundleVersion.getSystemApiVersion(), extensionBundleVersion.getBuildTool(), extensionBundleVersion.getBuildFlags(), extensionBundleVersion.getBuildBranch(), extensionBundleVersion.getBuildTag(), extensionBundleVersion.getBuildRevision(), extensionBundleVersion.getBuilt(), extensionBundleVersion.getBuiltBy()});
        return extensionBundleVersion;
    }

    @Override
    public BundleVersionEntity getBundleVersion(String extensionBundleId, String version) {
        String sql = "SELECT ebv.id AS ID,ebv.bundle_id AS BUNDLE_ID, ebv.version AS VERSION, ebv.created AS CREATED, ebv.created_by AS CREATED_BY, ebv.description AS DESCRIPTION, ebv.sha_256_hex AS SHA_256_HEX, ebv.sha_256_supplied AS SHA_256_SUPPLIED ,ebv.content_size AS CONTENT_SIZE, ebv.system_api_version AS SYSTEM_API_VERSION, ebv.build_tool AS BUILD_TOOL, ebv.build_flags AS BUILD_FLAGS, ebv.build_branch AS BUILD_BRANCH, ebv.build_tag AS BUILD_TAG, ebv.build_revision AS BUILD_REVISION, ebv.built AS BUILT, ebv.built_by AS BUILT_BY, eb.bucket_id AS BUCKET_ID, eb.group_id AS GROUP_ID, eb.artifact_id AS ARTIFACT_ID FROM BUNDLE eb, BUNDLE_VERSION ebv WHERE eb.id = ebv.bundle_id  AND ebv.bundle_id = ? AND ebv.version = ?";
        try {
            return (BundleVersionEntity)this.jdbcTemplate.queryForObject("SELECT ebv.id AS ID,ebv.bundle_id AS BUNDLE_ID, ebv.version AS VERSION, ebv.created AS CREATED, ebv.created_by AS CREATED_BY, ebv.description AS DESCRIPTION, ebv.sha_256_hex AS SHA_256_HEX, ebv.sha_256_supplied AS SHA_256_SUPPLIED ,ebv.content_size AS CONTENT_SIZE, ebv.system_api_version AS SYSTEM_API_VERSION, ebv.build_tool AS BUILD_TOOL, ebv.build_flags AS BUILD_FLAGS, ebv.build_branch AS BUILD_BRANCH, ebv.build_tag AS BUILD_TAG, ebv.build_revision AS BUILD_REVISION, ebv.built AS BUILT, ebv.built_by AS BUILT_BY, eb.bucket_id AS BUCKET_ID, eb.group_id AS GROUP_ID, eb.artifact_id AS ARTIFACT_ID FROM BUNDLE eb, BUNDLE_VERSION ebv WHERE eb.id = ebv.bundle_id  AND ebv.bundle_id = ? AND ebv.version = ?", (RowMapper)new BundleVersionEntityRowMapper(), new Object[]{extensionBundleId, version});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public BundleVersionEntity getBundleVersion(String bucketId, String groupId, String artifactId, String version) {
        String sql = "SELECT ebv.id AS ID,ebv.bundle_id AS BUNDLE_ID, ebv.version AS VERSION, ebv.created AS CREATED, ebv.created_by AS CREATED_BY, ebv.description AS DESCRIPTION, ebv.sha_256_hex AS SHA_256_HEX, ebv.sha_256_supplied AS SHA_256_SUPPLIED ,ebv.content_size AS CONTENT_SIZE, ebv.system_api_version AS SYSTEM_API_VERSION, ebv.build_tool AS BUILD_TOOL, ebv.build_flags AS BUILD_FLAGS, ebv.build_branch AS BUILD_BRANCH, ebv.build_tag AS BUILD_TAG, ebv.build_revision AS BUILD_REVISION, ebv.built AS BUILT, ebv.built_by AS BUILT_BY, eb.bucket_id AS BUCKET_ID, eb.group_id AS GROUP_ID, eb.artifact_id AS ARTIFACT_ID FROM BUNDLE eb, BUNDLE_VERSION ebv WHERE eb.id = ebv.bundle_id AND eb.bucket_id = ? AND eb.group_id = ? AND eb.artifact_id = ? AND ebv.version = ?";
        try {
            return (BundleVersionEntity)this.jdbcTemplate.queryForObject("SELECT ebv.id AS ID,ebv.bundle_id AS BUNDLE_ID, ebv.version AS VERSION, ebv.created AS CREATED, ebv.created_by AS CREATED_BY, ebv.description AS DESCRIPTION, ebv.sha_256_hex AS SHA_256_HEX, ebv.sha_256_supplied AS SHA_256_SUPPLIED ,ebv.content_size AS CONTENT_SIZE, ebv.system_api_version AS SYSTEM_API_VERSION, ebv.build_tool AS BUILD_TOOL, ebv.build_flags AS BUILD_FLAGS, ebv.build_branch AS BUILD_BRANCH, ebv.build_tag AS BUILD_TAG, ebv.build_revision AS BUILD_REVISION, ebv.built AS BUILT, ebv.built_by AS BUILT_BY, eb.bucket_id AS BUCKET_ID, eb.group_id AS GROUP_ID, eb.artifact_id AS ARTIFACT_ID FROM BUNDLE eb, BUNDLE_VERSION ebv WHERE eb.id = ebv.bundle_id AND eb.bucket_id = ? AND eb.group_id = ? AND eb.artifact_id = ? AND ebv.version = ?", (RowMapper)new BundleVersionEntityRowMapper(), new Object[]{bucketId, groupId, artifactId, version});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public List<BundleVersionEntity> getBundleVersions(Set<String> bucketIdentifiers, BundleVersionFilterParams filterParams) {
        if (bucketIdentifiers == null || bucketIdentifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sqlBuilder = new StringBuilder(BASE_EXTENSION_BUNDLE_VERSION_SQL);
        if (filterParams != null) {
            String version;
            String artifactId;
            String groupId = filterParams.getGroupId();
            if (!StringUtils.isBlank((CharSequence)groupId)) {
                sqlBuilder.append(" AND eb.group_id LIKE ? ");
                args.add(groupId);
            }
            if (!StringUtils.isBlank((CharSequence)(artifactId = filterParams.getArtifactId()))) {
                sqlBuilder.append(" AND eb.artifact_id LIKE ? ");
                args.add(artifactId);
            }
            if (!StringUtils.isBlank((CharSequence)(version = filterParams.getVersion()))) {
                sqlBuilder.append(" AND ebv.version LIKE ? ");
                args.add(version);
            }
        }
        sqlBuilder.append(" AND ");
        this.addIdentifiersInClause(sqlBuilder, "eb.bucket_id", bucketIdentifiers);
        args.addAll(bucketIdentifiers);
        List bundleVersionEntities = this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)new BundleVersionEntityRowMapper(), args.toArray());
        return bundleVersionEntities;
    }

    private void addIdentifiersInClause(StringBuilder sqlBuilder, String idFieldName, Set<String> identifiers) {
        sqlBuilder.append(idFieldName).append(" IN (");
        for (int i = 0; i < identifiers.size(); ++i) {
            if (i > 0) {
                sqlBuilder.append(", ");
            }
            sqlBuilder.append("?");
        }
        sqlBuilder.append(") ");
    }

    @Override
    public List<BundleVersionEntity> getBundleVersions(String extensionBundleId) {
        String sql = "SELECT ebv.id AS ID,ebv.bundle_id AS BUNDLE_ID, ebv.version AS VERSION, ebv.created AS CREATED, ebv.created_by AS CREATED_BY, ebv.description AS DESCRIPTION, ebv.sha_256_hex AS SHA_256_HEX, ebv.sha_256_supplied AS SHA_256_SUPPLIED ,ebv.content_size AS CONTENT_SIZE, ebv.system_api_version AS SYSTEM_API_VERSION, ebv.build_tool AS BUILD_TOOL, ebv.build_flags AS BUILD_FLAGS, ebv.build_branch AS BUILD_BRANCH, ebv.build_tag AS BUILD_TAG, ebv.build_revision AS BUILD_REVISION, ebv.built AS BUILT, ebv.built_by AS BUILT_BY, eb.bucket_id AS BUCKET_ID, eb.group_id AS GROUP_ID, eb.artifact_id AS ARTIFACT_ID FROM BUNDLE eb, BUNDLE_VERSION ebv WHERE eb.id = ebv.bundle_id  AND ebv.bundle_id = ?";
        return this.jdbcTemplate.query("SELECT ebv.id AS ID,ebv.bundle_id AS BUNDLE_ID, ebv.version AS VERSION, ebv.created AS CREATED, ebv.created_by AS CREATED_BY, ebv.description AS DESCRIPTION, ebv.sha_256_hex AS SHA_256_HEX, ebv.sha_256_supplied AS SHA_256_SUPPLIED ,ebv.content_size AS CONTENT_SIZE, ebv.system_api_version AS SYSTEM_API_VERSION, ebv.build_tool AS BUILD_TOOL, ebv.build_flags AS BUILD_FLAGS, ebv.build_branch AS BUILD_BRANCH, ebv.build_tag AS BUILD_TAG, ebv.build_revision AS BUILD_REVISION, ebv.built AS BUILT, ebv.built_by AS BUILT_BY, eb.bucket_id AS BUCKET_ID, eb.group_id AS GROUP_ID, eb.artifact_id AS ARTIFACT_ID FROM BUNDLE eb, BUNDLE_VERSION ebv WHERE eb.id = ebv.bundle_id  AND ebv.bundle_id = ?", (RowMapper)new BundleVersionEntityRowMapper(), new Object[]{extensionBundleId});
    }

    @Override
    public List<BundleVersionEntity> getBundleVersions(String bucketId, String groupId, String artifactId) {
        String sql = "SELECT ebv.id AS ID,ebv.bundle_id AS BUNDLE_ID, ebv.version AS VERSION, ebv.created AS CREATED, ebv.created_by AS CREATED_BY, ebv.description AS DESCRIPTION, ebv.sha_256_hex AS SHA_256_HEX, ebv.sha_256_supplied AS SHA_256_SUPPLIED ,ebv.content_size AS CONTENT_SIZE, ebv.system_api_version AS SYSTEM_API_VERSION, ebv.build_tool AS BUILD_TOOL, ebv.build_flags AS BUILD_FLAGS, ebv.build_branch AS BUILD_BRANCH, ebv.build_tag AS BUILD_TAG, ebv.build_revision AS BUILD_REVISION, ebv.built AS BUILT, ebv.built_by AS BUILT_BY, eb.bucket_id AS BUCKET_ID, eb.group_id AS GROUP_ID, eb.artifact_id AS ARTIFACT_ID FROM BUNDLE eb, BUNDLE_VERSION ebv WHERE eb.id = ebv.bundle_id AND eb.bucket_id = ? AND eb.group_id = ? AND eb.artifact_id = ? ";
        return this.jdbcTemplate.query("SELECT ebv.id AS ID,ebv.bundle_id AS BUNDLE_ID, ebv.version AS VERSION, ebv.created AS CREATED, ebv.created_by AS CREATED_BY, ebv.description AS DESCRIPTION, ebv.sha_256_hex AS SHA_256_HEX, ebv.sha_256_supplied AS SHA_256_SUPPLIED ,ebv.content_size AS CONTENT_SIZE, ebv.system_api_version AS SYSTEM_API_VERSION, ebv.build_tool AS BUILD_TOOL, ebv.build_flags AS BUILD_FLAGS, ebv.build_branch AS BUILD_BRANCH, ebv.build_tag AS BUILD_TAG, ebv.build_revision AS BUILD_REVISION, ebv.built AS BUILT, ebv.built_by AS BUILT_BY, eb.bucket_id AS BUCKET_ID, eb.group_id AS GROUP_ID, eb.artifact_id AS ARTIFACT_ID FROM BUNDLE eb, BUNDLE_VERSION ebv WHERE eb.id = ebv.bundle_id AND eb.bucket_id = ? AND eb.group_id = ? AND eb.artifact_id = ? ", (RowMapper)new BundleVersionEntityRowMapper(), new Object[]{bucketId, groupId, artifactId});
    }

    @Override
    public List<BundleVersionEntity> getBundleVersionsGlobal(String groupId, String artifactId, String version) {
        String sql = "SELECT ebv.id AS ID,ebv.bundle_id AS BUNDLE_ID, ebv.version AS VERSION, ebv.created AS CREATED, ebv.created_by AS CREATED_BY, ebv.description AS DESCRIPTION, ebv.sha_256_hex AS SHA_256_HEX, ebv.sha_256_supplied AS SHA_256_SUPPLIED ,ebv.content_size AS CONTENT_SIZE, ebv.system_api_version AS SYSTEM_API_VERSION, ebv.build_tool AS BUILD_TOOL, ebv.build_flags AS BUILD_FLAGS, ebv.build_branch AS BUILD_BRANCH, ebv.build_tag AS BUILD_TAG, ebv.build_revision AS BUILD_REVISION, ebv.built AS BUILT, ebv.built_by AS BUILT_BY, eb.bucket_id AS BUCKET_ID, eb.group_id AS GROUP_ID, eb.artifact_id AS ARTIFACT_ID FROM BUNDLE eb, BUNDLE_VERSION ebv WHERE eb.id = ebv.bundle_id AND eb.group_id = ? AND eb.artifact_id = ? AND ebv.version = ?";
        return this.jdbcTemplate.query("SELECT ebv.id AS ID,ebv.bundle_id AS BUNDLE_ID, ebv.version AS VERSION, ebv.created AS CREATED, ebv.created_by AS CREATED_BY, ebv.description AS DESCRIPTION, ebv.sha_256_hex AS SHA_256_HEX, ebv.sha_256_supplied AS SHA_256_SUPPLIED ,ebv.content_size AS CONTENT_SIZE, ebv.system_api_version AS SYSTEM_API_VERSION, ebv.build_tool AS BUILD_TOOL, ebv.build_flags AS BUILD_FLAGS, ebv.build_branch AS BUILD_BRANCH, ebv.build_tag AS BUILD_TAG, ebv.build_revision AS BUILD_REVISION, ebv.built AS BUILT, ebv.built_by AS BUILT_BY, eb.bucket_id AS BUCKET_ID, eb.group_id AS GROUP_ID, eb.artifact_id AS ARTIFACT_ID FROM BUNDLE eb, BUNDLE_VERSION ebv WHERE eb.id = ebv.bundle_id AND eb.group_id = ? AND eb.artifact_id = ? AND ebv.version = ?", (RowMapper)new BundleVersionEntityRowMapper(), new Object[]{groupId, artifactId, version});
    }

    @Override
    public void deleteBundleVersion(BundleVersionEntity extensionBundleVersion) {
        this.deleteBundleVersion(extensionBundleVersion.getId());
    }

    @Override
    public void deleteBundleVersion(String extensionBundleVersionId) {
        String sql = "DELETE FROM BUNDLE_VERSION WHERE id = ?";
        this.jdbcTemplate.update("DELETE FROM BUNDLE_VERSION WHERE id = ?", new Object[]{extensionBundleVersionId});
    }

    @Override
    public BundleVersionDependencyEntity createDependency(BundleVersionDependencyEntity dependencyEntity) {
        String dependencySql = "INSERT INTO BUNDLE_VERSION_DEPENDENCY (ID, BUNDLE_VERSION_ID, GROUP_ID, ARTIFACT_ID, VERSION ) VALUES (?, ?, ?, ?, ?)";
        this.jdbcTemplate.update("INSERT INTO BUNDLE_VERSION_DEPENDENCY (ID, BUNDLE_VERSION_ID, GROUP_ID, ARTIFACT_ID, VERSION ) VALUES (?, ?, ?, ?, ?)", new Object[]{dependencyEntity.getId(), dependencyEntity.getExtensionBundleVersionId(), dependencyEntity.getGroupId(), dependencyEntity.getArtifactId(), dependencyEntity.getVersion()});
        return dependencyEntity;
    }

    @Override
    public List<BundleVersionDependencyEntity> getDependenciesForBundleVersion(String extensionBundleVersionId) {
        String sql = "SELECT * FROM BUNDLE_VERSION_DEPENDENCY WHERE bundle_version_id = ?";
        return this.jdbcTemplate.query("SELECT * FROM BUNDLE_VERSION_DEPENDENCY WHERE bundle_version_id = ?", (RowMapper)new BundleVersionDependencyEntityRowMapper(), new Object[]{extensionBundleVersionId});
    }

    @Override
    public ExtensionEntity createExtension(ExtensionEntity extension) {
        Set<ExtensionRestrictionEntity> restrictions;
        Set<ExtensionProvidedServiceApiEntity> providedServiceApis;
        String insertExtensionSql = "INSERT INTO EXTENSION (ID, BUNDLE_VERSION_ID, NAME, DISPLAY_NAME, TYPE, CONTENT, ADDITIONAL_DETAILS, HAS_ADDITIONAL_DETAILS ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        this.jdbcTemplate.update("INSERT INTO EXTENSION (ID, BUNDLE_VERSION_ID, NAME, DISPLAY_NAME, TYPE, CONTENT, ADDITIONAL_DETAILS, HAS_ADDITIONAL_DETAILS ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{extension.getId(), extension.getBundleVersionId(), extension.getName(), extension.getDisplayName(), extension.getExtensionType().name(), extension.getContent(), extension.getAdditionalDetails(), extension.getAdditionalDetails() != null ? 1 : 0});
        String insertTagSql = "INSERT INTO EXTENSION_TAG (EXTENSION_ID, TAG) VALUES (?, ?);";
        Set<String> tags = extension.getTags();
        if (tags != null) {
            for (String tag : tags) {
                String normalizedTag;
                if (tag == null || (normalizedTag = tag.trim().toLowerCase()).isEmpty()) continue;
                this.jdbcTemplate.update("INSERT INTO EXTENSION_TAG (EXTENSION_ID, TAG) VALUES (?, ?);", new Object[]{extension.getId(), normalizedTag});
            }
        }
        if ((providedServiceApis = extension.getProvidedServiceApis()) != null) {
            providedServiceApis.forEach(p -> this.createProvidedServiceApi((ExtensionProvidedServiceApiEntity)p));
        }
        if ((restrictions = extension.getRestrictions()) != null) {
            restrictions.forEach(r -> this.createRestriction((ExtensionRestrictionEntity)r));
        }
        return extension;
    }

    @Override
    public ExtensionEntity getExtensionById(String id) {
        String selectSql = BASE_EXTENSION_SQL + " AND e.id = ?";
        try {
            return (ExtensionEntity)this.jdbcTemplate.queryForObject(selectSql, (RowMapper)new ExtensionEntityRowMapper(), new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public ExtensionEntity getExtensionByName(String bundleVersionId, String name) {
        String selectSql = BASE_EXTENSION_SQL + " AND e.bundle_version_id = ? AND e.name = ?";
        try {
            return (ExtensionEntity)this.jdbcTemplate.queryForObject(selectSql, (RowMapper)new ExtensionEntityRowMapper(), new Object[]{bundleVersionId, name});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public ExtensionAdditionalDetailsEntity getExtensionAdditionalDetails(String bundleVersionId, String name) {
        String selectSql = "SELECT id, additional_details FROM EXTENSION WHERE bundle_version_id = ? AND name = ?";
        try {
            return (ExtensionAdditionalDetailsEntity)this.jdbcTemplate.queryForObject("SELECT id, additional_details FROM EXTENSION WHERE bundle_version_id = ? AND name = ?", (rs, i) -> {
                ExtensionAdditionalDetailsEntity entity = new ExtensionAdditionalDetailsEntity();
                entity.setExtensionId(rs.getString("ID"));
                entity.setAdditionalDetails(Optional.ofNullable(rs.getString("ADDITIONAL_DETAILS")));
                return entity;
            }, new Object[]{bundleVersionId, name});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public List<ExtensionEntity> getExtensions(Set<String> bucketIdentifiers, ExtensionFilterParams filterParams) {
        if (bucketIdentifiers == null || bucketIdentifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sqlBuilder = new StringBuilder(BASE_EXTENSION_SQL);
        sqlBuilder.append(" AND ");
        this.addIdentifiersInClause(sqlBuilder, "eb.bucket_id", bucketIdentifiers);
        args.addAll(bucketIdentifiers);
        if (filterParams != null) {
            Set tags;
            ExtensionType extensionType;
            BundleType bundleType = filterParams.getBundleType();
            if (bundleType != null) {
                sqlBuilder.append(" AND eb.bundle_type = ?");
                args.add(bundleType.name());
            }
            if ((extensionType = filterParams.getExtensionType()) != null) {
                sqlBuilder.append(" AND e.type = ?");
                args.add(extensionType.name());
            }
            if ((tags = filterParams.getTags()) != null && !tags.isEmpty()) {
                sqlBuilder.append(" AND e.id IN (").append(" SELECT et.extension_id FROM EXTENSION_TAG et WHERE ");
                boolean first = true;
                for (String tag : tags) {
                    if (!first) {
                        sqlBuilder.append(" OR ");
                    }
                    sqlBuilder.append(" et.tag = ? ");
                    args.add(tag.trim().toLowerCase());
                    first = false;
                }
                sqlBuilder.append(")");
            }
        }
        sqlBuilder.append(" ORDER BY e.name ASC");
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)new ExtensionEntityRowMapper(), args.toArray());
    }

    @Override
    public List<ExtensionEntity> getExtensionsByProvidedServiceApi(Set<String> bucketIdentifiers, ProvidedServiceAPI providedServiceAPI) {
        if (bucketIdentifiers == null || bucketIdentifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sqlBuilder = new StringBuilder(BASE_EXTENSION_SQL);
        sqlBuilder.append(" AND ");
        this.addIdentifiersInClause(sqlBuilder, "eb.bucket_id", bucketIdentifiers);
        args.addAll(bucketIdentifiers);
        sqlBuilder.append(" AND e.id IN (").append(" SELECT ep.extension_id FROM EXTENSION_PROVIDED_SERVICE_API ep").append(" WHERE ep.class_name = ? ").append(" AND ep.group_id = ? ").append(" AND ep.artifact_id = ? ").append(" AND ep.version = ?").append(")");
        args.add(providedServiceAPI.getClassName());
        args.add(providedServiceAPI.getGroupId());
        args.add(providedServiceAPI.getArtifactId());
        args.add(providedServiceAPI.getVersion());
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)new ExtensionEntityRowMapper(), args.toArray());
    }

    @Override
    public List<ExtensionEntity> getExtensionsByBundleVersionId(String bundleVersionId) {
        String selectSql = BASE_EXTENSION_SQL + " AND e.bundle_version_id = ?";
        Object[] args = new Object[]{bundleVersionId};
        return this.jdbcTemplate.query(selectSql, (RowMapper)new ExtensionEntityRowMapper(), new Object[]{bundleVersionId});
    }

    @Override
    public List<TagCountEntity> getAllExtensionTags() {
        String selectSql = "SELECT tag as TAG, count(*) as COUNT FROM EXTENSION_TAG GROUP BY tag ORDER BY tag ASC";
        return this.jdbcTemplate.query("SELECT tag as TAG, count(*) as COUNT FROM EXTENSION_TAG GROUP BY tag ORDER BY tag ASC", (RowMapper)new TagCountEntityMapper());
    }

    @Override
    public void deleteExtension(ExtensionEntity extension) {
        String deleteSql = "DELETE FROM EXTENSION WHERE id = ?";
        this.jdbcTemplate.update("DELETE FROM EXTENSION WHERE id = ?", new Object[]{extension.getId()});
    }

    private ExtensionProvidedServiceApiEntity createProvidedServiceApi(ExtensionProvidedServiceApiEntity providedServiceApi) {
        String sql = "INSERT INTO EXTENSION_PROVIDED_SERVICE_API (ID, EXTENSION_ID, CLASS_NAME, GROUP_ID, ARTIFACT_ID, VERSION) VALUES (?, ?, ?, ?, ?, ?)";
        this.jdbcTemplate.update("INSERT INTO EXTENSION_PROVIDED_SERVICE_API (ID, EXTENSION_ID, CLASS_NAME, GROUP_ID, ARTIFACT_ID, VERSION) VALUES (?, ?, ?, ?, ?, ?)", new Object[]{providedServiceApi.getId(), providedServiceApi.getExtensionId(), providedServiceApi.getClassName(), providedServiceApi.getGroupId(), providedServiceApi.getArtifactId(), providedServiceApi.getVersion()});
        return providedServiceApi;
    }

    private ExtensionRestrictionEntity createRestriction(ExtensionRestrictionEntity restriction) {
        String sql = "INSERT INTO EXTENSION_RESTRICTION (ID, EXTENSION_ID, REQUIRED_PERMISSION, EXPLANATION) VALUES (?, ?, ?, ?)";
        this.jdbcTemplate.update("INSERT INTO EXTENSION_RESTRICTION (ID, EXTENSION_ID, REQUIRED_PERMISSION, EXPLANATION) VALUES (?, ?, ?, ?)", new Object[]{restriction.getId(), restriction.getExtensionId(), restriction.getRequiredPermission(), restriction.getExplanation()});
        return restriction;
    }

    @Override
    public Set<String> getBucketFields() {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        fields.add("ID");
        fields.add("NAME");
        fields.add("DESCRIPTION");
        fields.add("CREATED");
        return fields;
    }

    @Override
    public Set<String> getBucketItemFields() {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        fields.add("ID");
        fields.add("NAME");
        fields.add("DESCRIPTION");
        fields.add("CREATED");
        fields.add("MODIFIED");
        fields.add("ITEM_TYPE");
        fields.add("BUCKET_ID");
        return fields;
    }

    @Override
    public Set<String> getFlowFields() {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        fields.add("ID");
        fields.add("NAME");
        fields.add("DESCRIPTION");
        fields.add("CREATED");
        fields.add("MODIFIED");
        fields.add("ITEM_TYPE");
        fields.add("BUCKET_ID");
        return fields;
    }
}

