/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.process;

import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.bootstrap.process.AbstractFileBasedRuntimeValidator;
import org.apache.nifi.bootstrap.process.RuntimeValidatorResult;

public class AvailableLocalPorts
extends AbstractFileBasedRuntimeValidator {
    private static final String FILE_PATH = "/proc/sys/net/ipv4/ip_local_port_range";
    private static final Pattern PATTERN = Pattern.compile("(\\d+)\\s+(\\d+)");
    private static final int RECOMMENDED_AVAILABLE_PORTS = 55000;

    public AvailableLocalPorts() {
        super(new File(FILE_PATH));
    }

    AvailableLocalPorts(File configurationFile) {
        super(configurationFile);
    }

    @Override
    protected Pattern getPattern() {
        return PATTERN;
    }

    @Override
    protected void performChecks(Matcher matcher, List<RuntimeValidatorResult> results) {
        String configurationPath = this.getConfigurationFile().getPath();
        if (matcher.find()) {
            int lowerPort = Integer.parseInt(matcher.group(1));
            int higherPort = Integer.parseInt(matcher.group(2));
            int availablePorts = higherPort - lowerPort;
            if (availablePorts < 55000) {
                RuntimeValidatorResult result = this.getResultBuilder(RuntimeValidatorResult.Outcome.FAILED).explanation(String.format("Local Ports [%d] less than recommended [%d] according to [%s]", availablePorts, 55000, configurationPath)).build();
                results.add(result);
            }
        } else {
            RuntimeValidatorResult result = this.getResultBuilder(RuntimeValidatorResult.Outcome.FAILED).explanation(String.format("Configuration file [%s] cannot be parsed", configurationPath)).build();
            results.add(result);
        }
    }
}

