/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.bootstrap.RunNiFi;

public class ShutdownHook
extends Thread {
    private final Process nifiProcess;
    private final Long pid;
    private final RunNiFi runner;
    private final int gracefulShutdownSeconds;
    private final ExecutorService executor;
    private volatile String secretKey;

    public ShutdownHook(Process nifiProcess, Long pid, RunNiFi runner, String secretKey, int gracefulShutdownSeconds, ExecutorService executor) {
        this.nifiProcess = nifiProcess;
        this.pid = pid;
        this.runner = runner;
        this.secretKey = secretKey;
        this.gracefulShutdownSeconds = gracefulShutdownSeconds;
        this.executor = executor;
    }

    void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Override
    public void run() {
        this.executor.shutdown();
        this.runner.setAutoRestartNiFi(false);
        int ccPort = this.runner.getNiFiCommandControlPort();
        if (ccPort > 0) {
            System.out.printf("NiFi PID [%d] shutdown started%n", this.pid);
            try {
                Socket socket = new Socket("localhost", ccPort);
                OutputStream out = socket.getOutputStream();
                out.write(("SHUTDOWN " + this.secretKey + "\n").getBytes(StandardCharsets.UTF_8));
                out.flush();
                socket.close();
            }
            catch (IOException ioe) {
                System.out.println("Failed to Shutdown NiFi due to " + String.valueOf(ioe));
            }
        }
        System.out.printf("NiFi PID [%d] shutdown in progress...%n", this.pid);
        long startWait = System.nanoTime();
        while (RunNiFi.isAlive(this.nifiProcess)) {
            long waitNanos = System.nanoTime() - startWait;
            long waitSeconds = TimeUnit.NANOSECONDS.toSeconds(waitNanos);
            if (waitSeconds >= (long)this.gracefulShutdownSeconds && this.gracefulShutdownSeconds > 0) {
                if (!RunNiFi.isAlive(this.nifiProcess)) break;
                System.out.println("NiFi has not finished shutting down after " + this.gracefulShutdownSeconds + " seconds. Killing process.");
                this.nifiProcess.destroy();
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            File statusFile = this.runner.getStatusFile();
            if (!statusFile.delete()) {
                System.err.println("Failed to delete status file " + statusFile.getAbsolutePath() + "; this file should be cleaned up manually");
            }
        }
        catch (IOException ex) {
            System.err.println("Failed to retrieve status file " + String.valueOf(ex));
        }
    }
}

