/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Objects;

public class RunStatelessNiFi {
    public static void main(String[] args) throws Exception {
        String nifi_home = System.getenv("NIFI_HOME");
        if (nifi_home == null || nifi_home.equals("")) {
            nifi_home = ".";
        }
        ArrayList<URL> cpURLs = new ArrayList<URL>();
        File libDir = new File(nifi_home + "/lib");
        if (libDir.exists()) {
            for (File file : Objects.requireNonNull(libDir.listFiles((dir, filename) -> filename.toLowerCase().endsWith(".jar")))) {
                cpURLs.add(file.toURI().toURL());
            }
        }
        if (cpURLs.isEmpty()) {
            throw new RuntimeException("Could not find lib directory at " + libDir.getAbsolutePath());
        }
        URLClassLoader rootClassLoader = new URLClassLoader(cpURLs.toArray(new URL[0]));
        Thread.currentThread().setContextClassLoader(rootClassLoader);
        Class<?> programClass = Class.forName("org.apache.nifi.StatelessNiFi", true, rootClassLoader);
        Method launchMethod = programClass.getMethod("main", String[].class);
        launchMethod.setAccessible(true);
        launchMethod.invoke(null, new Object[]{args});
    }
}

