/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.crypto.key.scrypt;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.security.crypto.key.DerivedKeyParameterSpecReader;
import org.apache.nifi.security.crypto.key.scrypt.ScryptDerivedKeyParameterSpec;

public class ScryptDerivedKeyParameterSpecReader
implements DerivedKeyParameterSpecReader<ScryptDerivedKeyParameterSpec> {
    private static final Pattern MODULAR_CRYPT_FORMAT = Pattern.compile("^\\$s0\\$([a-f0-9]{5,})\\$([\\w/=+]{11,64})\\$?([\\w/=+]{1,256})?$");
    private static final int PARAMETERS_GROUP = 1;
    private static final int SALT_GROUP = 2;
    private static final Charset PARAMETERS_CHARACTER_SET = StandardCharsets.US_ASCII;
    private static final int HEXADECIMAL_RADIX = 16;
    private static final int LOG_BASE_2 = 2;
    private static final int COST_BITS = 16;
    private static final int SIZE_BITS = 8;
    private static final int SIXTEEN_BIT_SHIFT = 65535;
    private static final int EIGHT_BIT_SHIFT = 255;
    private static final Base64.Decoder decoder = Base64.getDecoder();

    @Override
    public ScryptDerivedKeyParameterSpec read(byte[] serializedParameters) {
        Objects.requireNonNull(serializedParameters, "Parameters required");
        String parameters = new String(serializedParameters, PARAMETERS_CHARACTER_SET);
        Matcher matcher = MODULAR_CRYPT_FORMAT.matcher(parameters);
        if (matcher.matches()) {
            String parametersGroup = matcher.group(1);
            String saltGroup = matcher.group(2);
            return this.readParameters(parametersGroup, saltGroup);
        }
        String message = String.format("scrypt serialized parameters [%s] format not matched", parameters);
        throw new IllegalArgumentException(message);
    }

    private ScryptDerivedKeyParameterSpec readParameters(String parametersEncoded, String saltEncoded) {
        long parameters = Long.parseLong(parametersEncoded, 16);
        long costExponent = parameters >> 16 & 0xFFFFL;
        int cost = (int)Math.pow(2.0, costExponent);
        int blockSize = (int)parameters >> 8 & 0xFF;
        int parallelization = (int)parameters & 0xFF;
        byte[] salt = decoder.decode(saltEncoded);
        return new ScryptDerivedKeyParameterSpec(cost, blockSize, parallelization, salt);
    }
}

