/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.crypto.key.argon2;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.security.crypto.key.DerivedKeyParameterSpecReader;
import org.apache.nifi.security.crypto.key.argon2.Argon2DerivedKeyParameterSpec;

public class Argon2DerivedKeyParameterSpecReader
implements DerivedKeyParameterSpecReader<Argon2DerivedKeyParameterSpec> {
    private static final Pattern PHC_STRING_FORMAT = Pattern.compile("^\\$argon2id\\$v=19\\$m=(\\d+),t=(\\d+),p=(\\d+)\\$([\\w/+]{22})(\\$[\\w/+]+)?$");
    private static final int MEMORY_GROUP = 1;
    private static final int ITERATIONS_GROUP = 2;
    private static final int PARALLELISM_GROUP = 3;
    private static final int SALT_GROUP = 4;
    private static final Charset PARAMETERS_CHARACTER_SET = StandardCharsets.US_ASCII;
    private static final Base64.Decoder decoder = Base64.getDecoder();

    @Override
    public Argon2DerivedKeyParameterSpec read(byte[] serializedParameters) {
        Objects.requireNonNull(serializedParameters, "Parameters required");
        String parameters = new String(serializedParameters, PARAMETERS_CHARACTER_SET);
        Matcher matcher = PHC_STRING_FORMAT.matcher(parameters);
        if (matcher.matches()) {
            String memoryGroup = matcher.group(1);
            String iterationsGroup = matcher.group(2);
            String parallelismGroup = matcher.group(3);
            String saltGroup = matcher.group(4);
            int memory = Integer.parseInt(memoryGroup);
            int iterations = Integer.parseInt(iterationsGroup);
            int parallelism = Integer.parseInt(parallelismGroup);
            byte[] salt = decoder.decode(saltGroup);
            return new Argon2DerivedKeyParameterSpec(memory, iterations, parallelism, salt);
        }
        String message = String.format("Argon2 serialized parameters [%s] format not matched", parameters);
        throw new IllegalArgumentException(message);
    }
}

