/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.nifi.properties.ApplicationProperties;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiFiProperties
extends ApplicationProperties {
    private static final Logger logger = LoggerFactory.getLogger(NiFiProperties.class);
    public static final String PROPERTIES_FILE_PATH = "nifi.properties.file.path";
    public static final String FLOW_CONFIGURATION_FILE = "nifi.flow.configuration.file";
    public static final String FLOW_CONFIGURATION_ARCHIVE_ENABLED = "nifi.flow.configuration.archive.enabled";
    public static final String FLOW_CONFIGURATION_ARCHIVE_DIR = "nifi.flow.configuration.archive.dir";
    public static final String FLOW_CONFIGURATION_ARCHIVE_MAX_TIME = "nifi.flow.configuration.archive.max.time";
    public static final String FLOW_CONFIGURATION_ARCHIVE_MAX_STORAGE = "nifi.flow.configuration.archive.max.storage";
    public static final String FLOW_CONFIGURATION_ARCHIVE_MAX_COUNT = "nifi.flow.configuration.archive.max.count";
    public static final String AUTHORIZER_CONFIGURATION_FILE = "nifi.authorizer.configuration.file";
    public static final String LOGIN_IDENTITY_PROVIDER_CONFIGURATION_FILE = "nifi.login.identity.provider.configuration.file";
    public static final String REPOSITORY_DATABASE_DIRECTORY = "nifi.database.directory";
    public static final String RESTORE_DIRECTORY = "nifi.restore.directory";
    public static final String WRITE_DELAY_INTERVAL = "nifi.flowservice.writedelay.interval";
    public static final String AUTO_RESUME_STATE = "nifi.flowcontroller.autoResumeState";
    public static final String FLOW_CONTROLLER_GRACEFUL_SHUTDOWN_PERIOD = "nifi.flowcontroller.graceful.shutdown.period";
    public static final String NAR_LIBRARY_DIRECTORY = "nifi.nar.library.directory";
    public static final String NAR_LIBRARY_DIRECTORY_PREFIX = "nifi.nar.library.directory.";
    public static final String NAR_LIBRARY_AUTOLOAD_DIRECTORY = "nifi.nar.library.autoload.directory";
    public static final String NAR_WORKING_DIRECTORY = "nifi.nar.working.directory";
    public static final String UNPACK_NARS_TO_UBER_JAR = "nifi.nar.unpack.uber.jar";
    public static final String COMPONENT_DOCS_DIRECTORY = "nifi.documentation.working.directory";
    public static final String SENSITIVE_PROPS_KEY = "nifi.sensitive.props.key";
    public static final String SENSITIVE_PROPS_ALGORITHM = "nifi.sensitive.props.algorithm";
    public static final String REMOTE_INPUT_HOST = "nifi.remote.input.host";
    public static final String REMOTE_INPUT_PORT = "nifi.remote.input.socket.port";
    public static final String SITE_TO_SITE_SECURE = "nifi.remote.input.secure";
    public static final String SITE_TO_SITE_HTTP_ENABLED = "nifi.remote.input.http.enabled";
    public static final String SITE_TO_SITE_HTTP_TRANSACTION_TTL = "nifi.remote.input.http.transaction.ttl";
    public static final String REMOTE_CONTENTS_CACHE_EXPIRATION = "nifi.remote.contents.cache.expiration";
    public static final String ADMINISTRATIVE_YIELD_DURATION = "nifi.administrative.yield.duration";
    public static final String BORED_YIELD_DURATION = "nifi.bored.yield.duration";
    public static final String PROCESSOR_SCHEDULING_TIMEOUT = "nifi.processor.scheduling.timeout";
    public static final String BACKPRESSURE_COUNT = "nifi.queue.backpressure.count";
    public static final String BACKPRESSURE_SIZE = "nifi.queue.backpressure.size";
    public static final String LISTENER_BOOTSTRAP_PORT = "nifi.listener.bootstrap.port";
    public static final String REPOSITORY_ENCRYPTION_PROTOCOL_VERSION = "nifi.repository.encryption.protocol.version";
    public static final String REPOSITORY_ENCRYPTION_KEY_ID = "nifi.repository.encryption.key.id";
    public static final String REPOSITORY_ENCRYPTION_KEY_PROVIDER = "nifi.repository.encryption.key.provider";
    public static final String REPOSITORY_ENCRYPTION_KEY_PROVIDER_KEYSTORE_LOCATION = "nifi.repository.encryption.key.provider.keystore.location";
    public static final String REPOSITORY_ENCRYPTION_KEY_PROVIDER_KEYSTORE_PASSWORD = "nifi.repository.encryption.key.provider.keystore.password";
    public static final String REPOSITORY_CONTENT_PREFIX = "nifi.content.repository.directory.";
    public static final String CONTENT_REPOSITORY_IMPLEMENTATION = "nifi.content.repository.implementation";
    public static final String MAX_APPENDABLE_CLAIM_SIZE = "nifi.content.claim.max.appendable.size";
    public static final String CONTENT_ARCHIVE_MAX_RETENTION_PERIOD = "nifi.content.repository.archive.max.retention.period";
    public static final String CONTENT_ARCHIVE_MAX_USAGE_PERCENTAGE = "nifi.content.repository.archive.max.usage.percentage";
    public static final String CONTENT_ARCHIVE_BACK_PRESSURE_PERCENTAGE = "nifi.content.repository.archive.backpressure.percentage";
    public static final String CONTENT_ARCHIVE_ENABLED = "nifi.content.repository.archive.enabled";
    public static final String CONTENT_ARCHIVE_CLEANUP_FREQUENCY = "nifi.content.repository.archive.cleanup.frequency";
    public static final String CONTENT_VIEWER_URL = "nifi.content.viewer.url";
    public static final String FLOWFILE_REPOSITORY_IMPLEMENTATION = "nifi.flowfile.repository.implementation";
    public static final String FLOWFILE_REPOSITORY_WAL_IMPLEMENTATION = "nifi.flowfile.repository.wal.implementation";
    public static final String FLOWFILE_REPOSITORY_ALWAYS_SYNC = "nifi.flowfile.repository.always.sync";
    public static final String FLOWFILE_REPOSITORY_DIRECTORY = "nifi.flowfile.repository.directory";
    public static final String FLOWFILE_REPOSITORY_CHECKPOINT_INTERVAL = "nifi.flowfile.repository.checkpoint.interval";
    public static final String FLOWFILE_SWAP_MANAGER_IMPLEMENTATION = "nifi.swap.manager.implementation";
    public static final String QUEUE_SWAP_THRESHOLD = "nifi.queue.swap.threshold";
    public static final String PROVENANCE_REPO_IMPLEMENTATION_CLASS = "nifi.provenance.repository.implementation";
    public static final String PROVENANCE_REPO_DIRECTORY_PREFIX = "nifi.provenance.repository.directory.";
    public static final String PROVENANCE_MAX_STORAGE_TIME = "nifi.provenance.repository.max.storage.time";
    public static final String PROVENANCE_MAX_STORAGE_SIZE = "nifi.provenance.repository.max.storage.size";
    public static final String PROVENANCE_ROLLOVER_TIME = "nifi.provenance.repository.rollover.time";
    public static final String PROVENANCE_ROLLOVER_SIZE = "nifi.provenance.repository.rollover.size";
    public static final String PROVENANCE_ROLLOVER_EVENT_COUNT = "nifi.provenance.repository.rollover.events";
    public static final String PROVENANCE_QUERY_THREAD_POOL_SIZE = "nifi.provenance.repository.query.threads";
    public static final String PROVENANCE_INDEX_THREAD_POOL_SIZE = "nifi.provenance.repository.index.threads";
    public static final String PROVENANCE_COMPRESS_ON_ROLLOVER = "nifi.provenance.repository.compress.on.rollover";
    public static final String PROVENANCE_INDEXED_FIELDS = "nifi.provenance.repository.indexed.fields";
    public static final String PROVENANCE_INDEXED_ATTRIBUTES = "nifi.provenance.repository.indexed.attributes";
    public static final String PROVENANCE_INDEX_SHARD_SIZE = "nifi.provenance.repository.index.shard.size";
    public static final String PROVENANCE_JOURNAL_COUNT = "nifi.provenance.repository.journal.count";
    public static final String PROVENANCE_REPO_DEBUG_FREQUENCY = "nifi.provenance.repository.debug.frequency";
    public static final String COMPONENT_STATUS_REPOSITORY_IMPLEMENTATION = "nifi.components.status.repository.implementation";
    public static final String COMPONENT_STATUS_SNAPSHOT_FREQUENCY = "nifi.components.status.snapshot.frequency";
    public static final String STATUS_REPOSITORY_QUESTDB_PERSIST_NODE_DAYS = "nifi.status.repository.questdb.persist.node.days";
    public static final String STATUS_REPOSITORY_QUESTDB_PERSIST_COMPONENT_DAYS = "nifi.status.repository.questdb.persist.component.days";
    public static final String STATUS_REPOSITORY_QUESTDB_PERSIST_LOCATION = "nifi.status.repository.questdb.persist.location";
    public static final String STATUS_REPOSITORY_QUESTDB_PERSIST_LOCATION_BACKUP = "nifi.status.repository.questdb.persist.location.backup";
    public static final String STATUS_REPOSITORY_QUESTDB_PERSIST_BATCH_SIZE = "nifi.status.repository.questdb.persist.batchsize";
    public static final String STATUS_REPOSITORY_QUESTDB_PERSIST_FREQUENCY = "nifi.status.repository.questdb.persist.frequency";
    public static final String SECURITY_KEYSTORE = "nifi.security.keystore";
    public static final String SECURITY_KEYSTORE_TYPE = "nifi.security.keystoreType";
    public static final String SECURITY_KEYSTORE_PASSWD = "nifi.security.keystorePasswd";
    public static final String SECURITY_KEY_PASSWD = "nifi.security.keyPasswd";
    public static final String SECURITY_TRUSTSTORE = "nifi.security.truststore";
    public static final String SECURITY_TRUSTSTORE_TYPE = "nifi.security.truststoreType";
    public static final String SECURITY_TRUSTSTORE_PASSWD = "nifi.security.truststorePasswd";
    public static final String SECURITY_AUTO_RELOAD_ENABLED = "nifi.security.autoreload.enabled";
    public static final String SECURITY_AUTO_RELOAD_INTERVAL = "nifi.security.autoreload.interval";
    public static final String SECURITY_USER_AUTHORIZER = "nifi.security.user.authorizer";
    public static final String SECURITY_ANONYMOUS_AUTHENTICATION = "nifi.security.allow.anonymous.authentication";
    public static final String SECURITY_USER_LOGIN_IDENTITY_PROVIDER = "nifi.security.user.login.identity.provider";
    public static final String SECURITY_OCSP_RESPONDER_URL = "nifi.security.ocsp.responder.url";
    public static final String SECURITY_OCSP_RESPONDER_CERTIFICATE = "nifi.security.ocsp.responder.certificate";
    public static final String SECURITY_IDENTITY_MAPPING_PATTERN_PREFIX = "nifi.security.identity.mapping.pattern.";
    public static final String SECURITY_IDENTITY_MAPPING_VALUE_PREFIX = "nifi.security.identity.mapping.value.";
    public static final String SECURITY_IDENTITY_MAPPING_TRANSFORM_PREFIX = "nifi.security.identity.mapping.transform.";
    public static final String SECURITY_GROUP_MAPPING_PATTERN_PREFIX = "nifi.security.group.mapping.pattern.";
    public static final String SECURITY_GROUP_MAPPING_VALUE_PREFIX = "nifi.security.group.mapping.value.";
    public static final String SECURITY_GROUP_MAPPING_TRANSFORM_PREFIX = "nifi.security.group.mapping.transform.";
    public static final String SECURITY_USER_JWS_KEY_ROTATION_PERIOD = "nifi.security.user.jws.key.rotation.period";
    public static final String SECURITY_USER_OIDC_DISCOVERY_URL = "nifi.security.user.oidc.discovery.url";
    public static final String SECURITY_USER_OIDC_CONNECT_TIMEOUT = "nifi.security.user.oidc.connect.timeout";
    public static final String SECURITY_USER_OIDC_READ_TIMEOUT = "nifi.security.user.oidc.read.timeout";
    public static final String SECURITY_USER_OIDC_CLIENT_ID = "nifi.security.user.oidc.client.id";
    public static final String SECURITY_USER_OIDC_CLIENT_SECRET = "nifi.security.user.oidc.client.secret";
    public static final String SECURITY_USER_OIDC_TRUSTSTORE_STRATEGY = "nifi.security.user.oidc.truststore.strategy";
    public static final String SECURITY_USER_OIDC_PREFERRED_JWSALGORITHM = "nifi.security.user.oidc.preferred.jwsalgorithm";
    public static final String SECURITY_USER_OIDC_ADDITIONAL_SCOPES = "nifi.security.user.oidc.additional.scopes";
    public static final String SECURITY_USER_OIDC_CLAIM_IDENTIFYING_USER = "nifi.security.user.oidc.claim.identifying.user";
    public static final String NIFI_SECURITY_USER_OIDC_CLAIM_GROUPS = "nifi.security.user.oidc.claim.groups";
    public static final String SECURITY_USER_OIDC_FALLBACK_CLAIMS_IDENTIFYING_USER = "nifi.security.user.oidc.fallback.claims.identifying.user";
    public static final String SECURITY_USER_OIDC_TOKEN_REFRESH_WINDOW = "nifi.security.user.oidc.token.refresh.window";
    public static final String SECURITY_USER_SAML_IDP_METADATA_URL = "nifi.security.user.saml.idp.metadata.url";
    public static final String SECURITY_USER_SAML_SP_ENTITY_ID = "nifi.security.user.saml.sp.entity.id";
    public static final String SECURITY_USER_SAML_IDENTITY_ATTRIBUTE_NAME = "nifi.security.user.saml.identity.attribute.name";
    public static final String SECURITY_USER_SAML_GROUP_ATTRIBUTE_NAME = "nifi.security.user.saml.group.attribute.name";
    public static final String SECURITY_USER_SAML_METADATA_SIGNING_ENABLED = "nifi.security.user.saml.metadata.signing.enabled";
    public static final String SECURITY_USER_SAML_REQUEST_SIGNING_ENABLED = "nifi.security.user.saml.request.signing.enabled";
    public static final String SECURITY_USER_SAML_WANT_ASSERTIONS_SIGNED = "nifi.security.user.saml.want.assertions.signed";
    public static final String SECURITY_USER_SAML_SIGNATURE_ALGORITHM = "nifi.security.user.saml.signature.algorithm";
    public static final String SECURITY_USER_SAML_SIGNATURE_DIGEST_ALGORITHM = "nifi.security.user.saml.signature.digest.algorithm";
    public static final String SECURITY_USER_SAML_MESSAGE_LOGGING_ENABLED = "nifi.security.user.saml.message.logging.enabled";
    public static final String SECURITY_USER_SAML_AUTHENTICATION_EXPIRATION = "nifi.security.user.saml.authentication.expiration";
    public static final String SECURITY_USER_SAML_SINGLE_LOGOUT_ENABLED = "nifi.security.user.saml.single.logout.enabled";
    public static final String SECURITY_USER_SAML_HTTP_CLIENT_TRUSTSTORE_STRATEGY = "nifi.security.user.saml.http.client.truststore.strategy";
    public static final String SECURITY_USER_SAML_HTTP_CLIENT_CONNECT_TIMEOUT = "nifi.security.user.saml.http.client.connect.timeout";
    public static final String SECURITY_USER_SAML_HTTP_CLIENT_READ_TIMEOUT = "nifi.security.user.saml.http.client.read.timeout";
    public static final String WEB_HTTP_PORT = "nifi.web.http.port";
    public static final String WEB_HTTP_PORT_FORWARDING = "nifi.web.http.port.forwarding";
    public static final String WEB_HTTP_HOST = "nifi.web.http.host";
    public static final String WEB_HTTP_NETWORK_INTERFACE_PREFIX = "nifi.web.http.network.interface.";
    public static final String WEB_HTTPS_PORT = "nifi.web.https.port";
    public static final String WEB_HTTPS_PORT_FORWARDING = "nifi.web.https.port.forwarding";
    public static final String WEB_HTTPS_HOST = "nifi.web.https.host";
    public static final String WEB_HTTPS_APPLICATION_PROTOCOLS = "nifi.web.https.application.protocols";
    public static final String WEB_HTTPS_CIPHERSUITES_INCLUDE = "nifi.web.https.ciphersuites.include";
    public static final String WEB_HTTPS_CIPHERSUITES_EXCLUDE = "nifi.web.https.ciphersuites.exclude";
    public static final String WEB_HTTPS_NETWORK_INTERFACE_PREFIX = "nifi.web.https.network.interface.";
    public static final String WEB_WORKING_DIR = "nifi.web.jetty.working.directory";
    public static final String WEB_THREADS = "nifi.web.jetty.threads";
    public static final String WEB_MAX_HEADER_SIZE = "nifi.web.max.header.size";
    public static final String WEB_PROXY_CONTEXT_PATH = "nifi.web.proxy.context.path";
    public static final String WEB_PROXY_HOST = "nifi.web.proxy.host";
    public static final String WEB_MAX_CONTENT_SIZE = "nifi.web.max.content.size";
    public static final String WEB_MAX_REQUESTS_PER_SECOND = "nifi.web.max.requests.per.second";
    public static final String WEB_MAX_ACCESS_TOKEN_REQUESTS_PER_SECOND = "nifi.web.max.access.token.requests.per.second";
    public static final String WEB_REQUEST_TIMEOUT = "nifi.web.request.timeout";
    public static final String WEB_REQUEST_IP_WHITELIST = "nifi.web.request.ip.whitelist";
    public static final String WEB_SHOULD_SEND_SERVER_VERSION = "nifi.web.should.send.server.version";
    public static final String WEB_REQUEST_LOG_FORMAT = "nifi.web.request.log.format";
    public static final String WEB_JMX_METRICS_ALLOWED_FILTER_PATTERN = "nifi.web.jmx.metrics.allowed.filter.pattern";
    public static final String UI_BANNER_TEXT = "nifi.ui.banner.text";
    public static final String CLUSTER_PROTOCOL_HEARTBEAT_INTERVAL = "nifi.cluster.protocol.heartbeat.interval";
    public static final String CLUSTER_PROTOCOL_HEARTBEAT_MISSABLE_MAX = "nifi.cluster.protocol.heartbeat.missable.max";
    public static final String CLUSTER_PROTOCOL_IS_SECURE = "nifi.cluster.protocol.is.secure";
    public static final String CLUSTER_LEADER_ELECTION_IMPLEMENTATION = "nifi.cluster.leader.election.implementation";
    public static final String CLUSTER_IS_NODE = "nifi.cluster.is.node";
    public static final String CLUSTER_NODE_ADDRESS = "nifi.cluster.node.address";
    public static final String CLUSTER_NODE_PROTOCOL_PORT = "nifi.cluster.node.protocol.port";
    public static final String CLUSTER_NODE_PROTOCOL_MAX_THREADS = "nifi.cluster.node.protocol.max.threads";
    public static final String CLUSTER_NODE_CONNECTION_TIMEOUT = "nifi.cluster.node.connection.timeout";
    public static final String CLUSTER_NODE_READ_TIMEOUT = "nifi.cluster.node.read.timeout";
    public static final String CLUSTER_NODE_MAX_CONCURRENT_REQUESTS = "nifi.cluster.node.max.concurrent.requests";
    public static final String CLUSTER_FIREWALL_FILE = "nifi.cluster.firewall.file";
    public static final String FLOW_ELECTION_MAX_WAIT_TIME = "nifi.cluster.flow.election.max.wait.time";
    public static final String FLOW_ELECTION_MAX_CANDIDATES = "nifi.cluster.flow.election.max.candidates";
    public static final String LOAD_BALANCE_HOST = "nifi.cluster.load.balance.host";
    public static final String LOAD_BALANCE_PORT = "nifi.cluster.load.balance.port";
    public static final String LOAD_BALANCE_CONNECTIONS_PER_NODE = "nifi.cluster.load.balance.connections.per.node";
    public static final String LOAD_BALANCE_MAX_THREAD_COUNT = "nifi.cluster.load.balance.max.thread.count";
    public static final String LOAD_BALANCE_COMMS_TIMEOUT = "nifi.cluster.load.balance.comms.timeout";
    public static final String ZOOKEEPER_CONNECT_STRING = "nifi.zookeeper.connect.string";
    public static final String ZOOKEEPER_CONNECT_TIMEOUT = "nifi.zookeeper.connect.timeout";
    public static final String ZOOKEEPER_SESSION_TIMEOUT = "nifi.zookeeper.session.timeout";
    public static final String ZOOKEEPER_ROOT_NODE = "nifi.zookeeper.root.node";
    public static final String ZOOKEEPER_CLIENT_ENSEMBLE_TRACKER = "nifi.zookeeper.client.ensembleTracker";
    public static final String ZOOKEEPER_CLIENT_SECURE = "nifi.zookeeper.client.secure";
    public static final String ZOOKEEPER_SECURITY_KEYSTORE = "nifi.zookeeper.security.keystore";
    public static final String ZOOKEEPER_SECURITY_KEYSTORE_TYPE = "nifi.zookeeper.security.keystoreType";
    public static final String ZOOKEEPER_SECURITY_KEYSTORE_PASSWD = "nifi.zookeeper.security.keystorePasswd";
    public static final String ZOOKEEPER_SECURITY_TRUSTSTORE = "nifi.zookeeper.security.truststore";
    public static final String ZOOKEEPER_SECURITY_TRUSTSTORE_TYPE = "nifi.zookeeper.security.truststoreType";
    public static final String ZOOKEEPER_SECURITY_TRUSTSTORE_PASSWD = "nifi.zookeeper.security.truststorePasswd";
    public static final String ZOOKEEPER_AUTH_TYPE = "nifi.zookeeper.auth.type";
    public static final String ZOOKEEPER_KERBEROS_REMOVE_HOST_FROM_PRINCIPAL = "nifi.zookeeper.kerberos.removeHostFromPrincipal";
    public static final String ZOOKEEPER_KERBEROS_REMOVE_REALM_FROM_PRINCIPAL = "nifi.zookeeper.kerberos.removeRealmFromPrincipal";
    public static final String ZOOKEEPER_JUTE_MAXBUFFER = "nifi.zookeeper.jute.maxbuffer";
    public static final String KERBEROS_KRB5_FILE = "nifi.kerberos.krb5.file";
    public static final String KERBEROS_SERVICE_PRINCIPAL = "nifi.kerberos.service.principal";
    public static final String KERBEROS_SERVICE_KEYTAB_LOCATION = "nifi.kerberos.service.keytab.location";
    public static final String STATE_MANAGEMENT_CONFIG_FILE = "nifi.state.management.configuration.file";
    public static final String STATE_MANAGEMENT_LOCAL_PROVIDER_ID = "nifi.state.management.provider.local";
    public static final String STATE_MANAGEMENT_CLUSTER_PROVIDER_ID = "nifi.state.management.provider.cluster";
    public static final String STATE_MANAGEMENT_CLUSTER_PROVIDER_PREVIOUS_ID = "nifi.state.management.provider.cluster.previous";
    public static final String STATE_MANAGEMENT_START_EMBEDDED_ZOOKEEPER = "nifi.state.management.embedded.zookeeper.start";
    public static final String STATE_MANAGEMENT_ZOOKEEPER_PROPERTIES = "nifi.state.management.embedded.zookeeper.properties";
    public static final String ANALYTICS_PREDICTION_ENABLED = "nifi.analytics.predict.enabled";
    public static final String ANALYTICS_PREDICTION_INTERVAL = "nifi.analytics.predict.interval";
    public static final String ANALYTICS_QUERY_INTERVAL = "nifi.analytics.query.interval";
    public static final String ANALYTICS_CONNECTION_MODEL_IMPLEMENTATION = "nifi.analytics.connection.model.implementation";
    public static final String ANALYTICS_CONNECTION_MODEL_SCORE_NAME = "nifi.analytics.connection.model.score.name";
    public static final String ANALYTICS_CONNECTION_MODEL_SCORE_THRESHOLD = "nifi.analytics.connection.model.score.threshold";
    public static final String FLOW_REGISTRY_CHECK_FOR_RULE_VIOLATIONS_BEFORE_COMMIT = "nifi.registry.check.for.rule.violations.before.commit";
    public static final String MONITOR_LONG_RUNNING_TASK_SCHEDULE = "nifi.monitor.long.running.task.schedule";
    public static final String MONITOR_LONG_RUNNING_TASK_THRESHOLD = "nifi.monitor.long.running.task.threshold";
    public static final String DIAGNOSTICS_ON_SHUTDOWN_ENABLED = "nifi.diagnostics.on.shutdown.enabled";
    public static final String DIAGNOSTICS_ON_SHUTDOWN_VERBOSE = "nifi.diagnostics.on.shutdown.verbose";
    public static final String DIAGNOSTICS_ON_SHUTDOWN_DIRECTORY = "nifi.diagnostics.on.shutdown.directory";
    public static final String DIAGNOSTICS_ON_SHUTDOWN_MAX_FILE_COUNT = "nifi.diagnostics.on.shutdown.max.filecount";
    public static final String DIAGNOSTICS_ON_SHUTDOWN_MAX_DIRECTORY_SIZE = "nifi.diagnostics.on.shutdown.max.directory.size";
    public static final String PYTHON_COMMAND = "nifi.python.command";
    public static final String PYTHON_FRAMEWORK_SOURCE_DIRECTORY = "nifi.python.framework.source.directory";
    public static final String PYTHON_EXTENSION_DIRECTORY_PREFIX = "nifi.python.extensions.source.directory.";
    public static final String PYTHON_WORKING_DIRECTORY = "nifi.python.working.directory";
    public static final String PYTHON_MAX_PROCESSES = "nifi.python.max.processes";
    public static final String PYTHON_MAX_PROCESSES_PER_TYPE = "nifi.python.max.processes.per.extension.type";
    public static final String PYTHON_COMMS_TIMEOUT = "nifi.python.comms.timeout";
    public static final String PYTHON_CONTROLLER_DEBUGPY_ENABLED = "nifi.python.controller.debugpy.enabled";
    public static final String PYTHON_CONTROLLER_DEBUGPY_PORT = "nifi.python.controller.debugpy.port";
    public static final String PYTHON_CONTROLLER_DEBUGPY_HOST = "nifi.python.controller.debugpy.host";
    public static final String CLUSTER_LEADER_ELECTION_KUBERNETES_LEASE_PREFIX = "nifi.cluster.leader.election.kubernetes.lease.prefix";
    public static final String DEFAULT_PYTHON_WORKING_DIRECTORY = "./work/python";
    public static final String DEFAULT_DIAGNOSTICS_ON_SHUTDOWN_DIRECTORY = "./diagnostics";
    public static final int DEFAULT_DIAGNOSTICS_ON_SHUTDOWN_MAX_FILE_COUNT = 10;
    public static final String DEFAULT_DIAGNOSTICS_ON_SHUTDOWN_MAX_DIRECTORY_SIZE = "10 MB";
    public static final String TRACK_PERFORMANCE_PERCENTAGE = "nifi.performance.tracking.percentage";
    public static final int DEFAULT_TRACK_PERFORMANCE_PERCENTAGE = 0;
    public static final Boolean DEFAULT_AUTO_RESUME_STATE = true;
    public static final String DEFAULT_AUTHORIZER_CONFIGURATION_FILE = "conf/authorizers.xml";
    public static final String DEFAULT_LOGIN_IDENTITY_PROVIDER_CONFIGURATION_FILE = "conf/login-identity-providers.xml";
    public static final Integer DEFAULT_REMOTE_INPUT_PORT = null;
    private static final String DEFAULT_WEB_HTTPS_APPLICATION_PROTOCOLS = "h2 http/1.1";
    public static final int DEFAULT_WEB_THREADS = 200;
    public static final String DEFAULT_WEB_MAX_HEADER_SIZE = "16 KB";
    public static final String DEFAULT_WEB_WORKING_DIR = "./work/jetty";
    public static final String DEFAULT_WEB_MAX_CONTENT_SIZE = "20 MB";
    public static final int DEFAULT_WEB_MAX_REQUESTS_PER_SECOND = 30000;
    public static final int DEFAULT_WEB_MAX_ACCESS_TOKEN_REQUESTS_PER_SECOND = 25;
    public static final String DEFAULT_WEB_REQUEST_TIMEOUT = "60 secs";
    public static final String DEFAULT_NAR_WORKING_DIR = "./work/nar";
    public static final boolean DEFAULT_UNPACK_NARS_TO_UBER_JAR = false;
    public static final String DEFAULT_COMPONENT_DOCS_DIRECTORY = "./work/docs/components";
    public static final String DEFAULT_NAR_LIBRARY_DIR = "./lib";
    public static final String DEFAULT_NAR_LIBRARY_AUTOLOAD_DIR = "./extensions";
    public static final String DEFAULT_FLOWFILE_CHECKPOINT_INTERVAL = "20 secs";
    public static final String DEFAULT_MAX_APPENDABLE_CLAIM_SIZE = "1 MB";
    public static final int DEFAULT_QUEUE_SWAP_THRESHOLD = 20000;
    public static final long DEFAULT_BACKPRESSURE_COUNT = 10000L;
    public static final String DEFAULT_BACKPRESSURE_SIZE = "1 GB";
    public static final String DEFAULT_ADMINISTRATIVE_YIELD_DURATION = "30 sec";
    public static final String DEFAULT_COMPONENT_STATUS_SNAPSHOT_FREQUENCY = "5 mins";
    public static final String DEFAULT_BORED_YIELD_DURATION = "10 millis";
    public static final String DEFAULT_ZOOKEEPER_CONNECT_TIMEOUT = "3 secs";
    public static final String DEFAULT_ZOOKEEPER_SESSION_TIMEOUT = "3 secs";
    public static final String DEFAULT_ZOOKEEPER_ROOT_NODE = "/nifi";
    public static final boolean DEFAULT_ZOOKEEPER_CLIENT_SECURE = false;
    public static final boolean DEFAULT_ZOOKEEPER_CLIENT_ENSEMBLE_TRACKER = true;
    public static final String DEFAULT_ZOOKEEPER_AUTH_TYPE = "default";
    public static final String DEFAULT_ZOOKEEPER_KERBEROS_REMOVE_HOST_FROM_PRINCIPAL = "true";
    public static final String DEFAULT_ZOOKEEPER_KERBEROS_REMOVE_REALM_FROM_PRINCIPAL = "true";
    public static final int DEFAULT_ZOOKEEPER_JUTE_MAXBUFFER = 1048575;
    public static final String DEFAULT_SECURITY_AUTO_RELOAD_INTERVAL = "10 secs";
    public static final String DEFAULT_SITE_TO_SITE_HTTP_TRANSACTION_TTL = "30 secs";
    public static final String DEFAULT_FLOW_CONFIGURATION_ARCHIVE_ENABLED = "true";
    public static final String DEFAULT_FLOW_CONFIGURATION_ARCHIVE_MAX_TIME = "30 days";
    public static final String DEFAULT_FLOW_CONFIGURATION_ARCHIVE_MAX_STORAGE = "500 MB";
    public static final String DEFAULT_SECURITY_USER_OIDC_CONNECT_TIMEOUT = "5 secs";
    public static final String DEFAULT_SECURITY_USER_OIDC_READ_TIMEOUT = "5 secs";
    public static final String DEFAULT_SECURITY_USER_OIDC_TRUSTSTORE_STRATEGY = "JDK";
    private static final String DEFAULT_SECURITY_USER_OIDC_TOKEN_REFRESH_WINDOW = "60 secs";
    public static final String DEFAULT_SECURITY_USER_SAML_METADATA_SIGNING_ENABLED = "false";
    public static final String DEFAULT_SECURITY_USER_SAML_REQUEST_SIGNING_ENABLED = "false";
    public static final String DEFAULT_SECURITY_USER_SAML_WANT_ASSERTIONS_SIGNED = "true";
    public static final String DEFAULT_SECURITY_USER_SAML_SIGNATURE_ALGORITHM = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    public static final String DEFAULT_SECURITY_USER_SAML_DIGEST_ALGORITHM = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String DEFAULT_SECURITY_USER_SAML_MESSAGE_LOGGING_ENABLED = "false";
    public static final String DEFAULT_SECURITY_USER_SAML_AUTHENTICATION_EXPIRATION = "12 hours";
    public static final String DEFAULT_SECURITY_USER_SAML_SINGLE_LOGOUT_ENABLED = "false";
    public static final String DEFAULT_SECURITY_USER_SAML_HTTP_CLIENT_TRUSTSTORE_STRATEGY = "JDK";
    public static final String DEFAULT_SECURITY_USER_SAML_HTTP_CLIENT_CONNECT_TIMEOUT = "30 secs";
    public static final String DEFAULT_SECURITY_USER_SAML_HTTP_CLIENT_READ_TIMEOUT = "30 secs";
    private static final String DEFAULT_SECURITY_USER_JWS_KEY_ROTATION_PERIOD = "PT1H";
    public static final String DEFAULT_WEB_SHOULD_SEND_SERVER_VERSION = "true";
    public static final int DEFAULT_LISTENER_BOOTSTRAP_PORT = 0;
    public static final Boolean DEFAULT_FLOW_REGISTRY_CHECK_FOR_RULE_VIOLATIONS_BEFORE_COMMIT = false;
    public static final String DEFAULT_CLUSTER_PROTOCOL_HEARTBEAT_INTERVAL = "5 sec";
    public static final int DEFAULT_CLUSTER_PROTOCOL_HEARTBEAT_MISSABLE_MAX = 8;
    public static final String DEFAULT_CLUSTER_NODE_READ_TIMEOUT = "5 sec";
    public static final String DEFAULT_CLUSTER_NODE_CONNECTION_TIMEOUT = "5 sec";
    public static final int DEFAULT_CLUSTER_NODE_MAX_CONCURRENT_REQUESTS = 100;
    public static final String DEFAULT_CLUSTER_LEADER_ELECTION_IMPLEMENTATION = "CuratorLeaderElectionManager";
    public static final int DEFAULT_CLUSTER_NODE_PROTOCOL_THREADS = 10;
    public static final int DEFAULT_CLUSTER_NODE_PROTOCOL_MAX_THREADS = 50;
    public static final String DEFAULT_FLOW_ELECTION_MAX_WAIT_TIME = "5 mins";
    public static final int DEFAULT_LOAD_BALANCE_PORT = 6342;
    public static final int DEFAULT_LOAD_BALANCE_CONNECTIONS_PER_NODE = 4;
    public static final int DEFAULT_LOAD_BALANCE_MAX_THREAD_COUNT = 8;
    public static final String DEFAULT_LOAD_BALANCE_COMMS_TIMEOUT = "30 sec";
    public static final String DEFAULT_STATE_MANAGEMENT_CONFIG_FILE = "conf/state-management.xml";
    public static final String DEFAULT_KERBEROS_AUTHENTICATION_EXPIRATION = "12 hours";
    public static final String DEFAULT_ANALYTICS_PREDICTION_ENABLED = "false";
    public static final String DEFAULT_ANALYTICS_PREDICTION_INTERVAL = "3 mins";
    public static final String DEFAULT_ANALYTICS_QUERY_INTERVAL = "3 mins";
    public static final String DEFAULT_ANALYTICS_CONNECTION_MODEL_IMPLEMENTATION = "org.apache.nifi.controller.status.analytics.models.OrdinaryLeastSquares";
    public static final String DEFAULT_ANALYTICS_CONNECTION_SCORE_NAME = "rSquared";
    public static final double DEFAULT_ANALYTICS_CONNECTION_SCORE_THRESHOLD = 0.9;
    public static final int DEFAULT_COMPONENT_STATUS_REPOSITORY_PERSIST_NODE_DAYS = 14;
    public static final int DEFAULT_COMPONENT_STATUS_REPOSITORY_PERSIST_COMPONENT_DAYS = 3;
    public static final String DEFAULT_COMPONENT_STATUS_REPOSITORY_PERSIST_LOCATION = "./status_repository";
    public static final String DEFAULT_COMPONENT_STATUS_REPOSITORY_PERSIST_LOCATION_BACKUP = "./status_repository_backup";
    public static final String DEFAULT_COMPONENT_STATUS_REPOSITORY_PERSIST_BATCH_SIZE = "1000";
    public static final String DEFAULT_COMPONENT_STATUS_REPOSITORY_PERSIST_FREQUENCY = "5 secs";

    public NiFiProperties() {
        this(Collections.emptyMap());
    }

    public NiFiProperties(Map<String, String> props) {
        super(props);
    }

    public NiFiProperties(Properties props) {
        super(props);
    }

    public File getFlowConfigurationFile() {
        try {
            return new File(this.getProperty(FLOW_CONFIGURATION_FILE));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public File getFlowConfigurationFileDir() {
        try {
            return this.getFlowConfigurationFile().getParentFile();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Integer getPropertyAsPort(String propertyName, Integer defaultValue) {
        String port = this.getProperty(propertyName);
        if (StringUtils.isEmpty((String)port)) {
            return defaultValue;
        }
        try {
            int val = Integer.parseInt(port);
            if (val <= 0 || val > 65535) {
                throw new RuntimeException("Valid port range is 0 - 65535 but got " + val);
            }
            return val;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public int getQueueSwapThreshold() {
        String thresholdValue = this.getProperty(QUEUE_SWAP_THRESHOLD);
        if (thresholdValue == null) {
            return 20000;
        }
        try {
            return Integer.parseInt(thresholdValue);
        }
        catch (NumberFormatException e) {
            return 20000;
        }
    }

    public Integer getIntegerProperty(String propertyName, Integer defaultValue) {
        String value = this.getProperty(propertyName);
        if (value == null || value.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (Exception e) {
            logger.warn("Configured value for property {} in nifi.properties is invalid, falling back to default value", (Object)propertyName, (Object)e);
            return defaultValue;
        }
    }

    public String getAdministrativeYieldDuration() {
        return this.getProperty(ADMINISTRATIVE_YIELD_DURATION, "30 sec");
    }

    public String getRemoteInputHost() {
        String value = this.getProperty(REMOTE_INPUT_HOST);
        return StringUtils.isBlank((String)value) ? null : value;
    }

    public Integer getRemoteInputPort() {
        return this.getPropertyAsPort(REMOTE_INPUT_PORT, DEFAULT_REMOTE_INPUT_PORT);
    }

    public Boolean isSiteToSiteSecure() {
        String secureVal = this.getProperty(SITE_TO_SITE_SECURE, "true");
        return !"false".equalsIgnoreCase(secureVal);
    }

    public Boolean isSiteToSiteHttpEnabled() {
        String remoteInputHttpEnabled = this.getProperty(SITE_TO_SITE_HTTP_ENABLED, "false");
        return "true".equalsIgnoreCase(remoteInputHttpEnabled);
    }

    public Integer getRemoteInputHttpPort() {
        if (!this.isSiteToSiteHttpEnabled().booleanValue()) {
            return null;
        }
        String propertyKey = this.isSiteToSiteSecure().booleanValue() ? (StringUtils.isBlank((String)this.getProperty(WEB_HTTPS_PORT_FORWARDING)) ? WEB_HTTPS_PORT : WEB_HTTPS_PORT_FORWARDING) : (StringUtils.isBlank((String)this.getProperty(WEB_HTTP_PORT_FORWARDING)) ? WEB_HTTP_PORT : WEB_HTTP_PORT_FORWARDING);
        Integer port = this.getIntegerProperty(propertyKey, null);
        if (port == null) {
            throw new RuntimeException("Remote input HTTP" + (this.isSiteToSiteSecure() != false ? "S" : "") + " is enabled but " + propertyKey + " is not specified.");
        }
        return port;
    }

    public String getFlowServiceWriteDelay() {
        return this.getProperty(WRITE_DELAY_INTERVAL);
    }

    public boolean getAutoResumeState() {
        String rawAutoResumeState = this.getProperty(AUTO_RESUME_STATE, DEFAULT_AUTO_RESUME_STATE.toString());
        return Boolean.parseBoolean(rawAutoResumeState);
    }

    public String getFlowFileRepositoryCheckpointInterval() {
        return this.getProperty(FLOWFILE_REPOSITORY_CHECKPOINT_INTERVAL, DEFAULT_FLOWFILE_CHECKPOINT_INTERVAL);
    }

    public File getRestoreDirectory() {
        String value = this.getProperty(RESTORE_DIRECTORY);
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        return new File(value);
    }

    public File getAuthorizerConfigurationFile() {
        String value = this.getProperty(AUTHORIZER_CONFIGURATION_FILE);
        if (StringUtils.isBlank((String)value)) {
            return new File(DEFAULT_AUTHORIZER_CONFIGURATION_FILE);
        }
        return new File(value);
    }

    public File getLoginIdentityProviderConfigurationFile() {
        String value = this.getProperty(LOGIN_IDENTITY_PROVIDER_CONFIGURATION_FILE);
        if (StringUtils.isBlank((String)value)) {
            return new File(DEFAULT_LOGIN_IDENTITY_PROVIDER_CONFIGURATION_FILE);
        }
        return new File(value);
    }

    public Integer getPort() {
        Integer port = null;
        try {
            port = Integer.parseInt(this.getProperty(WEB_HTTP_PORT));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return port;
    }

    public Integer getSslPort() {
        Integer sslPort = null;
        try {
            sslPort = Integer.parseInt(this.getProperty(WEB_HTTPS_PORT));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sslPort;
    }

    public boolean isHttpEnabled() {
        return this.getPort() != null;
    }

    public boolean isHTTPSConfigured() {
        return this.getSslPort() != null;
    }

    public Integer getConfiguredHttpOrHttpsPort() throws RuntimeException {
        if (this.getSslPort() != null) {
            return this.getSslPort();
        }
        if (this.getPort() != null) {
            return this.getPort();
        }
        throw new RuntimeException("The HTTP or HTTPS port must be configured");
    }

    public Set<String> getWebHttpsApplicationProtocols() {
        String protocols = this.getProperty(WEB_HTTPS_APPLICATION_PROTOCOLS, DEFAULT_WEB_HTTPS_APPLICATION_PROTOCOLS);
        return Arrays.stream(protocols.split("\\s+")).collect(Collectors.toSet());
    }

    public String getWebMaxHeaderSize() {
        return this.getProperty(WEB_MAX_HEADER_SIZE, DEFAULT_WEB_MAX_HEADER_SIZE);
    }

    public String getWebMaxContentSize() {
        return this.getProperty(WEB_MAX_CONTENT_SIZE);
    }

    public Integer getMaxWebRequestsPerSecond() {
        return this.getIntegerProperty(WEB_MAX_REQUESTS_PER_SECOND, 30000);
    }

    public Integer getMaxWebAccessTokenRequestsPerSecond() {
        return this.getIntegerProperty(WEB_MAX_ACCESS_TOKEN_REQUESTS_PER_SECOND, 25);
    }

    public String getWebRequestTimeout() {
        return this.getProperty(WEB_REQUEST_TIMEOUT, "60 secs");
    }

    public String getWebRequestIpWhitelist() {
        return this.getProperty(WEB_REQUEST_IP_WHITELIST);
    }

    public int getWebThreads() {
        return this.getIntegerProperty(WEB_THREADS, 200);
    }

    public int getClusterNodeMaxConcurrentRequests() {
        return this.getIntegerProperty(CLUSTER_NODE_MAX_CONCURRENT_REQUESTS, 100);
    }

    public File getWebWorkingDirectory() {
        return new File(this.getProperty(WEB_WORKING_DIR, DEFAULT_WEB_WORKING_DIR));
    }

    public File getComponentDocumentationWorkingDirectory() {
        return new File(this.getProperty(COMPONENT_DOCS_DIRECTORY, DEFAULT_COMPONENT_DOCS_DIRECTORY));
    }

    public File getNarWorkingDirectory() {
        return new File(this.getProperty(NAR_WORKING_DIRECTORY, DEFAULT_NAR_WORKING_DIR));
    }

    public boolean isUnpackNarsToUberJar() {
        String propertyValue = this.getProperty(UNPACK_NARS_TO_UBER_JAR);
        if (propertyValue == null) {
            return false;
        }
        return Boolean.parseBoolean(propertyValue);
    }

    public File getFrameworkWorkingDirectory() {
        return new File(this.getNarWorkingDirectory(), "framework");
    }

    public File getExtensionsWorkingDirectory() {
        return new File(this.getNarWorkingDirectory(), "extensions");
    }

    public List<Path> getNarLibraryDirectories() {
        ArrayList<Path> narLibraryPaths = new ArrayList<Path>();
        for (String propertyName : this.getPropertyKeys()) {
            String narLib;
            if (!StringUtils.startsWith((String)propertyName, (String)NAR_LIBRARY_DIRECTORY_PREFIX) && !NAR_LIBRARY_DIRECTORY.equals(propertyName) && !NAR_LIBRARY_AUTOLOAD_DIRECTORY.equals(propertyName) || StringUtils.isBlank((String)(narLib = this.getProperty(propertyName)))) continue;
            narLibraryPaths.add(Paths.get(narLib, new String[0]));
        }
        if (narLibraryPaths.isEmpty()) {
            narLibraryPaths.add(Paths.get(DEFAULT_NAR_LIBRARY_DIR, new String[0]));
        }
        return narLibraryPaths;
    }

    public File getNarAutoLoadDirectory() {
        return new File(this.getProperty(NAR_LIBRARY_AUTOLOAD_DIRECTORY, DEFAULT_NAR_LIBRARY_AUTOLOAD_DIR));
    }

    public String getBannerText() {
        return this.getProperty(UI_BANNER_TEXT, "");
    }

    public boolean isSecurityAutoReloadEnabled() {
        return this.getProperty(SECURITY_AUTO_RELOAD_ENABLED, Boolean.FALSE.toString()).equals(Boolean.TRUE.toString());
    }

    public String getSecurityAutoReloadInterval() {
        return this.getProperty(SECURITY_AUTO_RELOAD_INTERVAL, DEFAULT_SECURITY_AUTO_RELOAD_INTERVAL);
    }

    public Duration getSecurityUserJwsKeyRotationPeriod() {
        return Duration.parse(this.getProperty(SECURITY_USER_JWS_KEY_ROTATION_PERIOD, DEFAULT_SECURITY_USER_JWS_KEY_ROTATION_PERIOD));
    }

    public String getClusterProtocolHeartbeatInterval() {
        return this.getProperty(CLUSTER_PROTOCOL_HEARTBEAT_INTERVAL, "5 sec");
    }

    public String getNodeHeartbeatInterval() {
        return this.getClusterProtocolHeartbeatInterval();
    }

    public String getClusterNodeReadTimeout() {
        return this.getProperty(CLUSTER_NODE_READ_TIMEOUT, "5 sec");
    }

    public String getClusterNodeConnectionTimeout() {
        return this.getProperty(CLUSTER_NODE_CONNECTION_TIMEOUT, "5 sec");
    }

    public boolean isNode() {
        return Boolean.parseBoolean(this.getProperty(CLUSTER_IS_NODE));
    }

    public InetSocketAddress getClusterNodeProtocolAddress() {
        try {
            int socketPort;
            String socketAddress = this.getProperty(CLUSTER_NODE_ADDRESS);
            if (StringUtils.isBlank((String)socketAddress)) {
                socketAddress = "localhost";
            }
            if ((socketPort = this.getClusterNodeProtocolPort().intValue()) == 0) {
                throw new RuntimeException("Cluster Node Protocol port cannot be 0. Port must be inclusively in the range [1, 65535].");
            }
            return InetSocketAddress.createUnresolved(socketAddress, socketPort);
        }
        catch (Exception ex) {
            throw new RuntimeException("Invalid node protocol address/port due to: " + String.valueOf(ex), ex);
        }
    }

    public InetSocketAddress getClusterLoadBalanceAddress() {
        try {
            String host = this.getProperty(LOAD_BALANCE_HOST);
            if (StringUtils.isBlank((String)host)) {
                host = this.getProperty(CLUSTER_NODE_ADDRESS);
            }
            if (StringUtils.isBlank((String)host)) {
                host = "localhost";
            }
            int port = this.getIntegerProperty(LOAD_BALANCE_PORT, 6342);
            return InetSocketAddress.createUnresolved(host, port);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid load balance address/port due to: " + String.valueOf(e), e);
        }
    }

    public Integer getClusterNodeProtocolPort() {
        try {
            return Integer.parseInt(this.getProperty(CLUSTER_NODE_PROTOCOL_PORT));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public int getClusterNodeProtocolMaxPoolSize() {
        try {
            return Integer.parseInt(this.getProperty(CLUSTER_NODE_PROTOCOL_MAX_THREADS));
        }
        catch (NumberFormatException nfe) {
            return 50;
        }
    }

    public boolean isClustered() {
        return Boolean.parseBoolean(this.getProperty(CLUSTER_IS_NODE));
    }

    public File getClusterNodeFirewallFile() {
        String firewallFile = this.getProperty(CLUSTER_FIREWALL_FILE);
        if (StringUtils.isBlank((String)firewallFile)) {
            return null;
        }
        return new File(firewallFile);
    }

    public String getClusterProtocolManagerToNodeApiScheme() {
        String isSecureProperty = this.getProperty(CLUSTER_PROTOCOL_IS_SECURE);
        if (Boolean.valueOf(isSecureProperty).booleanValue()) {
            return "https";
        }
        return "http";
    }

    public File getKerberosConfigurationFile() {
        String krb5File = this.getProperty(KERBEROS_KRB5_FILE);
        if (krb5File != null && krb5File.trim().length() > 0) {
            return new File(krb5File.trim());
        }
        return null;
    }

    public String getKerberosServicePrincipal() {
        String servicePrincipal = this.getProperty(KERBEROS_SERVICE_PRINCIPAL);
        if (!StringUtils.isBlank((String)servicePrincipal)) {
            return servicePrincipal.trim();
        }
        return null;
    }

    public String getKerberosServiceKeytabLocation() {
        String keytabLocation = this.getProperty(KERBEROS_SERVICE_KEYTAB_LOCATION);
        if (!StringUtils.isBlank((String)keytabLocation)) {
            return keytabLocation.trim();
        }
        return null;
    }

    public boolean isLoginIdentityProviderEnabled() {
        return !StringUtils.isBlank((String)this.getProperty(SECURITY_USER_LOGIN_IDENTITY_PROVIDER));
    }

    public Boolean isAnonymousAuthenticationAllowed() {
        String anonymousAuthenticationAllowed = this.getProperty(SECURITY_ANONYMOUS_AUTHENTICATION, "false");
        return "true".equalsIgnoreCase(anonymousAuthenticationAllowed);
    }

    public boolean isOidcEnabled() {
        return !StringUtils.isBlank((String)this.getOidcDiscoveryUrl());
    }

    public String getOidcDiscoveryUrl() {
        return this.getProperty(SECURITY_USER_OIDC_DISCOVERY_URL);
    }

    public String getOidcConnectTimeout() {
        return this.getProperty(SECURITY_USER_OIDC_CONNECT_TIMEOUT, "5 secs");
    }

    public String getOidcReadTimeout() {
        return this.getProperty(SECURITY_USER_OIDC_READ_TIMEOUT, "5 secs");
    }

    public String getOidcClientId() {
        return this.getProperty(SECURITY_USER_OIDC_CLIENT_ID);
    }

    public String getOidcClientSecret() {
        return this.getProperty(SECURITY_USER_OIDC_CLIENT_SECRET);
    }

    public String getOidcPreferredJwsAlgorithm() {
        return this.getProperty(SECURITY_USER_OIDC_PREFERRED_JWSALGORITHM);
    }

    public List<String> getOidcAdditionalScopes() {
        String rawProperty = this.getProperty(SECURITY_USER_OIDC_ADDITIONAL_SCOPES, "");
        if (rawProperty.isEmpty()) {
            return new ArrayList<String>();
        }
        List<String> additionalScopes = Arrays.asList(rawProperty.split(","));
        return additionalScopes.stream().map(String::trim).collect(Collectors.toList());
    }

    public String getOidcClaimIdentifyingUser() {
        return this.getProperty(SECURITY_USER_OIDC_CLAIM_IDENTIFYING_USER, "email").trim();
    }

    public String getOidcClaimGroups() {
        return this.getProperty(NIFI_SECURITY_USER_OIDC_CLAIM_GROUPS, "groups").trim();
    }

    public List<String> getOidcFallbackClaimsIdentifyingUser() {
        String rawProperty = this.getProperty(SECURITY_USER_OIDC_FALLBACK_CLAIMS_IDENTIFYING_USER, "").trim();
        if (StringUtils.isBlank((String)rawProperty)) {
            return Collections.emptyList();
        }
        List<String> fallbackClaims = Arrays.asList(rawProperty.split(","));
        return fallbackClaims.stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public String getOidcClientTruststoreStrategy() {
        return this.getProperty(SECURITY_USER_OIDC_TRUSTSTORE_STRATEGY, "JDK");
    }

    public String getOidcTokenRefreshWindow() {
        return this.getProperty(SECURITY_USER_OIDC_TOKEN_REFRESH_WINDOW, "60 secs");
    }

    public boolean shouldSendServerVersion() {
        return Boolean.parseBoolean(this.getProperty(WEB_SHOULD_SEND_SERVER_VERSION, "true"));
    }

    public boolean isDiagnosticsOnShutdownEnabled() {
        return Boolean.parseBoolean(this.getProperty(DIAGNOSTICS_ON_SHUTDOWN_ENABLED));
    }

    public boolean isDiagnosticsOnShutdownVerbose() {
        return Boolean.parseBoolean(this.getProperty(DIAGNOSTICS_ON_SHUTDOWN_VERBOSE));
    }

    public String getDiagnosticsOnShutdownDirectory() {
        return this.getProperty(DIAGNOSTICS_ON_SHUTDOWN_DIRECTORY, DEFAULT_DIAGNOSTICS_ON_SHUTDOWN_DIRECTORY);
    }

    public int getDiagnosticsOnShutdownMaxFileCount() {
        try {
            return Integer.parseInt(this.getProperty(DIAGNOSTICS_ON_SHUTDOWN_MAX_FILE_COUNT));
        }
        catch (NumberFormatException e) {
            return 10;
        }
    }

    public String getDiagnosticsOnShutdownDirectoryMaxSize() {
        return this.getProperty(DIAGNOSTICS_ON_SHUTDOWN_MAX_DIRECTORY_SIZE, DEFAULT_DIAGNOSTICS_ON_SHUTDOWN_MAX_DIRECTORY_SIZE);
    }

    public boolean isSamlEnabled() {
        return !StringUtils.isBlank((String)this.getSamlIdentityProviderMetadataUrl());
    }

    public String getSamlIdentityProviderMetadataUrl() {
        return this.getProperty(SECURITY_USER_SAML_IDP_METADATA_URL);
    }

    public String getSamlServiceProviderEntityId() {
        return this.getProperty(SECURITY_USER_SAML_SP_ENTITY_ID);
    }

    public String getSamlIdentityAttributeName() {
        return this.getProperty(SECURITY_USER_SAML_IDENTITY_ATTRIBUTE_NAME);
    }

    public String getSamlGroupAttributeName() {
        return this.getProperty(SECURITY_USER_SAML_GROUP_ATTRIBUTE_NAME);
    }

    public String getSamlSignatureAlgorithm() {
        return this.getProperty(SECURITY_USER_SAML_SIGNATURE_ALGORITHM, DEFAULT_SECURITY_USER_SAML_SIGNATURE_ALGORITHM);
    }

    public String getSamlSignatureDigestAlgorithm() {
        return this.getProperty(SECURITY_USER_SAML_SIGNATURE_DIGEST_ALGORITHM, DEFAULT_SECURITY_USER_SAML_DIGEST_ALGORITHM);
    }

    public boolean isSamlMetadataSigningEnabled() {
        return Boolean.parseBoolean(this.getProperty(SECURITY_USER_SAML_METADATA_SIGNING_ENABLED, "false"));
    }

    public boolean isSamlRequestSigningEnabled() {
        return Boolean.parseBoolean(this.getProperty(SECURITY_USER_SAML_REQUEST_SIGNING_ENABLED, "false"));
    }

    public boolean isSamlWantAssertionsSigned() {
        return Boolean.parseBoolean(this.getProperty(SECURITY_USER_SAML_WANT_ASSERTIONS_SIGNED, "true"));
    }

    public boolean isSamlMessageLoggingEnabled() {
        return Boolean.parseBoolean(this.getProperty(SECURITY_USER_SAML_MESSAGE_LOGGING_ENABLED, "false"));
    }

    public String getSamlAuthenticationExpiration() {
        return this.getProperty(SECURITY_USER_SAML_AUTHENTICATION_EXPIRATION, "12 hours");
    }

    public boolean isSamlSingleLogoutEnabled() {
        return Boolean.parseBoolean(this.getProperty(SECURITY_USER_SAML_SINGLE_LOGOUT_ENABLED, "false"));
    }

    public String getSamlHttpClientTruststoreStrategy() {
        return this.getProperty(SECURITY_USER_SAML_HTTP_CLIENT_TRUSTSTORE_STRATEGY, "JDK");
    }

    public String getSamlHttpClientConnectTimeout() {
        return this.getProperty(SECURITY_USER_SAML_HTTP_CLIENT_CONNECT_TIMEOUT, "30 secs");
    }

    public String getSamlHttpClientReadTimeout() {
        return this.getProperty(SECURITY_USER_SAML_HTTP_CLIENT_READ_TIMEOUT, "30 secs");
    }

    public boolean isClientAuthRequiredForRestApi() {
        return !this.isLoginIdentityProviderEnabled() && !this.isOidcEnabled() && !this.isSamlEnabled() && this.isAnonymousAuthenticationAllowed() == false;
    }

    public InetSocketAddress getNodeApiAddress() {
        Integer port;
        String host;
        String scheme;
        String rawScheme = this.getClusterProtocolManagerToNodeApiScheme();
        String string = scheme = rawScheme == null ? "http" : rawScheme;
        if ("http".equalsIgnoreCase(scheme)) {
            host = StringUtils.isBlank((String)this.getProperty(WEB_HTTP_HOST)) ? "localhost" : this.getProperty(WEB_HTTP_HOST);
            port = this.getPort();
            if (port == null) {
                throw new RuntimeException(String.format("The %s must be specified if running in a cluster with %s set to false.", WEB_HTTP_PORT, CLUSTER_PROTOCOL_IS_SECURE));
            }
        } else {
            host = StringUtils.isBlank((String)this.getProperty(WEB_HTTPS_HOST)) ? "localhost" : this.getProperty(WEB_HTTPS_HOST);
            port = this.getSslPort();
            if (port == null) {
                throw new RuntimeException(String.format("The %s must be specified if running in a cluster with %s set to true.", WEB_HTTPS_PORT, CLUSTER_PROTOCOL_IS_SECURE));
            }
        }
        return InetSocketAddress.createUnresolved(host, port);
    }

    public Path getDatabaseRepositoryPath() {
        return Paths.get(this.getProperty(REPOSITORY_DATABASE_DIRECTORY), new String[0]);
    }

    public Path getFlowFileRepositoryPath() {
        return Paths.get(this.getProperty(FLOWFILE_REPOSITORY_DIRECTORY), new String[0]);
    }

    public Map<String, Path> getContentRepositoryPaths() {
        HashMap<String, Path> contentRepositoryPaths = new HashMap<String, Path>();
        for (String propertyName : this.getPropertyKeys()) {
            if (!StringUtils.startsWith((String)propertyName, (String)REPOSITORY_CONTENT_PREFIX)) continue;
            String key = StringUtils.substringAfter((String)propertyName, (String)REPOSITORY_CONTENT_PREFIX);
            contentRepositoryPaths.put(key, Paths.get(this.getProperty(propertyName), new String[0]));
        }
        return contentRepositoryPaths;
    }

    public Map<String, Path> getProvenanceRepositoryPaths() {
        HashMap<String, Path> provenanceRepositoryPaths = new HashMap<String, Path>();
        for (String propertyName : this.getPropertyKeys()) {
            if (!StringUtils.startsWith((String)propertyName, (String)PROVENANCE_REPO_DIRECTORY_PREFIX)) continue;
            String key = StringUtils.substringAfter((String)propertyName, (String)PROVENANCE_REPO_DIRECTORY_PREFIX);
            provenanceRepositoryPaths.put(key, Paths.get(this.getProperty(propertyName), new String[0]));
        }
        return provenanceRepositoryPaths;
    }

    public String getMaxAppendableClaimSize() {
        return this.getProperty(MAX_APPENDABLE_CLAIM_SIZE, DEFAULT_MAX_APPENDABLE_CLAIM_SIZE);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value == null || value.trim().isEmpty() ? defaultValue : value;
    }

    public String getBoredYieldDuration() {
        return this.getProperty(BORED_YIELD_DURATION, DEFAULT_BORED_YIELD_DURATION);
    }

    public File getStateManagementConfigFile() {
        return new File(this.getProperty(STATE_MANAGEMENT_CONFIG_FILE, DEFAULT_STATE_MANAGEMENT_CONFIG_FILE));
    }

    public String getLocalStateProviderId() {
        return this.getProperty(STATE_MANAGEMENT_LOCAL_PROVIDER_ID);
    }

    public String getClusterStateProviderId() {
        return this.getProperty(STATE_MANAGEMENT_CLUSTER_PROVIDER_ID);
    }

    public int getPerformanceMetricTrackingPercentage() {
        int percentage = this.getIntegerProperty(TRACK_PERFORMANCE_PERCENTAGE, 0);
        if (percentage < 0) {
            return 0;
        }
        if (percentage > 100) {
            return 100;
        }
        return percentage;
    }

    public File getEmbeddedZooKeeperPropertiesFile() {
        String filename = this.getProperty(STATE_MANAGEMENT_ZOOKEEPER_PROPERTIES);
        return filename == null ? null : new File(filename);
    }

    public boolean isStartEmbeddedZooKeeper() {
        return Boolean.parseBoolean(this.getProperty(STATE_MANAGEMENT_START_EMBEDDED_ZOOKEEPER));
    }

    public boolean isFlowConfigurationArchiveEnabled() {
        return Boolean.parseBoolean(this.getProperty(FLOW_CONFIGURATION_ARCHIVE_ENABLED, "true"));
    }

    public String getFlowConfigurationArchiveDir() {
        return this.getProperty(FLOW_CONFIGURATION_ARCHIVE_DIR);
    }

    public String getFlowElectionMaxWaitTime() {
        return this.getProperty(FLOW_ELECTION_MAX_WAIT_TIME, "5 mins");
    }

    public Integer getFlowElectionMaxCandidates() {
        return this.getIntegerProperty(FLOW_ELECTION_MAX_CANDIDATES, null);
    }

    public String getFlowConfigurationArchiveMaxTime() {
        return this.getProperty(FLOW_CONFIGURATION_ARCHIVE_MAX_TIME, null);
    }

    public String getFlowConfigurationArchiveMaxStorage() {
        return this.getProperty(FLOW_CONFIGURATION_ARCHIVE_MAX_STORAGE, null);
    }

    public Integer getFlowConfigurationArchiveMaxCount() {
        return this.getIntegerProperty(FLOW_CONFIGURATION_ARCHIVE_MAX_COUNT, null);
    }

    public Map<String, String> getHttpNetworkInterfaces() {
        HashMap<String, String> networkInterfaces = new HashMap<String, String>();
        for (String propertyName : this.getPropertyKeys()) {
            if (!StringUtils.startsWith((String)propertyName, (String)WEB_HTTP_NETWORK_INTERFACE_PREFIX)) continue;
            String key = StringUtils.substringAfter((String)propertyName, (String)WEB_HTTP_NETWORK_INTERFACE_PREFIX);
            networkInterfaces.put(key, this.getProperty(propertyName));
        }
        return networkInterfaces;
    }

    public Map<String, String> getHttpsNetworkInterfaces() {
        HashMap<String, String> networkInterfaces = new HashMap<String, String>();
        for (String propertyName : this.getPropertyKeys()) {
            if (!StringUtils.startsWith((String)propertyName, (String)WEB_HTTPS_NETWORK_INTERFACE_PREFIX)) continue;
            String key = StringUtils.substringAfter((String)propertyName, (String)WEB_HTTPS_NETWORK_INTERFACE_PREFIX);
            networkInterfaces.put(key, this.getProperty(propertyName));
        }
        return networkInterfaces;
    }

    public boolean isZooKeeperClientSecure() {
        String defaultValue = String.valueOf(false);
        String clientSecure = this.getProperty(ZOOKEEPER_CLIENT_SECURE, defaultValue).trim();
        if (!"true".equalsIgnoreCase(clientSecure) && !"false".equalsIgnoreCase(clientSecure)) {
            throw new RuntimeException(String.format("%s was '%s', expected true or false", ZOOKEEPER_CLIENT_SECURE, clientSecure));
        }
        return Boolean.parseBoolean(clientSecure);
    }

    public boolean isZookeeperClientWithEnsembleTracker() {
        String defaultValue = String.valueOf(true);
        String withEnsembleTracker = this.getProperty(ZOOKEEPER_CLIENT_ENSEMBLE_TRACKER, defaultValue).trim();
        if (!"true".equalsIgnoreCase(withEnsembleTracker) && !"false".equalsIgnoreCase(withEnsembleTracker)) {
            throw new RuntimeException(String.format("%s was '%s', expected true or false", ZOOKEEPER_CLIENT_ENSEMBLE_TRACKER, withEnsembleTracker));
        }
        return Boolean.parseBoolean(withEnsembleTracker);
    }

    public boolean isZooKeeperTlsConfigurationPresent() {
        return StringUtils.isNotBlank((String)this.getProperty(ZOOKEEPER_CLIENT_SECURE)) && StringUtils.isNotBlank((String)this.getProperty(ZOOKEEPER_SECURITY_KEYSTORE)) && this.getProperty(ZOOKEEPER_SECURITY_KEYSTORE_PASSWD) != null && StringUtils.isNotBlank((String)this.getProperty(ZOOKEEPER_SECURITY_TRUSTSTORE)) && this.getProperty(ZOOKEEPER_SECURITY_TRUSTSTORE_PASSWD) != null;
    }

    public boolean isTlsConfigurationPresent() {
        return StringUtils.isNotBlank((String)this.getProperty(SECURITY_KEYSTORE)) && this.getProperty(SECURITY_KEYSTORE_PASSWD) != null && StringUtils.isNotBlank((String)this.getProperty(SECURITY_TRUSTSTORE)) && this.getProperty(SECURITY_TRUSTSTORE_PASSWD) != null;
    }

    public String getRepositoryEncryptionKeyId() {
        return this.getProperty(REPOSITORY_ENCRYPTION_KEY_ID);
    }

    public List<String> getAllowedHostsAsList() {
        String rawProperty = this.getProperty(WEB_PROXY_HOST, "");
        List<String> hosts = Arrays.asList(rawProperty.split(","));
        return hosts.stream().map(this::normalizeHost).filter(host -> !StringUtils.isBlank((String)host)).collect(Collectors.toList());
    }

    String normalizeHost(String host) {
        if (host == null || host.equalsIgnoreCase("")) {
            return "";
        }
        return host.trim();
    }

    public String getAllowedContextPaths() {
        return StringUtils.join(this.getAllowedContextPathsAsList(), (String)",");
    }

    public List<String> getAllowedContextPathsAsList() {
        String rawProperty = this.getProperty(WEB_PROXY_CONTEXT_PATH, "");
        List<String> contextPaths = Arrays.asList(rawProperty.split(","));
        return contextPaths.stream().map(this::normalizeContextPath).collect(Collectors.toList());
    }

    private String normalizeContextPath(String cp) {
        if (cp == null || cp.equalsIgnoreCase("")) {
            return "";
        }
        Object trimmedCP = cp.trim();
        trimmedCP = ((String)trimmedCP).startsWith("/") ? trimmedCP : "/" + (String)trimmedCP;
        trimmedCP = ((String)trimmedCP).endsWith("/") ? ((String)trimmedCP).substring(0, ((String)trimmedCP).length() - 1) : trimmedCP;
        return trimmedCP;
    }

    public Long getDefaultBackPressureObjectThreshold() {
        long backPressureCount;
        try {
            String backPressureCountStr = this.getProperty(BACKPRESSURE_COUNT);
            backPressureCount = backPressureCountStr == null || backPressureCountStr.trim().isEmpty() ? 10000L : Long.parseLong(backPressureCountStr);
        }
        catch (NumberFormatException nfe) {
            backPressureCount = 10000L;
        }
        return backPressureCount;
    }

    public String getDefaultBackPressureDataSizeThreshold() {
        return this.getProperty(BACKPRESSURE_SIZE, DEFAULT_BACKPRESSURE_SIZE);
    }

    public int getDefaultListenerBootstrapPort() {
        return this.getIntegerProperty(LISTENER_BOOTSTRAP_PORT, 0);
    }

    public String getQuestDbStatusRepositoryPath() {
        return this.getProperty(STATUS_REPOSITORY_QUESTDB_PERSIST_LOCATION, DEFAULT_COMPONENT_STATUS_REPOSITORY_PERSIST_LOCATION);
    }

    public String getQuestDbStatusRepositoryBackupPath() {
        return this.getProperty(STATUS_REPOSITORY_QUESTDB_PERSIST_LOCATION_BACKUP, DEFAULT_COMPONENT_STATUS_REPOSITORY_PERSIST_LOCATION_BACKUP);
    }

    public int getQuestDbStatusRepositoryPersistBatchSize() {
        return Integer.parseInt(this.getProperty(STATUS_REPOSITORY_QUESTDB_PERSIST_BATCH_SIZE, DEFAULT_COMPONENT_STATUS_REPOSITORY_PERSIST_BATCH_SIZE));
    }

    public String getQuestDbStatusRepositoryPersistFrequency() {
        return this.getProperty(STATUS_REPOSITORY_QUESTDB_PERSIST_FREQUENCY, "5 secs");
    }

    public File getPythonFrameworkSourceDirectory() {
        String directory = this.getProperty(PYTHON_FRAMEWORK_SOURCE_DIRECTORY);
        return directory == null ? null : new File(directory);
    }

    public List<File> getPythonExtensionsDirectories() {
        Collection<String> directories = this.getPropertiesWithPrefix(PYTHON_EXTENSION_DIRECTORY_PREFIX).values();
        return directories.stream().distinct().map(File::new).collect(Collectors.toList());
    }

    public Map<String, String> getPropertiesWithPrefix(String prefix) {
        return this.getPropertyKeys().stream().filter(key -> key.startsWith(prefix)).collect(Collectors.toMap(key -> key, key -> this.getProperty((String)key)));
    }

    public Set<String> getDirectSubsequentTokens(String prefix) {
        Object fixedPrefix = prefix.endsWith(".") ? prefix : prefix + ".";
        return this.getPropertyKeys().stream().filter(arg_0 -> NiFiProperties.lambda$getDirectSubsequentTokens$5((String)fixedPrefix, arg_0)).map(arg_0 -> NiFiProperties.lambda$getDirectSubsequentTokens$6((String)fixedPrefix, arg_0)).map(key -> key.indexOf(46) == -1 ? key : key.substring(0, key.indexOf(46))).collect(Collectors.toSet());
    }

    public boolean flowRegistryCheckForRuleViolationsBeforeCommit() {
        String flowRegistryCheckForRuleViolationsBeforeCommit = this.getProperty(FLOW_REGISTRY_CHECK_FOR_RULE_VIOLATIONS_BEFORE_COMMIT, DEFAULT_FLOW_REGISTRY_CHECK_FOR_RULE_VIOLATIONS_BEFORE_COMMIT.toString());
        if (!"true".equalsIgnoreCase(flowRegistryCheckForRuleViolationsBeforeCommit) && !"false".equalsIgnoreCase(flowRegistryCheckForRuleViolationsBeforeCommit)) {
            throw new RuntimeException(String.format("%s was '%s', expected true or false", FLOW_REGISTRY_CHECK_FOR_RULE_VIOLATIONS_BEFORE_COMMIT, flowRegistryCheckForRuleViolationsBeforeCommit));
        }
        return Boolean.parseBoolean(flowRegistryCheckForRuleViolationsBeforeCommit);
    }

    public static NiFiProperties createBasicNiFiProperties(String propertiesFilePath) {
        return NiFiProperties.createBasicNiFiProperties(propertiesFilePath, new Properties());
    }

    public static NiFiProperties createBasicNiFiProperties(String propertiesFilePath, Map<String, String> additionalProperties) {
        Map<Object, Object> addProps = additionalProperties == null ? Collections.emptyMap() : additionalProperties;
        Properties properties = new Properties();
        addProps.forEach(properties::put);
        return NiFiProperties.createBasicNiFiProperties(propertiesFilePath, properties);
    }

    public static NiFiProperties createBasicNiFiProperties(String propertiesFilePath, Properties additionalProperties) {
        final Properties properties = new Properties();
        if (propertiesFilePath == null || StringUtils.isNotBlank((String)propertiesFilePath)) {
            NiFiProperties.readFromPropertiesFile(propertiesFilePath, properties);
        }
        if (additionalProperties != null) {
            additionalProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)properties::put));
        }
        return new NiFiProperties(){

            public String getProperty(String key) {
                return properties.getProperty(key);
            }

            public Set<String> getPropertyKeys() {
                return properties.stringPropertyNames();
            }

            public int size() {
                return this.getPropertyKeys().size();
            }
        };
    }

    private static void readFromPropertiesFile(String propertiesFilePath, Properties properties) {
        String nfPropertiesFilePath;
        String string = nfPropertiesFilePath = propertiesFilePath == null ? System.getProperty(PROPERTIES_FILE_PATH) : propertiesFilePath;
        if (nfPropertiesFilePath != null) {
            File propertiesFile = new File(nfPropertiesFilePath.trim());
            if (!propertiesFile.exists()) {
                throw new RuntimeException("Properties file doesn't exist '" + propertiesFile.getAbsolutePath() + "'");
            }
            if (!propertiesFile.canRead()) {
                throw new RuntimeException("Properties file exists but cannot be read '" + propertiesFile.getAbsolutePath() + "'");
            }
            BufferedInputStream inStream = null;
            try {
                inStream = new BufferedInputStream(new FileInputStream(propertiesFile));
                properties.load(inStream);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot load properties file due to " + ex.getLocalizedMessage(), ex);
            }
            finally {
                if (null != inStream) {
                    try {
                        ((InputStream)inStream).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void validate() {
        String remoteInputHost = this.getProperty(REMOTE_INPUT_HOST);
        if (!StringUtils.isBlank((String)remoteInputHost) && remoteInputHost.split(":").length > 1) {
            throw new IllegalArgumentException(remoteInputHost + " is not a correct value for nifi.remote.input.host. It should be a valid hostname without protocol or port.");
        }
    }

    public String toString() {
        return "NiFiProperties instance with " + this.size() + " properties";
    }

    private static /* synthetic */ String lambda$getDirectSubsequentTokens$6(String fixedPrefix, String key) {
        return key.substring(fixedPrefix.length());
    }

    private static /* synthetic */ boolean lambda$getDirectSubsequentTokens$5(String fixedPrefix, String key) {
        return key.startsWith(fixedPrefix);
    }
}

