/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.flow.Bundle;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.ConnectableComponent;
import org.apache.nifi.flow.ControllerServiceAPI;
import org.apache.nifi.flow.Position;
import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.flow.VersionedRemoteProcessGroup;
import org.apache.nifi.flow.VersionedReportingTask;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.minifi.commons.api.MiNiFiProperties;
import org.apache.nifi.minifi.commons.service.FlowEnrichService;
import org.apache.nifi.properties.ReadableProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardFlowEnrichService
implements FlowEnrichService {
    static final String DEFAULT_SSL_CONTEXT_SERVICE_NAME = "SSL Context Service";
    static final String COMMON_SSL_CONTEXT_SERVICE_NAME = "SSL-Context-Service";
    static final String COMMON_SSL_CONTEXT_SERVICE_ID = "generated-common-ssl-context";
    static final String SITE_TO_SITE_PROVENANCE_REPORTING_TASK_NAME = "Site-To-Site-Provenance-Reporting";
    static final String SITE_TO_SITE_PROVENANCE_REPORTING_TASK_ID = "generated-s2s-provenance-reporting-task";
    private static final Logger LOG = LoggerFactory.getLogger(StandardFlowEnrichService.class);
    private static final String NIFI_BUNDLE_GROUP = "org.apache.nifi";
    private static final String STANDARD_RESTRICTED_SSL_CONTEXT_SERVICE = "org.apache.nifi.ssl.StandardRestrictedSSLContextService";
    private static final String RESTRICTED_SSL_CONTEXT_SERVICE_API = "org.apache.nifi.ssl.RestrictedSSLContextService";
    private static final String SSL_CONTEXT_SERVICE_API = "org.apache.nifi.ssl.SSLContextService";
    private static final String SSL_CONTEXT_SERVICE_NAR = "nifi-ssl-context-service-nar";
    private static final String STANDARD_SERVICES_API_NAR_ARTIFACT = "nifi-standard-services-api-nar";
    private static final String SITE_TO_SITE_PROVENANCE_REPORTING_TASK = "org.apache.nifi.reporting.SiteToSiteProvenanceReportingTask";
    private static final String SITE_TO_SITE_REPORTING_NAR_ARTIFACT = "nifi-site-to-site-reporting-nar";
    private static final String PROVENANCE_REPORTING_TASK_PROTOCOL = "HTTP";
    private static final String PROVENANCE_REPORTING_TASK_BEGINNING_OF_STREAM = "beginning-of-stream";
    private static final String DEFAULT_BULLETIN_LEVEL = "WARN";
    private static final String DEFAULT_EXECUTION_NODE = "ALL";
    private static final Position DEFAULT_POSITION = new Position(0.0, 0.0);
    private static final Predicate<? super VersionedComponent> IS_LEGACY_COMPONENT = versionedComponent -> StringUtils.isBlank((CharSequence)versionedComponent.getInstanceIdentifier());
    private final ReadableProperties minifiProperties;

    public StandardFlowEnrichService(ReadableProperties minifiProperties) {
        this.minifiProperties = minifiProperties;
    }

    public VersionedDataflow enrichFlow(VersionedDataflow versionedDataflow) {
        versionedDataflow.setReportingTasks(Optional.ofNullable(versionedDataflow.getReportingTasks()).orElseGet(ArrayList::new));
        versionedDataflow.setRegistries(Optional.ofNullable(versionedDataflow.getRegistries()).orElseGet(ArrayList::new));
        versionedDataflow.setControllerServices(Optional.ofNullable(versionedDataflow.getControllerServices()).orElseGet(ArrayList::new));
        versionedDataflow.setParameterContexts(Optional.ofNullable(versionedDataflow.getParameterContexts()).orElseGet(ArrayList::new).stream().map(versionedParameterContext -> {
            versionedParameterContext.setIdentifier(Optional.ofNullable(versionedParameterContext.getIdentifier()).orElseGet(UUID.randomUUID()::toString));
            versionedParameterContext.setInstanceIdentifier(Optional.ofNullable(versionedParameterContext.getInstanceIdentifier()).orElseGet(UUID.randomUUID()::toString));
            return versionedParameterContext;
        }).collect(Collectors.toList()));
        Optional<Integer> maxConcurrentThreads = Optional.ofNullable(this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_FLOW_MAX_CONCURRENT_THREADS.getKey())).map(Integer::parseInt);
        maxConcurrentThreads.ifPresent(arg_0 -> ((VersionedDataflow)versionedDataflow).setMaxTimerDrivenThreadCount(arg_0));
        VersionedProcessGroup rootGroup = versionedDataflow.getRootGroup();
        if (StringUtils.isBlank((CharSequence)rootGroup.getIdentifier())) {
            rootGroup.setIdentifier(UUID.randomUUID().toString());
        }
        if (Objects.isNull(rootGroup.getPosition())) {
            rootGroup.setPosition(DEFAULT_POSITION);
        }
        rootGroup.getControllerServices().forEach(controllerService -> controllerService.setScheduledState(ScheduledState.ENABLED));
        Optional<VersionedControllerService> commonSslControllerService = this.createCommonSslControllerService();
        commonSslControllerService.ifPresent(versionedDataflow.getControllerServices()::add);
        commonSslControllerService.filter(__ -> Boolean.parseBoolean(this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_FLOW_USE_PARENT_SSL.getKey()))).map(VersionedComponent::getInstanceIdentifier).ifPresent(commonSslControllerServiceInstanceId -> this.overrideProcessorsSslControllerService(rootGroup, (String)commonSslControllerServiceInstanceId));
        this.createProvenanceReportingTask(commonSslControllerService.map(VersionedComponent::getInstanceIdentifier).orElse("")).ifPresent(versionedDataflow.getReportingTasks()::add);
        if (IS_LEGACY_COMPONENT.test((VersionedComponent)rootGroup)) {
            LOG.info("Legacy flow detected. Initializing missing but mandatory properties on components");
            this.initializeComponentsMissingProperties(rootGroup);
            Map<String, String> idToInstanceIdMap = this.createIdToInstanceIdMap(rootGroup);
            this.setConnectableComponentsInstanceId(rootGroup, idToInstanceIdMap);
        }
        return versionedDataflow;
    }

    private Optional<VersionedControllerService> createCommonSslControllerService() {
        if (!this.parentSslEnabled()) {
            LOG.debug("Parent SSL is disabled, skip creating parent SSL Controller Service");
            return Optional.empty();
        }
        LOG.debug("Parent SSL is enabled, creating parent SSL Controller Service");
        VersionedControllerService sslControllerService = new VersionedControllerService();
        sslControllerService.setIdentifier(UUID.randomUUID().toString());
        sslControllerService.setInstanceIdentifier(COMMON_SSL_CONTEXT_SERVICE_ID);
        sslControllerService.setName(COMMON_SSL_CONTEXT_SERVICE_NAME);
        sslControllerService.setComments("");
        sslControllerService.setType(STANDARD_RESTRICTED_SSL_CONTEXT_SERVICE);
        sslControllerService.setScheduledState(ScheduledState.ENABLED);
        sslControllerService.setBulletinLevel(LogLevel.WARN.name());
        sslControllerService.setComponentType(ComponentType.CONTROLLER_SERVICE);
        sslControllerService.setBundle(this.createBundle(SSL_CONTEXT_SERVICE_NAR));
        sslControllerService.setProperties(this.sslControllerServiceProperties());
        sslControllerService.setControllerServiceApis(List.of(this.controllerServiceAPI(SSL_CONTEXT_SERVICE_API, this.createBundle(STANDARD_SERVICES_API_NAR_ARTIFACT)), this.controllerServiceAPI(RESTRICTED_SSL_CONTEXT_SERVICE_API, this.createBundle(STANDARD_SERVICES_API_NAR_ARTIFACT))));
        sslControllerService.setPropertyDescriptors(Map.of());
        return Optional.of(sslControllerService);
    }

    private boolean parentSslEnabled() {
        return MiNiFiProperties.securityPropertyKeys().stream().map(arg_0 -> ((ReadableProperties)this.minifiProperties).getProperty(arg_0)).allMatch(StringUtils::isNotBlank);
    }

    private Map<String, String> sslControllerServiceProperties() {
        return Map.of("Keystore Filename", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SECURITY_KEYSTORE.getKey()), "Keystore Password", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SECURITY_KEYSTORE_PASSWD.getKey()), "key-password", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SECURITY_KEY_PASSWD.getKey()), "Keystore Type", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SECURITY_KEYSTORE_TYPE.getKey()), "Truststore Filename", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SECURITY_TRUSTSTORE.getKey()), "Truststore Password", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SECURITY_TRUSTSTORE_PASSWD.getKey()), "Truststore Type", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SECURITY_TRUSTSTORE_TYPE.getKey()), "SSL Protocol", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SECURITY_SSL_PROTOCOL.getKey()));
    }

    private ControllerServiceAPI controllerServiceAPI(String type, Bundle bundle) {
        ControllerServiceAPI controllerServiceAPI = new ControllerServiceAPI();
        controllerServiceAPI.setType(type);
        controllerServiceAPI.setBundle(bundle);
        return controllerServiceAPI;
    }

    private void overrideProcessorsSslControllerService(VersionedProcessGroup processGroup, String commonSslControllerServiceInstanceId) {
        LOG.debug("Use parent SSL is enabled, overriding processors' SSL Controller service to {}", (Object)commonSslControllerServiceInstanceId);
        processGroup.getProcessors().forEach(processor -> processor.getProperties().replace(DEFAULT_SSL_CONTEXT_SERVICE_NAME, (String)processor.getProperties().get(DEFAULT_SSL_CONTEXT_SERVICE_NAME), commonSslControllerServiceInstanceId));
        processGroup.getProcessGroups().forEach(childProcessGroup -> this.overrideProcessorsSslControllerService((VersionedProcessGroup)childProcessGroup, commonSslControllerServiceInstanceId));
    }

    private Optional<VersionedReportingTask> createProvenanceReportingTask(String sslControllerServiceIdentifier) {
        if (!this.provenanceReportingEnabled()) {
            LOG.debug("Provenance reporting task is disabled, skip creating provenance reporting task");
            return Optional.empty();
        }
        LOG.debug("Provenance reporting task is enabled, creating provenance reporting task");
        VersionedReportingTask reportingTask = new VersionedReportingTask();
        reportingTask.setIdentifier(UUID.randomUUID().toString());
        reportingTask.setInstanceIdentifier(SITE_TO_SITE_PROVENANCE_REPORTING_TASK_ID);
        reportingTask.setName(SITE_TO_SITE_PROVENANCE_REPORTING_TASK_NAME);
        reportingTask.setComments(this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_COMMENT.getKey()));
        reportingTask.setType(SITE_TO_SITE_PROVENANCE_REPORTING_TASK);
        reportingTask.setBundle(this.createBundle(SITE_TO_SITE_REPORTING_NAR_ARTIFACT));
        reportingTask.setScheduledState(ScheduledState.RUNNING);
        reportingTask.setSchedulingStrategy(this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_SCHEDULING_STRATEGY.getKey()));
        reportingTask.setSchedulingPeriod(this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_SCHEDULING_PERIOD.getKey()));
        reportingTask.setComponentType(ComponentType.REPORTING_TASK);
        reportingTask.setProperties(this.provenanceReportingTaskProperties(sslControllerServiceIdentifier));
        reportingTask.setPropertyDescriptors(Map.of());
        return Optional.of(reportingTask);
    }

    private boolean provenanceReportingEnabled() {
        return MiNiFiProperties.provenanceReportingPropertyKeys().stream().map(arg_0 -> ((ReadableProperties)this.minifiProperties).getProperty(arg_0)).allMatch(StringUtils::isNotBlank);
    }

    private Bundle createBundle(String artifact) {
        Bundle bundle = new Bundle();
        bundle.setGroup(NIFI_BUNDLE_GROUP);
        bundle.setArtifact(artifact);
        bundle.setVersion("");
        return bundle;
    }

    private Map<String, String> provenanceReportingTaskProperties(String sslControllerServiceIdentifier) {
        return List.of(Map.entry("Input Port Name", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_INPUT_PORT_NAME.getKey())), Map.entry("s2s-transport-protocol", PROVENANCE_REPORTING_TASK_PROTOCOL), Map.entry("Platform", "nifi"), Map.entry("Destination URL", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_DESTINATION_URL.getKey())), Map.entry("include-null-values", Boolean.FALSE.toString()), Map.entry("Compress Events", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_COMPRESS_EVENTS.getKey())), Map.entry("Batch Size", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_BATCH_SIZE.getKey())), Map.entry("Communications Timeout", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_COMMUNICATIONS_TIMEOUT.getKey())), Map.entry("start-position", PROVENANCE_REPORTING_TASK_BEGINNING_OF_STREAM), Map.entry("Instance URL", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_INSTANCE_URL.getKey())), Map.entry(DEFAULT_SSL_CONTEXT_SERVICE_NAME, sslControllerServiceIdentifier)).stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void initializeComponentsMissingProperties(VersionedProcessGroup versionedProcessGroup) {
        versionedProcessGroup.setInstanceIdentifier(UUID.randomUUID().toString());
        Stream.of(Optional.ofNullable(versionedProcessGroup.getControllerServices()).orElse(Set.of()), Optional.ofNullable(versionedProcessGroup.getConnections()).orElse(Set.of()), Optional.ofNullable(versionedProcessGroup.getProcessors()).orElse(Set.of()), Optional.ofNullable(versionedProcessGroup.getInputPorts()).orElse(Set.of()), Optional.ofNullable(versionedProcessGroup.getOutputPorts()).orElse(Set.of()), Optional.ofNullable(versionedProcessGroup.getFunnels()).orElse(Set.of()), Optional.ofNullable(versionedProcessGroup.getRemoteProcessGroups()).orElse(Set.of()), Optional.ofNullable(versionedProcessGroup.getRemoteProcessGroups()).orElse(Set.of()).stream().map(VersionedRemoteProcessGroup::getInputPorts).flatMap(Collection::stream).collect(Collectors.toSet()), Optional.ofNullable(versionedProcessGroup.getRemoteProcessGroups()).orElse(Set.of()).stream().map(VersionedRemoteProcessGroup::getOutputPorts).flatMap(Collection::stream).collect(Collectors.toSet())).flatMap(Collection::stream).filter(IS_LEGACY_COMPONENT).forEach(versionedComponent -> {
            versionedComponent.setInstanceIdentifier(UUID.randomUUID().toString());
            if (versionedComponent instanceof VersionedProcessor) {
                VersionedProcessor processor = (VersionedProcessor)versionedComponent;
                if (StringUtils.isBlank((CharSequence)processor.getBulletinLevel())) {
                    processor.setBulletinLevel(DEFAULT_BULLETIN_LEVEL);
                }
                if (StringUtils.isBlank((CharSequence)processor.getExecutionNode())) {
                    processor.setExecutionNode(DEFAULT_EXECUTION_NODE);
                }
            }
        });
        versionedProcessGroup.getProcessGroups().forEach(this::initializeComponentsMissingProperties);
    }

    private Map<String, String> createIdToInstanceIdMap(VersionedProcessGroup versionedProcessGroup) {
        Map<String, String> thisProcessGroupIdToInstanceIdMaps = Stream.of(Optional.ofNullable(versionedProcessGroup.getProcessors()).orElse(Set.of()), Optional.ofNullable(versionedProcessGroup.getInputPorts()).orElse(Set.of()), Optional.ofNullable(versionedProcessGroup.getOutputPorts()).orElse(Set.of()), Optional.ofNullable(versionedProcessGroup.getFunnels()).orElse(Set.of()), Optional.ofNullable(versionedProcessGroup.getRemoteProcessGroups()).orElse(Set.of()).stream().map(VersionedRemoteProcessGroup::getInputPorts).flatMap(Collection::stream).collect(Collectors.toSet()), Optional.ofNullable(versionedProcessGroup.getRemoteProcessGroups()).orElse(Set.of()).stream().map(VersionedRemoteProcessGroup::getOutputPorts).flatMap(Collection::stream).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toMap(VersionedComponent::getIdentifier, VersionedComponent::getInstanceIdentifier));
        Stream<Map> childProcessGroupsIdToInstanceIdMaps = Optional.ofNullable(versionedProcessGroup.getProcessGroups()).orElse(Set.of()).stream().map(this::createIdToInstanceIdMap);
        return Stream.concat(Stream.of(thisProcessGroupIdToInstanceIdMaps), childProcessGroupsIdToInstanceIdMaps).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void setConnectableComponentsInstanceId(VersionedProcessGroup versionedProcessGroup, Map<String, String> idToInstanceIdMap) {
        Optional.ofNullable(versionedProcessGroup.getConnections()).orElse(Set.of()).forEach(connection -> {
            ConnectableComponent source = connection.getSource();
            source.setInstanceIdentifier((String)idToInstanceIdMap.get(source.getId()));
            ConnectableComponent destination = connection.getDestination();
            destination.setInstanceIdentifier((String)idToInstanceIdMap.get(destination.getId()));
        });
        Optional.ofNullable(versionedProcessGroup.getProcessGroups()).orElse(Set.of()).forEach(childProcessGroup -> this.setConnectableComponentsInstanceId((VersionedProcessGroup)childProcessGroup, idToInstanceIdMap));
    }
}

