/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.authentication.LoginIdentityProvider;
import org.apache.nifi.authorization.AccessPolicyProvider;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.UserGroupProvider;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.components.ClassloaderIsolationKeyProvider;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.StateProvider;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.status.analytics.StatusAnalyticsModel;
import org.apache.nifi.controller.status.history.StatusHistoryRepository;
import org.apache.nifi.flow.resource.ExternalResourceProvider;
import org.apache.nifi.flowanalysis.FlowAnalysisRule;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.init.ConfigurableComponentInitializer;
import org.apache.nifi.init.ConfigurableComponentInitializerFactory;
import org.apache.nifi.nar.ExtensionDefinition;
import org.apache.nifi.nar.ExtensionDiscoveringManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarClassLoader;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.nar.PythonBundle;
import org.apache.nifi.nar.SharedInstanceClassLoader;
import org.apache.nifi.parameter.ParameterProvider;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.python.PythonBridge;
import org.apache.nifi.python.PythonProcessorDetails;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardExtensionDiscoveringManager
implements ExtensionDiscoveringManager {
    private static final Logger logger = LoggerFactory.getLogger(StandardExtensionDiscoveringManager.class);
    private static final String PYTHON_TYPE_PREFIX = "python.";
    private final Map<Class, Set<ExtensionDefinition>> definitionMap = new HashMap<Class, Set<ExtensionDefinition>>();
    private final Map<String, List<Bundle>> classNameBundleLookup = new HashMap<String, List<Bundle>>();
    private final Map<BundleCoordinate, Set<ExtensionDefinition>> bundleCoordinateClassesLookup = new HashMap<BundleCoordinate, Set<ExtensionDefinition>>();
    private final Map<BundleCoordinate, Bundle> bundleCoordinateBundleLookup = new HashMap<BundleCoordinate, Bundle>();
    private final Map<ClassLoader, Bundle> classLoaderBundleLookup = new HashMap<ClassLoader, Bundle>();
    private final Map<String, ConfigurableComponent> tempComponentLookup = new HashMap<String, ConfigurableComponent>();
    private final Map<String, List<PythonProcessorDetails>> pythonProcessorDetails = new HashMap<String, List<PythonProcessorDetails>>();
    private final Map<String, InstanceClassLoader> instanceClassloaderLookup = new ConcurrentHashMap<String, InstanceClassLoader>();
    private final ConcurrentMap<BaseClassLoaderKey, SharedInstanceClassLoader> sharedBaseClassloaders = new ConcurrentHashMap<BaseClassLoaderKey, SharedInstanceClassLoader>();
    private PythonBridge pythonBridge;

    public StandardExtensionDiscoveringManager() {
        this(Collections.emptyList());
    }

    public StandardExtensionDiscoveringManager(Collection<Class<? extends ConfigurableComponent>> additionalExtensionTypes) {
        this.definitionMap.put(Processor.class, new HashSet());
        this.definitionMap.put(FlowFilePrioritizer.class, new HashSet());
        this.definitionMap.put(ReportingTask.class, new HashSet());
        this.definitionMap.put(FlowAnalysisRule.class, new HashSet());
        this.definitionMap.put(ParameterProvider.class, new HashSet());
        this.definitionMap.put(ControllerService.class, new HashSet());
        this.definitionMap.put(Authorizer.class, new HashSet());
        this.definitionMap.put(UserGroupProvider.class, new HashSet());
        this.definitionMap.put(AccessPolicyProvider.class, new HashSet());
        this.definitionMap.put(LoginIdentityProvider.class, new HashSet());
        this.definitionMap.put(ProvenanceRepository.class, new HashSet());
        this.definitionMap.put(StatusHistoryRepository.class, new HashSet());
        this.definitionMap.put(FlowFileRepository.class, new HashSet());
        this.definitionMap.put(FlowFileSwapManager.class, new HashSet());
        this.definitionMap.put(ContentRepository.class, new HashSet());
        this.definitionMap.put(StateProvider.class, new HashSet());
        this.definitionMap.put(StatusAnalyticsModel.class, new HashSet());
        this.definitionMap.put(ExternalResourceProvider.class, new HashSet());
        this.definitionMap.put(FlowRegistryClient.class, new HashSet());
        this.definitionMap.put(LeaderElectionManager.class, new HashSet());
        this.definitionMap.put(PythonBridge.class, new HashSet());
        additionalExtensionTypes.forEach(type -> this.definitionMap.putIfAbsent((Class)type, new HashSet()));
    }

    @Override
    public Set<Bundle> getAllBundles() {
        return new HashSet<Bundle>(this.bundleCoordinateBundleLookup.values());
    }

    @Override
    public void discoverExtensions(Bundle systemBundle, Set<Bundle> narBundles) {
        this.loadExtensions(systemBundle);
        this.bundleCoordinateBundleLookup.put(systemBundle.getBundleDetails().getCoordinate(), systemBundle);
        this.discoverExtensions(narBundles);
    }

    @Override
    public void discoverExtensions(Set<Bundle> narBundles, boolean logDetails) {
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        for (Bundle bundle : narBundles) {
            ClassLoader ncl = bundle.getClassLoader();
            Thread.currentThread().setContextClassLoader(ncl);
            long loadStart = System.currentTimeMillis();
            this.loadExtensions(bundle);
            long loadMillis = System.currentTimeMillis() - loadStart;
            if (logDetails) {
                logger.info("Loaded extensions for {} in {} millis", (Object)bundle.getBundleDetails(), (Object)loadMillis);
            }
            this.bundleCoordinateBundleLookup.put(bundle.getBundleDetails().getCoordinate(), bundle);
        }
        if (currentContextClassLoader != null) {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
    }

    @Override
    public void setPythonBridge(PythonBridge pythonBridge) {
        this.pythonBridge = pythonBridge;
    }

    @Override
    public void discoverPythonExtensions(Bundle pythonBundle) {
        this.discoverPythonExtensions(pythonBundle, true);
    }

    @Override
    public void discoverNewPythonExtensions(Bundle pythonBundle) {
        logger.debug("Scanning to discover new Python extensions...");
        this.discoverPythonExtensions(pythonBundle, false);
    }

    private void discoverPythonExtensions(Bundle pythonBundle, boolean includeNarBundles) {
        logger.debug("Scanning to discover which Python extensions are available and importing any necessary dependencies. If new components are discovered, this may take a few minutes. See python logs for more details.");
        long start = System.currentTimeMillis();
        this.pythonBridge.discoverExtensions(includeNarBundles);
        this.bundleCoordinateBundleLookup.putIfAbsent(pythonBundle.getBundleDetails().getCoordinate(), pythonBundle);
        Set<ExtensionDefinition> processorDefinitions = this.definitionMap.get(Processor.class);
        List pythonProcessorDetails = this.pythonBridge.getProcessorTypes();
        int processorsFound = 0;
        for (PythonProcessorDetails details : pythonProcessorDetails) {
            BundleDetails bundleDetails = this.createBundleDetailsWithOverriddenVersion(pythonBundle.getBundleDetails(), details.getProcessorVersion());
            Bundle bundle = new Bundle(bundleDetails, pythonBundle.getClassLoader());
            String className = PYTHON_TYPE_PREFIX + details.getProcessorType();
            ExtensionDefinition extensionDefinition = new ExtensionDefinition.Builder().implementationClassName(className).runtime(ExtensionDefinition.ExtensionRuntime.PYTHON).bundle(bundle).extensionType(Processor.class).description(details.getCapabilityDescription()).tags(details.getTags()).version(details.getProcessorVersion()).build();
            boolean added = processorDefinitions.add(extensionDefinition);
            if (added) {
                ++processorsFound;
                List bundlesForClass = this.classNameBundleLookup.computeIfAbsent(className, key -> new ArrayList());
                bundlesForClass.add(bundle);
                this.bundleCoordinateBundleLookup.putIfAbsent(bundleDetails.getCoordinate(), bundle);
                List detailsList = this.pythonProcessorDetails.computeIfAbsent(details.getProcessorType(), key -> new ArrayList());
                detailsList.add(details);
                logger.info("Discovered Python Processor {}", (Object)details.getProcessorType());
                continue;
            }
            logger.debug("Python Processor {} is already known", (Object)details.getProcessorType());
        }
        if (processorsFound == 0) {
            logger.debug("Discovered no new or updated Python Processors. Process took in {} millis", (Object)(System.currentTimeMillis() - start));
        } else {
            logger.info("Discovered or updated {} Python Processors in {} millis", (Object)processorsFound, (Object)(System.currentTimeMillis() - start));
        }
    }

    @Override
    public PythonProcessorDetails getPythonProcessorDetails(String processorType, String version) {
        String canonicalProcessorType = StandardExtensionDiscoveringManager.stripPythonTypePrefix(processorType);
        List<PythonProcessorDetails> detailsList = this.pythonProcessorDetails.get(canonicalProcessorType);
        if (detailsList == null) {
            return null;
        }
        for (PythonProcessorDetails processorDetails : detailsList) {
            if (!processorDetails.getProcessorVersion().equals(version)) continue;
            return processorDetails;
        }
        return null;
    }

    private BundleDetails createBundleDetailsWithOverriddenVersion(BundleDetails details, String version) {
        BundleCoordinate overriddenCoordinate = new BundleCoordinate(details.getCoordinate().getGroup(), details.getCoordinate().getId(), version);
        return new BundleDetails.Builder().buildBranch(details.getBuildBranch()).buildJdk(details.getBuildJdk()).buildRevision(details.getBuildRevision()).buildTag(details.getBuildTag()).buildTimestamp(details.getBuildTimestamp()).builtBy(details.getBuiltBy()).dependencyCoordinate(details.getDependencyCoordinate()).coordinate(overriddenCoordinate).workingDir(details.getWorkingDirectory()).build();
    }

    private void loadExtensions(Bundle bundle) {
        for (Class extensionType : this.definitionMap.keySet()) {
            String serviceType = extensionType.getName();
            try {
                Set<URL> serviceResourceUrls = this.getServiceFileURLs(bundle, extensionType);
                logger.debug("Bundle {} has the following Services File URLs for {}: {}", new Object[]{bundle, serviceType, serviceResourceUrls});
                for (URL serviceResourceUrl : serviceResourceUrls) {
                    Set<String> implementationClassNames = this.getServiceFileImplementationClassNames(serviceResourceUrl);
                    logger.debug("Bundle {} defines {} implementations of interface {}", new Object[]{bundle, implementationClassNames.size(), serviceType});
                    for (String implementationClassName : implementationClassNames) {
                        try {
                            this.loadExtension(implementationClassName, extensionType, bundle);
                            logger.debug("Successfully loaded {} {} from {}", new Object[]{extensionType.getSimpleName(), implementationClassName, bundle});
                        }
                        catch (Exception e) {
                            logger.error("Failed to register {} of type {} in bundle {}", new Object[]{extensionType.getSimpleName(), implementationClassName, bundle, e});
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get resources of type " + serviceType + " from bundle " + String.valueOf(bundle));
            }
        }
        this.classLoaderBundleLookup.put(bundle.getClassLoader(), bundle);
    }

    private Set<String> getServiceFileImplementationClassNames(URL serviceFileUrl) throws IOException {
        HashSet<String> implementationClassNames = new HashSet<String>();
        try (InputStream in = serviceFileUrl.openStream();
             InputStreamReader inputStreamReader = new InputStreamReader(in);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                int index = line.indexOf("#");
                if (index >= 0) {
                    line = line.substring(0, index);
                }
                if ((line = line.trim()).isEmpty()) continue;
                implementationClassNames.add(line);
            }
        }
        return implementationClassNames;
    }

    private Set<URL> getServiceFileURLs(Bundle bundle, Class<?> extensionType) throws IOException {
        String servicesFile = "META-INF/services/" + extensionType.getName();
        Enumeration<URL> serviceResourceUrlEnum = bundle.getClassLoader().getResources(servicesFile);
        HashSet<URL> serviceResourceUrls = new HashSet<URL>();
        while (serviceResourceUrlEnum.hasMoreElements()) {
            serviceResourceUrls.add(serviceResourceUrlEnum.nextElement());
        }
        Enumeration<URL> parentResourceUrlEnum = bundle.getClassLoader().getParent().getResources(servicesFile);
        while (parentResourceUrlEnum.hasMoreElements()) {
            serviceResourceUrls.remove(parentResourceUrlEnum.nextElement());
        }
        return serviceResourceUrls;
    }

    protected void loadExtension(String extensionClassName, Class<?> extensionType, Bundle bundle) {
        this.registerExtensionClass(extensionType, extensionClassName, bundle);
    }

    protected void registerExtensionClass(Class<?> extensionType, String implementationClassName, Bundle bundle) {
        Set<ExtensionDefinition> registeredClasses = this.definitionMap.get(extensionType);
        this.registerServiceClass(implementationClassName, extensionType, this.classNameBundleLookup, this.bundleCoordinateClassesLookup, bundle, registeredClasses);
    }

    protected void initializeTempComponent(ConfigurableComponent configurableComponent) {
        try {
            ConfigurableComponentInitializer initializer = ConfigurableComponentInitializerFactory.createComponentInitializer(this, configurableComponent.getClass());
            if (initializer != null) {
                initializer.initialize(configurableComponent);
            }
        }
        catch (InitializationException e) {
            logger.warn("Unable to initialize component {} due to {}", (Object)configurableComponent.getClass().getName(), (Object)e.getMessage());
        }
    }

    private void registerServiceClass(String className, Class<?> extensionType, Map<String, List<Bundle>> classNameBundleMap, Map<BundleCoordinate, Set<ExtensionDefinition>> bundleCoordinateClassesMap, Bundle bundle, Set<ExtensionDefinition> classes) {
        BundleCoordinate bundleCoordinate = bundle.getBundleDetails().getCoordinate();
        List registeredBundles = classNameBundleMap.computeIfAbsent(className, key -> new ArrayList());
        Set bundleExtensionDefinitions = bundleCoordinateClassesMap.computeIfAbsent(bundleCoordinate, key -> new HashSet());
        boolean alreadyRegistered = false;
        for (Bundle registeredBundle : registeredBundles) {
            BundleCoordinate registeredCoordinate = registeredBundle.getBundleDetails().getCoordinate();
            if (registeredCoordinate.equals((Object)bundleCoordinate)) {
                alreadyRegistered = true;
                break;
            }
            if (StandardExtensionDiscoveringManager.multipleVersionsAllowed(extensionType)) continue;
            logger.debug("Attempt was made to load {} from {} but that class name is already loaded/registered from {} and multiple versions are not supported for this type", new Object[]{className, bundle.getBundleDetails().getCoordinate().getCoordinate(), registeredBundle.getBundleDetails().getCoordinate()});
            return;
        }
        if (!alreadyRegistered) {
            registeredBundles.add(bundle);
            ExtensionDefinition extensionDefinition = new ExtensionDefinition.Builder().implementationClassName(className).bundle(bundle).extensionType(extensionType).runtime(ExtensionDefinition.ExtensionRuntime.JAVA).build();
            bundleExtensionDefinitions.add(extensionDefinition);
            classes.add(extensionDefinition);
        }
    }

    @Override
    public Class<?> getClass(ExtensionDefinition extensionDefinition) {
        Bundle bundle = extensionDefinition.getBundle();
        ClassLoader bundleClassLoader = bundle.getClassLoader();
        NarCloseable x = NarCloseable.withComponentNarLoader(bundleClassLoader);
        try {
            Class<?> clazz = Class.forName(extensionDefinition.getImplementationClassName(), true, bundleClassLoader);
            if (x != null) {
                x.close();
            }
            return clazz;
        }
        catch (Throwable throwable) {
            try {
                if (x != null) {
                    try {
                        x.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create Class for " + String.valueOf(extensionDefinition), e);
            }
        }
    }

    private static boolean multipleVersionsAllowed(Class<?> type) {
        return Processor.class.isAssignableFrom(type) || ControllerService.class.isAssignableFrom(type) || ReportingTask.class.isAssignableFrom(type) || FlowAnalysisRule.class.isAssignableFrom(type) || ParameterProvider.class.isAssignableFrom(type) || FlowRegistryClient.class.isAssignableFrom(type);
    }

    protected boolean isInstanceClassLoaderRequired(String classType, Bundle bundle) {
        ClassLoader bundleClassLoader = bundle.getClassLoader();
        if (!(bundleClassLoader instanceof NarClassLoader)) {
            return false;
        }
        ConfigurableComponent tempComponent = this.getTempComponent(classType, bundle.getBundleDetails().getCoordinate());
        if (tempComponent == null) {
            return false;
        }
        return tempComponent.getClass().isAnnotationPresent(RequiresInstanceClassLoading.class);
    }

    @Override
    public InstanceClassLoader createInstanceClassLoader(String classType, String instanceIdentifier, Bundle bundle, Set<URL> additionalUrls, boolean register, String classloaderIsolationKey) {
        InstanceClassLoader instanceClassLoader;
        if (StringUtils.isEmpty((String)classType)) {
            throw new IllegalArgumentException("Class-Type is required");
        }
        if (StringUtils.isEmpty((String)instanceIdentifier)) {
            throw new IllegalArgumentException("Instance Identifier is required");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle is required");
        }
        ClassLoader bundleClassLoader = bundle.getClassLoader();
        boolean requiresInstanceClassLoader = this.isInstanceClassLoaderRequired(classType, bundle);
        if (requiresInstanceClassLoader) {
            ConfigurableComponent tempComponent = this.getTempComponent(classType, bundle.getBundleDetails().getCoordinate());
            Class type = tempComponent.getClass();
            boolean allowsSharedClassloader = tempComponent instanceof ClassloaderIsolationKeyProvider;
            if (allowsSharedClassloader && classloaderIsolationKey == null) {
                instanceClassLoader = new InstanceClassLoader(instanceIdentifier, classType, Collections.emptySet(), additionalUrls, bundleClassLoader);
            } else {
                BaseClassLoaderKey baseClassLoaderKey = classloaderIsolationKey == null ? null : new BaseClassLoaderKey(bundle, classloaderIsolationKey);
                NarClassLoader narBundleClassLoader = (NarClassLoader)bundleClassLoader;
                logger.debug("Including ClassLoader resources from {} for component {}", (Object)bundle.getBundleDetails(), (Object)instanceIdentifier);
                LinkedHashSet<URL> instanceUrls = new LinkedHashSet<URL>(Arrays.asList(narBundleClassLoader.getURLs()));
                LinkedHashSet<File> narNativeLibDirs = new LinkedHashSet<File>();
                narNativeLibDirs.add(narBundleClassLoader.getNARNativeLibDir());
                Object ancestorClassLoader = narBundleClassLoader.getParent();
                boolean resolvedSharedClassLoader = false;
                RequiresInstanceClassLoading requiresInstanceClassLoading = type.getAnnotation(RequiresInstanceClassLoading.class);
                if (requiresInstanceClassLoading.cloneAncestorResources()) {
                    SharedInstanceClassLoader sharedBaseClassloader;
                    if (baseClassLoaderKey != null && (sharedBaseClassloader = (SharedInstanceClassLoader)((Object)this.sharedBaseClassloaders.get(baseClassLoaderKey))) != null && sharedBaseClassloader.incrementReferenceCount()) {
                        resolvedSharedClassLoader = true;
                        ancestorClassLoader = sharedBaseClassloader;
                        logger.debug("Creating InstanceClassLoader for type {} using shared Base ClassLoader {} for component {}", new Object[]{type, sharedBaseClassloader, instanceIdentifier});
                    }
                    if (!resolvedSharedClassLoader) {
                        Bundle ancestorNarBundle;
                        ConfigurableComponent component = this.getTempComponent(classType, bundle.getBundleDetails().getCoordinate());
                        Set<BundleCoordinate> reachableApiBundles = this.findReachableApiBundles(component);
                        while (ancestorClassLoader instanceof NarClassLoader && (ancestorNarBundle = this.classLoaderBundleLookup.get(ancestorClassLoader)) != null && !reachableApiBundles.contains(ancestorNarBundle.getBundleDetails().getCoordinate()) && !ancestorNarBundle.getBundleDetails().getCoordinate().getId().equals("nifi-jetty-nar")) {
                            NarClassLoader ancestorNarClassLoader = (NarClassLoader)ancestorClassLoader;
                            narNativeLibDirs.add(ancestorNarClassLoader.getNARNativeLibDir());
                            Collections.addAll(instanceUrls, ancestorNarClassLoader.getURLs());
                            ancestorClassLoader = ancestorNarClassLoader.getParent();
                        }
                    }
                }
                if (baseClassLoaderKey != null && !resolvedSharedClassLoader) {
                    SharedInstanceClassLoader sharedClassLoader = new SharedInstanceClassLoader(instanceIdentifier, classType, (Set<URL>)instanceUrls, Collections.emptySet(), (Set<File>)narNativeLibDirs, (ClassLoader)ancestorClassLoader);
                    sharedClassLoader.incrementReferenceCount();
                    instanceClassLoader = new InstanceClassLoader(instanceIdentifier, classType, Collections.emptySet(), additionalUrls, Collections.emptySet(), (ClassLoader)((Object)sharedClassLoader));
                    logger.debug("Creating InstanceClassLoader for type {} using newly created shared Base ClassLoader {} for component {}", new Object[]{type, sharedClassLoader, instanceIdentifier});
                    if (logger.isTraceEnabled()) {
                        for (URL url : sharedClassLoader.getURLs()) {
                            logger.trace("Shared Base ClassLoader URL resource: {}", (Object)url.toExternalForm());
                        }
                    }
                    this.sharedBaseClassloaders.putIfAbsent(baseClassLoaderKey, sharedClassLoader);
                } else {
                    Set<URL> resolvedInstanceUrls = resolvedSharedClassLoader ? Collections.emptySet() : instanceUrls;
                    instanceClassLoader = new InstanceClassLoader(instanceIdentifier, classType, resolvedInstanceUrls, additionalUrls, (Set<File>)narNativeLibDirs, (ClassLoader)ancestorClassLoader);
                }
            }
        } else {
            instanceClassLoader = new InstanceClassLoader(instanceIdentifier, classType, Collections.emptySet(), additionalUrls, bundleClassLoader);
        }
        if (logger.isTraceEnabled()) {
            for (URL url : instanceClassLoader.getURLs()) {
                logger.trace("URL resource {} for {}...", (Object)url.toExternalForm(), (Object)instanceIdentifier);
            }
        }
        if (register) {
            this.instanceClassloaderLookup.put(instanceIdentifier, instanceClassLoader);
        }
        return instanceClassLoader;
    }

    protected Set<BundleCoordinate> findReachableApiBundles(ConfigurableComponent component) {
        HashSet<BundleCoordinate> reachableApiBundles = new HashSet<BundleCoordinate>();
        try (NarCloseable closeable = NarCloseable.withComponentNarLoader(component.getClass().getClassLoader());){
            List descriptors = component.getPropertyDescriptors();
            if (descriptors != null && !descriptors.isEmpty()) {
                for (PropertyDescriptor descriptor : descriptors) {
                    Class serviceApi = descriptor.getControllerServiceDefinition();
                    if (serviceApi == null || component.getClass().getClassLoader().equals(serviceApi.getClassLoader())) continue;
                    Bundle apiBundle = this.classLoaderBundleLookup.get(serviceApi.getClassLoader());
                    reachableApiBundles.add(apiBundle.getBundleDetails().getCoordinate());
                }
            }
        }
        return reachableApiBundles;
    }

    @Override
    public InstanceClassLoader getInstanceClassLoader(String instanceIdentifier) {
        return this.instanceClassloaderLookup.get(instanceIdentifier);
    }

    @Override
    public InstanceClassLoader removeInstanceClassLoader(String instanceIdentifier) {
        if (instanceIdentifier == null) {
            return null;
        }
        InstanceClassLoader classLoader = this.instanceClassloaderLookup.remove(instanceIdentifier);
        this.closeURLClassLoader(instanceIdentifier, (ClassLoader)((Object)classLoader));
        return classLoader;
    }

    @Override
    public void registerInstanceClassLoader(String instanceIdentifier, InstanceClassLoader instanceClassLoader) {
        this.instanceClassloaderLookup.putIfAbsent(instanceIdentifier, instanceClassLoader);
    }

    @Override
    public void closeURLClassLoader(String instanceIdentifier, ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            try {
                urlClassLoader.close();
            }
            catch (IOException e) {
                logger.warn("Unable to close URLClassLoader for {}", (Object)instanceIdentifier);
            }
        }
    }

    @Override
    public List<Bundle> getBundles(String classType) {
        if (classType == null) {
            throw new IllegalArgumentException("Class type cannot be null");
        }
        List<Bundle> bundles = this.classNameBundleLookup.get(classType);
        return bundles == null ? Collections.emptyList() : new ArrayList<Bundle>(bundles);
    }

    @Override
    public Bundle getBundle(BundleCoordinate bundleCoordinate) {
        if (bundleCoordinate == null) {
            throw new IllegalArgumentException("BundleCoordinate cannot be null");
        }
        return this.bundleCoordinateBundleLookup.get(bundleCoordinate);
    }

    @Override
    public Set<ExtensionDefinition> getTypes(BundleCoordinate bundleCoordinate) {
        if (bundleCoordinate == null) {
            throw new IllegalArgumentException("BundleCoordinate cannot be null");
        }
        Set<ExtensionDefinition> types = this.bundleCoordinateClassesLookup.get(bundleCoordinate);
        return types == null ? Collections.emptySet() : Collections.unmodifiableSet(types);
    }

    @Override
    public Bundle getBundle(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader cannot be null");
        }
        return this.classLoaderBundleLookup.get(classLoader);
    }

    @Override
    public Set<ExtensionDefinition> getExtensions(Class<?> definition) {
        if (definition == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        Set<ExtensionDefinition> extensions = this.definitionMap.get(definition);
        return extensions == null ? Collections.emptySet() : extensions;
    }

    @Override
    public synchronized ConfigurableComponent getTempComponent(String classType, BundleCoordinate bundleCoordinate) {
        if (classType == null) {
            throw new IllegalArgumentException("Class type cannot be null");
        }
        if (bundleCoordinate == null) {
            throw new IllegalArgumentException("Bundle Coordinate cannot be null");
        }
        String bundleKey = StandardExtensionDiscoveringManager.getClassBundleKey(classType, bundleCoordinate);
        ConfigurableComponent existing = this.tempComponentLookup.get(bundleKey);
        if (existing != null) {
            return existing;
        }
        Bundle bundle = this.getBundle(bundleCoordinate);
        if (bundle == null) {
            logger.error("Could not instantiate class of type {} using ClassLoader for bundle {} because the bundle could not be found", (Object)classType, (Object)bundleCoordinate);
            return null;
        }
        ClassLoader bundleClassLoader = bundle.getClassLoader();
        NarCloseable narCloseable = NarCloseable.withComponentNarLoader(bundleClassLoader);
        try {
            ConfigurableComponent componentClass;
            ConfigurableComponent tempComponent;
            if (PythonBundle.isPythonCoordinate((BundleCoordinate)bundle.getBundleDetails().getCoordinate())) {
                String type = StandardExtensionDiscoveringManager.stripPythonTypePrefix(classType);
                String procId = "temp-component-" + type;
                tempComponent = this.pythonBridge.createProcessor(procId, type, bundleCoordinate.getVersion(), false, false);
            } else {
                componentClass = Class.forName(classType, true, bundleClassLoader);
                tempComponent = (ConfigurableComponent)componentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            this.initializeTempComponent(tempComponent);
            this.tempComponentLookup.put(bundleKey, tempComponent);
            componentClass = tempComponent;
            if (narCloseable != null) {
                narCloseable.close();
            }
            return componentClass;
        }
        catch (Throwable tempComponent) {
            try {
                if (narCloseable != null) {
                    try {
                        narCloseable.close();
                    }
                    catch (Throwable componentClass) {
                        tempComponent.addSuppressed(componentClass);
                    }
                }
                throw tempComponent;
            }
            catch (Exception e) {
                logger.error("Could not instantiate class of type {} using ClassLoader for bundle {}", new Object[]{classType, bundleCoordinate, e});
                if (logger.isDebugEnabled() && bundleClassLoader instanceof URLClassLoader) {
                    URLClassLoader urlClassLoader = (URLClassLoader)bundleClassLoader;
                    List<URL> availableUrls = Arrays.asList(urlClassLoader.getURLs());
                    logger.debug("Available URLs for Bundle ClassLoader {}: {}", (Object)bundleCoordinate, availableUrls);
                }
                return null;
            }
        }
    }

    private static String stripPythonTypePrefix(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith(PYTHON_TYPE_PREFIX)) {
            return value.substring(PYTHON_TYPE_PREFIX.length());
        }
        return value;
    }

    private static String getClassBundleKey(String classType, BundleCoordinate bundleCoordinate) {
        return classType + "_" + bundleCoordinate.getCoordinate();
    }

    @Override
    public void logClassLoaderMapping() {
        StringBuilder builder = new StringBuilder();
        builder.append("Extension Type Mapping to Bundle:");
        for (Map.Entry<Class, Set<ExtensionDefinition>> entry : this.definitionMap.entrySet()) {
            builder.append("\n\t=== ").append(entry.getKey().getSimpleName()).append(" Type ===");
            for (ExtensionDefinition extensionDefinition : entry.getValue()) {
                String implementationClassName = extensionDefinition.getImplementationClassName();
                List bundles = this.classNameBundleLookup.getOrDefault(implementationClassName, Collections.emptyList());
                builder.append("\n\t").append(implementationClassName);
                for (Bundle bundle : bundles) {
                    String coordinate = bundle.getBundleDetails().getCoordinate().getCoordinate();
                    String workingDir = bundle.getBundleDetails().getWorkingDirectory().getPath();
                    builder.append("\n\t\t").append(coordinate).append(" || ").append(workingDir);
                }
            }
            builder.append("\n\t=== End ").append(entry.getKey().getSimpleName()).append(" types ===");
        }
        logger.info("{}", (Object)builder);
    }

    @Override
    public void logClassLoaderDetails() {
        if (!logger.isDebugEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("ClassLoader Hierarchy:\n");
        for (Bundle bundle : this.classLoaderBundleLookup.values()) {
            this.buildClassLoaderDetails(bundle, sb, 0);
            sb.append("\n---------------------------------------------------------------------------------------------------------\n");
        }
        String message = sb.toString();
        logger.debug(message);
    }

    private void buildClassLoaderDetails(Bundle bundle, StringBuilder sb, int indentLevel) {
        Bundle parent;
        BundleCoordinate parentCoordinate;
        StringBuilder indentBuilder = new StringBuilder();
        indentBuilder.append("\n");
        for (int i = 0; i < indentLevel; ++i) {
            indentBuilder.append(" ");
        }
        String prefix = indentBuilder.toString();
        sb.append(prefix).append("Bundle: ").append(bundle);
        sb.append(prefix).append("Working Directory: ").append(bundle.getBundleDetails().getWorkingDirectory().getAbsolutePath());
        sb.append(prefix).append("Coordinates: ").append(bundle.getBundleDetails().getCoordinate().getCoordinate());
        sb.append(prefix).append("Files loaded: ").append(bundle.getBundleDetails().getCoordinate().getCoordinate());
        ClassLoader classLoader = bundle.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URL[] urls;
            for (URL url : urls = ((URLClassLoader)bundle.getClassLoader()).getURLs()) {
                sb.append(prefix).append("    ").append(url.getFile());
            }
        }
        if ((parentCoordinate = bundle.getBundleDetails().getDependencyCoordinate()) != null && (parent = this.getBundle(parentCoordinate)) != null) {
            this.buildClassLoaderDetails(parent, sb, indentLevel + 4);
        }
    }

    private static class BaseClassLoaderKey {
        private final Bundle bundle;
        private final String classloaderIsolationKey;

        public BaseClassLoaderKey(Bundle bundle, String classloaderIsolationKey) {
            this.bundle = Objects.requireNonNull(bundle);
            this.classloaderIsolationKey = Objects.requireNonNull(classloaderIsolationKey);
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseClassLoaderKey that = (BaseClassLoaderKey)o;
            return this.bundle.equals((Object)that.bundle) && this.classloaderIsolationKey.equals(that.classloaderIsolationKey);
        }

        public int hashCode() {
            return Objects.hash(this.bundle, this.classloaderIsolationKey);
        }
    }
}

