/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.encrypt;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.nifi.encrypt.EncryptionException;
import org.apache.nifi.encrypt.PropertyEncryptor;

abstract class CipherPropertyEncryptor
implements PropertyEncryptor {
    private static final Charset PROPERTY_CHARSET = StandardCharsets.UTF_8;

    CipherPropertyEncryptor() {
    }

    @Override
    public String encrypt(String property) {
        byte[] binary = property.getBytes(PROPERTY_CHARSET);
        byte[] encodedParameters = this.getEncodedParameters();
        Cipher cipher = this.getEncryptionCipher(encodedParameters);
        try {
            byte[] encrypted = cipher.doFinal(binary);
            return Hex.encodeHexString((byte[])this.getConcatenatedBinary(encodedParameters, encrypted));
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            String message = String.format("Encryption Failed with Algorithm [%s]", cipher.getAlgorithm());
            throw new EncryptionException(message, e);
        }
    }

    @Override
    public String decrypt(String encryptedProperty) {
        byte[] binary = this.getDecodedBinary(encryptedProperty);
        Cipher cipher = this.getDecryptionCipher(binary);
        byte[] cipherBinary = this.getCipherBinary(binary);
        try {
            byte[] deciphered = cipher.doFinal(cipherBinary);
            return new String(deciphered, PROPERTY_CHARSET);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            String message = String.format("Decryption Failed with Algorithm [%s]", cipher.getAlgorithm());
            throw new EncryptionException(message, e);
        }
    }

    private byte[] getDecodedBinary(String encryptedProperty) {
        try {
            return Hex.decodeHex((String)encryptedProperty);
        }
        catch (DecoderException e) {
            throw new EncryptionException("Hexadecimal decoding failed", e);
        }
    }

    private byte[] getConcatenatedBinary(byte[] encodedParameters, byte[] encrypted) {
        int encodedParametersLength = encodedParameters.length;
        int encryptedLength = encrypted.length;
        int concatenatedLength = encodedParametersLength + encryptedLength;
        byte[] concatenated = new byte[concatenatedLength];
        System.arraycopy(encodedParameters, 0, concatenated, 0, encodedParametersLength);
        System.arraycopy(encrypted, 0, concatenated, encodedParametersLength, encryptedLength);
        return concatenated;
    }

    protected abstract byte[] getEncodedParameters();

    protected abstract Cipher getEncryptionCipher(byte[] var1);

    protected abstract Cipher getDecryptionCipher(byte[] var1);

    protected abstract byte[] getCipherBinary(byte[] var1);
}

